use strict;
use utf8;
use File::Find;
use Storable qw(store_fd);
use gmm;
use xls;

my $DATA_FILE = "data.bin";
my %LANG_TEXT = (
	japanese => "日本語",
	english => "英語",
	korean => "韓国語"
);
my $TEXT_VER = "071218";

main();
exit;

#===========================================================
# メイン処理。
#===========================================================
sub main {
	my %GET_FUNC = ( gmm => \&get_gmm, xls => \&get_xls );
	my ($flist, %data);

	if (@ARGV != 1) {
		return;
	}
	$data{text_ver} = $TEXT_VER;
	$flist = get_file_list($ARGV[0]);

	for my $i (@{$flist}) {
		my ($f_name);

		$i->{name} =~ /[\\\/]?([^\\\/]+)$/;
		$f_name = $1;
		$data{term}{$f_name} = $GET_FUNC{$i->{type}}($i->{name});
	}
	if (open DT, ">$DATA_FILE") {
		store_fd(\%data, \*DT);
		close DT;
	}
}

#===========================================================
# ファイルリスト取得。
#===========================================================
sub get_file_list {
	my ($dir) = @_;
	my $sub;
	my @list;

	$sub = sub {
		if ($File::Find::name =~ /\.gmm$/) {
			push @list, { name => $File::Find::name, type => "gmm" };
		} elsif ($File::Find::name =~ /\.xls$/) {
			push @list, { name => $File::Find::name, type => "xls" };
		}
	};
	find($sub, $dir);
	return \@list;
}

#===========================================================
# gmmファイルの内容取得。
#===========================================================
sub get_gmm {
	my ($path) = @_;
	my ($term, $gmm);
	my %LANG = (
		"日本語" => "japanese",
		"Japanese" => "japanese",
		"English" => "english",
		"Korean" => "korean"
	);

	$gmm = new gmm($path);

	for (my $iter = $gmm->newIter(); !$iter->over(); $iter->next()) {
		if ($iter->getWindowContext() ne "garbage") {
			my ($res, $t);

			push @{$term}, { id => $iter->getMsgId(), set => [] };
			$t = $term->[-1];
			$res = $iter->getTextAllLang();
			for my $i (@{$res}) {
				my ($lang);

				$lang = $LANG{$i->{lang}};
				$t->{set}[0]{$lang} = { text => $LANG_TEXT{$lang}, val => $i->{text} };
			}
		}
	}
	$gmm->delete();
	return $term;
}

#===========================================================
# xlsファイルの内容取得。
#===========================================================
sub get_xls {
	my ($path) = @_;
	my ($term, $xls, $data, %col_to_id, $info);
	my @LANG = (
		"japanese",
		"english",
		"korean"
	);
	my %COL_INFO = (
		"DP_Areanames.xls"   => [
			{ col => [ 'C', 'D', 'E' ], add => "" }
		],
		"DP_Berries.xls"     => [
			{ col => [ 'C', 'D', 'E' ], add => " (Name)" },
			{ col => [ 'F', 'G', 'H' ], add => " (Info)" }
		],
		"DP_Characters.xls"  => [
			{ col => [ 'C', 'D', 'E' ], add => "" }
		],
		"DP_Items.xls"       => [
			{ col => [ 'C', 'D', 'E' ], add => " (Name)" },
			{ col => [ 'F', 'G', 'H' ], add => " (Info)" }
		],
		"DP_Moves.xls"       => [
			{ col => [ 'C', 'D', 'E' ], add => " (Name)" },
			{ col => [ 'F', 'G', 'H' ], add => " (Info)" }
		],
		"DP_Pokedex.xls"     => [
			{ col => [ 'B', 'C', 'D' ], add => " (Name)" },
			{ col => [ 'G', 'H', 'I' ], add => " (Diamond)" },
			{ col => [ 'J', 'K', 'L' ], add => " (Pearl)" }
		],
		"DP_Simpletext.xls"  => [
			{ col => [ 'C', 'D', 'E' ], add => "" }
		],
		"DP_SpeAbility.xls"  => [
			{ col => [ 'C', 'D', 'E' ], add => " (Name)" },
			{ col => [ 'F', 'G', 'H' ], add => " (Info)" }
		],
		"DP_Stickers.xls"    => [
			{ col => [ 'C', 'D', 'E' ], add => " (Name)" },
			{ col => [ 'F', 'G', 'H' ], add => " (Info)" }
		],
		"DP_Trainers.xls"    => [
			{ col => [ 'C', 'D', 'E' ], add => "" }
		],
		"DP_Underground.xls" => [
			{ col => [ 'C', 'D', 'E' ], add => " (Name)" },
			{ col => [ 'F', 'G', 'H' ], add => " (Info)" }
		]
	);

	for (my ($col_id, $cnt) = ('A', 0); $col_id ne 'AA'; $col_id++, $cnt++) {
		$col_to_id{$col_id} = $cnt;
	}
	$term = [];
	xls::start();
	$xls = new xls($path);
	$data = $xls->getData();
	$path =~ /[\\\/]?([^\\\/]+)$/;
	$info = $COL_INFO{$1};
	for my $i (@{$data}[1 .. $#{$data}]) {
		my ($t);

		push @{$term}, { id => $i->[0], set => [] };
		$t = $term->[-1];
		for my $j (@{$info}) {
			my ($tmp, $cnt);

			$cnt = 0;
			for my $k (@{$j->{col}}) {
				$tmp->{$LANG[$cnt]} = { text => "$LANG_TEXT{$LANG[$cnt]}$j->{add}", val => $i->[$col_to_id{$k}] };
				$cnt++;
			}
			push @{$t->{set}}, $tmp;
		}
	}
	$xls->close();
	return $term;
}
