use strict;
use utf8;
use Encode;
use File::Find;
use Win32::Process;
use Win32::Clipboard;
use Tk;
use Storable qw(fd_retrieve);
use letter;

binmode STDOUT, "encoding(shiftjis)";
binmode STDERR, "encoding(shiftjis)";

my $DATA_FILE = "data.bin";
my $APP_VER = "1.7";
my ($mw, $cb1, %wdt, $txt, %ini, @out, $data, $jpn, $kor, $ng, %font);
my (%g_res, $narrow, $nega, $cb2, $cb3);

main();
exit;

#===========================================================
# メイン処理。
#===========================================================
sub main {
	my ($fr, $fr1, $fr2, $none);

	if (open(INI, "ini.txt")) {
		my (@list, $dum);

		# utf8のBOM。
		read(INI, $dum, 3);
		binmode(INI, "utf8");
		@list = <INI>;
		close INI;
		chomp @list;

		for (@list) {
			if (/^([^=]+)=([^=]+)$/) {
				$ini{$1} = $2;
			}
		}
	}
	if (!exists $ini{jump}) {
		$ini{jump} = 0;
	}
	if (!exists $ini{spec_cond}) {
		$ini{spec_cond} = 0;
	}
	if (!exists $ini{message_editor}) {
		$ini{message_editor} = "C:\\MessageEditor.exe";
	}
	if (!exists $ini{reg}) {
		$ini{reg} = 0;
	}
	$none = 1;
	for my $i ("lang_korean", "lang_english", "lang_japanese") {
		if (exists $ini{$i}) {
			$none = 0;
		}
	}
	if ($none) {
		# 全言語の設定が存在しなければ、「韓国語」をONにしておく。
		$ini{lang_korean} = 1;
	}

	add_font(\%font, $letter::LETTER, 1);
	add_font(\%font, $letter::LETTER_KOR, 0x401);
	$font{"E000"} = "\n";

	if (open DT, "$DATA_FILE") {
		$data = fd_retrieve(\*DT);
		close DT;
	}

	$mw = new MainWindow();
	$mw->title("msggrep");
	$mw->geometry("740x1008+50+50");
	$mw->protocol('WM_DELETE_WINDOW', \&mw_closed);
	$txt = $mw->Text(-height => 77, -width => 50, -wrap => 'none', -font => "{MS ゴシック} 10 normal")->
		pack(-side => 'left', -anchor => 'nw');
	$fr = $mw->Frame()->pack(-anchor => 'nw');
	$fr->Frame(-height => 10)->pack();
	$fr->Label(-text => "ver. $APP_VER, text-ver. $data->{text_ver}")->pack(-anchor => 'ne', -padx => 30);
	$fr->Frame(-height => 30)->pack();

	$fr1 = $fr->Frame()->pack(-anchor => 'nw', -padx => 30);
	$fr2 = $fr1->Frame(-width => 110);
	$fr2->pack(-side => 'left', -anchor => 'nw');
	$fr2->Label(-text => "検索文字列:")->pack(-anchor => 'ne', -pady => 5);
	$fr2 = $fr1->Frame();
	$fr2->pack(-side => 'left', -anchor => 'nw');
	$wdt{tgt_str} = $fr2->Scrolled('Text', -background => 'white', -height => 3, -width => 30, -wrap => 'none', -scrollbars => 'se');
	$wdt{tgt_str}->pack(-anchor => 'nw', -pady => 5);

	$fr->Frame(-height => 4)->pack();
	$fr1 = $fr->Frame()->pack(-anchor => 'nw', -padx => 34);
	$fr2 = $fr1->Frame()->pack(-side => 'left', -anchor => 'nw');
	$fr2->Radiobutton(-variable => \$ini{reg}, -text => "文字検索", -value => 0, -command => \&rb1_cb)->
		pack(-anchor => 'nw');
	$fr2->Radiobutton(-variable => \$ini{reg}, -text => "正規表現", -value => 1, -command => \&rb1_cb)->
		pack(-anchor => 'nw');
	if ($ini{spec_cond}) {
		$fr2->Radiobutton(-variable => \$ini{reg}, -text => "条件指定", -value => 2, -command => \&rb1_cb)->
			pack(-anchor => 'nw');
	} elsif ($ini{reg} == 2) {
		$ini{reg} = 1;
	}
	$cb1 = $fr2->Checkbutton(-variable => \$ini{str}, -text => "英大文字・小文字を区別")->
		pack(-anchor => 'nw');
	$cb2 = $fr2->Checkbutton(-variable => \$ini{match_full}, -text => "完全一致")->
		pack(-anchor => 'nw');
	$cb3 = $fr2->Checkbutton(-variable => \$ini{ignore_space}, -text => "空白を無視")->
		pack(-anchor => 'nw');
	$fr2 = $fr1->Frame()->pack(-anchor => 'nw', -padx => 14);
	$kor = $fr2->Checkbutton(-variable => \$ini{lang_korean}, -text => "韓国語")->pack(-anchor => 'nw');
	$fr2->Checkbutton(-variable => \$ini{lang_english}, -text => "英語")->pack(-anchor => 'nw');
	$jpn = $fr2->Checkbutton(-variable => \$ini{lang_japanese}, -text => "日本語")->pack(-anchor => 'nw');
	$fr2->Frame(-height => 8)->pack();
	$fr2->Checkbutton(-variable => \$ini{force_korean}, -text => "韓国語訳参照", -command => \&kor_f_cb)->pack(-anchor => 'nw');
	$fr2->Checkbutton(-variable => \$ini{force_japanese}, -text => "日本語訳参照", -command => \&jpn_f_cb)->pack(-anchor => 'nw');

	$fr->Frame(-height => 5)->pack();
	$fr1 = $fr->Frame()->pack(-anchor => 'ne', -padx => 30);
	$fr1->Button(-command => \&conv_cap_str, -text => "キャプチャ変換", -width => 20)->pack(-side => 'left');
	$fr1->Frame(-width => 25)->pack(-side => 'left');
	$fr1->Button(-command => \&execute, -text => "実行", -width => 9)->pack(-side => 'left', -pady => 7);

	$fr1 = $fr->Frame()->pack(-anchor => 'ne', -padx => 30);
	$ng = $fr1->Checkbutton(-variable => \$nega, -text => "否定")->pack(-side => 'left', -anchor => 'nw');
	$fr1->Checkbutton(-variable => \$narrow, -text => "絞り込み", -command => \&nar_cb)->pack(-anchor => 'nw');

	if ($ini{jump}) {
		$fr->Frame(-height => 25)->pack();
		$fr1 = $fr->Frame()->pack(-anchor => 'ne', -padx => 30);
		$fr2 = $fr1->Frame()->pack();
		$fr2->Label(-text => "ジャンプ先:")->pack(-side => 'left', -anchor => 'nw');
		$wdt{folder} = $fr2->Text(-background => 'white', -height => 1, -width => 24, -wrap => 'none')->pack(-side => 'left');
		$wdt{folder}->insert('end', $ini{folder});
		$fr2->Button(-command => \&jump_to_file, -text => "ジャンプ", -width => 8)->pack();
	}
	rb1_cb();
	kor_f_cb();
	jpn_f_cb();
	nar_cb();
	MainLoop();

	if (open(INI, ">ini.txt")) {
		# utf8のBOM。
		print INI "\x{ef}\x{bb}\x{bf}";
		binmode(INI, "utf8");
		for my $i (sort keys %ini) {
			print INI "$i=$ini{$i}\n";
		}
		close INI;
	}
}

#===========================================================
# メインウィンドウ終了。
#===========================================================
sub mw_closed {
	my ($path);

	if ($ini{jump}) {
		$path = $wdt{folder}->get('1.0', 'end');
		$path =~ /^(.*)$/m;
		$path = $1;
		$ini{folder} = $path;
	}
	$mw->destroy();
}

#===========================================================
# 検索文字列オプションコールバック。
#===========================================================
sub rb1_cb {
	if ($ini{reg} == 2) {
		$cb1->configure(-state => 'disabled');
		$cb2->configure(-state => 'disabled');
		$cb3->configure(-state => 'disabled');
	} else {
		if ($ini{reg} == 1) {
			$cb3->configure(-state => 'disabled');
		} else {
			$cb3->configure(-state => 'normal');
		}
		$cb1->configure(-state => 'normal');
		$cb2->configure(-state => 'normal');
	}
}

#===========================================================
# 韓国語強制選択コールバック。
#===========================================================
sub kor_f_cb {
	if ($ini{force_korean}) {
		$kor->configure(-state => 'disabled');
	} else {
		$kor->configure(-state => 'normal');
	}
}

#===========================================================
# 日本語強制選択コールバック。
#===========================================================
sub jpn_f_cb {
	if ($ini{force_japanese}) {
		$jpn->configure(-state => 'disabled');
	} else {
		$jpn->configure(-state => 'normal');
	}
}

#===========================================================
# 絞り込みコールバック。
#===========================================================
sub nar_cb {
	if (!$narrow) {
		$ng->configure(-state => 'disabled');
	} else {
		$ng->configure(-state => 'normal');
	}
}

#===========================================================
# grep実行。
#===========================================================
sub execute {
	my ($tgt_str, $str, $sub, @lang, @pos, @rng);

	my %GET_FUNC = ( gmm => \&get_gmm, xls => \&get_xls );

	if (@rng = $wdt{tgt_str}->tagRanges('sel')) {
		$tgt_str = $wdt{tgt_str}->get($rng[0], $rng[1]);
	} else {
		$tgt_str = $wdt{tgt_str}->get('1.0', 'end');
		$tgt_str =~ s/\n$//;
	}
	if ($ini{reg} == 2) {
		my ($val);

		$tgt_str =~ s/\$0/\$val/g;
		$val = "構文チェックのテストです。";
		eval $tgt_str;
		if ($@) {
			$wdt{tgt_str}->delete('1.0', 'end');
			$wdt{tgt_str}->insert('end', "条件指定エラー!!");
			return;
		}
		$sub = sub {
			my ($val) = @_;

			if (!($narrow && $nega)) {
				return eval $tgt_str;
			} else {
				return !eval $tgt_str;
			}
		};
	} else {
		my ($reg, $ignore_space);

		if ($ini{reg} == 0) {
			if ($ini{ignore_space}) {
				my ($c, $str);

				$tgt_str =~ s/[ 　]//g;
				$c = substr($tgt_str, 0, 1, "");
				$str .= "\Q$c";
				if ($c) {
					while ($c = substr($tgt_str, 0, 1, "")) {
						$str .= "[ 　]*\Q$c";
					}
				}
				$tgt_str = $str;
				$ignore_space = 1;
			} else {
				$tgt_str = "\Q$tgt_str";
			}
			$tgt_str =~ s/\\\n/\\n/;
		}
		if ($ini{match_full}) {
			if ($tgt_str !~ /^\^/) {
				$tgt_str = "^" . $tgt_str;
			}
			if ($tgt_str !~ /\$$/) {
				$tgt_str .= "\$";
			}
		}
		if (!$ini{str}) {
			$tgt_str = "(?i)$tgt_str";
		}
		eval {
			$reg = qr/$tgt_str/;
		};
		if ($@) {
			$wdt{tgt_str}->delete('1.0', 'end');
			$wdt{tgt_str}->insert('end', "検索文字列エラー!!");
			return;
		}
		$sub = sub {
			my ($val, $pos) = @_;
			my (@hit, @lines, @len, $res, $p);

			if (!($narrow && $nega)) {
				while ($val =~ /$reg/g) {
					push @hit, { s => length($`), e => pos($val) };
				}
				pos($val) = 0;
				$res = @hit;
			} else {
				$res = $val !~ /$reg/;
			}
			$p = 0;
			while ($val =~ /\n/g) {
				push @lines, substr($val, $p, length($`) - $p);
				$p = pos($val);
			}
			push @lines, substr($val, $p, length($val) - $p);
			for my $i (@lines) {
				push @len, length($i);
			}
			# 空文字列でもマッチする場合の対処。
			if (@lines == 0) {
				$len[0] = 0;
			}
			for my $i (@hit) {
				my ($n, $t);

				$n = 0;
				while (1) {
					if ($i->{s} <= $len[$n]) {
						$t->{s}{lin} = $n + 1;
						$t->{s}{col} = $i->{s};
						last;
					} else {
						$i->{s} -= $len[$n] + 1;
						$i->{e} -= $len[$n] + 1;
					}
					$n++;
					if (@lines == $n) {
						print "error: line over1\n";
						last;
					}
				}
				while (1) {
					if ($i->{e} <= $len[$n]) {
						$t->{e}{lin} = $n + 1;
						$t->{e}{col} = $i->{e};
						push @{$pos}, $t;
						last;
					} else {
						$i->{e} -= $len[$n] + 1;
					}
					$n++;
					if (@lines == $n) {
						print "error: line over2\n";
						last;
					}
				}
			}
			return $res;
		};
	}

	if ($ini{lang_korean} && !$ini{force_korean}) {
		push @lang, { force => 0, lang => "korean" };
	}
	if ($ini{lang_english}) {
		push @lang, { force => 0, lang => "english" };
	}
	if ($ini{lang_japanese} && !$ini{force_japanese}) {
		push @lang, { force => 0, lang => "japanese" };
	}
	if ($ini{force_korean}) {
		push @lang, { force => 1, lang => "korean" };
	}
	if ($ini{force_japanese}) {
		push @lang, { force => 1, lang => "japanese" };
	}

	@out = ();
	if (!$narrow) {
		%g_res = ();
		for my $i (sort keys %{$data->{term}}) {
			$g_res{$i} = [];
			push @out, "\"$i\"";
			for my $j (@{$data->{term}{$i}}) {
				for my $k (@{$j->{set}}) {
					search(\@lang, $sub, $k, $i, $j->{id}, \@pos, \%g_res);
				}
			}
			push @out, "";
		}
	} else {
		my %tmp;

		for my $i (sort keys %g_res) {
			$tmp{$i} = [];
			push @out, "\"$i\"";
			for my $j (@{$g_res{$i}}) {
				search(\@lang, $sub, $j->{data}, $i, $j->{msg_id}, \@pos, \%tmp);
			}
			push @out, "";
		}
		%g_res = %tmp;
	}
	$txt->tagDelete("match");
	$txt->delete("1.0", 'end');
	$str = join("\n", @out) . "\n";
	$txt->insert('end', $str);
	$txt->tagConfigure("match", -background => 'cyan');
	for my $i (@pos) {
		$txt->tagAdd("match", "$i->{s}{lin}.$i->{s}{col}", "$i->{e}{lin}.$i->{e}{col}");
	}
}

#===========================================================
# ファイルリスト取得。
#===========================================================
sub get_file_list {
	my ($dir, $reg) = @_;
	my @list;

	find(sub { if ($File::Find::name =~ /$reg/) { push @list, $File::Find::name }; }, $dir);
	return \@list;
}

#===========================================================
# 対象ファイルへジャンプ。
#===========================================================
sub jump_to_file {
	my ($line_no, $msg_id, $f_name);

	$txt->index('insert') =~ /^(\d+)\.\d+$/;
	$line_no = $1 - 1;
	if (!defined($out[$line_no])) {
		$line_no = $#out;
	}
	for (my $i = $line_no; 0 <= $i; $i--) {
		if (!defined($msg_id) && $out[$i] =~ /^>> ([^,]*), .*$/) {
			$msg_id = $1;
		} elsif ($out[$i] =~ /^\"([^\"]*)\"$/) {
			$f_name = $1;
			last;
		}
	}
	if (!$msg_id) {
		$msg_id = "?"
	}

	if ($f_name =~ /\.(?:gmm|xls)$/) {
		my ($jump, $path, $fpath);

		if (-e "jump_trans.pl") {
			$jump = "jump_trans.pl";
		} else {
			$jump = "jump_trans.exe";
		}
		$path = $wdt{folder}->get('1.0', 'end');
		$path =~ /^(.*)$/m;
		$path = $1;
		if (-e "$path/$f_name") {
			$fpath = "$path/$f_name";
		} else {
			my ($pre, $list);

			$pre = $f_name;
			$pre =~ s/\.([^\.]+)$/_$1/;
			$list = get_file_list(encode("shiftjis", $path), qr/($f_name|$pre[\d_]+\.xls)$/);
			if (@{$list}) {
				$fpath = decode("shiftjis", $list->[0]);
			}
		}

		if ($fpath) {
			my ($ext, $cmd);

			$fpath =~ /\.([^\.]+)$/;
			$ext = $1;
			if ($ext eq "gmm") {
				if ($ini{message_editor}) {
					$cmd = encode("shiftjis", "$jump $msg_id gmm " .
						"\"$ini{message_editor}\" \"$fpath\"");
				}
			} else {
				$cmd = encode("shiftjis", "$jump $msg_id xls \"$fpath\"");
			}
			if ($cmd) {
				`$cmd`;
			}
		}
	}
}

#===========================================================
# キャプチャ文字列変換。
#===========================================================
sub conv_cap_str {
	my ($str, $tgt_str);

	$str = Win32::Clipboard()->GetText();
	while ($str =~ /([\dA-F]{4}) /g) {
		my ($code);

		$code = $1;
		if (exists $font{$code}) {
			$tgt_str .= $font{$code};
		} else {
			$tgt_str .= " ";
		}
	}
	if ($ini{reg} != 0) {
		$tgt_str = "\Q$tgt_str\E";
		$tgt_str =~ s/\\ +/\.\*/g;
		$tgt_str =~ s/\\\n/\.\*\\n/g;
		if ($ini{reg} == 2) {
			$tgt_str = "\$0 =~ /$tgt_str/";
		}
	}
	$wdt{tgt_str}->delete("1.0", 'end');
	$wdt{tgt_str}->insert('end', $tgt_str);
}

#===========================================================
# フォント追加。
#===========================================================
sub add_font {
	my ($font, $str, $cnt) = @_;
	my ($c);

	while (($c = substr($str, 0, 1, "")) ne "") {
		if ($c ne '_') {
			my ($code);

			$code = sprintf("%04X", $cnt);
			$font->{$code} = $c;
		}
		$cnt++;
	}
}

#===========================================================
# 検索処理。
#===========================================================
sub search {
	my ($lang, $sub, $data, $f_name, $msg_id, $pos, $g_res) = @_;
	my ($find);

	$find = 0;
	for my $i (@{$lang}) {
		my (@tmp);

		if ($i->{force} ? $find : $sub->($data->{$i->{lang}}{val}, \@tmp)) {
			push @out, "---";
			push @out, ">> $msg_id, $data->{$i->{lang}}{text}";

			for my $n (@tmp) {
				$n->{s}{lin} += @out;
				$n->{e}{lin} += @out;
			}
			push @{$pos}, @tmp;

			push @out, split(/\n/, "$data->{$i->{lang}}{val}");
			$find = 1;
		}
	}
	if ($find) {
		push @{$g_res->{$f_name}}, { msg_id => $msg_id, data => $data };
	}
}
