#include <stdio.h>
#pragma hdrstop

#include "font_data.h"

//----------------------------------------------------------
// f[^B
//----------------------------------------------------------
void CFontData::DeleteData()
{
	if (m_Data) {
		delete[] m_Data;
	}
	if (m_Width) {
		delete[] m_Width;
	}
}

//----------------------------------------------------------
// tHgf[^[hB
//----------------------------------------------------------
void CFontData::LoadFromFile(const char *fname)
{
	FILE		*fp;
	int			wid_ofs, wid_set_num, n;
	WID_INFO	*wid_info;

	DeleteData();
	fp = fopen(fname, "rb");
	if (fp == NULL) {
		printf("t@CJ܂B\n");
	}
	fseek(fp, 4, SEEK_CUR);
	fread(&wid_ofs, sizeof(int), 1, fp);

	m_FontNum = (wid_ofs - 0x10) / (FONT_SIZE * sizeof(unsigned short));
	m_Data = new unsigned short[m_FontNum * FONT_SIZE];
	m_Width = new unsigned char[m_FontNum];

	fseek(fp, 0x10, SEEK_SET);
	fread(m_Data, sizeof(unsigned short), m_FontNum * FONT_SIZE, fp);
	fseek(fp, 4, SEEK_CUR);
	fread(&wid_set_num, sizeof(int), 1, fp);
	wid_info = new WID_INFO[wid_set_num];
	fread(wid_info, sizeof(*wid_info), wid_set_num, fp);
	n = 0;
	for (int i = 0; i < wid_set_num; i++) {
		WID_INFO	*p = &wid_info[i];

		if (p->width == -1) {
			fread(m_Width + n, sizeof(unsigned char), p->end - n, fp);
		} else {
			for (int j = n; j < p->end; j++) {
				m_Width[j] = p->width;
			}
		}
		n = p->end;
	}
	delete[] wid_info;
	fclose(fp);
}

//----------------------------------------------------------
// tHgf[^w肵hbgl擾B
//----------------------------------------------------------
int CFontData::GetDotVal(int id, int x, int y) const
{
	int		val;

	val = GetDotValRaw(id, x, y);
	if (m_Button) {
		if (val == 1 || val == 2) {
			val = 1;
		} else {
			val = 0;
		}
	} else {
		if (val != 1) {
			val = 0;
		}
	}

	return val;
}
