#ifndef	FONT_DATA_H
#define	FONT_DATA_H

//----------------------------------------------------------
// tHgf[^NXB
//----------------------------------------------------------
class CFontData {
public:
	enum {
		H_MAX = 16
	};

private:
	enum {
		FONT_SIZE = 32
	};
	struct WID_INFO {
		short		end;
		short		width;
		int			dummy;
	};
	unsigned short		*m_Data;
	unsigned char		*m_Width;
	int					m_FontNum;
	int					m_Button;

	void DeleteData();

public:
	CFontData() {
		m_Data = NULL;
		m_Width = NULL;
		m_FontNum = 0;
		m_Button = 0;
	}
	virtual ~CFontData() {
		DeleteData();
	}
	void SetButton() { m_Button = 1; }
	void LoadFromFile(const char *fname);
	int GetDotVal(int id, int x, int y) const;
	int GetDotValRaw(int id, int x, int y) const {
		return (m_Data[id * 32 + (y / 8 * 2 + x / 8) * 8 + y % 8] >> ((7 - x % 8) * 2)) & 0x3;
	}
	int GetWidth(int id) const {
		return m_Width[id];
	}
	int FontNum() const {
		return m_FontNum;
	}
};

#endif
