#include "font_match.h"
#include "font_data.h"

//----------------------------------------------------------
// Tc[쐬B
//----------------------------------------------------------
void CFontMatchWidth::MakeSearchTree(const CFontData *fnt, NODE *node, int x, int y) const
{
	TList	*list[2];

	if (node->list->Count == 0 || CFontMatch::MaxHeight() <= y) {
		node->end = 1;
		return;
	}

	for (int i = 0; i < 2; i++) {
		list[i] = new TList();
	}
	// ̃hbglɏ]āAXg𕪔zB
	for (int i = 0; i < node->list->Count; i++) {
		CFontMatch::INFO	*info;
		int					val;

		info = (CFontMatch::INFO *)node->list->Items[i];
		val = fnt[info->set_id].GetDotVal(info->id, x, y);
		list[val]->Add(info);
	}
	// Wɐi߂B
	x++;
	if (m_FontWidth <= x) {
		x = 0;
		y++;
	}
	// zXgɏB
	for (int i = 0; i < 2; i++) {
		NODE	*next;

		next = new NODE;
		next->list = list[i];
		node->next[i] = next;
		MakeSearchTree(fnt, next, x, y);
	}
}

//----------------------------------------------------------
// m[h폜B
//----------------------------------------------------------
void CFontMatchWidth::DeleteTree(NODE *node)
{
	if (node->end) {
		delete node->list;
		return;
	}
	for (int i = 0; i < 2; i++) {
		DeleteTree(node->next[i]);
		delete node->next[i];
	}
}

//----------------------------------------------------------
// RXgN^B
//----------------------------------------------------------
CFontMatchWidth::CFontMatchWidth(TList *list, int width, const CFontData *fnt)
{
	m_Root = new NODE;
	m_Root->list = list;
	m_FontWidth = width;
	MakeSearchTree(fnt, m_Root, 0, 0);
	Reset();
}

//----------------------------------------------------------
// fXgN^B
//----------------------------------------------------------
CFontMatchWidth::~CFontMatchWidth()
{
	TList	*list;

	DeleteTree(m_Root);
	list = m_Root->list;
	delete m_Root;
	for (int i = 0; i < list->Count; i++) {
		delete (CFontMatch::INFO *)list->Items[i];
	}
	delete list;
}

//----------------------------------------------------------
// hbg`FbNB
//----------------------------------------------------------
TList *CFontMatchWidth::NextDot(int val)
{
	m_CurNode = m_CurNode->next[val];
	if (m_CurNode->end) {
		return m_CurNode->list;
	} else {
		return NULL;
	}
}

//==========================================================
// CFontMatchB
//==========================================================

//----------------------------------------------------------
// fXgN^B
//----------------------------------------------------------
CFontMatch::~CFontMatch()
{
	for (int i = 0; i < 16; i++) {
		if (m_MatchOrg[i]) {
			delete m_MatchOrg[i];
		}
	}
}

//----------------------------------------------------------
// B
//----------------------------------------------------------
void CFontMatch::Init(const CFontData *fnt, int num)
{
	TList	*list[16];

	for (int i = 0; i < 16; i++) {
		list[i] = new TList();
		m_MatchWork[i] = new TList();
	}
	for (int i = 0; i < num; i++) {
		for (int j = 0; j < fnt[i].FontNum(); j++) {
			if (!CheckSpace(fnt[i], j)) {
				INFO	*info;
				int		wid;

				info = new INFO;
				info->set_id = i;
				info->id = j;
				list[fnt[i].GetWidth(j) - 1]->Add(info);
			}
		}
	}
	m_MinWidth = 0;
	m_MaxWidth = 0;
	for (int i = 0; i < 16; i++) {
		if (list[i]->Count) {
			m_MaxWidth = i + 1;
			if (m_MinWidth == 0) {
				m_MinWidth = i + 1;
			}
			m_MatchOrg[i] = new CFontMatchWidth(list[i], i + 1, fnt);
		} else {
			m_MatchOrg[i] = NULL;
		}
	}
	m_FoundList = new TList();
}

//----------------------------------------------------------
// ZbgB
//----------------------------------------------------------
void CFontMatch::Reset(int wid)
{
	m_PosX = 0;
	m_FoundList->Clear();
	m_SearchWidth = wid;
	for (int i = 0; i < 16; i++) {
		if (m_MatchOrg[i]) {
			m_MatchOrg[i]->Reset();
		}
		m_MatchWork[i]->Clear();
	}
	for (int i = wid - 1; 0 <= i; i--) {
		if (m_MatchOrg[i]) {
			for (int j = 0; j <= i; j++) {
				m_MatchWork[j]->Add(m_MatchOrg[i]);
			}
		}
	}
}

//----------------------------------------------------------
// hbg`FbNB
//----------------------------------------------------------
TList *CFontMatch::NextDot(int val)
{
	TList				*list;
	CFontMatchWidth		*found[16];
	int					found_num = 0;

	list = m_MatchWork[m_PosX];
	if (m_SearchWidth <= ++m_PosX) {
		m_PosX = 0;
	}
	for (int i = 0; i < list->Count; i++) {
		CFontMatchWidth		*p;
		TList				*info;

		p = (CFontMatchWidth *)list->Items[i];
		info = p->NextDot(val);
		if (info) {
			for (int j = 0; j < info->Count; j++) {
				m_FoundList->Add(info->Items[j]);
			}
			found[found_num++] = p;
		}
	}
	for (int i = 0; i < found_num; i++) {
		for (int j = 0; j < 16; j++) {
			if (!m_MatchWork[j]->Count) {
				break;
			}
			m_MatchWork[j]->Remove(found[i]);
		}
	}
	if (m_MatchWork[0]->Count == 0) {
		return m_FoundList;
	}
	return NULL;
}

//----------------------------------------------------------
// tHg󔒂mFB
//----------------------------------------------------------
int CFontMatch::CheckSpace(const CFontData &fnt, int id)
{
	int		wid, space;

	wid = fnt.GetWidth(id);
	space = 1;
	for (int y = 0; y < 16; y++) {
		for (int x = 0; x < wid; x++) {
			int		val;

			val = fnt.GetDotVal(id, x, y);
			if (val == 1) {
				space = 0;
				break;
			}
		}
		if (!space) {
			break;
		}
	}
	return space;
}
