#ifndef	FONT_MATCH_H
#define	FONT_MATCH_H

#include <vcl.h>

#include "font_data.h"

//----------------------------------------------------------
// eƂ̃tHg}b`GWB
//----------------------------------------------------------
class CFontMatchWidth {
private:
	struct NODE {
		struct NODE		*next[2];
		TList			*list;
		int				end;
		NODE() {
			end = 0;
		}
	};

	NODE	*m_Root;
	int		m_FontWidth;
	NODE	*m_CurNode;

	void MakeSearchTree(const CFontData *fnt, NODE *node, int x, int y) const;
	void DeleteTree(NODE *node);

	friend class TTreeViewerForm;

public:
	CFontMatchWidth(TList *list, int width, const CFontData *fnt);
	~CFontMatchWidth();
	void Reset() {
		m_CurNode = m_Root;
	}
	TList *NextDot(int val);
};

//----------------------------------------------------------
// tHg}b`B
//----------------------------------------------------------
class CFontMatch {
public:
	struct INFO {
		int		set_id;
		int		id;
	};

private:
	CFontMatchWidth	*m_MatchOrg[16];
	TList			*m_MatchWork[16];
	int				m_PosX;
	TList			*m_FoundList;
	int				m_MinWidth;
	int				m_MaxWidth;
	int				m_SearchWidth;

	friend class TTreeViewerForm;

public:
	CFontMatch() { }
	~CFontMatch();
	void Init(const CFontData *fnt, int num);
	void Reset(int wid);
	TList *NextDot(int val);
	int MinWidth() const {
		return m_MinWidth;
	}
	int MaxWidth() const {
		return m_MaxWidth;
	}
	static int MaxHeight() {
		return CFontData::H_MAX;
	}
	static int CheckSpace(const CFontData &fnt, int id);
};

#endif
