#include <vcl.h>
#pragma hdrstop

#include "../lib/font_data.h"

//----------------------------------------------------------
// tHgJ[\́B
//----------------------------------------------------------
struct FONT_COL {
	unsigned char	r;
	unsigned char	g;
	unsigned char	b;
};

static const FONT_COL	font_col[] = {
	{ 19, 24, 13 },
	{ 11, 11, 10 },
	{ 21, 23, 23 },
	{ 31, 31, 31 }
};
static const FONT_COL	FONT_COL_BLACK = { 0, 0, 0 };

typedef Graphics::TBitmap TBITMAP;

static void write_dgt(int ys, int h, TBITMAP *bmp, TBITMAP *dgt);
static void write_bmp(int xs, int ys, int id, int solid, TBITMAP *bmp,
	const CFontData &fnt);
static void draw_col(unsigned char *c, int x, const FONT_COL &col);

//----------------------------------------------------------
// Ήrbg}bv쐬B
//----------------------------------------------------------
void make_bitmap()
{
	TBITMAP			*bmp;
	TBITMAP			*dgt;
	CFontData		fnt;
	int				n, h_lim, w_lim;

	bmp = new TBITMAP();
	bmp->LoadFromFile("make_bitmap/template.bmp");
	dgt = new TBITMAP();
	dgt->LoadFromFile("make_bitmap/digit.bmp");

	fnt.LoadFromFile("data/talk.dat");

	h_lim = fnt.FontNum() / 16;
	w_lim = fnt.FontNum() % 16;
	n = 0;
	for (int h = 0; h < h_lim; h++) {
		write_dgt(h * 17, h, bmp, dgt);
		for (int w = 0; w < 16; w++) {
			int		solid = (w == 7) ? 1 : 0;

			write_bmp(w * 17 + 33, h * 17, n, solid, bmp, fnt);
			n++;
		}
	}
	if (w_lim) {
		write_dgt(h_lim * 17, h_lim, bmp, dgt);
		for (int w = 0; w < w_lim; w++) {
			int		solid = (w == 7) ? 1 : 0;

			write_bmp(w * 17 + 33, h_lim * 17, n, solid, bmp, fnt);
			n++;
		}
	}

	bmp->SaveToFile("data/out_talk.bmp");
	delete bmp;
}

//----------------------------------------------------------
// CfbNXtB
//----------------------------------------------------------
static void write_dgt(int ys, int h, TBITMAP *bmp, TBITMAP *dgt)
{
	unsigned char	*c;
	int				f;
	int				n;

	for (int y = 0; y < 16; y++) {
		c = (unsigned char *)bmp->ScanLine[ys + y];
		for (int x = 0; x < 32; x++) {
			draw_col(c, x, font_col[0]);
		}
		draw_col(c, 32, FONT_COL_BLACK);
	}
	c = (unsigned char *)bmp->ScanLine[ys + 16];
	for (int x = 0; x < 33; x++) {
		draw_col(c, x, FONT_COL_BLACK);
	}
	f = 0;
	n = h * 16 + 1;
	while (1) {
		TRect	src, dst;
		int		d;

		d = n % 16;
		src.left = d * 6;
		src.top = 0;
		src.right = (d + 1) * 6;
		src.bottom = 10;
		dst.left = 29 - (f + 1) * 6;
		dst.top = h * 17 + 3;
		dst.right = 29 - f * 6;
		dst.bottom = h * 17 + 13;
		bmp->Canvas->CopyRect(dst, dgt->Canvas, src);
		n /= 16;
		if (n == 0) {
			break;
		}
		f++;
	};
}

//----------------------------------------------------------
// rbg}bv֕摜`B
//----------------------------------------------------------
static void write_bmp(int xs, int ys, int id, int solid, TBITMAP *bmp,
	const CFontData &fnt)
{
	unsigned char			*c;
	int						val;

	for (int y = 0; y < 16; y++) {
		const FONT_COL		*col;

		c = (unsigned char *)bmp->ScanLine[ys + y];
		for (int x = 0; x < 16; x++) {
			val = fnt.GetDotValRaw(id, x, y);
			draw_col(c, xs + x, font_col[val]);
		}
		if (!solid || y % 2 == 0) {
			col = &FONT_COL_BLACK;
		} else {
			col = &font_col[0];
		}
		draw_col(c, xs + 16, *col);
	}
	c = (unsigned char *)bmp->ScanLine[ys + 16];
	for (int x = 0; x < 17; x++) {
		draw_col(c, xs + x, FONT_COL_BLACK);
	}
}

//----------------------------------------------------------
// rbg}bvւ̃hbg݁B
//----------------------------------------------------------
static void draw_col(unsigned char *c, int x, const FONT_COL &col)
{
	c[x * 3 + 0] = col.b * 8;
	c[x * 3 + 1] = col.g * 8;
	c[x * 3 + 2] = col.r * 8;
}
