#include <vcl.h>
#include <stdio.h>
#include <vector>
#pragma hdrstop

#include "FrmMatchTest.h"
#include "search_string.h"

#define	DATA_VER		(1)

#pragma package(smart_init)
#pragma resource "*.dfm"

TMatchTestForm		*MatchTestForm;

CFontMatch			*TMatchTestForm::m_TempFmB;
CFontMatch			*TMatchTestForm::m_TempFmST;
const CFontData		*TMatchTestForm::m_TempFnt;
unsigned char		*TMatchTestForm::m_TempPl;

//----------------------------------------------------------
// }b`Oʎ擾B
//----------------------------------------------------------
class CMatchRes : public IMatchRes {
private:
	enum {
		STT_NOT_MATCH = 0,
		STT_MATCH,
		STT_MATCH_NEED_SPACE,
	};

	int					m_State;
	std::vector<short>	m_Code;
	const CFontData		*m_Fnt;
	TMatchTestForm		*m_MsForm;

public:
	CMatchRes(const CFontData *fnt, TMatchTestForm *ms_form) :
		m_State(STT_NOT_MATCH), m_Fnt(fnt), m_MsForm(ms_form) { }
	virtual void Reset();
	virtual void Return();
	virtual int Notify(int match, int set_id, int id, const POS &s, int button);
	virtual void Finish();
	virtual int IsCancel();
	void Print();
};

//----------------------------------------------------------
// ZbgB
//----------------------------------------------------------
void CMatchRes::Reset()
{
	m_Code.clear();
}

//----------------------------------------------------------
// sB
//----------------------------------------------------------
void CMatchRes::Return()
{
	switch (m_State) {
	case STT_MATCH:
	case STT_MATCH_NEED_SPACE:
		m_Code.push_back(0xe000);
		m_State = STT_NOT_MATCH;
		break;
	}
}

//----------------------------------------------------------
// ʒʒmB
//----------------------------------------------------------
int CMatchRes::Notify(int match, int set_id, int id, const POS &s, int button)
{
	int		code;
	int		wid;

	code = id + 1;
	switch (m_State) {
	case STT_NOT_MATCH:
		if (match) {
			m_Code.push_back(code);
			m_State = STT_MATCH;
		}
		break;
	case STT_MATCH:
		if (match) {
			m_Code.push_back(code);
		} else {
			m_State = STT_MATCH_NEED_SPACE;
		}
		break;
	case STT_MATCH_NEED_SPACE:
		if (match) {
			m_Code.push_back(0x1de);
			m_Code.push_back(code);
			m_State = STT_MATCH;
		}
		break;
	}
	if (match) {
		if (button) {
			wid = m_Fnt[0].GetWidth(id);
		} else {
			wid = m_Fnt[1 + set_id].GetWidth(id);
		}
		m_MsForm->Match(s, id, wid);
	} else {
		wid = 0;
	}

	return wid;
}

//----------------------------------------------------------
// IB
//----------------------------------------------------------
void CMatchRes::Finish()
{
	if (m_Code.size()) {
		m_Code.pop_back();
	}
}

//----------------------------------------------------------
// LZmFB
//----------------------------------------------------------
int CMatchRes::IsCancel()
{
	MSG		msg;

	// L[͂󂯕tāALZ\ɂB
	if (PeekMessage(&msg, NULL, WM_KEYFIRST, WM_KEYLAST, PM_NOREMOVE)) {
		TranslateMessage(&msg);
		DispatchMessage(&msg);
		return m_MsForm->SearchStopping();
	}
	return 0;
}

//----------------------------------------------------------
// ʏóB
//----------------------------------------------------------
void CMatchRes::Print()
{
	std::vector<short>::iterator	iter;
	char							*str;
	char							*mem;
	int								size;
	char							buf[256];
	HGLOBAL							hg;

	size = m_Code.size() * 5 + 1;
	str = new char[size];
	str[0] = '\0';
	for (iter = m_Code.begin(); iter != m_Code.end(); iter++) {
		sprintf(buf, "%04X ", *iter & 0xffff);
		strcat(str, buf);
	}

	hg = GlobalAlloc(GHND, size);
	mem = (char *)GlobalLock(hg);
	for(int i = 0; i < size; i++) {
		mem[i] = str[i];
	}
	GlobalUnlock(hg);
	OpenClipboard(m_MsForm->Handle);
	EmptyClipboard();
	SetClipboardData(CF_TEXT, hg);
	CloseClipboard();

	delete str;
}

//----------------------------------------------------------
// [W`FbNB
//----------------------------------------------------------
int TMatchTestForm::InRegion(int x, int y, R_INFO **info)
{
	std::list<R_INFO *>::iterator	iter;

	for (iter = m_RegionList.begin(); iter != m_RegionList.end(); iter++) {
		TRect	*r;

		r = &(*iter)->rect;
		if (r->left <= x && x <= r->right && r->top <= y && y <= r->bottom) {
			*info = *iter;
			return 1;
		}
	}
	return 0;
}

//----------------------------------------------------------
// [W폜B
//----------------------------------------------------------
void TMatchTestForm::DeleteRegion(R_INFO *info)
{
	std::list<R_INFO *>::iterator	iter;

	for (iter = m_RegionList.begin(); iter != m_RegionList.end(); iter++) {
		if (*iter == info) {
			break;
		}
	}
	if (iter != m_RegionList.end()) {
		delete *iter;
		m_RegionList.erase(iter);
		if (m_SelRegion == info) {
			DeleteMatch();
			m_SelRegion = NULL;
		}
	}
}

//----------------------------------------------------------
// S[W폜B
//----------------------------------------------------------
void TMatchTestForm::DeleteRegion()
{
	std::list<R_INFO *>::iterator	iter;

	for (iter = m_RegionList.begin(); iter != m_RegionList.end(); iter++) {
		delete *iter;
	}
	m_RegionList.clear();
	m_SelRegion = NULL;
	DeleteMatch();
}

//----------------------------------------------------------
// }b`GA폜B
//----------------------------------------------------------
void TMatchTestForm::DeleteMatch()
{
	std::list<M_INFO *>::iterator	iter;

	for (iter = m_MatchList.begin(); iter != m_MatchList.end(); iter++) {
		delete *iter;
	}
	m_MatchList.clear();
}

//----------------------------------------------------------
// [W̃`FbNB
//----------------------------------------------------------
int TMatchTestForm::CheckRegion(TRect *rect)
{
	if (rect->right < 0) {
		rect->right = 0;
	} else if (LCD_WID <= rect->right) {
		rect->right = LCD_WID - 1;
	}
	if (rect->bottom < 0) {
		rect->bottom = 0;
	} else if (LCD_HEI <= rect->bottom) {
		rect->bottom = LCD_HEI - 1;
	}
	if (rect->right < rect->left) {
		int		swap;

		swap = rect->left;
		rect->left = rect->right;
		rect->right = swap;
	}
	if (rect->bottom < rect->top) {
		int		swap;

		swap = rect->top;
		rect->top = rect->bottom;
		rect->bottom = swap;
	}
	if (3 < rect->right - rect->left &&
		3 < rect->bottom - rect->top)
	{
		return 1;
	}
	return 0;
}

//----------------------------------------------------------
// `XVB
//----------------------------------------------------------
void TMatchTestForm::DrawUpdate()
{
	std::list<R_INFO *>::iterator	iter;
	std::list<M_INFO *>::iterator	iter2;
	TRect							rect;
	TPoint							pnt[5];

	rect.left = rect.top = 0;
	rect.right = LCD_WID;
	rect.bottom = LCD_HEI;
	ImgCapture->Canvas->CopyRect(rect, m_Screen->Canvas, rect);

	ImgCapture->Canvas->Pen->Width = 1;
	ImgCapture->Canvas->Pen->Style = psSolid;
	ImgCapture->Canvas->Pen->Color = TColor(0xff0000);
	for (iter = m_RegionList.begin(); iter != m_RegionList.end(); iter++) {
		RectToPoints((*iter)->rect, pnt);
		ImgCapture->Canvas->Polyline(pnt, 4);
	}
	if (m_SelRegion) {
		if (m_State == STT_MOUSE_DOWN) {
			ImgCapture->Canvas->Pen->Color = TColor(0xff0000);
		} else {
			ImgCapture->Canvas->Pen->Color = TColor(0x0000ff);
		}
		RectToPoints(m_SelRegion->rect, pnt);
		ImgCapture->Canvas->Polyline(pnt, 4);
	}
	ImgCapture->Canvas->Pen->Color = TColor(0x00ffff);
	for (iter2 = m_MatchList.begin(); iter2 != m_MatchList.end(); iter2++) {
		RectToPoints((*iter2)->rect, pnt);
		ImgCapture->Canvas->Polyline(pnt, 4);
	}
}

//----------------------------------------------------------
// IB
//----------------------------------------------------------
void TMatchTestForm::Finish()
{
	DeleteRegion();
}

//----------------------------------------------------------
// `ɁB
//----------------------------------------------------------
void TMatchTestForm::RectToPoints(const TRect &rect, TPoint *pnt)
{
	pnt[0].x = rect.left;
	pnt[0].y = rect.top;
	pnt[1].x = rect.right;
	pnt[1].y = rect.top;
	pnt[2].x = rect.right;
	pnt[2].y = rect.bottom;
	pnt[3].x = rect.left;
	pnt[3].y = rect.bottom;
	pnt[4].x = rect.left;
	pnt[4].y = rect.top;
}

//----------------------------------------------------------
// }b`GAqbg`FbNB
//----------------------------------------------------------
int TMatchTestForm::InMatch(int x, int y, POS *pos, int *id)
{
	std::list<M_INFO *>::iterator	iter;

	for (iter = m_MatchList.begin(); iter != m_MatchList.end(); iter++) {
		TRect	*r;

		r = &(*iter)->rect;
		if (r->left <= x && x <= r->right && r->top <= y && y <= r->bottom) {
			pos->x = r->left;
			pos->y = r->top;
			*id = (*iter)->id;
			return 1;
		}
	}
	return 0;
}

//----------------------------------------------------------
// t@C[hB
//----------------------------------------------------------
void TMatchTestForm::LoadFile()
{
	AnsiString		ext;

	ext = ExtractFileExt(m_ImgPath);
	if (AnsiCompareText(ext, ".bmp") == 0) {
		int		open_error;

		open_error = 0;
		try {
			m_Screen->LoadFromFile(m_ImgPath);
		} catch (EFOpenError &e) {
			ShowMessage("t@CJ܂B");
			open_error = 1;
		}
		if (open_error || m_Screen->Width != LCD_WID || m_Screen->Height != LCD_HEI) {
			ImgCapture->Picture->Bitmap->Width = 0;
			ImgCapture->Picture->Bitmap->Height = 0;
			m_ImgPath = "";
		} else {
			Finish();
			DrawUpdate();
		}
	} else if (AnsiCompareText(ext, ".ppp") == 0) {
		FILE							*fp;
		int								rn, val;

		fp = fopen(m_ImgPath.c_str(), "rb");
		if (fp == NULL) {
			ShowMessage("t@CJ܂B");
			return;
		}

		// f[^o[W̊mFB
		fread(&val, sizeof(val), 1, fp);
		if (val != DATA_VER) {
			ShowMessage("f[^o[WႢ܂B");
			fclose(fp);
			return;
		}
		Finish();
		// [W̓ǂݏoB
		fread(&rn, sizeof(rn), 1, fp);
		for (int i = 0; i < rn; i++) {
			R_INFO		*ri;
			int			en;

			ri = new R_INFO();
			fread(&ri->rect, sizeof(ri->rect), 1, fp);
			fread(&en, sizeof(en), 1, fp);
			for (int j = 0; j < en; j++) {
				EXC		exc;
				int		xn;

				fread(&exc.pos, sizeof(exc.pos), 1, fp);
				fread(&xn, sizeof(xn), 1, fp);
				for (int k = 0; k < xn; k++) {
					fread(&val, sizeof(val), 1, fp);
					exc.id_list.push_back(val);
				}
				ri->exc_list.push_back(exc);
			}
			m_RegionList.push_back(ri);
		}
		// 摜f[^̓ǂݏoB
		fread(&val, sizeof(val), 1, fp);
		if (val) {
			m_Screen->PixelFormat = pf24bit;
			m_Screen->Width = LCD_WID;
			m_Screen->Height = LCD_HEI;
			for (int i = 0; i < LCD_HEI; i++) {
				fread(m_Screen->ScanLine[i], sizeof(char) * 3, LCD_WID, fp);
			}
		}

		fclose(fp);
		DrawUpdate();
	}
}

//----------------------------------------------------------
// t@CZ[uB
//----------------------------------------------------------
void TMatchTestForm::SaveData(const char *fname)
{
	FILE							*fp;
	std::list<R_INFO *>::iterator	iter;
	int								val;

	fp = fopen(fname, "wb");
	if (fp == NULL) {
		ShowMessage("ۑł܂łB");
		return;
	}

	// f[^o[W̕ۑB
	val = DATA_VER;
	fwrite(&val, sizeof(val), 1, fp);
	// [W̕ۑB
	val = m_RegionList.size();
	fwrite(&val, sizeof(val), 1, fp);
	for (iter = m_RegionList.begin(); iter != m_RegionList.end(); iter++) {
		std::list<EXC>				*exc_list;
		std::list<EXC>::iterator	iter2;

		fwrite(&(*iter)->rect, sizeof((*iter)->rect), 1, fp);
		exc_list = &(*iter)->exc_list;
		val = exc_list->size();
		fwrite(&val, sizeof(val), 1, fp);
		for (iter2 = exc_list->begin(); iter2 != exc_list->end(); iter2++) {
			std::list<int>				*id_list;
			std::list<int>::iterator	iter3;

			fwrite(&iter2->pos, sizeof(iter2->pos), 1, fp);
			id_list = &iter2->id_list;
			val = id_list->size();
			fwrite(&val, sizeof(val), 1, fp);
			for (iter3 = id_list->begin(); iter3 != id_list->end(); iter3++) {
				fwrite(&(*iter3), sizeof(*iter3), 1, fp);
			}
		}
	}
	// 摜f[^̕ۑB
	if (m_ImgPath != "") {
		val = 1;
		fwrite(&val, sizeof(val), 1, fp);
		for (int i = 0; i < LCD_HEI; i++) {
			fwrite(m_Screen->ScanLine[i], sizeof(char) * 3, LCD_WID, fp);
		}
	} else {
		val = 0;
		fwrite(&val, sizeof(val), 1, fp);
	}

	fclose(fp);
}

//----------------------------------------------------------
// 񌟍sB
//----------------------------------------------------------
void TMatchTestForm::SearchString()
{
	CMatchRes	ms(m_Fnt, this);

	m_SearchState = STT_SCH_RUN;
	search_string(m_SelRegion->rect, m_SelRegion->exc_list, m_Screen,
		&ms, m_FontMatchB, m_FontMatchST, m_PrioList);
	if (m_SearchState == STT_SCH_STOPPING) {
		DeleteMatch();
	} else {
		ms.Print();
	}
	m_SearchState = STT_SCH_IDLE;
}

//----------------------------------------------------------
// RXgN^B
//----------------------------------------------------------
__fastcall TMatchTestForm::TMatchTestForm(TComponent *Owner) : TForm(Owner)
{
	DragAcceptFiles(Handle, true);

	m_FontMatchB = m_TempFmB;
	m_FontMatchST = m_TempFmST;
	m_Fnt = m_TempFnt;
	m_PrioList = m_TempPl;
	m_State = STT_IDLE;
	m_SelRegion = NULL;
	m_Screen = new TBITMAP;
	m_SearchState = STT_SCH_IDLE;
}

//----------------------------------------------------------
// hbOhbvt@Cǂݍ݁B
//----------------------------------------------------------
void __fastcall TMatchTestForm::DoDropFiles(TWMDropFiles &msg)
{
	int			count;

	// hbvꂽt@CB
	count = DragQueryFile((HDROP)msg.Drop, 0xFFFFFFFF, NULL, 0);

	if (count == 1) {
		char		*buf, tmp[4];
		int			len;

		// t@C̒B
		len = DragQueryFile((HDROP)msg.Drop, 0, NULL, 0);
		buf = new char[len + 1];
		DragQueryFile((HDROP)msg.Drop, 0, buf, len + 1);
		m_ImgPath = buf;
		LoadFile();
		delete[] buf;
	}

	DragFinish((HDROP)msg.Drop);
}

//----------------------------------------------------------
// }b`OB
//----------------------------------------------------------
void TMatchTestForm::Match(const POS &s, int id, int wid)
{
	M_INFO	*info;

	info = new M_INFO;
	info->rect.left = s.x;
	info->rect.top = s.y;
	info->rect.right = s.x + wid - 1;
	info->rect.bottom = s.y + CFontMatch::MaxHeight() - 1;
	info->id = id;
	m_MatchList.push_back(info);
}

//----------------------------------------------------------
// }EXB
//----------------------------------------------------------
void __fastcall TMatchTestForm::ImgCaptureMouseDown(TObject *Sender,
	TMouseButton Button, TShiftState Shift, int X, int Y)
{
	if (m_ImgPath != "") {
		switch (m_State) {
		case STT_IDLE:
			if (Button == mbLeft) {
				if (!Shift.Contains(ssShift)) {
					R_INFO	*info;

					// STT_MOUSE_DOWNɂƂɌĂԂƂOɂĂB
					DeleteMatch();
					if (InRegion(X, Y, &info)) {
						m_SelRegion = info;
						SearchString();
					} else {
						m_SelRegion = new R_INFO();
						m_SelRegion->rect.left = m_SelRegion->rect.right = X;
						m_SelRegion->rect.top = m_SelRegion->rect.bottom = Y;
						m_State = STT_MOUSE_DOWN;
					}
					DrawUpdate();
				} else {
					POS		pos;
					int		id;

					if (InMatch(X, Y, &pos, &id)) {
						std::list<EXC>				*exc_list;
						std::list<EXC>::iterator	iter;

						exc_list = &m_SelRegion->exc_list;
						for (iter = exc_list->begin(); iter != exc_list->end(); iter++) {
							if (iter->pos.x == pos.x && iter->pos.y == pos.y) {
								break;
							}
						}
						if (iter != exc_list->end()) {
							iter->id_list.push_back(id);
						} else {
							EXC		exc;

							exc.pos = pos;
							exc.id_list.push_back(id);
							exc_list->push_back(exc);
						}
						DeleteMatch();
						SearchString();
						DrawUpdate();
					}
				}
			} else if (Button == mbRight) {
				R_INFO	*info;

				if (InRegion(X, Y, &info)) {
					DeleteRegion(info);
					DrawUpdate();
				}
			}
			break;
		}
	}
}

//----------------------------------------------------------
// }EXړB
//----------------------------------------------------------
void __fastcall TMatchTestForm::ImgCaptureMouseMove(TObject *Sender,
	TShiftState Shift, int X, int Y)
{
	switch (m_State) {
	case STT_MOUSE_DOWN:
		m_SelRegion->rect.right = X;
		m_SelRegion->rect.bottom = Y;
		DrawUpdate();
		break;
	}
}

//----------------------------------------------------------
// }EXB
//----------------------------------------------------------
void __fastcall TMatchTestForm::ImgCaptureMouseUp(TObject *Sender,
	TMouseButton Button, TShiftState Shift, int X, int Y)
{
	TRect	*rect;

	switch (m_State) {
	case STT_MOUSE_DOWN:
		m_SelRegion->rect.right = X;
		m_SelRegion->rect.bottom = Y;
		// DeleteMatch()́AƂSTT_MOUSE_DOWNɂȂKĂłB
		if (CheckRegion(&m_SelRegion->rect)) {
			m_RegionList.push_front(m_SelRegion);
			SearchString();
		} else {
			delete m_SelRegion;
			m_SelRegion = NULL;
		}
		m_State = STT_IDLE;
		DrawUpdate();
		break;
	}
}

//----------------------------------------------------------
// B
//----------------------------------------------------------
void __fastcall TMatchTestForm::FormClose(TObject *Sender,
      TCloseAction &Action)
{
	Finish();
}

//----------------------------------------------------------
// L[B
//----------------------------------------------------------
void __fastcall TMatchTestForm::FormKeyDown(TObject *Sender, WORD &Key,
      TShiftState Shift)
{
	if (m_SearchState == STT_SCH_RUN) {
		if (Key == VK_ESCAPE) {
			m_SearchState = STT_SCH_STOPPING;
		}
	} else if (Shift.Contains(ssCtrl)) {
		switch (Key) {
		case 'R':
			if (m_ImgPath != "") {
				LoadFile();
			}
			break;
		case 'S':
			if (SaveDialog->Execute()) {
				SaveData(SaveDialog->FileName.c_str());
			}
			break;
		}
	}
}
