#ifndef FrmMatchTestH
#define FrmMatchTestH

#include <Classes.hpp>
#include <Controls.hpp>
#include <StdCtrls.hpp>
#include <Forms.hpp>
#include <ExtCtrls.hpp>
#include <Graphics.hpp>
#include <Dialogs.hpp>
#include <list>
#include <stdio.h>

#include "../lib/font_match.h"
#include "search_string.h"

typedef Graphics::TBitmap TBITMAP;

//----------------------------------------------------------
// }b`OeXgB
//----------------------------------------------------------
class TMatchTestForm : public TForm {
__published:	// IDE Ǘ̃R|[lg
	TPanel		*PnlCapture;
	TImage		*ImgCapture;
    TSaveDialog *SaveDialog;
	void __fastcall ImgCaptureMouseDown(TObject *Sender,
		TMouseButton Button, TShiftState Shift, int X, int Y);
	void __fastcall ImgCaptureMouseMove(TObject *Sender, TShiftState Shift,
		int X, int Y);
	void __fastcall ImgCaptureMouseUp(TObject *Sender, TMouseButton Button,
		TShiftState Shift, int X, int Y);
    void __fastcall FormClose(TObject *Sender, TCloseAction &Action);
    void __fastcall FormKeyDown(TObject *Sender, WORD &Key,
          TShiftState Shift);

private:	// [U[錾
	enum {
		STT_IDLE = 0,
		STT_MOUSE_DOWN,
		STT_SCH_IDLE = 0,
		STT_SCH_RUN,
		STT_SCH_STOPPING
	};
	struct R_INFO {
		TRect			rect;
		std::list<EXC>	exc_list;
	};
	struct M_INFO {
		TRect			rect;
		int				id;
	};
	CFontMatch				*m_FontMatchB;
	CFontMatch				*m_FontMatchST;
	const CFontData			*m_Fnt;
	AnsiString				m_ImgPath;
	int						m_State;
	std::list<R_INFO *>		m_RegionList;
	TBITMAP					*m_Screen;
	R_INFO					*m_SelRegion;
	std::list<M_INFO *>		m_MatchList;
	unsigned char			*m_PrioList;
	int						m_SearchState;

	int InRegion(int x, int y, R_INFO **info);
	void DeleteRegion(R_INFO *info);
	void DeleteRegion();
	void DeleteMatch();
	int CheckRegion(TRect *rect);
	void DrawUpdate();
	void Finish();
	void RectToPoints(const TRect &rect, TPoint *pnt);
	int InMatch(int x, int y, POS *pos, int *id);
	void LoadFile();
	void SaveData(const char *fname);
	void SearchString();

public:		// [U[錾
	static CFontMatch			*m_TempFmB;
	static CFontMatch			*m_TempFmST;
	static const CFontData		*m_TempFnt;
	static unsigned char		*m_TempPl;

	__fastcall TMatchTestForm(TComponent *Owner);
	void __fastcall DoDropFiles(TWMDropFiles &msg);
	void Match(const POS &s, int id, int wid);
	int SearchStopping() const { return m_SearchState == STT_SCH_STOPPING; }

BEGIN_MESSAGE_MAP
	VCL_MESSAGE_HANDLER(WM_DROPFILES, TWMDropFiles, DoDropFiles)
END_MESSAGE_MAP(TForm)
};

extern PACKAGE TMatchTestForm	*MatchTestForm;

#endif
