#include <vcl.h>
#include <stdio.h>
#pragma hdrstop

#include "FrmMatchTest.h"
#include "../lib/font_match.h"

#define	FONT_SET_NUM	(3)

static unsigned char *make_priority(const CFontData *fnt, int fs_num);

USEFORM("FrmMatchTest.cpp", MatchTestForm);
//---------------------------------------------------------------------------
WINAPI WinMain(HINSTANCE, HINSTANCE, LPSTR, int)
{
	try {
		static const char	*fname[] = {
			"data/button.dat",
			"data/system.dat",
			"data/talk.dat"
	//		"data/test.dat"
		};
		CFontMatch		fm_b, fm_st;
		CFontData		fnt[FONT_SET_NUM];
		unsigned char	*prio_list;

		fnt[0].SetButton();
		for (int i = 0; i < FONT_SET_NUM; i++) {
			fnt[i].LoadFromFile(fname[i]);
		}
		fm_b.Init(fnt, 1);
		fm_st.Init(&fnt[1], FONT_SET_NUM - 1);

		prio_list = make_priority(fnt, FONT_SET_NUM);

		TMatchTestForm::m_TempFmB = &fm_b;
		TMatchTestForm::m_TempFmST = &fm_st;
		TMatchTestForm::m_TempFnt = fnt;
		TMatchTestForm::m_TempPl = prio_list;

		Application->Initialize();
		Application->CreateForm(__classid(TMatchTestForm), &MatchTestForm);
		Application->Run();

		if (prio_list) {
			delete[] prio_list;
		}
	} catch (Exception &exception) {
		Application->ShowException(&exception);
	} catch (...) {
		try {
			throw Exception("");
		} catch (Exception &exception) {
			Application->ShowException(&exception);
		}
	}
	return 0;
}

//----------------------------------------------------------
// DxXg̐B
//----------------------------------------------------------
static unsigned char *make_priority(const CFontData *fnt, int fs_num)
{
	int				f_num, prio;
	char			dum[3], buf[256];
	unsigned char	*prio_list;
	FILE			*fp;

	f_num = 0;
	for (int i = 0; i < fs_num; i++) {
		int		n;

		n = fnt[i].FontNum();
		if (f_num < n) {
			f_num = n;
		}
	}
	prio_list = new unsigned char[f_num];
	for (int i = 0; i < f_num; i++) {
		prio_list[i] = 0;
	}

	fp = fopen("priority.txt", "rt");
	if (fp == NULL) {
		ShowMessage("t@C܂B");
		return NULL;
	}
	// utf-8BOMǂݔ΂B
	fread(dum, sizeof(char), 3, fp);

	prio = 1;
	while (fgets(buf, 256, fp)) {
		int		n, code;

		n = sscanf(buf, "%d", &code);
		if (n == 1) {
			prio_list[code - 1] = prio++;
		}
	}

	fclose(fp);
	return prio_list;
}
