#include <stdlib.h>
#pragma hdrstop

#include "search_string.h"
#include "../lib/font_match.h"

#define	REGION_MARGIN	(3)

//----------------------------------------------------------
// FxB
//----------------------------------------------------------
struct COL_NUM {
	COL		col;
	int		num;
};

static int __cdecl comp_col_num(const void *a, const void *b);
static int matching(const POS &s, CFontMatch *fm, TBITMAP *bmp,
	const COL *sel, int sel_num, int button, CFontMatch::INFO **res,
	unsigned char *prio_list, const std::list<int> *id_list);

//----------------------------------------------------------
// 񌟍sB
//----------------------------------------------------------
void search_string(const TRect &reg, const std::list<EXC> &exc_list, TBITMAP *bmp,
	IMatchRes *m, CFontMatch *fm_b, CFontMatch *fm_st, unsigned char *prio_list)
{
	COL_NUM					*col_array;
	int						col_size, match_col;
	int						siz;
	POS						s, e, c;
	int						min_wid, max_hei, skip_height;
	int						min_wid_b, min_wid_st;
	std::list<COL_NUM *>	col_list;

	min_wid_b = fm_b->MinWidth();
	min_wid_st = fm_st->MinWidth();
	min_wid = (min_wid_b < min_wid_st) ? min_wid_b : min_wid_st;
	max_hei = CFontMatch::MaxHeight();
	// F̕zvB
	siz = (reg.right - reg.left) * (reg.bottom - reg.top);
	col_array = new COL_NUM[siz];
	for (int i = 0; i < siz; i++) {
		col_array[i].num = 0;
	}
	col_size = 0;
	for (int y = reg.top; y < reg.bottom; y++) {
		unsigned char	*c;

		c = (unsigned char *)bmp->ScanLine[y];
		for (int x = reg.left; x < reg.right; x++) {
			COL		col;
			int		i;

			col.b = c[x * 3 + 0];
			col.g = c[x * 3 + 1];
			col.r = c[x * 3 + 2];
			for (i = 0; i < col_size; i++) {
				if (col.val == col_array[i].col.val) {
					break;
				}
			}
			if (i == col_size) {
				col_array[i].col = col;
				col_size++;
			}
			col_array[i].num++;
		}
	}
	qsort(col_array, col_size, sizeof(COL_NUM), comp_col_num);
	for (int i = 0; i < col_size; i++) {
		col_list.push_back(&col_array[i]);
	}

	// Ï̍ォAɑSFŃ}b`OB
	s.x = reg.left - REGION_MARGIN;
	if (s.x < 0) {
		s.x = 0;
	}
	s.y = reg.top - REGION_MARGIN;
	if (s.y < 0) {
		s.y = 0;
	}
	e.x = reg.right - (min_wid - 1) + REGION_MARGIN;
	e.y = reg.bottom - (max_hei - 1) + REGION_MARGIN;
	if (LCD_HEI - (max_hei - 1) < e.y) {
		e.y = LCD_HEI - (max_hei - 1) ;
	}

	skip_height = 0;
	c = s;
	m->Reset();
	if (e.x - s.x <= 0 || e.y - s.y <= 0) {
		goto end;
	}
	while (1) {
		std::list<COL_NUM *>::iterator	iter, iter2;
		CFontMatch::INFO				*p;
		int								find, button;
		std::list<EXC>::const_iterator	iter3;
		const std::list<int>			*id_list, dum_id_list;

		if (m->IsCancel()) {
			break;
		}
		if (e.x <= c.x) {
			c.x = s.x;
			if (skip_height) {
				c.y += max_hei;
				skip_height = 0;
				m->Return();
			} else {
				c.y++;
			}
			if (e.y <= c.y) {
				break;
			}
		}
		find = 0;
		id_list = NULL;
		for (iter3 = exc_list.begin(); iter3 != exc_list.end(); iter3++) {
			if (c.x == iter3->pos.x && c.y == iter3->pos.y) {
				id_list = &iter3->id_list;
			}
		}
		if (id_list == NULL) {
			id_list = &dum_id_list;
		}
		for (iter = col_list.begin(); iter != col_list.end(); iter++) {
			find = matching(c, fm_st, bmp, &(*iter)->col, 1, 0, &p, prio_list, id_list);
			if (find) {
				button = 0;
				break;
			}
		}
		if (!find) {
			for (iter = col_list.begin(); iter != col_list.end(); iter++) {
				find = matching(c, fm_b, bmp, &(*iter)->col, 1, 0, &p, prio_list, id_list);
				if (find) {
					button = 1;
					break;
				}
			}
			if (!find) {
				std::list<COL_NUM *>::iterator	iter_last;

				iter_last = col_list.end();
				iter_last--;
				for (iter = col_list.begin(); iter != iter_last; iter++) {
					for (iter2 = iter, iter2++; iter2 != col_list.end(); iter2++) {
						COL		col2[2];

						col2[0] = (*iter)->col;
						col2[1] = (*iter2)->col;
						find = matching(c, fm_b, bmp, col2, 2, 1, &p, prio_list, id_list);
						if (find) {
							button = 2;
							break;
						}
					}
					if (find) {
						break;
					}
				}
			}
		}
		if (find) {
			c.x += m->Notify(1, p->set_id, p->id, c, button != 0);
			skip_height = 1;
			col_list.push_front(*iter);
			col_list.erase(iter);
			if (button == 2) {
				col_list.push_front(*iter2);
				col_list.erase(iter2);
			}
		} else {
			c.x++;
			m->Notify(0, 0, 0, c, button);
		}
	}

end:
	m->Finish();
	delete[] col_array;
}

//----------------------------------------------------------
// Fzr֐B
//----------------------------------------------------------
static int __cdecl comp_col_num(const void *a, const void *b)
{
	const COL_NUM	*a_col = (const COL_NUM *)a;
	const COL_NUM	*b_col = (const COL_NUM *)b;

	return b_col->num - a_col->num;
}

//----------------------------------------------------------
// tHg}b`B
//----------------------------------------------------------
static int matching(const POS &s, CFontMatch *fm, TBITMAP *bmp,
	const COL *sel, int sel_num, int button, CFontMatch::INFO **res,
	unsigned char *prio_list, const std::list<int> *id_list)
{
	unsigned char	*c;
	POS				cur, e;
	int				find;

	cur = s;
	e.x = s.x + fm->MaxWidth();
	if (LCD_WID < e.x) {
		e.x = LCD_WID;
	}
	e.y = s.y + CFontMatch::MaxHeight();
	fm->Reset(e.x - s.x);
	c = (unsigned char *)bmp->ScanLine[cur.y];
	while (1) {
		TList	*list;
		int		val;
		COL		col;

		col.b = c[cur.x * 3 + 0];
		col.g = c[cur.x * 3 + 1];
		col.r = c[cur.x * 3 + 2];
		val = 0;
		for (int i = 0; i < sel_num; i++) {
			if (col.val == sel[i].val) {
				val = 1;
				break;
			}
		}
		list = fm->NextDot(val);
		if (list) {
			int					prio;
			CFontMatch::INFO	*q;

			prio = 0x7fffffff;
			q = NULL;
			for (int i = 0; i < list->Count; i++) {
				CFontMatch::INFO				*p;
				std::list<int>::const_iterator	iter;

				p = (CFontMatch::INFO *)list->Items[i];
				for (iter = id_list->begin(); iter != id_list->end(); iter++) {
					if (*iter == p->id) {
						break;
					}
				}
				if (iter == id_list->end()) {
					if (prio_list[p->id] < prio) {
						prio = prio_list[p->id];
						q = p;
					}
				}
			}
			if (q) {
				*res = q;
				find = 1;
			} else {
				find = 0;
			}
			break;
		}
		if (e.x <= ++cur.x) {
			if (e.y <= ++cur.y) {
				ShowMessage("ɂ̂́AB");
				find = 0;
				break;
			}
			cur.x = s.x;
			c = (unsigned char *)bmp->ScanLine[cur.y];
		}
	}
	return find;
}
