#ifndef	SEARCH_STRING_H
#define	SEARCH_STRING_H

#include <vcl.h>
#include <list>

#define	LCD_WID		(256)
#define	LCD_HEI		(192 * 2)

class CFontMatch;

typedef Graphics::TBitmap TBITMAP;

//----------------------------------------------------------
// FB
//----------------------------------------------------------
struct COL {
	union {
		struct {
			unsigned char	r;
			unsigned char	g;
			unsigned char	b;
		};
		unsigned			val;
	};
	COL() { val = 0; }
};

//----------------------------------------------------------
// ʒuB
//----------------------------------------------------------
struct POS {
	int		x;
	int		y;
};

//----------------------------------------------------------
// }b`OOB
//----------------------------------------------------------
struct EXC {
	POS				pos;
	std::list<int>	id_list;
};

//----------------------------------------------------------
// }b`OʃC^tF[XB
//----------------------------------------------------------
class IMatchRes {
public:
	virtual void Reset() { }
	virtual void Return() { }
	virtual int Notify(int match, int set_id, int id, const POS &s, int button) = 0;
	virtual void Finish() = 0;
	virtual int IsCancel() { return 0; }
};

void search_string(const TRect &reg, const std::list<EXC> &exc_list, TBITMAP *bmp,
	IMatchRes *m, CFontMatch *fm_b, CFontMatch *fm_st, unsigned char *prio_list);

#endif
