#include <vcl.h>
#include <stdio.h>
#pragma hdrstop

#include "FrmTreeViewer.h"
#include "../lib/font_data.h"

#pragma package(smart_init)
#pragma resource "*.dfm"

TTreeViewerForm		*TreeViewerForm;
const CFontMatch	*TTreeViewerForm::m_TempFm;

//----------------------------------------------------------
// c[\XVB
//----------------------------------------------------------
void TTreeViewerForm::UpdateShowTree()
{
	char	buf[256];

	if (m_Parent->color == 2) {
		BtnParent->Caption = "q";
		LblParent->Caption = "";
		BtnParentUpper->Enabled = false;
	} else {
		if (m_Parent->color == 0) {
			BtnParent->Caption = "";
		} else {
			BtnParent->Caption = "";
		}
		sprintf(buf, "( %d, %d ) %d", m_CurX, m_CurY,
			m_Parent->node->list->Count);
		LblParent->Caption = buf;
		BtnParentUpper->Enabled = true;
	}

	sprintf(buf, "( %d, %d ) %d", m_NextX, m_NextY,
		m_Parent->node->next[0]->list->Count);
	LblWhite->Caption = buf;
	if (m_Parent->node->next[0]->end || m_PosEnd) {
		BtnWhiteLower->Enabled = false;
	} else {
		BtnWhiteLower->Enabled = true;
	}
	sprintf(buf, "( %d, %d ) %d", m_NextX, m_NextY,
		m_Parent->node->next[1]->list->Count);
	LblBlack->Caption = buf;
	if (m_Parent->node->next[1]->end || m_PosEnd) {
		BtnBlackLower->Enabled = false;
	} else {
		BtnBlackLower->Enabled = true;
	}
}

//----------------------------------------------------------
// Iʒu`FbNB
//----------------------------------------------------------
void TTreeViewerForm::CheckPosEnd()
{
	if (m_CurFontMatchWidth->m_FontWidth <= m_NextX + 1) {
		if (CFontMatch::MaxHeight() <= m_NextY + 1) {
			m_PosEnd = 1;
		}
	}
}

//----------------------------------------------------------
// q̎ɈړB
//----------------------------------------------------------
void TTreeViewerForm::NextNode(int id)
{
	CFontMatchWidth::NODE	*next;

	next = m_Parent->node->next[id];
	m_Trace->Add(m_Parent);
	m_Parent = new INFO;
	m_Parent->node = next;
	m_Parent->color = id;
	m_CurX = m_NextX;
	m_CurY = m_NextY;
	if (m_CurFontMatchWidth->m_FontWidth <= ++m_NextX) {
		m_NextX = 0;
		m_NextY++;
	}
	CheckPosEnd();
	UpdateShowTree();
}

//----------------------------------------------------------
// m[hJEgB
//----------------------------------------------------------
int TTreeViewerForm::CountNode(CFontMatchWidth::NODE *node)
{
	int		n;

	if (node->end) {
		return 1;
	}
	n = 0;
	for (int i = 0; i < 2; i++) {
		n += CountNode(node->next[i]);
	}
	return n + 1;
}

//----------------------------------------------------------
// g[X폜B
//----------------------------------------------------------
void TTreeViewerForm::DeleteTrace()
{
	for (int i = 0; i < m_Trace->Count; i++) {
		delete (INFO *)m_Trace->Items[i];
	}
}

//----------------------------------------------------------
// RXgN^B
//----------------------------------------------------------
__fastcall TTreeViewerForm::TTreeViewerForm(TComponent *Owner) : TForm(Owner)
{
	TList	*list;

	m_FontMatch = m_TempFm;

	for (int i = 15; 0 <= i; i--) {
		CFontMatchWidth		*p;

		p = m_FontMatch->m_MatchOrg[i];
		if (p) {
			CBWidth->AddItem(p->m_FontWidth, (TObject *)p);
		}
	}
	m_Trace = new TList();
	m_Parent = new INFO;

	CBWidth->ItemIndex = 0;
	CBWidthChange(NULL);
}

//----------------------------------------------------------
// Xg\B
//----------------------------------------------------------
void TTreeViewerForm::ShowList(TList *list)
{
	AnsiString		str;

	for (int i = 0; i < list->Count; i++) {
		CFontMatch::INFO	*p;
		char				buf[256];

		p = (CFontMatch::INFO *)list->Items[i];
		sprintf(buf, "%d", p->id);
		str = str + buf;
		if (i != list->Count - 1) {
			str = str + ", ";
		}
	}
	ShowMessage(str);
}

//----------------------------------------------------------
// ȅ{^B
//----------------------------------------------------------
void __fastcall TTreeViewerForm::BtnParentUpperClick(TObject *Sender)
{
	delete m_Parent;
	m_Parent = (INFO *)m_Trace->Last();
	m_Trace->Delete(m_Trace->Count - 1);
	m_NextX = m_CurX;
	m_NextY = m_CurY;
	if (--m_CurX < 0) {
		m_CurX = m_CurFontMatchWidth->m_FontWidth - 1;
		m_CurY--;
	}
	m_PosEnd = 0;
	UpdateShowTree();
}

//----------------------------------------------------------
// ̉{^B
//----------------------------------------------------------
void __fastcall TTreeViewerForm::BtnWhiteLowerClick(TObject *Sender)
{
	NextNode(0);
}

//----------------------------------------------------------
// ̉{^B
//----------------------------------------------------------
void __fastcall TTreeViewerForm::BtnBlackLowerClick(TObject *Sender)
{
	NextNode(1);
}

//----------------------------------------------------------
// IB
//----------------------------------------------------------
void __fastcall TTreeViewerForm::FormClose(TObject *Sender, TCloseAction &Action)
{
	delete m_Parent;
	DeleteTrace();
	delete m_Trace;
}

//----------------------------------------------------------
// e̒gB
//----------------------------------------------------------
void __fastcall TTreeViewerForm::BtnParentClick(TObject *Sender)
{
	ShowList(m_Parent->node->list);
}

//----------------------------------------------------------
// ̒gB
//----------------------------------------------------------
void __fastcall TTreeViewerForm::BtnWhiteClick(TObject *Sender)
{
	ShowList(m_Parent->node->next[0]->list);
}

//----------------------------------------------------------
// ̒gB
//----------------------------------------------------------
void __fastcall TTreeViewerForm::BtnBlackClick(TObject *Sender)
{
	ShowList(m_Parent->node->next[1]->list);
}

//----------------------------------------------------------
// vm[hB
//----------------------------------------------------------
void __fastcall TTreeViewerForm::BtnTotalClick(TObject *Sender)
{
	int		n;

	n = CountNode(m_CurFontMatchWidth->m_Root);
	ShowMessage(n);
}

//----------------------------------------------------------
// IB
//----------------------------------------------------------
void __fastcall TTreeViewerForm::CBWidthChange(TObject *Sender)
{
	m_CurFontMatchWidth = (CFontMatchWidth *)CBWidth->Items->Objects[CBWidth->ItemIndex];
	m_Parent->node = m_CurFontMatchWidth->m_Root;
	m_Parent->color = 2;
	m_CurX = m_CurFontMatchWidth->m_FontWidth - 1;
	m_CurY = -1;
	m_NextX = 0;
	m_NextY = 0;
	m_PosEnd = 0;
	CheckPosEnd();
	UpdateShowTree();
}
