#ifndef FrmTreeViewerH
#define FrmTreeViewerH

#include <Classes.hpp>
#include <Controls.hpp>
#include <StdCtrls.hpp>
#include <Forms.hpp>

#include "../lib/font_match.h"

//----------------------------------------------------------
// c[\B
//----------------------------------------------------------
class TTreeViewerForm : public TForm {
__published:	// IDE Ǘ̃R|[lg
	TButton		*BtnParent;
	TButton		*BtnWhite;
	TButton		*BtnBlack;
	TLabel		*LblWhite;
	TLabel		*LblParent;
	TLabel		*LblBlack;
	TButton		*BtnParentUpper;
	TButton		*BtnWhiteLower;
	TButton		*BtnBlackLower;
	TButton		*BtnTotal;
	TComboBox	*CBWidth;
	void __fastcall BtnParentUpperClick(TObject *Sender);
	void __fastcall BtnWhiteLowerClick(TObject *Sender);
	void __fastcall BtnBlackLowerClick(TObject *Sender);
	void __fastcall FormClose(TObject *Sender, TCloseAction &Action);
	void __fastcall BtnParentClick(TObject *Sender);
	void __fastcall BtnWhiteClick(TObject *Sender);
	void __fastcall BtnBlackClick(TObject *Sender);
	void __fastcall BtnTotalClick(TObject *Sender);
	void __fastcall CBWidthChange(TObject *Sender);

private:	// [U[錾
	struct INFO {
		CFontMatchWidth::NODE	*node;
		int						color;
	};
	const CFontMatch		*m_FontMatch;
	const CFontMatchWidth	*m_CurFontMatchWidth;
	INFO					*m_Parent;
	int						m_CurX;
	int						m_CurY;
	int						m_NextX;
	int						m_NextY;
	int						m_PosEnd;
	TList					*m_Trace;

	void UpdateShowTree();
	void CheckPosEnd();
	void NextNode(int id);
	int CountNode(CFontMatchWidth::NODE *node);
	void DeleteTrace();
	static void ShowList(TList *list);

public:		// [U[錾
	static const CFontMatch		*m_TempFm;

	__fastcall TTreeViewerForm(TComponent *Owner);
};

extern PACKAGE TTreeViewerForm	*TreeViewerForm;

#endif
