﻿use strict;
use utf8;

binmode(STDERR, "encoding(shiftjis)");

main();
exit;

#===========================================================
# メイン処理。
#===========================================================
sub main {
	my (@list, %block, @dst);

	if (!(2 <= @ARGV && @ARGV <= 3)) {
		die "引数は２つか３つ。\n";
	}

	{
		my ($f_list, %list);

		$f_list = $ARGV[1];
		# ファイルリストを作る。
		if (!open(LIST, $f_list)) {
			die "${f_list}が開けない。\n";
		}
		while (<LIST>) {
			my ($fname);

			if (!/\"([^\"]+)\"/) {
				die "リストファイルのフォーマットがおかしい。\n";
			}
			$fname = $1;
			$fname =~ s/^.*[\\\/]([^\\\/]+)$/$1/;
			if (exists $list{$fname}) {
				die "ファイル名が重複している。\n";
			}
			push @list, $fname;
			$list{$fname} = 1;
		}
		close LIST;
	}

	{
		my ($f_arc);

		$f_arc = $ARGV[0];
		# アーカイブファイルを開く。
		if (!open(ARC, $f_arc)) {
			die "${f_arc}が開けない。\n";
		}
		binmode(ARC, "raw");
	}

	{
		my ($ofs, $sig);

		# 各ブロックのオフセット取得。
		get_data(\$ofs, \*ARC, 12, 0, 2, "S");
		while (get_data(\$sig, \*ARC, $ofs, 0, 4, "Z4")) {
			my ($size);

			$sig = reverse($sig);
			$block{$sig} = $ofs;
			get_data(\$size, \*ARC, 0, 1, 4, "L");
			$ofs += $size;
		}
	}

	{
		my ($ofs, $dst_num);

		# ファイル情報を取得。
		$ofs = $block{"FATB"} + 8;
		get_data(\$dst_num, \*ARC, $ofs, 0, 2, "S");
		if ($dst_num != @list) {
			die "ファイル数が一致しません。\n";
		}
		$ofs += 4;
		for my $i (0 .. $dst_num - 1) {
			my ($top, $btm);

			get_data(\$top, \*ARC, $ofs, 0, 4, "L");
			get_data(\$btm, \*ARC, $ofs + 4, 0, 4, "L");
			push @dst, { top => $top, btm => $btm };
			$ofs += 8;
		}
	}

	{
		my ($bs, $dir);

		# ファイルを保存。
		if (defined($ARGV[2])) {
			$dir = "$ARGV[2]/";
		}
		$bs = $block{"FIMG"} + 8;
		for my $i (0 .. $#list) {
			my ($ofs, $size, $data);

			$ofs = $bs + $dst[$i]{top};
			$size = $dst[$i]{btm} - $dst[$i]{top};
			get_data(\$data, \*ARC, $ofs, 0, $size, "a${size}");

			if (!open(DST, ">$dir$list[$i]")) {
				die "$list[$i]が開けない。\n";
			}
			binmode(DST, "raw");
			print DST $data;
			close DST;
		}
	}

	close ARC;
}

#===========================================================
# バイナリデータ読み込み。
#===========================================================
sub get_data {
	my ($dst, $hdl, $ofs, $bs, $size, $fmt) = @_;
	my ($data, $res);

	seek($hdl, $ofs, $bs);
	$res = read($hdl, $data, $size);
	$$dst = unpack($fmt, $data);
	return $res;
}
