﻿use strict;
use File::Find;
use utf8;
use xls;
use util::log;

binmode(STDOUT, "utf8");
binmode(STDERR, "encoding(shiftjis)");

my %CHECK_COL = (
	"DP_Areanames.xls"   => { msg_id => 'A', text => { 
		old => [ 'D' ],
		new => [ 'D' ] } },
	"DP_Berries.xls"     => { msg_id => 'A', text => {
		old => [ 'D', 'G' ],
		new => [ 'D', 'F' ] } },
	"DP_Characters.xls"  => { msg_id => 'A', text => {
		old => [ 'D' ],
		new => [ 'D' ] } },
	"DP_Items.xls"       => { msg_id => 'A', text => {
		old => [ 'D', 'G', 'N', 'P', 'R' ],
		new => [ 'D', 'F', 'L', 'M', 'N' ] } },
	"DP_Moves.xls"       => { msg_id => 'A', text => {
		old => [ 'D', 'G', 'N' ],
		new => [ 'D', 'F', 'L' ] } },
	"DP_Pokedex.xls"     => { msg_id => 'A', text => {
		old => [ 'C', 'J', 'M', 'T' ],
		new => [ 'C', 'G', 'I', 'O' ] } },
	"DP_Simpletext.xls"  => { msg_id => 'A', text => {
		old => [ 'D' ],
		new => [ 'D' ] } },
	"DP_SpeAbility.xls"  => { msg_id => 'A', text => {
		old => [ 'D', 'G', 'N' ],
		new => [ 'D', 'F', 'L' ] } },
	"DP_Stickers.xls"    => { msg_id => 'A', text => {
		old => [ 'D', 'G', 'N' ],
		new => [ 'D', 'F', 'L' ] } },
	"DP_Trainers.xls"    => { msg_id => 'A', text => {
		old => [ 'D', 'G', 'M' ],
		new => [ 'D', 'F', 'K' ] } },
	"DP_Underground.xls" => { msg_id => 'A', text => {
		old => [ 'D', 'E', 'I', 'P' ],
		new => [ 'D', 'E', 'G', 'M' ] } }
);
my %CHECK_COL_EU = (
	"DP_Areanames.xls"   => { msg_id => 'A', text => { 
		old => [ 'E' ],
		new => [ 'E' ] } },
	"DP_Berries.xls"     => { msg_id => 'A', text => {
		old => [ 'E', 'H' ],
		new => [ 'E', 'H' ] } },
	"DP_Characters.xls"  => { msg_id => 'A', text => {
		old => [ 'E' ],
		new => [ 'E' ] } },
	"DP_Items.xls"       => { msg_id => 'A', text => {
		old => [ 'E', 'H', 'O', 'Q', 'S' ],
		new => [ 'E', 'H', 'O', 'Q', 'S' ] } },
	"DP_Moves.xls"       => { msg_id => 'A', text => {
		old => [ 'E', 'H', 'O' ],
		new => [ 'E', 'H', 'O' ] } },
	"DP_Pokedex.xls"     => { msg_id => 'A', text => {
		old => [ 'D', 'G', 'H', 'K', 'N', 'U' ],
		new => [ 'D', 'G', 'H', 'K', 'N', 'U' ] } },
	"DP_Simpletext.xls"  => { msg_id => 'A', text => {
		old => [ 'E' ],
		new => [ 'E' ] } },
	"DP_SpeAbility.xls"  => { msg_id => 'A', text => {
		old => [ 'E', 'H', 'O' ],
		new => [ 'E', 'H', 'O' ] } },
	"DP_Stickers.xls"    => { msg_id => 'A', text => {
		old => [ 'E', 'H', 'O' ],
		new => [ 'E', 'H', 'O' ] } },
	"DP_Trainers.xls"    => { msg_id => 'A', text => {
		old => [ 'E', 'H', 'N' ],
		new => [ 'E', 'H', 'N' ] } },
	"DP_Underground.xls" => { msg_id => 'A', text => {
		old => [ 'F', 'G', 'J', 'Q' ],
		new => [ 'F', 'G', 'J', 'Q' ] } }
);
my %COL_NUM;
# 0: 英語のコピー、1: 英語を欧州の英語欄にコピー、2: 欧州のコピー。
my $EU = 2;

main();
exit;

#===========================================================
# メイン処理。
#===========================================================
sub main {
	my %f_list = (
		"old" => [ sort @{get_file_list("old")} ],
		"new" => [ sort @{get_file_list("new")} ]
	);

	{
		# カラム文字をインデクス値に変換するテーブル。
		my ($letter, $idx) = ( 'A', 0 );

		for my $i (1 .. 100) {
			$COL_NUM{$letter} = $idx;
			$letter++;
			$idx++;
		}
	}
	for (my $i = 0; $i < @{$f_list{old}}; $i++) {
		my (%file, %xls, %data, @head, %col, $row);
		my %path = (
			"old" => $f_list{old}[$i],
			"new" => $f_list{new}[$i]
		);
		my %file = ( %path );

		for my $i (keys %path) {
			$file{$i} =~ s/^.*[\\\/]_?([^\\\/]+)$/$1/;
			$xls{$i} = new xls($path{$i});
			$data{$i} = $xls{$i}->getData('Z');
			@head = ( @{$data{$i}[0]} );	# ヘッダは共通なので１つでよい。
		}
		if ($file{old} ne $file{new}) {
			die "error: ファイル名が一致しない。\n";
		}

		print STDERR "===$file{old}===\n";

		util::log::setFileName($file{old});
		if ($EU != 2) {
			%col = ( %{$CHECK_COL{$file{old}}} );
		} else {
			%col = ( %{$CHECK_COL_EU{$file{old}}} );
		}
		$col{msg_id} = $COL_NUM{$col{msg_id}};
		for my $j (@{$col{text}{old}}) {
			$j = $COL_NUM{$j};
		}
		for my $j (@{$col{text}{new}}) {
			$j = $COL_NUM{$j};
		}
		if ($EU == 0) {
			$col{text}{old} = $col{text}{new};
		}
		$row = 2;
		for (my $j = 1; $j < @{$data{old}}; $j++) {
			my ($col);
			my %msg_id = (
				"old" => $data{old}[$j][$col{msg_id}],
				"new" => $data{new}[$j][$col{msg_id}]
			);

			if ($msg_id{old} ne $msg_id{new}) {
				util::log::msg("idが一致しません。");
			}
			if ($EU == 1) {
				$col = 1;
				for my $k (@{$data{old}[$j]}) {
					if ($xls{old}->getColor($row, $col) == 46) {
						$xls{old}->setColor($row, $col, 2);
					}
					$col++;
				}
			}
			for (my $k = 0; $k < @{$col{text}{old}}; $k++) {
				my %text = (
					"old" => $data{old}[$j][$col{text}{old}[$k]],
					"new" => $data{new}[$j][$col{text}{new}[$k]],
					"old_ref" => \$data{old}[$j][$col{text}{old}[$k]]
				);
				my $head = $head[$col{text}{old}[$k]];

				util::log::setMsgId($msg_id{old});
				if ($text{old} ne $text{new}) {
					if ($text{old} eq "") {
						util::log::msg('NEW', $head, $text{new});
					} elsif ($text{new} eq "") {
						util::log::msg('DEL', $head, $text{old});
					} else {
						util::log::msg('UP', $head, $text{old}, '->', $text{new});
					}
					${$text{old_ref}} = $text{new};
					if ($EU == 1) {
						$xls{old}->setColor($row, $col{text}{old}[$k] + 1, 46);
					}
				}
			}
			$row++;
		}
		$xls{old}->setData('Z', $data{old});
		$xls{old}->Save();
	}
}

#===========================================================
# ファイルリスト取得。
#===========================================================
sub get_file_list {
	my ($dir) = @_;
	my $sub;
	my @list;

	$sub = sub {
		if ($File::Find::name =~ /\.xls$/) {
			push @list, $File::Find::name;
		}
	};
	find($sub, $dir);
	return \@list;
}
