﻿//This file contains the vertex, fragment, and Geometry functions for both the ForwardBase and Forward Add pass.
#if defined(SHADOWS_CUBE) && !defined(SHADOWS_CUBE_IN_DEPTH_TEX)
#define V2F_SHADOW_CASTER_NOPOS float3 vec : TEXCOORD0;
#define TRANSFER_SHADOW_CASTER_NOPOS_GEOMETRY(o,opos) o.vec = mul(unity_ObjectToWorld, v[i].vertex).xyz - _LightPositionRange.xyz; opos = o.pos;
#else
#define V2F_SHADOW_CASTER_NOPOS
#define TRANSFER_SHADOW_CASTER_NOPOS_GEOMETRY(o, opos, vertexPosition, vertexNormal) \
        opos = UnityClipSpaceShadowCasterPos(vertexPosition, vertexNormal); \
        opos = UnityApplyLinearShadowBias(opos);
#endif

v2g vert (appdata v)
{
    v2g o = (v2g)0;
    o.vertex = v.vertex;
    o.uv = v.uv;
    
    #if defined(UNITY_PASS_FORWARDBASE)
        o.uv1 = v.uv1;
        o.uv2 = v.uv2;
    #endif
    
    o.normal = v.normal;
    o.tangent = v.tangent;

    return o;
}

[maxvertexcount(27)]
void geom(triangle v2g v[3], uint pid : SV_PrimitiveID, /*uint InstanceID : SV_GSInstanceID,*/ inout TriangleStream<g2f> tristream)
{
    g2f o = (g2f)0;
    _FurLength = _FurLength * 0.3;
    float layerOffset = -_FurLength;
    float3 gravityDir = float4(0,-0.8,0,0) * _Gravity * _FurLength;

    for (int k = 0; k < _LayerCount; k++)
    {
        if(k != 0)
            layerOffset += _FurLength;

        for (int i = 0; i < 3; i++)
        {
            float3 worldNormal = UnityObjectToWorldNormal(v[i].normal);
            float4 worldPos = mul(unity_ObjectToWorld, v[i].vertex);
            
            float4 vertexPos = worldPos;
            if(k != 0)
            {
                vertexPos = float4((worldPos + normalize(worldNormal) * layerOffset) + (gravityDir * k), 1);
            }
            o.pos = UnityWorldToClipPos(vertexPos);
            o.uv = v[i].uv;
            #if defined(UNITY_PASS_FORWARDBASE)
                o.uv1 = v[i].uv1;
                o.uv2 = v[i].uv2;
            #endif

            float3 tangent = UnityObjectToWorldDir(v[i].tangent);
            float3 bitangent = cross(tangent, worldNormal) * v[i].tangent.w;

            o.btn[0] = bitangent;
            o.btn[1] = tangent;
            o.btn[2] = worldNormal;
            o.worldPos = worldPos;
            o.objPos = v[i].vertex;
            o.objNormal = v[i].normal;
            o.screenPos = ComputeScreenPos(o.pos);
            o.layer = k;

            //Only pass needed things through for shadow caster
            #if !defined(UNITY_PASS_SHADOWCASTER)
            UNITY_TRANSFER_SHADOW(o, o.uv);
            #else
            TRANSFER_SHADOW_CASTER_NOPOS_GEOMETRY(o, o.pos, v[i].vertex, v[i].normal);
            #endif
            tristream.Append(o);
        }
        tristream.RestartStrip();
    }
}
			
fixed4 frag (g2f i) : SV_Target
{
        //Return only this if in the shadowcaster
    #if defined(UNITY_PASS_SHADOWCASTER)
        float layer = i.layer;
        float2 furUV = i.uv * _NoiseTexture_ST.xy + _NoiseTexture_ST.zw;
        float4 noise = tex2D(_NoiseTexture, furUV);

        float4 albedo = texTP(_MainTex, _MainTex_ST, i.worldPos, i.objPos, i.btn[2], i.objNormal, _TriplanarFalloff, i.uv) * _Color;
        float alpha;
        doAlpha(alpha, float4(noise.r, 0, 0, albedo.a), i.screenPos, layer);
        SHADOW_CASTER_FRAGMENT(i);
    #else
        return CustomStandardLightingBRDF(i);
    #endif
}