/********************************************************************/
/*          AgbDefine.h                                             */
/*            AGBW萔                                           */
/*                                                                  */
/*          Copyright (C) 1999-2000 NINTENDO Co.,Ltd.               */
/********************************************************************/
#ifndef _AGB_DEFINE_H
#define _AGB_DEFINE_H

#ifdef __cplusplus
extern "C" {
#endif


/*------------------------------------------------------------------*/
/*                            萔                                  */
/*------------------------------------------------------------------*/

#define ON                      1
#define OFF                     0
#define ENABLE                  1
#define DISABLE                 0
#define TRUE                    1
#define FALSE                   0

#define LCD_WIDTH               240         // ʕ
#define LCD_HEIGHT              160         // ʍ


/*------------------------------------------------------------------*/
/*                WX^q`l Zbg VXeR[          */
/*------------------------------------------------------------------*/

#define RESET_ALL_FLAG          0xFF    // SZbg

#define RESET_REG_FLAG          0x80    // WX^iLȊOjZbg
#define RESET_REG_SOUND_FLAG    0x40    // TEhWX^    Zbg
#define RESET_REG_SIO_FLAG      0x20    // rhnWX^      Zbg

#define RESET_EX_WRAM_FLAG      0x01    // botOq`l  NA
#define RESET_CPU_WRAM_FLAG     0x02    // botq`l  NA
#define RESET_PLTT_FLAG         0x04    // pbg          NA
#define RESET_VRAM_FLAG         0x08    // uq`l          NA
#define RESET_OAM_FLAG          0x10    // n`l            NA


/*------------------------------------------------------------------*/
/*                    afXN[f[^                          */
/*------------------------------------------------------------------*/

#define BG_SC_CHAR_NO_MASK      0x03ff      // LN^m
#define BG_SC_FLIP_MASK         0x0c00      // tbv
#define BG_SC_PLTT_MASK         0xf000      // J[pbgm

#define BG_SC_CHAR_NO_SHIFT     0
#define BG_SC_FLIP_SHIFT        10
#define BG_SC_PLTT_SHIFT        12

#define BG_SC_H_FLIP            0x0400      // gtbv
#define BG_SC_V_FLIP            0x0800      // utbv

/*------------------------------------------------------------------*/
/*                        AtBϊ                              */
/*------------------------------------------------------------------*/

#define SIN_SHIFT               14
#define AFFINE_DIV_SHIFT        8
#define AFFINE_REG_SHIFT        8
#define AFFINE_CAL_SHIFT        (SIN_SHIFT + AFFINE_DIV_SHIFT - AFFINE_REG_SHIFT)

/*------------------------------------------------------------------*/
/*                        n`lf[^                              */
/*------------------------------------------------------------------*/

#define OAM_SHAPE_MASK          0x0000c000  // nai`
#define OAM_SIZE_MASK           0xc0000000  // naiTCY

#define OAM_V_POS_MASK          0x000000ff  // nai wW
#define OAM_H_POS_MASK          0x01ff0000  // nai xW
#define OAM_V_SIZE_MASK         0x0000c000  // nai(8/16/32/64)
#define OAM_H_SIZE_MASK         0xc0000000  // nai(8/16/32/64)
#define OAM_OBJ_MODE_MASK       0x00000c00  // nai[h
#define OAM_AFFINE_MODE_MASK    0x00000300  // AtB[h
#define OAM_AFFINE_NO_MASK      0x3e000000  // AtB p[^m
#define OAM_FLIP_MASK           0x30000000  // tbv
#define OAM_CHAR_NO_MASK        0x000003ff  // LN^m
#define OAM_PRIORITY_MASK       0x00000c00  // afΗD揇
#define OAM_PLTT_MASK           0x0000f000  // J[pbgm
#define OAM_AFFINE_PARAM_MASK   0xffff0000  // AtB p[^

#define OAM_SHAPE_SHIFT         14
#define OAM_SIZE_SHIFT          30

#define OAM_V_POS_SHIFT         0
#define OAM_H_POS_SHIFT         16
#define OAM_V_SIZE_SHIFT        14
#define OAM_H_SIZE_SHIFT        30
#define OAM_AFFINE_MODE_SHIFT   8
#define OAM_OBJ_MODE_SHIFT      10
#define OAM_AFFINE_NO_SHIFT     25
#define OAM_FLIP_SHIFT          28
#define OAM_CHAR_NO_SHIFT       0
#define OAM_PRIORITY_SHIFT      10
#define OAM_PLTT_SHIFT          12
#define OAM_AFFINE_PARAM_SHIFT  16

#define OAM_SQUARE              0x00000000  // `nai
#define OAM_H_RECTANGLE         0x00004000  // `nai
#define OAM_V_RECTANGLE         0x00008000  // c`nai
#define OAM_SIZE_NO_0           0x00000000  // nai TCYm O
#define OAM_SIZE_NO_1           0x40000000  // nai TCYm P
#define OAM_SIZE_NO_2           0x80000000  // nai TCYm Q
#define OAM_SIZE_NO_3           0xc0000000  // nai TCYm R
#define OAM_SIZE_8x8            0x00000000  // nai   W  Whbg
#define OAM_SIZE_16x16          0x40000000  // nai PUPUhbg
#define OAM_SIZE_32x32          0x80000000  // nai RQRQhbg
#define OAM_SIZE_64x64          0xc0000000  // nai USUShbg
#define OAM_SIZE_16x8           0x00004000  // nai PU  Whbg
#define OAM_SIZE_32x8           0x40004000  // nai RQ  Whbg
#define OAM_SIZE_32x16          0x80004000  // nai RQPUhbg
#define OAM_SIZE_64x32          0xc0004000  // nai USRQhbg
#define OAM_SIZE_8x16           0x00008000  // nai   WPUhbg
#define OAM_SIZE_8x32           0x40008000  // nai   WRQhbg
#define OAM_SIZE_16x32          0x80008000  // nai PURQhbg
#define OAM_SIZE_32x64          0xc0008000  // nai RQUShbg

#define OAM_OBJ_ON              0x00000000  // nai nm
#define OAM_OBJ_OFF             0x00000200  // nai nee
#define OAM_OBJ_NORMAL          0x00000000  // naim[}[h
#define OAM_OBJ_BLEND           0x00000400  // nai[h
#define OAM_OBJ_WINDOW          0x00000800  // naiEChE[h
#define OAM_AFFINE_NONE         0x00000000  // AtB[h
#define OAM_AFFINE_NORMAL       0x00000100  // AtBm[}[h
#define OAM_AFFINE_TWICE        0x00000300  // AtBQ{p[h
#define OAM_MOS_ON              0x00001000  // UCN nm
#define OAM_MOS_OFF             0x00000000  // UCN nee
#define OAM_COLOR_16            0x00000000  // PU     I
#define OAM_COLOR_256           0x00002000  // QTUF I
#define OAM_V_SIZE_8DOT         0x00000000  // nai uTCY   Whbg
#define OAM_V_SIZE_16DOT        0x00004000  // nai uTCY PUhbg
#define OAM_V_SIZE_32DOT        0x00008000  // nai uTCY RQhbg
#define OAM_V_SIZE_64DOT        0x0000c000  // nai uTCY UShbg
#define OAM_H_FLIP              0x10000000  // gtbv
#define OAM_V_FLIP              0x20000000  // utbv
#define OAM_H_SIZE_8DOT         0x00000000  // nai gTCY   Whbg
#define OAM_H_SIZE_16DOT        0x40000000  // nai gTCY PUhbg
#define OAM_H_SIZE_32DOT        0x80000000  // nai gTCY RQhbg
#define OAM_H_SIZE_64DOT        0xc0000000  // nai gTCY UShbg


/*------------------------------------------------------------------*/
/*                      J[pbgf[^                        */
/*------------------------------------------------------------------*/

#define PLTT_RED_MASK           0x001f      // 
#define PLTT_GREEN_MASK         0x03e0      // 
#define PLTT_BLUE_MASK          0x7c00      // 

#define PLTT_RED_SHIFT          0
#define PLTT_GREEN_SHIFT        5
#define PLTT_BLUE_SHIFT         10


/********************************************************************/
/*              `faWX^ERg[rbg                  */
/********************************************************************/

/*------------------------------------------------------------------*/
/*                  vOXe[^XWX^                    */
/*------------------------------------------------------------------*/

#define PSR_CPU_MODE_MASK       0x1f        // bot[h

#define PSR_USER_MODE           0x10        // [U
#define PSR_FIQ_MODE            0x11        // ehp
#define PSR_IRQ_MODE            0x12        // hqp
#define PSR_SVC_MODE            0x13        // X[poCU
#define PSR_ABORT_MODE          0x17        // A{[givtFb`^f[^j
#define PSR_UNDEF_MODE          0x1b        // `
#define PSR_SYS_MODE            0x1f        // VXe

#define PSR_THUMB_STATE         0x20        // sgtlaXe[g
#define PSR_FIQ_DISABLE         0x40        // ehps
#define PSR_IRQ_DISABLE         0x80        // hqps
#define PSR_IRQ_FIQ_DISABLE     0xc0        // hqpehps

#define PSR_V_FLAG              0x10000000  // I[o[t[
#define PSR_C_FLAG              0x20000000  // L[^{[^g
#define PSR_Z_FLAG              0x40000000  // [
#define PSR_N_FLAG              0x80000000  // ^


/*------------------------------------------------------------------*/
/*                  荞ݗv^tO                        */
/*------------------------------------------------------------------*/

#define V_BLANK_INTR_FLAG       0x0001      // uuN荞
#define H_BLANK_INTR_FLAG       0x0002      // guN荞
#define V_COUNT_INTR_FLAG       0x0004      // uJE^v荞
#define TIMER0_INTR_FLAG        0x0008      // ^C}[O荞
#define TIMER1_INTR_FLAG        0x0010      // ^C}[P荞
#define TIMER2_INTR_FLAG        0x0020      // ^C}[Q荞
#define TIMER3_INTR_FLAG        0x0040      // ^C}[R荞
#define SIO_INTR_FLAG           0x0080      // VAʐM荞
#define DMA0_INTR_FLAG          0x0100      // cl`O荞
#define DMA1_INTR_FLAG          0x0200      // cl`P荞
#define DMA2_INTR_FLAG          0x0400      // cl`Q荞
#define DMA3_INTR_FLAG          0x0800      // cl`R荞
#define KEY_INTR_FLAG           0x1000      // L[荞
#define CASSETTE_INTR_FLAG      0x2000      // JZbg荞


/*------------------------------------------------------------------*/
/*                      \Rg[                            */
/*------------------------------------------------------------------*/

#define DISP_BG_MODE_MASK       0x0007      // af[h
#define DISP_ON_MASK            0x1f00      // naiEaf nm
#define DISP_WIN_MASK           0x6000      // EChE nm

#define DISP_BG_MODE_SHIFT      0
#define DISP_ON_SHIFT           8
#define DISP_WIN_SHIFT          13

#define DISP_MODE_0             0x0000      // af[hO
#define DISP_MODE_1             0x0001      // af[hP
#define DISP_MODE_2             0x0002      // af[hQ
#define DISP_MODE_3             0x0003      // af[hR
#define DISP_MODE_4             0x0004      // af[hS
#define DISP_MODE_5             0x0005      // af[hT
#define DISP_BMP_FRAME_NO       0x0010      // rbg}bv[h \t[
#define DISP_OBJ_HOFF           0x0020      // guNnai nee
#define DISP_OBJ_CHAR_2D_MAP    0x0000      // naiLN^f[^ Qc}bsO
#define DISP_OBJ_CHAR_1D_MAP    0x0040      // naiLN^f[^ Pc}bsO
#define DISP_LCDC_OFF           0x0080      // kbcb nee
#define DISP_BG0_ON             0x0100      // afO nm
#define DISP_BG1_ON             0x0200      // afP nm
#define DISP_BG2_ON             0x0400      // afQ nm
#define DISP_BG3_ON             0x0800      // afR nm
#define DISP_BG_ALL_ON          0x0f00      // afS nm
#define DISP_OBJ_ON             0x1000      // nai nm
#define DISP_OBJ_BG_ALL_ON      0x1f00      // naiEafS nm
#define DISP_WIN0_ON            0x2000      // EChEO nm
#define DISP_WIN1_ON            0x4000      // EChEP nm
#define DISP_WIN01_ON           0x6000      // EChEOEP nm
#define DISP_OBJWIN_ON          0x8000      // naiEChE nm
#define DISP_WIN_ALL_ON         0xe000      // EChES nm
#define DISP_ALL_ON             0x7f00      // S nm

/*------------------------------------------------------------------*/
/*                      Xe[^XRg[                      */
/*------------------------------------------------------------------*/

#define STAT_VCOUNT_CMP_MASK    0xff00      // uJE^rl

#define STAT_VCOUNT_CMP_SHIFT   8

#define STAT_V_BLANK            0x0001      // uuNԒ
#define STAT_H_BLANK            0x0002      // guNԒ
#define STAT_V_COUNT            0x0004      // uJE^v
#define STAT_V_BLANK_IF_ENABLE  0x0008      // uuN荞ݗv 
#define STAT_H_BLANK_IF_ENABLE  0x0010      // guN荞ݗv 
#define STAT_V_COUNT_IF_ENABLE  0x0020      // uJE^v荞ݗv 

/*------------------------------------------------------------------*/
/*                      afRg[                            */
/*------------------------------------------------------------------*/

#define BG_PRIORITY_MASK        0x0003      // afԗD揇
#define BG_CHAR_BASE_MASK       0x000c      // LN^ x[XAhX
#define BG_SCREEN_BASE_MASK     0x1f00      // XN[ x[XAhX
#define BG_SCREEN_SIZE_MASK     0xc000      // XN[TCY(256/512)

#define BG_PRIORITY_SHIFT       0
#define BG_CHAR_BASE_SHIFT      2
#define BG_SCREEN_BASE_SHIFT    8
#define BG_SCREEN_SIZE_SHIFT    14

#define BG_PRIORITY_0           0x0000      // afOD
#define BG_PRIORITY_1           0x0001      // afPD
#define BG_PRIORITY_2           0x0002      // afQD
#define BG_PRIORITY_3           0x0003      // afRD
#define BG_MOS_ON               0x0040      // UCN nm
#define BG_MOS_OFF              0x0000      // UCN nee
#define BG_COLOR_16             0x0000      // PUF   I
#define BG_COLOR_256            0x0080      // QTUF I
#define BG_LOOP_ON              0x2000      // [v nm
#define BG_LOOP_OFF             0x0000      // [v nee
#define BG_SCREEN_SIZE_0        0x0000      // XN[TCY(256x256)
#define BG_SCREEN_SIZE_1        0x4000      // XN[TCY(512x256)
#define BG_SCREEN_SIZE_2        0x8000      // XN[TCY(256x512)
#define BG_SCREEN_SIZE_3        0xc000      // XN[TCY(512x512)

/*------------------------------------------------------------------*/
/*                      EChE Rg[                     */
/*------------------------------------------------------------------*/

#define WIN_END_POS_MASK        0x00ff      // EChEI_
#define WIN_START_POS_MASK      0xff00      // EChEJn_

#define WIN_END_POS_SHIFT       0
#define WIN_START_POS_SHIFT     8

#define WIN_BG0_ON              0x0001      // afO nm
#define WIN_BG1_ON              0x0002      // afP nm
#define WIN_BG2_ON              0x0004      // afQ nm
#define WIN_BG3_ON              0x0008      // afR nm
#define WIN_OBJ_ON              0x0010      // nai nm
#define WIN_BLEND_ON            0x0020      // uh nm
#define WIN_ALL_ON              0x003f      // S nm

/*------------------------------------------------------------------*/
/*                      UCN Rg[                       */
/*------------------------------------------------------------------*/

#define MOS_H_SIZE_MASK         0x000f      //       UCN
#define MOS_V_SIZE_MASK         0x00f0      //       UCN
#define MOS_BG_H_SIZE_MASK      0x000f      //   afUCN
#define MOS_BG_V_SIZE_MASK      0x00f0      //   afUCN
#define MOS_OBJ_H_SIZE_MASK     0x000f      // naiUCN
#define MOS_OBJ_V_SIZE_MASK     0x00f0      // naiUCN

#define MOS_H_SIZE_SHIFT        0
#define MOS_V_SIZE_SHIFT        4
#define MOS_BG_H_SIZE_SHIFT     0
#define MOS_BG_V_SIZE_SHIFT     4
#define MOS_OBJ_H_SIZE_SHIFT    8
#define MOS_OBJ_V_SIZE_SHIFT    12

/*------------------------------------------------------------------*/
/*                      uh Rg[                       */
/*------------------------------------------------------------------*/

#define BLD_PIXEL_MASK          0x003f      // sNZI
#define BLD_1ST_PIXEL_MASK      0x003f      // PsNZI
#define BLD_MODE_MASK           0x00c0      // uh[h
#define BLD_2ND_PIXEL_MASK      0x3f00      // QsNZI

#define BLD_1ST_PIXEL_SHIFT     0
#define BLD_MODE_SHIFT          6
#define BLD_2ND_PIXEL_SHIFT     8

#define BLD_BG0                 0x0001      // afO sNZI
#define BLD_BG1                 0x0002      // afP sNZI
#define BLD_BG2                 0x0004      // afQ sNZI
#define BLD_BG3                 0x0008      // afR sNZI
#define BLD_OBJ                 0x0010      // nai sNZI
#define BLD_BD                  0x0020      // wiF sNZI
#define BLD_ALL                 0x003f      //        sNZSI
#define BLD_BG0_1ST             0x0001      // afO PsNZI
#define BLD_BG1_1ST             0x0002      // afP PsNZI
#define BLD_BG2_1ST             0x0004      // afQ PsNZI
#define BLD_BG3_1ST             0x0008      // afR PsNZI
#define BLD_OBJ_1ST             0x0010      // nai PsNZI
#define BLD_BD_1ST              0x0020      // wiF PsNZI
#define BLD_1ST_ALL             0x003f      //        PsNZSI
#define BLD_NORMAL_MODE         0x0000      // m[}[h
#define BLD_A_BLEND_MODE        0x0040      // [h
#define BLD_UP_MODE             0x0080      // Pxto[h
#define BLD_DOWN_MODE           0x00c0      // Pxcnvm[h
#define BLD_BG0_2ND             0x0100      // afO QsNZI
#define BLD_BG1_2ND             0x0200      // afP QsNZI
#define BLD_BG2_2ND             0x0400      // afQ QsNZI
#define BLD_BG3_2ND             0x0800      // afR QsNZI
#define BLD_OBJ_2ND             0x1000      // nai QsNZI
#define BLD_BD_2ND              0x2000      // wiF QsNZI
#define BLD_2ND_ALL             0x3f00      //        QsNZSI


#define BLD_A_MASK              0x001f      // uhϐ `
#define BLD_B_MASK              0x1f00      // uhϐ a
#define BLD_Y_MASK              0x001f      // uhϐ x

#define BLD_A_SHIFT             16
#define BLD_B_SHIFT             24
#define BLD_Y_SHIFT             0


/*------------------------------------------------------------------*/
/*                      TEh Rg[                       */
/*------------------------------------------------------------------*/

#define SOUND_SO1_LEVEL_MASK    0x03        // rnPo̓x
#define SOUND_SO2_LEVEL_MASK    0x30        // rnQo̓x
#define SOUND_DMG_SO1_ON_MASK   0x0f        // clf݊TEhrnP nm
#define SOUND_DMG_SO2_ON_MASK   0xf0        // clf݊TEhrnQ nm

#define SOUND_SWEEP_SHIFT_MASK  0x03        // XC[v Vtg
#define SOUND_SWEEP_TIME_MASK   0x30        // XC[v 
#define SOUND_COUNTS_MASK       0x3f        // ̒(JEg)
#define SOUND_DUTY_MASK         0xc0        // g`̃f[eB
#define SOUND_ENV_STEPS_MASK    0x03        // Gx[v Xebv
#define SOUND_ENV_INIT_MASK     0xf0        // Gx[v l
#define SOUND_FREQUENCY_MASK    0x03ff      // g
#define SOUND_FREQUENCY_L_MASK  0xff
#define SOUND_FREQUENCY_H_MASK  0x03

#define SOUND_3_COUNTS_MASK     0xff        // TEhR ̒(JEg)
#define SOUND_3_LEVEL_MASK      0xe0        //            o̓x

#define SOUND_4_PRESCALER_MASK  0x03        // TEhS vXP[I
#define SOUND_4_POLYSHIFT_MASK  0xf0        //            |m~JEJE^ Vtg


#define SOUND_SO1_LEVEL_SHIFT   0
#define SOUND_SO2_LEVEL_SHIFT   4
#define SOUND_DMG_SO1_ON_SHIFT  0
#define SOUND_DMG_SO2_ON_SHIFT  4

#define SOUND_SWEEP_SHIFT_SHIFT 0
#define SOUND_SWEEP_TIME_SHIFT  4
#define SOUND_COUNTS_SHIFT      0
#define SOUND_DUTY_SHIFT        6
#define SOUND_ENV_STEPS_SHIFT   0
#define SOUND_ENV_INIT_SHIFT    4
#define SOUND_FREQUENCY_SHIFT   0
#define SOUND_FREQUENCY_L_SHIFT 0
#define SOUND_FREQUENCY_H_SHIFT 8

#define SOUND_3_COUNTS_SHIFT    0
#define SOUND_3_LEVEL_SHIFT     5

#define SOUND_4_PRESCALER_SHIFT 0
#define SOUND_4_POLYSHIFT_SHIFT 4


#define SOUND_1_ON              0x01        // TEhP nm
#define SOUND_2_ON              0x02        // TEhQ nm
#define SOUND_3_ON              0x04        // TEhR nm
#define SOUND_4_ON              0x08        // TEhS nm
#define SOUND_DMG_ON            0x80        // clf݊TEh nm

#define SOUND_1_SO1_ON          0x01        // TEhPrnP nm
#define SOUND_2_SO1_ON          0x02        // TEhQrnP nm
#define SOUND_3_SO1_ON          0x04        // TEhRrnP nm
#define SOUND_4_SO1_ON          0x08        // TEhSrnP nm
#define SOUND_1_SO2_ON          0x10        // TEhPrnQ nm
#define SOUND_2_SO2_ON          0x20        // TEhQrnQ nm
#define SOUND_3_SO2_ON          0x40        // TEhRrnQ nm
#define SOUND_4_SO2_ON          0x80        // TEhSrnQ nm
#define SOUND_DMG_ALL_SO1_ON    0x0f        // clf݊TEhrnP nm
#define SOUND_DMG_ALL_SO2_ON    0xf0        // clf݊TEhrnQ nm
#define SOUND_DMG_ALL_SO_ON     0xff        // clf݊TEhrnP^Q nm
#define SOUND_VIN_SO1_ON        0x80        // urnP nm
#define SOUND_VIN_SO2_ON        0x08        // urnQ nm
#define SOUND_VIN_SO_ON         0x08        // urnP^Q nm

#define SOUND_A_SO1_ON          0x01        // _CNgTEh`rnP nm
#define SOUND_A_SO2_ON          0x02        // _CNgTEh`rnQ nm
#define SOUND_B_SO1_ON          0x10        // _CNgTEharnP nm
#define SOUND_B_SO2_ON          0x20        // _CNgTEharnQ nm
#define SOUND_A_ALL_SO_ON       0x03        // _CNgTEh`rnP^Q nm
#define SOUND_B_ALL_SO_ON       0x30        // _CNgTEharnP^Q nm
#define SOUND_DIRECT_ALL_SO1_ON 0x11        // _CNgTEh`^arnP nm
#define SOUND_DIRECT_ALL_SO2_ON 0x22        // _CNgTEh`^arnQ nm
#define SOUND_DIRECT_ALL_SO_ON  0x33        // _CNgTEh`^arnP^Q nm
#define SOUND_A_TIMER_0         0x00        // ^C}[O_CNgTEh`
#define SOUND_A_TIMER_1         0x04        // ^C}[P_CNgTEh`
#define SOUND_B_TIMER_0         0x00        // ^C}[O_CNgTEha
#define SOUND_B_TIMER_1         0x40        // ^C}[P_CNgTEha
#define SOUND_A_FIFO_RESET      0x08        // _CNgTEh`pehen Zbg
#define SOUND_B_FIFO_RESET      0x80        // _CNgTEhapehen Zbg

#define SOUND_DMG_MIX_1_4       0x00        //   clf݊TEh P^S
#define SOUND_DMG_MIX_2_4       0x01        //                            Q^S
#define SOUND_DMG_MIX_FULL      0x02        //                            tW
#define SOUND_A_MIX_1_2         0x00        // _CNgTEh` P^Q
#define SOUND_A_MIX_FULL        0x04        //                            tW
#define SOUND_B_MIX_1_2         0x00        // _CNgTEha P^Q
#define SOUND_B_MIX_FULL        0x08        //                            tW
#define SOUND_ALL_MIX_FULL      0x0e        //           STEh tW


#define SOUND_INIT_ON           0x80        // CjV nm
#define SOUND_INIT_OFF          0x00        // CjV nm
#define SOUND_COUNTER_ON        0x40        //   JE^ nm
#define SOUND_COUNTER_OFF       0x00        //   JE^ nee

#define SOUND_SWEEP_UP          0x00        // XC[v Z
#define SOUND_SWEEP_DOWN        0x08        //          Z
#define SOUND_DUTY_1_8          0x00        // g`̃f[eB P^W
#define SOUND_DUTY_2_8          0x40        //                  Q^W
#define SOUND_DUTY_4_8          0x80        //                  S^W
#define SOUND_DUTY_6_8          0xc0        //                  U^W
#define SOUND_ENV_UP            0x08        // Gx[v to
#define SOUND_ENV_DOWN          0x00        //              cnvm

#define SOUND_3_LOCAL_ON        0x80        // TEhR nm
#define SOUND_3_WAVE_BANK_0     0x00        // TEhR g`q`l oNO
#define SOUND_3_WAVE_BANK_1     0x40        //                       oNP
#define SOUND_3_WAVE_CONNECT    0x20        // TEhR g`q`l ڑ
#define SOUND_3_WAVE_DISCONNECT 0x00        //                       ڑ
#define SOUND_3_LEVEL_0_4       0x00        // TEhR o Ȃ
#define SOUND_3_LEVEL_FULL      0x20        //                 S^S
#define SOUND_3_LEVEL_2_4       0x40        //                 Q^S
#define SOUND_3_LEVEL_1_4       0x60        //                 P^S
#define SOUND_3_LEVEL_3_4       0x80        //                 R^S

#define SOUND_4_POLYSTEP_15     0x00        // TEhS |m~JEJE^ PTi
#define SOUND_4_POLYSTEP_7      0x08        //                                     Vi


/*------------------------------------------------------------------*/
/*                      rhnRg[                          */
/*------------------------------------------------------------------*/

#define SIO_MODE_MASK           0x3000        // ʐM[h
#define SIO_BAUD_RATE_MASK      0x0003        // {[[g
#define SIO_ID_NO_MASK          0x0030        // ʐMhc

#define SIO_MODE_SHIFT          12
#define SIO_BAUD_RATE_SHIFT     0
#define SIO_ID_NO_SHIFT         4

#define SIO_8BIT_MODE           0x0000        // m[}WrbgʐM[h
#define SIO_32BIT_MODE          0x1000        // m[}RQrbgʐM[h
#define SIO_MULTI_MODE          0x2000        // }`vCʐM[h
#define SIO_UART_MODE           0x3000        // t`qsʐM[h

#define SIO_SCK_OUT             0x0000        // ONbNI
#define SIO_SCK_IN              0x0001        // NbNI
#define SIO_IN_SCK_256K         0x0000        // NbN QTUjgI
#define SIO_IN_SCK_2M           0x0002        //                  QlgI
#define SIO_ACK_RECV            0x0004        // ]v
#define SIO_ACK_SEND            0x0008        // ]
#define SIO_9600_BPS            0x0000        // {[[g XUOOaor
#define SIO_38400_BPS           0x0001        //          RWSOOaor
#define SIO_57600_BPS           0x0002        //          TVUOOaor
#define SIO_115200_BPS          0x0003        //        PPTQOOaor
#define SIO_MULTI_CONNECT       0x0004        // }`vCʐM ڑ
#define SIO_MULTI_DISCONNECT    0x0000        //                  ڑ
#define SIO_MULTI_PARENT        0x0008        // }`vCʐM eڑ
#define SIO_MULTI_CHILD         0x0000        //                  qڑ
#define SIO_MULTI_SI            0x0004        // }`vCʐM rh[q
#define SIO_MULTI_SD            0x0008        //                  rc[q
#define SIO_MULTI_BUSY          0x0080        // }`vCʐM
#define SIO_CTS_ENABLE          0x0004        // t`qsM\M  Cl[u
#define SIO_UART_7BIT           0x0000        // t`qsʐM f[^ V
#define SIO_UART_8BIT           0x0080        //                       W
#define SIO_ERROR               0x0040        // G[o
#define SIO_START               0x0080        // ]X^[g
#define SIO_ENABLE              0x0080        // rhn
#define SIO_FIFO_ENABLE         0x0100        // ehen Cl[u
#define SIO_PARITY_ENABLE       0x0200        // peB Cl[u
#define SIO_PARITY_EVEN         0x0000        // peB
#define SIO_PARITY_ODD          0x0008        // peB
#define SIO_TRANS_ENABLE        0x0400        // gX~b^ Cl[u
#define SIO_TRANS_DATA_FULL     0x0010        // gX~bgf[^ t
#define SIO_RECV_ENABLE         0x0800        // V[o Cl[u
#define SIO_RECV_DATA_EMPTY     0x0020        // V[uf[^ 
#define SIO_IF_ENABLE           0x4000        // 荞ݗv 

/*------------------------------------------------------------------*/
/*                      inxoX Rg[                     */
/*------------------------------------------------------------------*/

#define JOY_IF_RESET            0x01          // inxoXEZbg 荞ݗv
#define JOY_IF_RECV             0x02          // inxoXM   荞ݗv
#define JOY_IF_SEND             0x04          // inxoXM   荞ݗv
#define JOY_IF_ENABLE           0x40          // 荞ݗv 

/*------------------------------------------------------------------*/
/*                      inxoX Xe[^X                       */
/*------------------------------------------------------------------*/

#define JSTAT_FLAGS_MASK        0x30          // ėptO

#define JSTAT_FLAGS_SHIFT       4

#define JSTAT_RECV              0x02          // MXe[^X
#define JSTAT_SEND              0x08          // MXe[^X

/*------------------------------------------------------------------*/
/*                      ėpo̓Rg[                      */
/*------------------------------------------------------------------*/

#define R_SIO_MODE_MASTER_MASK  0xc000        // rhn[hE}X^

#define R_SIO_MODE_MASTER_SHIFT 14

#define R_SIO_MASTER_MODE       0x0000        // rhn}X^E[h
#define R_DIRECT_MODE           0x8000        // ėpo͒ʐM[h
#define R_JOY_MODE              0xc000        // inxʐM[h

#define R_SC                    0x0001        // f[^
#define R_SD                    0x0002
#define R_SI                    0x0004
#define R_SO                    0x0008
#define R_SC_I_O                0x0010        // h/nI
#define R_SD_I_O                0x0020
#define R_SI_I_O                0x0040
#define R_SO_I_O                0x0080
#define R_IF_ENABLE             0x0100        // 荞ݗv 


/*------------------------------------------------------------------*/
/*                      cl`Rg[                          */
/*------------------------------------------------------------------*/

#define DMA_TIMMING_MASK        0x30000000  // Jn^C~O
#define DMA_COUNT_MASK          0x0000ffff  // ]

#define DMA_TIMMING_SHIFT       30
#define DMA_COUNT_SHIFT         0

#define DMA_ENABLE              0x80000000  // cl`
#define DMA_IF_ENABLE           0x40000000  // 荞ݗv 
#define DMA_TIMMING_IMM         0x00000000  // ɋN
#define DMA_TIMMING_V_BLANK     0x10000000  // uuNN
#define DMA_TIMMING_H_BLANK     0x20000000  // guNN
#define DMA_TIMMING_DISP        0x30000000  // \N
#define DMA_TIMMING_SOUND       0x30000000  // TEhehenNGXgN
#define DMA_DREQ_ON             0x08000000  // f[^v[h nm
#define DMA_16BIT_BUS           0x00000000  // oXTCYPUaI
#define DMA_32BIT_BUS           0x04000000  // oXTCYRQaI
#define DMA_CONTINUOUS_ON       0x02000000  // ReBjAX[h nm
#define DMA_SRC_INC             0x00000000  // ] CNg I
#define DMA_SRC_DEC             0x00800000  // ] fNg   I
#define DMA_SRC_FIX             0x01000000  // ] Œ I
#define DMA_DEST_INC            0x00000000  // ] CNg I
#define DMA_DEST_DEC            0x00200000  // ] fNg   I
#define DMA_DEST_FIX            0x00400000  // ] Œ I
#define DMA_DEST_RELOAD         0x00600000  // ] CNg/[h I

/*------------------------------------------------------------------*/
/*                      ^C}[ Rg[                       */
/*------------------------------------------------------------------*/

#define TMR_PRESCALER_MASK      0x00030000  // vXP[ NbN

#define TMR_PRESCALER_SHIFT     16

#define TMR_PRESCALER_1CK       0x00000000  // vXP[ P
#define TMR_PRESCALER_64CK      0x00010000  //           US
#define TMR_PRESCALER_256CK     0x00020000  //         QTU
#define TMR_PRESCALER_1024CK    0x00030000  //       POQS
#define TMR_IF_ENABLE           0x00400000  // 荞ݗv 
#define TMR_ENABLE              0x00800000  // ^C}[N


/*------------------------------------------------------------------*/
/*                          L[                                    */
/*------------------------------------------------------------------*/

#define BUTTON_MASK             0x030f      // {^
#define PLUS_KEY_MASK           0x00f0      // \L[
#define ALL_KEY_MASK            0x03ff      // SẴL[

#define A_BUTTON                0x0001      // `{^
#define B_BUTTON                0x0002      // a{^
#define SELECT_BUTTON           0x0004      // ZNg{^
#define START_BUTTON            0x0008      // X^[g{^
#define R_KEY                   0x0010      // E{^
#define L_KEY                   0x0020      // {^
#define U_KEY                   0x0040      // {^
#define D_KEY                   0x0080      // {^
#define R_BUTTON                0x0100      // q{^
#define L_BUTTON                0x0200      // k{^
#define KEY_IF_ENABLE           0x4000      // 荞ݗv 
#define KEY_OR_INTR             0x0000      //   ʏL[荞
#define KEY_AND_INTR            0x8000      // `mcL[荞


/*------------------------------------------------------------------*/
/*                  JZbgEFCg Rg[                   */
/*------------------------------------------------------------------*/

#define CST_SRAM_4WAIT          0x0000      // rq`l SEFCg
#define CST_SRAM_3WAIT          0x0001      //          REFCg
#define CST_SRAM_2WAIT          0x0002      //          QEFCg
#define CST_SRAM_8WAIT          0x0003      //          WEFCg
#define CST_ROM0_1ST_4WAIT      0x0000      // qnlO P SEFCg
#define CST_ROM0_1ST_3WAIT      0x0004      //                    REFCg
#define CST_ROM0_1ST_2WAIT      0x0008      //                    QEFCg
#define CST_ROM0_1ST_8WAIT      0x000c      //                    WEFCg
#define CST_ROM0_2ND_2WAIT      0x0000      //             Q QEFCg
#define CST_ROM0_2ND_1WAIT      0x0010      //                    PEFCg
#define CST_ROM1_1ST_4WAIT      0x0000      // qnlP P SEFCg
#define CST_ROM1_1ST_3WAIT      0x0020      //                    REFCg
#define CST_ROM1_1ST_2WAIT      0x0040      //                    QEFCg
#define CST_ROM1_1ST_8WAIT      0x0060      //                    WEFCg
#define CST_ROM1_2ND_4WAIT      0x0000      //             Q SEFCg
#define CST_ROM1_2ND_1WAIT      0x0080      //                    PEFCg
#define CST_ROM2_1ST_4WAIT      0x0000      // qnlQ P SEFCg
#define CST_ROM2_1ST_3WAIT      0x0100      //                    REFCg
#define CST_ROM2_1ST_2WAIT      0x0200      //                    QEFCg
#define CST_ROM2_1ST_8WAIT      0x0300      //                    WEFCg
#define CST_ROM2_2ND_8WAIT      0x0000      //             Q WEFCg
#define CST_ROM2_2ND_1WAIT      0x0400      //                 PEFCg

#define CST_PHI_OUT_NONE        0x0000      // Ӓ[qo̓NbN kŒ
#define CST_PHI_OUT_4MCK        0x0800      //                Slg
#define CST_PHI_OUT_8MCK        0x1000      //                Wlg
#define CST_PHI_OUT_16MCK       0x1800      //              PUlg
#define CST_PREFETCH_ENABLE     0x4000      // vtFb`obt@ 
#define CST_AGB                 0x0000      // `faJZbg
#define CST_CGB                 0x8000      // bfaJZbg



#ifdef __cplusplus
}      /* extern "C" */
#endif

#endif /* _AGB_DEFINE_H */
