;********************************************************************
;*          AgbDefineArm.s                                          *
;*            AGBW萔iARMASMpj                               *
;*                                                                  *
;*          Copyright (C) 1999-2000 NINTENDO Co.,Ltd.               *
;********************************************************************


;--------------------------------------------------------------------
;-                            萔                                  -
;--------------------------------------------------------------------

ON                      *   1
OFF                     *   0
ENABLE                  *   1
DISABLE                 *   0
TRUE                    *   1
FALSE                   *   0

LCD_WIDTH               *   240         ; ʕ
LCD_HEIGHT              *   160         ; ʍ


;--------------------------------------------------------------------
;-                WX^q`l Zbg VXeR[          -
;--------------------------------------------------------------------

RESET_ALL_FLAG          *   0xFF        ; SZbg

RESET_REG_FLAG          *   0x80        ; WX^iLȊOjZbg
RESET_REG_SOUND_FLAG    *   0x40        ; TEhWX^    Zbg
RESET_REG_SIO_FLAG      *   0x20        ; rhnWX^      Zbg

RESET_EX_WRAM_FLAG      *   0x01        ; botOq`l  NA
RESET_CPU_WRAM_FLAG     *   0x02        ; botq`l  NA
RESET_PLTT_FLAG         *   0x04        ; pbg          NA
RESET_VRAM_FLAG         *   0x08        ; uq`l          NA
RESET_OAM_FLAG          *   0x10        ; n`l            NA


;--------------------------------------------------------------------
;-                    afXN[f[^                          -
;--------------------------------------------------------------------

BG_SC_CHAR_NO_MASK      *   0x03ff      ; LN^m
BG_SC_FLIP_MASK         *   0x0c00      ; tbv
BG_SC_PLTT_MASK         *   0xf000      ; J[pbgm

BG_SC_CHAR_NO_SHIFT     *   0
BG_SC_FLIP_SHIFT        *   10
BG_SC_PLTT_SHIFT        *   12

BG_SC_H_FLIP            *   0x0400      ; gtbv
BG_SC_V_FLIP            *   0x0800      ; utbv

;--------------------------------------------------------------------
;-                        AtBϊ                              -
;--------------------------------------------------------------------

SIN_SHIFT               *   14
AFFINE_DIV_SHIFT        *   8
AFFINE_REG_SHIFT        *   8
AFFINE_CAL_SHIFT        *   SIN_SHIFT + AFFINE_DIV_SHIFT - AFFINE_REG_SHIFT

;--------------------------------------------------------------------
;-                        n`lf[^                              -
;--------------------------------------------------------------------

OAM_V_POS_MASK          *   0x000000ff  ; nai wW
OAM_H_POS_MASK          *   0x01ff0000  ; nai xW
OAM_SHAPE_MASK          *   0x0000c000  ; nai`
OAM_SIZE_MASK           *   0xc0000000  ; naiTCY
OAM_OBJ_MODE_MASK       *   0x00000c00  ; nai[h
OAM_AFFINE_MODE_MASK    *   0x00000300  ; AtB[h
OAM_AFFINE_NO_MASK      *   0x3e000000  ; AtB p[^m
OAM_FLIP_MASK           *   0x30000000  ; tbv
OAM_CHAR_NO_MASK        *   0x000003ff  ; LN^m
OAM_PRIORITY_MASK       *   0x00000c00  ; afΗD揇
OAM_PLTT_MASK           *   0x0000f000  ; J[pbgm
OAM_AFFINE_PARAM_MASK   *   0xffff0000  ; AtB p[^


OAM_V_POS_SHIFT         *   0
OAM_H_POS_SHIFT         *   16
OAM_SHAPE_SHIFT         *   14
OAM_SIZE_SHIFT          *   30
OAM_AFFINE_MODE_SHIFT   *   8
OAM_OBJ_MODE_SHIFT      *   10
OAM_AFFINE_NO_SHIFT     *   25
OAM_FLIP_SHIFT          *   28
OAM_CHAR_NO_SHIFT       *   0
OAM_PRIORITY_SHIFT      *   10
OAM_PLTT_SHIFT          *   12
OAM_AFFINE_PARAM_SHIFT  *   16

OAM_SQUARE              *   0x00000000  ; `nai
OAM_H_RECTANGLE         *   0x00004000  ; `nai
OAM_V_RECTANGLE         *   0x00008000  ; c`nai
OAM_SIZE_NO_0           *   0x00000000  ; nai TCYm O
OAM_SIZE_NO_1           *   0x40000000  ; nai TCYm P
OAM_SIZE_NO_2           *   0x80000000  ; nai TCYm Q
OAM_SIZE_NO_3           *   0xc0000000  ; nai TCYm R
OAM_SIZE_8x8            *   0x00000000  ; nai   W  Whbg
OAM_SIZE_16x16          *   0x40000000  ; nai PUPUhbg
OAM_SIZE_32x32          *   0x80000000  ; nai RQRQhbg
OAM_SIZE_64x64          *   0xc0000000  ; nai USUShbg
OAM_SIZE_16x8           *   0x00004000  ; nai PU  Whbg
OAM_SIZE_32x8           *   0x40004000  ; nai RQ  Whbg
OAM_SIZE_32x16          *   0x80004000  ; nai RQPUhbg
OAM_SIZE_64x32          *   0xc0004000  ; nai USRQhbg
OAM_SIZE_8x16           *   0x00008000  ; nai   WPUhbg
OAM_SIZE_8x32           *   0x40008000  ; nai   WRQhbg
OAM_SIZE_16x32          *   0x80008000  ; nai PURQhbg
OAM_SIZE_32x64          *   0xc0008000  ; nai RQUShbg

OAM_OBJ_ON              *   0x00000000  ; nai nm
OAM_OBJ_OFF             *   0x00000200  ; nai nee
OAM_OBJ_NORMAL          *   0x00000000  ; naim[}[h
OAM_OBJ_BLEND           *   0x00000400  ; nai[h
OAM_OBJ_WINDOW          *   0x00000800  ; naiEChE[h
OAM_AFFINE_NONE         *   0x00000000  ; AtB[h
OAM_AFFINE_NORMAL       *   0x00000100  ; AtBm[}[h
OAM_AFFINE_TWICE        *   0x00000300  ; AtBQ{p[h
OAM_MOS_ON              *   0x00001000  ; UCN nm
OAM_MOS_OFF             *   0x00000000  ; UCN nee
OAM_COLOR_16            *   0x00000000  ; PU     I
OAM_COLOR_256           *   0x00002000  ; QTUF I
OAM_V_SIZE_8DOT         *   0x00000000  ; nai uTCY   Whbg
OAM_V_SIZE_16DOT        *   0x00004000  ; nai uTCY PUhbg
OAM_V_SIZE_32DOT        *   0x00008000  ; nai uTCY RQhbg
OAM_V_SIZE_64DOT        *   0x0000c000  ; nai uTCY UShbg
OAM_H_FLIP              *   0x10000000  ; gtbv
OAM_V_FLIP              *   0x20000000  ; utbv
OAM_H_SIZE_8DOT         *   0x00000000  ; nai gTCY   Whbg
OAM_H_SIZE_16DOT        *   0x40000000  ; nai gTCY PUhbg
OAM_H_SIZE_32DOT        *   0x80000000  ; nai gTCY RQhbg
OAM_H_SIZE_64DOT        *   0xc0000000  ; nai gTCY UShbg


;--------------------------------------------------------------------
;-                      J[pbgf[^                        -
;--------------------------------------------------------------------

PLTT_RED_MASK           *   0x001f      ; 
PLTT_GREEN_MASK         *   0x03e0      ; 
PLTT_BLUE_MASK          *   0x7c00      ; 

PLTT_RED_SHIFT          *   0
PLTT_GREEN_SHIFT        *   5
PLTT_BLUE_SHIFT         *   10


;********************************************************************
;*              `faWX^ERg[rbg                  *
;********************************************************************

;--------------------------------------------------------------------
;-                  vOXe[^XWX^                    -
;--------------------------------------------------------------------

PSR_CPU_MODE_MASK       *   0x1f        ; bot[h

PSR_USER_MODE           *   0x10        ; [U
PSR_FIQ_MODE            *   0x11        ; ehp
PSR_IRQ_MODE            *   0x12        ; hqp
PSR_SVC_MODE            *   0x13        ; X[poCU
PSR_ABORT_MODE          *   0x17        ; A{[givtFb`^f[^j
PSR_UNDEF_MODE          *   0x1b        ; `
PSR_SYS_MODE            *   0x1f        ; VXe

PSR_THUMB_STATE         *   0x20        ; sgtlaXe[g
PSR_FIQ_DISABLE         *   0x40        ; ehps
PSR_IRQ_DISABLE         *   0x80        ; hqps
PSR_IRQ_FIQ_DISABLE     *   0xc0        ; hqpehps

PSR_V_FLAG              *   0x10000000  ; I[o[t[
PSR_C_FLAG              *   0x20000000  ; L[^{[^g
PSR_Z_FLAG              *   0x40000000  ; [
PSR_N_FLAG              *   0x80000000  ; ^


;--------------------------------------------------------------------
;-                  荞ݗv^tO                        -
;--------------------------------------------------------------------

V_BLANK_INTR_FLAG       *   0x0001      ; uuN荞
H_BLANK_INTR_FLAG       *   0x0002      ; guN荞
V_COUNT_INTR_FLAG       *   0x0004      ; uJE^v荞
TIMER0_INTR_FLAG        *   0x0008      ; ^C}[O荞
TIMER1_INTR_FLAG        *   0x0010      ; ^C}[P荞
TIMER2_INTR_FLAG        *   0x0020      ; ^C}[Q荞
TIMER3_INTR_FLAG        *   0x0040      ; ^C}[R荞
SIO_INTR_FLAG           *   0x0080      ; VAʐM荞
DMA0_INTR_FLAG          *   0x0100      ; cl`O荞
DMA1_INTR_FLAG          *   0x0200      ; cl`P荞
DMA2_INTR_FLAG          *   0x0400      ; cl`Q荞
DMA3_INTR_FLAG          *   0x0800      ; cl`R荞
KEY_INTR_FLAG           *   0x1000      ; L[荞
CASSETTE_INTR_FLAG      *   0x2000      ; JZbg荞


;--------------------------------------------------------------------
;-                      \Rg[                            -
;--------------------------------------------------------------------

DISP_BG_MODE_MASK       *   0x0007      ; af[h
DISP_ON_MASK            *   0x1f00      ; naiEaf nm
DISP_WIN_MASK           *   0x6000      ; EChE nm

DISP_BG_MODE_SHIFT      *   0
DISP_ON_SHIFT           *   8
DISP_WIN_SHIFT          *   13

DISP_MODE_0             *   0x0000      ; af[hO
DISP_MODE_1             *   0x0001      ; af[hP
DISP_MODE_2             *   0x0002      ; af[hQ
DISP_MODE_3             *   0x0003      ; af[hR
DISP_MODE_4             *   0x0004      ; af[hS
DISP_MODE_5             *   0x0005      ; af[hT
DISP_BMP_FRAME_NO       *   0x0010      ; rbg}bv[h \t[
DISP_OBJ_HOFF           *   0x0020      ; guNnai nee
DISP_OBJ_CHAR_2D_MAP    *   0x0000      ; naiLN^f[^ Qc}bsO
DISP_OBJ_CHAR_1D_MAP    *   0x0040      ; naiLN^f[^ Pc}bsO
DISP_LCDC_OFF           *   0x0080      ; kbcb nee
DISP_BG0_ON             *   0x0100      ; afO nm
DISP_BG1_ON             *   0x0200      ; afP nm
DISP_BG2_ON             *   0x0400      ; afQ nm
DISP_BG3_ON             *   0x0800      ; afR nm
DISP_BG_ALL_ON          *   0x0f00      ; afS nm
DISP_OBJ_ON             *   0x1000      ; nai nm
DISP_OBJ_BG_ALL_ON      *   0x1f00      ; naiEafS nm
DISP_WIN0_ON            *   0x2000      ; EChEO nm
DISP_WIN1_ON            *   0x4000      ; EChEP nm
DISP_WIN01_ON           *   0x6000      ; EChEOEP nm
DISP_OBJWIN_ON          *   0x8000      ; naiEChE nm
DISP_WIN_ALL_ON         *   0xe000      ; EChES nm
DISP_ALL_ON             *   0x7f00      ; S nm

;--------------------------------------------------------------------
;-                      Xe[^XRg[                      -
;--------------------------------------------------------------------

STAT_VCOUNT_CMP_MASK    *   0xff00      ; uJE^rl

STAT_VCOUNT_CMP_SHIFT   *   8

STAT_V_BLANK            *   0x0001      ; uuNԒ
STAT_H_BLANK            *   0x0002      ; guNԒ
STAT_V_COUNT            *   0x0004      ; uJE^v
STAT_V_BLANK_IF_ENABLE  *   0x0008      ; uuN荞ݗv 
STAT_H_BLANK_IF_ENABLE  *   0x0010      ; guN荞ݗv 
STAT_V_COUNT_IF_ENABLE  *   0x0020      ; uJE^v荞ݗv 

;--------------------------------------------------------------------
;-                      afRg[                            -
;--------------------------------------------------------------------

BG_PRIORITY_MASK        *   0x0003      ; afԗD揇
BG_CHAR_BASE_MASK       *   0x000c      ; LN^ x[XAhX
BG_SCREEN_BASE_MASK     *   0x1f00      ; XN[ x[XAhX
BG_SCREEN_SIZE_MASK     *   0xc000      ; XN[TCY(256/512)

BG_PRIORITY_SHIFT       *   0
BG_CHAR_BASE_SHIFT      *   2
BG_SCREEN_BASE_SHIFT    *   8
BG_SCREEN_SIZE_SHIFT    *   14

BG_PRIORITY_0           *   0x0000      ; afOD
BG_PRIORITY_1           *   0x0001      ; afPD
BG_PRIORITY_2           *   0x0002      ; afQD
BG_PRIORITY_3           *   0x0003      ; afRD
BG_MOS_ON               *   0x0040      ; UCN nm
BG_MOS_OFF              *   0x0000      ; UCN nee
BG_COLOR_16             *   0x0000      ; PUF   I
BG_COLOR_256            *   0x0080      ; QTUF I
BG_LOOP_ON              *   0x2000      ; [v nm
BG_LOOP_OFF             *   0x0000      ; [v nee
BG_SCREEN_SIZE_0        *   0x0000      ; XN[TCY(256x256)
BG_SCREEN_SIZE_1        *   0x4000      ; XN[TCY(512x256)
BG_SCREEN_SIZE_2        *   0x8000      ; XN[TCY(256x512)
BG_SCREEN_SIZE_3        *   0xc000      ; XN[TCY(512x512)

;--------------------------------------------------------------------
;-                      EChE Rg[                     -
;--------------------------------------------------------------------

WIN_END_POS_MASK        *   0x00ff      ; EChEI_
WIN_START_POS_MASK      *   0xff00      ; EChEJn_

WIN_END_POS_SHIFT       *   0
WIN_START_POS_SHIFT     *   8

WIN_BG0_ON              *   0x0001      ; afO nm
WIN_BG1_ON              *   0x0002      ; afP nm
WIN_BG2_ON              *   0x0004      ; afQ nm
WIN_BG3_ON              *   0x0008      ; afR nm
WIN_OBJ_ON              *   0x0010      ; nai nm
WIN_BLEND_ON            *   0x0020      ; uh nm
WIN_ALL_ON              *   0x003f      ; S nm

;--------------------------------------------------------------------
;-                      UCN Rg[                       -
;--------------------------------------------------------------------

MOS_H_SIZE_MASK         *   0x000f      ;       UCN
MOS_V_SIZE_MASK         *   0x00f0      ;       UCN
MOS_BG_H_SIZE_MASK      *   0x000f      ;   afUCN
MOS_BG_V_SIZE_MASK      *   0x00f0      ;   afUCN
MOS_OBJ_H_SIZE_MASK     *   0x000f      ; naiUCN
MOS_OBJ_V_SIZE_MASK     *   0x00f0      ; naiUCN

MOS_H_SIZE_SHIFT        *   0
MOS_V_SIZE_SHIFT        *   4
MOS_BG_H_SIZE_SHIFT     *   0
MOS_BG_V_SIZE_SHIFT     *   4
MOS_OBJ_H_SIZE_SHIFT    *   8
MOS_OBJ_V_SIZE_SHIFT    *   12

;--------------------------------------------------------------------
;-                      uh Rg[                       -
;--------------------------------------------------------------------

BLD_PIXEL_MASK          *   0x003f      ; sNZI
BLD_1ST_PIXEL_MASK      *   0x003f      ; PsNZI
BLD_MODE_MASK           *   0x00c0      ; uh[h
BLD_2ND_PIXEL_MASK      *   0x3f00      ; QsNZI

BLD_1ST_PIXEL_SHIFT     *   0
BLD_MODE_SHIFT          *   6
BLD_2ND_PIXEL_SHIFT     *   8

BLD_BG0                 *   0x0001      ; afO sNZI
BLD_BG1                 *   0x0002      ; afP sNZI
BLD_BG2                 *   0x0004      ; afQ sNZI
BLD_BG3                 *   0x0008      ; afR sNZI
BLD_OBJ                 *   0x0010      ; nai sNZI
BLD_BD                  *   0x0020      ; wiF sNZI
BLD_ALL                 *   0x003f      ;        sNZSI
BLD_BG0_1ST             *   0x0001      ; afO PsNZI
BLD_BG1_1ST             *   0x0002      ; afP PsNZI
BLD_BG2_1ST             *   0x0004      ; afQ PsNZI
BLD_BG3_1ST             *   0x0008      ; afR PsNZI
BLD_OBJ_1ST             *   0x0010      ; nai PsNZI
BLD_BD_1ST              *   0x0020      ; wiF PsNZI
BLD_1ST_ALL             *   0x003f      ;        PsNZSI
BLD_NORMAL_MODE         *   0x0000      ; m[}[h
BLD_A_BLEND_MODE        *   0x0040      ; [h
BLD_UP_MODE             *   0x0080      ; Pxto[h
BLD_DOWN_MODE           *   0x00c0      ; Pxcnvm[h
BLD_BG0_2ND             *   0x0100      ; afO QsNZI
BLD_BG1_2ND             *   0x0200      ; afP QsNZI
BLD_BG2_2ND             *   0x0400      ; afQ QsNZI
BLD_BG3_2ND             *   0x0800      ; afR QsNZI
BLD_OBJ_2ND             *   0x1000      ; nai QsNZI
BLD_BD_2ND              *   0x2000      ; wiF QsNZI
BLD_2ND_ALL             *   0x3f00      ;        QsNZSI


BLD_A_MASK              *   0x001f      ; uhϐ `
BLD_B_MASK              *   0x1f00      ; uhϐ a
BLD_Y_MASK              *   0x001f      ; uhϐ x

BLD_A_SHIFT             *   16
BLD_B_SHIFT             *   24
BLD_Y_SHIFT             *   0


;--------------------------------------------------------------------
;-                      TEh Rg[                       -
;--------------------------------------------------------------------

SOUND_SO1_LEVEL_MASK    *   0x03        ; rnPo̓x
SOUND_SO2_LEVEL_MASK    *   0x30        ; rnQo̓x
SOUND_DMG_SO1_ON_MASK   *   0x0f        ; clf݊TEhrnP nm
SOUND_DMG_SO2_ON_MASK   *   0xf0        ; clf݊TEhrnQ nm

SOUND_SWEEP_SHIFT_MASK  *   0x03        ; XC[v Vtg
SOUND_SWEEP_TIME_MASK   *   0x30        ; XC[v 
SOUND_COUNTS_MASK       *   0x3f        ; ̒(JEg)
SOUND_DUTY_MASK         *   0xc0        ; g`̃f[eB
SOUND_ENV_STEPS_MASK    *   0x03        ; Gx[v Xebv
SOUND_ENV_INIT_MASK     *   0xf0        ; Gx[v l
SOUND_FREQUENCY_MASK    *   0x03ff      ; g
SOUND_FREQUENCY_L_MASK  *   0xff
SOUND_FREQUENCY_H_MASK  *   0x03

SOUND_3_COUNTS_MASK     *   0xff        ; TEhR ̒(JEg)
SOUND_3_LEVEL_MASK      *   0xe0        ;            o̓x

SOUND_4_PRESCALER_MASK  *   0x03        ; TEhS vXP[I
SOUND_4_POLYSHIFT_MASK  *   0xf0        ;            |m~JEJE^ Vtg


SOUND_SO1_LEVEL_SHIFT   *   0
SOUND_SO2_LEVEL_SHIFT   *   4
SOUND_DMG_SO1_ON_SHIFT  *   0
SOUND_DMG_SO2_ON_SHIFT  *   4

SOUND_SWEEP_SHIFT_SHIFT *   0
SOUND_SWEEP_TIME_SHIFT  *   4
SOUND_COUNTS_SHIFT      *   0
SOUND_DUTY_SHIFT        *   6
SOUND_ENV_STEPS_SHIFT   *   0
SOUND_ENV_INIT_SHIFT    *   4
SOUND_FREQUENCY_SHIFT   *   0
SOUND_FREQUENCY_L_SHIFT *   0
SOUND_FREQUENCY_H_SHIFT *   8

SOUND_3_COUNTS_SHIFT    *   0
SOUND_3_LEVEL_SHIFT     *   5

SOUND_4_PRESCALER_SHIFT *   0
SOUND_4_POLYSHIFT_SHIFT *   4


SOUND_1_ON              *   0x01        ; TEhP nm
SOUND_2_ON              *   0x02        ; TEhQ nm
SOUND_3_ON              *   0x04        ; TEhR nm
SOUND_4_ON              *   0x08        ; TEhS nm
SOUND_DMG_ON            *   0x80        ; clf݊TEh nm

SOUND_1_SO1_ON          *   0x01        ; TEhPrnP nm
SOUND_2_SO1_ON          *   0x02        ; TEhQrnP nm
SOUND_3_SO1_ON          *   0x04        ; TEhRrnP nm
SOUND_4_SO1_ON          *   0x08        ; TEhSrnP nm
SOUND_1_SO2_ON          *   0x10        ; TEhPrnQ nm
SOUND_2_SO2_ON          *   0x20        ; TEhQrnQ nm
SOUND_3_SO2_ON          *   0x40        ; TEhRrnQ nm
SOUND_4_SO2_ON          *   0x80        ; TEhSrnQ nm
SOUND_DMG_ALL_SO1_ON    *   0x0f        ; clf݊TEhrnP nm
SOUND_DMG_ALL_SO2_ON    *   0xf0        ; clf݊TEhrnQ nm
SOUND_DMG_ALL_SO_ON     *   0xff        ; clf݊TEhrnP^Q nm
SOUND_VIN_SO1_ON        *   0x80        ; urnP nm
SOUND_VIN_SO2_ON        *   0x08        ; urnQ nm
SOUND_VIN_SO_ON         *   0x08        ; urnP^Q nm

SOUND_A_SO1_ON          *   0x01        ; _CNgTEh`rnP nm
SOUND_A_SO2_ON          *   0x02        ; _CNgTEh`rnQ nm
SOUND_B_SO1_ON          *   0x10        ; _CNgTEharnP nm
SOUND_B_SO2_ON          *   0x20        ; _CNgTEharnQ nm
SOUND_A_ALL_SO_ON       *   0x03        ; _CNgTEh`rnP^Q nm
SOUND_B_ALL_SO_ON       *   0x30        ; _CNgTEharnP^Q nm
SOUND_DIRECT_ALL_SO1_ON *   0x11        ; _CNgTEh`^arnP nm
SOUND_DIRECT_ALL_SO2_ON *   0x22        ; _CNgTEh`^arnQ nm
SOUND_DIRECT_ALL_SO_ON  *   0x33        ; _CNgTEh`^arnP^Q nm
SOUND_A_TIMER_0         *   0x00        ; ^C}[O_CNgTEh`
SOUND_A_TIMER_1         *   0x04        ; ^C}[P_CNgTEh`
SOUND_B_TIMER_0         *   0x00        ; ^C}[O_CNgTEha
SOUND_B_TIMER_1         *   0x40        ; ^C}[P_CNgTEha
SOUND_A_FIFO_RESET      *   0x08        ; _CNgTEh`pehen Zbg
SOUND_B_FIFO_RESET      *   0x80        ; _CNgTEhapehen Zbg

SOUND_DMG_MIX_1_4       *   0x00        ;   clf݊TEh P^S
SOUND_DMG_MIX_2_4       *   0x01        ;                            Q^S
SOUND_DMG_MIX_FULL      *   0x02        ;                            tW
SOUND_A_MIX_1_2         *   0x00        ; _CNgTEh` P^Q
SOUND_A_MIX_FULL        *   0x04        ;                            tW
SOUND_B_MIX_1_2         *   0x00        ; _CNgTEha P^Q
SOUND_B_MIX_FULL        *   0x08        ;                            tW
SOUND_ALL_MIX_FULL      *   0x0e        ;           STEh tW


SOUND_INIT_ON           *   0x80        ; CjV nm
SOUND_INIT_OFF          *   0x00        ; CjV nm
SOUND_COUNTER_ON        *   0x40        ;   JE^ nm
SOUND_COUNTER_OFF       *   0x00        ;   JE^ nee

SOUND_SWEEP_UP          *   0x00        ; XC[v Z
SOUND_SWEEP_DOWN        *   0x08        ;          Z
SOUND_DUTY_1_8          *   0x00        ; g`̃f[eB P^W
SOUND_DUTY_2_8          *   0x40        ;                  Q^W
SOUND_DUTY_4_8          *   0x80        ;                  S^W
SOUND_DUTY_6_8          *   0xc0        ;                  U^W
SOUND_ENV_UP            *   0x08        ; Gx[v to
SOUND_ENV_DOWN          *   0x00        ;              cnvm

SOUND_3_LOCAL_ON        *   0x80        ; TEhR nm
SOUND_3_WAVE_BANK_0     *   0x00        ; TEhR g`q`l oNO
SOUND_3_WAVE_BANK_1     *   0x40        ;                       oNP
SOUND_3_WAVE_CONNECT    *   0x20        ; TEhR g`q`l ڑ
SOUND_3_WAVE_DISCONNECT *   0x00        ;                       ڑ
SOUND_3_LEVEL_0_4       *   0x00        ; TEhR o Ȃ
SOUND_3_LEVEL_FULL      *   0x20        ;                 S^S
SOUND_3_LEVEL_2_4       *   0x40        ;                 Q^S
SOUND_3_LEVEL_1_4       *   0x60        ;                 P^S
SOUND_3_LEVEL_3_4       *   0x80        ;                 R^S

SOUND_4_POLYSTEP_15     *   0x00        ; TEhS |m~JEJE^ PTi
SOUND_4_POLYSTEP_7      *   0x08        ;                                     Vi


;--------------------------------------------------------------------
;-                      rhnRg[                          -
;--------------------------------------------------------------------

SIO_MODE_MASK           *   0x3000        ; ʐM[h
SIO_BAUD_RATE_MASK      *   0x0003        ; {[[g
SIO_ID_NO_MASK          *   0x0030        ; ʐMhc

SIO_MODE_SHIFT          *   12
SIO_BAUD_RATE_SHIFT     *   0
SIO_ID_NO_SHIFT         *   4

SIO_8BIT_MODE           *   0x0000        ; m[}WrbgʐM[h
SIO_32BIT_MODE          *   0x1000        ; m[}RQrbgʐM[h
SIO_MULTI_MODE          *   0x2000        ; }`vCʐM[h
SIO_UART_MODE           *   0x3000        ; t`qsʐM[h

SIO_SCK_OUT             *   0x0000        ; ONbNI
SIO_SCK_IN              *   0x0001        ; NbNI
SIO_IN_SCK_256K         *   0x0000        ; NbN QTUjgI
SIO_IN_SCK_2M           *   0x0002        ;                  QlgI
SIO_ACK_RECV            *   0x0004        ; ]v
SIO_ACK_SEND            *   0x0008        ; ]
SIO_9600_BPS            *   0x0000        ; {[[g XUOOaor
SIO_38400_BPS           *   0x0001        ;          RWSOOaor
SIO_57600_BPS           *   0x0002        ;          TVUOOaor
SIO_115200_BPS          *   0x0003        ;        PPTQOOaor
SIO_MULTI_CONNECT       *   0x0004        ; }`vCʐM ڑ
SIO_MULTI_DISCONNECT    *   0x0000        ;                  ڑ
SIO_MULTI_PARENT        *   0x0008        ; }`vCʐM eڑ
SIO_MULTI_CHILD         *   0x0000        ;                  qڑ
SIO_MULTI_SI            *   0x0004        ; }`vCʐM rh[q
SIO_MULTI_SD            *   0x0008        ;                  rc[q
SIO_MULTI_BUSY          *   0x0080        ; }`vCʐM
SIO_CTS_ENABLE          *   0x0004        ; t`qsM\M  Cl[u
SIO_UART_7BIT           *   0x0000        ; t`qsʐM f[^ V
SIO_UART_8BIT           *   0x0080        ;                       W
SIO_ERROR               *   0x0040        ; G[o
SIO_START               *   0x0080        ; ]X^[g
SIO_ENABLE              *   0x0080        ; rhn
SIO_FIFO_ENABLE         *   0x0100        ; ehen Cl[u
SIO_PARITY_ENABLE       *   0x0200        ; peB Cl[u
SIO_PARITY_EVEN         *   0x0000        ; peB
SIO_PARITY_ODD          *   0x0008        ; peB
SIO_TRANS_ENABLE        *   0x0400        ; gX~b^ Cl[u
SIO_TRANS_DATA_FULL     *   0x0010        ; gX~bgf[^ t
SIO_RECV_ENABLE         *   0x0800        ; V[o Cl[u
SIO_RECV_DATA_EMPTY     *   0x0020        ; V[uf[^ 
SIO_IF_ENABLE           *   0x4000        ; 荞ݗv 

;--------------------------------------------------------------------
;-                      inxoX Rg[                     -
;--------------------------------------------------------------------

JOY_IF_RESET            *   0x01          ; inxoXEZbg 荞ݗv
JOY_IF_RECV             *   0x02          ; inxoXM   荞ݗv
JOY_IF_SEND             *   0x04          ; inxoXM   荞ݗv
JOY_IF_ENABLE           *   0x40          ; 荞ݗv 

;--------------------------------------------------------------------
;-                      inxoX Xe[^X                       -
;--------------------------------------------------------------------

JSTAT_FLAGS_MASK        *   0x30          ; ėptO

JSTAT_FLAGS_SHIFT       *   4

JSTAT_RECV              *   0x02          ; MXe[^X
JSTAT_SEND              *   0x08          ; MXe[^X

;--------------------------------------------------------------------
;-                      ėpo̓Rg[                      -
;--------------------------------------------------------------------

R_SIO_MODE_MASTER_MASK  *   0xc000        ; rhn[hE}X^

R_SIO_MODE_MASTER_SHIFT *   14

R_SIO_MASTER_MODE       *   0x0000        ; rhn}X^E[h
R_DIRECT_MODE           *   0x8000        ; ėpo͒ʐM[h
R_JOY_MODE              *   0xc000        ; inxʐM[h

R_SC                    *   0x0001        ; f[^
R_SD                    *   0x0002
R_SI                    *   0x0004
R_SO                    *   0x0008
R_SC_I_O                *   0x0010        ; h/nI
R_SD_I_O                *   0x0020
R_SI_I_O                *   0x0040
R_SO_I_O                *   0x0080
R_IF_ENABLE             *   0x0100        ; 荞ݗv 


;--------------------------------------------------------------------
;-                      cl`Rg[                          -
;--------------------------------------------------------------------

DMA_TIMMING_MASK        *   0x30000000  ; Jn^C~O
DMA_COUNT_MASK          *   0x0000ffff  ; ]

DMA_TIMMING_SHIFT       *   30
DMA_COUNT_SHIFT         *   0

DMA_ENABLE              *   0x80000000  ; cl`
DMA_IF_ENABLE           *   0x40000000  ; 荞ݗv 
DMA_TIMMING_IMM         *   0x00000000  ; ɋN
DMA_TIMMING_V_BLANK     *   0x10000000  ; uuNN
DMA_TIMMING_H_BLANK     *   0x20000000  ; guNN
DMA_TIMMING_DISP        *   0x30000000  ; \N
DMA_TIMMING_SOUND       *   0x30000000  ; TEhehenNGXgN
DMA_DREQ_ON             *   0x08000000  ; f[^v[h nm
DMA_16BIT_BUS           *   0x00000000  ; oXTCYPUaI
DMA_32BIT_BUS           *   0x04000000  ; oXTCYRQaI
DMA_CONTINUOUS_ON       *   0x02000000  ; ReBjAX[h nm
DMA_SRC_INC             *   0x00000000  ; ] CNg I
DMA_SRC_FIX             *   0x01000000  ; ] Œ I
DMA_DEST_INC            *   0x00000000  ; ] CNg I
DMA_DEST_RELOAD         *   0x00800000  ; ] CNg/[h I

;--------------------------------------------------------------------
;-                      ^C}[ Rg[                       -
;--------------------------------------------------------------------

TMR_PRESCALER_MASK      *   0x00030000  ; vXP[ NbN

TMR_PRESCALER_SHIFT     *   16

TMR_PRESCALER_1CK       *   0x00000000  ; vXP[ P
TMR_PRESCALER_64CK      *   0x00010000  ;           US
TMR_PRESCALER_256CK     *   0x00020000  ;         QTU
TMR_PRESCALER_1024CK    *   0x00030000  ;       POQS
TMR_IF_ENABLE           *   0x00400000  ; 荞ݗv 
TMR_ENABLE              *   0x00800000  ; ^C}[N


;--------------------------------------------------------------------
;-                          L[                                    -
;--------------------------------------------------------------------

BUTTON_MASK             *   0x030f      ; {^
PLUS_KEY_MASK           *   0x00f0      ; \L[
ALL_KEY_MASK            *   0x03ff      ; SẴL[

A_BUTTON                *   0x0001      ; `{^
B_BUTTON                *   0x0002      ; a{^
SELECT_BUTTON           *   0x0004      ; ZNg{^
START_BUTTON            *   0x0008      ; X^[g{^
R_KEY                   *   0x0010      ; E{^
L_KEY                   *   0x0020      ; {^
U_KEY                   *   0x0040      ; {^
D_KEY                   *   0x0080      ; {^
R_BUTTON                *   0x0100      ; q{^
L_BUTTON                *   0x0200      ; k{^
KEY_IF_ENABLE           *   0x4000      ; 荞ݗv 
KEY_OR_INTR             *   0x0000      ;   ʏL[荞
KEY_AND_INTR            *   0x8000      ; `mcL[荞


;--------------------------------------------------------------------
;-                  JZbgEFCg Rg[                   -
;--------------------------------------------------------------------

CST_SRAM_4WAIT          *   0x0000      ; rq`l SEFCg
CST_SRAM_3WAIT          *   0x0001      ;          REFCg
CST_SRAM_2WAIT          *   0x0002      ;          QEFCg
CST_SRAM_8WAIT          *   0x0003      ;          WEFCg
CST_ROM0_1ST_4WAIT      *   0x0000      ; qnlO P SEFCg
CST_ROM0_1ST_3WAIT      *   0x0004      ;                    REFCg
CST_ROM0_1ST_2WAIT      *   0x0008      ;                    QEFCg
CST_ROM0_1ST_8WAIT      *   0x000c      ;                    WEFCg
CST_ROM0_2ND_2WAIT      *   0x0000      ;             Q QEFCg
CST_ROM0_2ND_1WAIT      *   0x0010      ;                    PEFCg
CST_ROM1_1ST_4WAIT      *   0x0000      ; qnlP P SEFCg
CST_ROM1_1ST_3WAIT      *   0x0020      ;                    REFCg
CST_ROM1_1ST_2WAIT      *   0x0040      ;                    QEFCg
CST_ROM1_1ST_8WAIT      *   0x0060      ;                    WEFCg
CST_ROM1_2ND_4WAIT      *   0x0000      ;             Q SEFCg
CST_ROM1_2ND_1WAIT      *   0x0080      ;                    PEFCg
CST_ROM2_1ST_4WAIT      *   0x0000      ; qnlQ P SEFCg
CST_ROM2_1ST_3WAIT      *   0x0100      ;                    REFCg
CST_ROM2_1ST_2WAIT      *   0x0200      ;                    QEFCg
CST_ROM2_1ST_8WAIT      *   0x0300      ;                    WEFCg
CST_ROM2_2ND_8WAIT      *   0x0000      ;             Q WEFCg
CST_ROM2_2ND_1WAIT      *   0x0400      ;                 PEFCg

CST_PHI_OUT_NONE        *   0x0000      ; Ӓ[qo̓NbN kŒ
CST_PHI_OUT_4MCK        *   0x0800      ;                Slg
CST_PHI_OUT_8MCK        *   0x1000      ;                Wlg
CST_PHI_OUT_16MCK       *   0x1800      ;              PUlg
CST_PREFETCH_ENABLE     *   0x4000      ; vtFb`obt@ 
CST_AGB                 *   0x0000      ; `faJZbg
CST_CGB                 *   0x8000      ; bfaJZbg


