/********************************************************************/
/*          AgbSound.h                                              */
/*            AGBWTEhhCop錾                         */
/*                                                                  */
/*          Copyright (C) 1999-2000 NINTENDO Co.,Ltd.               */
/*          Programed by SMASH Co.,Ltd.                             */
/********************************************************************/
#ifndef _AGB_SOUND_H
#define _AGB_SOUND_H

#ifdef __cplusplus
extern "C" {
#endif


#include <AgbTypes.h>


//g`f[^̍\
typedef struct {
    u16 type;   //^Cv
    u16 stat;   //Xe[^X
    u32 freq;   //gvZl
    u32 loop;   //[vJnʒu
    u32 size;   //TvO
    s8 data[1]; //TvOf[^z
} WaveData;

#define WAVE_STAT_LOOP  0xc000


//Ff[^̍\
typedef struct {
    u8 typ;         //^Cv
    u8 key;         //IWiL[
    u8 len;         //̒i݊TEhj
    u8 p_s;         //p|bg or XC[vi݊TEhPj
    WaveData *wav;  //g`f[^̃AhX
    u8 att;         //A^bN
    u8 dec;         //fBPC
    u8 sus;         //TXeB
    u8 rel;         //[X
} ToneData;

#define TONEDATA_TYP_RHY    0x80
#define TONEDATA_TYP_SPL    0x40
#define TONEDATA_TYP_FIX    0x08
#define TONEDATA_TYP_CGB    0x07

#define TONEDATA_P_S_PAM    0xc0

typedef struct { u32 typ; ToneData *ta; u8 *st; } SplitTone;
typedef union { ToneData t; SplitTone s; } ToneDataArr;

#define RHYTHM_TONE(TA)     {TONEDATA_TYP_RHY,0,0,0,(WaveData *)(TA)}
#define SPLIT_TONE(TA,ST)   (ToneDataArr)(SplitTone)\
                {TONEDATA_TYP_SPL, (ToneData *)(TA), (u8 *)(ST)}
#define RHY_SPL_TONE(TA,ST) (ToneDataArr)(SplitTone)\
                {TONEDATA_TYP_RHY|TONEDATA_TYP_SPL, (ToneData *)(TA), (u8 *)(ST)}


//z`l̍\
typedef struct {
    u8 sf;          //Xe[^X
    u8 ty;          //^Cv
    u8 rv;          //E
    u8 lv;          //
    u8 at;          //A^bN
    u8 de;          //fBPC
    u8 su;          //TXeB
    u8 re;          //[X
    u8 r1[24];      // (reserved)
    u32 fr;         //gvZl
    WaveData *wp;   //g`|C^
    u32 r3[6];      // (reserved)
} SoundChannel;

#define MAX_DIRECTSOUND_CHANNEL 12
#define SOUND_CHANNEL_SF_START  0x80
#define SOUND_CHANNEL_SF_STOP   0x40
#define SOUND_CHANNEL_SF_LOOP   0x10
#define SOUND_CHANNEL_SF_IEC    0x04
#define SOUND_CHANNEL_SF_ENV    0x03
#define SOUND_CHANNEL_SF_ON     (SOUND_CHANNEL_SF_START|SOUND_CHANNEL_SF_STOP\
                                |SOUND_CHANNEL_SF_IEC|SOUND_CHANNEL_SF_ENV)

#define SOUND_CHANNEL_TY_FIX    TONEDATA_TYP_FIX
#define SOUND_CHANNEL_TY_CGB    TONEDATA_TYP_CGB


//_CNgTEh]obt@̃TCY
#define PCM_DMA_BUF 1584


//TEhE[NGA̍\
typedef struct {
    u32 r1;     // (reserved)
    vu8 DmaCount;
    u8 reverb;  //_CNgTEhEo[ul
    u8 maxchn;  //_CNgTEhE
    u8 masvol;  //_CNgTEhE}X^[{[
    u8 freq;    //_CNgTEhEĐgԍ(1=5734Hz ` 12=42048Hz)
    u8 mode;    //TEhhCoE샂[h
    u8 r2[6];   // (reserved)
    u32 r3[16]; // (reserved)
    SoundChannel vchn[MAX_DIRECTSOUND_CHANNEL];
    s8 pcmbuf[PCM_DMA_BUF*2];
} SoundArea;

#define SOUND_MODE_REVERB_VAL   0x0000007f
#define SOUND_MODE_REVERB_SET   0x00000080
#define SOUND_MODE_MAXCHN       0x00000f00
#define SOUND_MODE_MAXCHN_SHIFT 8
#define SOUND_MODE_MASVOL       0x0000f000
#define SOUND_MODE_MASVOL_SHIFT 12
#define SOUND_MODE_FREQ_05734   0x00010000
#define SOUND_MODE_FREQ_07884   0x00020000
#define SOUND_MODE_FREQ_10512   0x00030000
#define SOUND_MODE_FREQ_13379   0x00040000
#define SOUND_MODE_FREQ_15768   0x00050000
#define SOUND_MODE_FREQ_18157   0x00060000
#define SOUND_MODE_FREQ_21024   0x00070000
#define SOUND_MODE_FREQ_26758   0x00080000
#define SOUND_MODE_FREQ_31536   0x00090000
#define SOUND_MODE_FREQ_36314   0x000a0000
#define SOUND_MODE_FREQ_40137   0x000b0000
#define SOUND_MODE_FREQ_42048   0x000c0000
#define SOUND_MODE_FREQ_SHIFT   16
#define SOUND_MODE_DA_BIT_9     0x00800000
#define SOUND_MODE_DA_BIT_8     0x00900000
#define SOUND_MODE_DA_BIT_7     0x00a00000
#define SOUND_MODE_DA_BIT_6     0x00b00000
#define SOUND_MODE_DA_BIT_SHIFT 20


//\Of[^̍\
typedef struct {
    u8 trks;            //gbN
    u8 blks;            //ubN
    u8 prio;            //vCIeB
    u8 rvrb;            //o[u
    ToneData *tone;     //Fe[u
    u8 *part[1];
} SongHeader;


//~[WbNvC[E[NGA̍\
typedef struct {
    SongHeader *song;   //݂̃\O|C^
    u32 stat;           //Xe[^X
    u8 mtrk;            //gbN
    u8 prio;            //݂̃vCIeB
    u8 d[54];
} MusicPlayerArea;

//~[WbNvC[̊egbN̍\
typedef struct {
    u8 d[80];
} MusicPlayerTrack;

#define MAX_MUSICPLAYER_TRACK       16
#define MUSICPLAYER_STATUS_TRACK    0x0000ffff
#define MUSICPLAYER_STATUS_PAUSE    0x80000000


#ifdef __cplusplus
}      /* extern "C" */
#endif

#endif // _AGB_SOUND_H
