#include "AgbMon.h"
#include "AgbSoundPrv.h"



#ifndef USE_SYSCALL

//萔f[^

extern void (*MPlyJmpTbl[])();

const u8 clock_tbl[49] = {
	 0, 1, 2, 3, 4, 5, 6, 7, 8, 9,10,11,
	12,13,14,15,16,17,18,19,20,21,22,23,
	24,         28,   30,   32,         
	36,         40,   42,   44,         
	48,         52,   54,   56,         
	60,         64,   66,   68,         
	72,         76,   78,   80,         
	84,         88,   90,   92,         
	96,
};



//t@NVEvg^Cv
extern void SampFreqSet(u32 i);

void MPlayMain(MPlayAreaPrv *ma);
void TrackStop(MPlayAreaPrv *ma, MPlayTrkPrv *tp);
void FadeOutBody(MPlayAreaPrv *ma);
void TrkVolPitSet(MPlayAreaPrv *ma, MPlayTrkPrv *tp);
void ClearChain(SoundChannelPrv *cp);
void Clear64byte(void *da);

u8 ld_tp_adr_i(MPlayAreaPrv *ma, MPlayTrkPrv *tp);
void ply_note(u8 d, MPlayAreaPrv *ma, MPlayTrkPrv *tp);
void ply_fine(MPlayAreaPrv *ma, MPlayTrkPrv *tp);
void ply_goto(MPlayAreaPrv *ma, MPlayTrkPrv *tp);



//t@NV

void MPlayOpen(MusicPlayerArea *ma, MusicPlayerTrack *ta, u8 tn)
{
	SoundAreaPrv *sa;

	if ( tn < 1 ) return;
	if ( tn > MAX_MUSICPLAYER_TRACK ) tn = MAX_MUSICPLAYER_TRACK;

	Clear64byte(ma);
	MA(PlyTrk) = (MPlayTrkPrv *)ta;
	MA(mtrk) = tn;
	MA(stat) = MUSICPLAYER_STATUS_PAUSE;
	for ( ; tn>0; tn--,ta++) *(u8 *)ta = 0;

	sa = *(SoundAreaPrv **)SOUND_AREA_ADR;
	if ( sa->ident != ID_NUMBER ) return;
	sa->ident++;

	if ( sa->func )
	{
		MA(func) = sa->func;
		MA(intp) = sa->intp;
		sa->func = 0;
	}

	sa->intp = (u32)ma;
	sa->func = MPlayMain;

	sa->ident = ID_NUMBER;
	MA(ident) = ID_NUMBER;
	return;
}



#ifndef WITH_ASM

void MPlyJmpTblCopy(void (**tbl)())
{
	int i, d;
	int *src;

	for (i=MPLYJMPTBLSIZ,src=(int *)MPlyJmpTbl; i>0; i--,src++,tbl++)
	{
		d = *src;

		//security
		if ( src < (int *)0x02000000 )
		{ if ( (src < (int *)MPlyJmpTbl )||(src >= (int *)0x4000) ) d = 0; }

		*tbl = (void (*)())d;
	}

	return;
}

#endif // WITH_ASM



void MPlayStart(MusicPlayerArea *ma, SongHeader *so)
{
	int i;
	MPlayTrkPrv *tp;

	if ( MA(ident) != ID_NUMBER ) return;
	MA(ident)++;

	MA(stat) = 0;
	MA(song) = so;
	MA(tone) = so->tone;
	MA(prio) = so->prio;
	MA(TempoI) = MA(TempoD) = TEMPOBASE;
	MA(TempoU) = 0x0100;
	MA(TempoC) = 0;
	MA(FadeOI) = 0;

	for (i=0,tp=MA(PlyTrk); (i<so->trks)&&(i<MA(mtrk)); i++,tp++)
	{
		TrackStop((MPlayAreaPrv *)ma, tp);
		tp->flg = MPT_FLG_EXIST | MPT_FLG_START;
		tp->adr = so->part[i];
	}

	for ( ; i<MA(mtrk); i++,tp++)
	{
		TrackStop((MPlayAreaPrv *)ma, tp); tp->flg = 0;
	}

	if ( so->rvrb & SOUND_MODE_REVERB_SET )
	{
		SoundMode(so->rvrb);
	}

	MA(ident) = ID_NUMBER;
	return;
}



void MPlayStop(MusicPlayerArea *ma)
{
	int i;
	MPlayTrkPrv *tp;

	if ( MA(ident) != ID_NUMBER ) return;
	MA(ident)++;

	MA(stat) |= MUSICPLAYER_STATUS_PAUSE;

	for (i=MA(mtrk),tp=MA(PlyTrk); i>0; i--,tp++)
	{
		TrackStop((MPlayAreaPrv *)ma, tp);
	}

	MA(ident) = ID_NUMBER;
	return;
}



void MPlayContinue(MusicPlayerArea *ma)
{
	int i;
	MPlayTrkPrv *tp;

	if ( MA(ident) != ID_NUMBER ) return;
	MA(ident)++;

	MA(stat) &= ~MUSICPLAYER_STATUS_PAUSE;

	MA(ident) = ID_NUMBER;
	return;
}



void MPlayFadeOut(MusicPlayerArea *ma, u16 sp)
{
	if ( MA(ident) != ID_NUMBER ) return;
	MA(ident)++;

	MA(FadeOI) = MA(FadeOC) = sp;
	MA(FadeOV) = 0x0100;

	MA(ident) = ID_NUMBER;
	return;
}



#ifndef WITH_ASM

void MPlayMain(MPlayAreaPrv *ma)
{
	int i, j;
	MPlayTrkPrv *tp;
	SoundAreaPrv *sa;
	SoundChannelPrv *cp;
	u32 bi, bs;
	u8 d, ch;

	if ( ma->ident != ID_NUMBER ) return;
	ma->ident++;

	if ( ma->func ) ma->func(ma->intp);

	if ( ma->stat & MUSICPLAYER_STATUS_PAUSE ) goto pause;

	sa = *(SoundAreaPrv **)SOUND_AREA_ADR;

	FadeOutBody(ma);

	if ( (ma->TempoC += ma->TempoI) >= TEMPOBASE )
	do{
		for (i=ma->mtrk,tp=ma->PlyTrk,bi=1,bs=0; i>0; i--,tp++,bi<<=1)
		{
			if ( (tp->flg & MPT_FLG_EXIST)==0 ) continue;
			bs |= bi;

			for (cp=tp->chn; cp!=0; cp=(SoundChannelPrv *)(cp->np))
			{
				if ( cp->sf & SOUND_CHANNEL_SF_ON )
				{ if ( cp->gt ) { if (--cp->gt == 0) cp->sf |= SOUND_CHANNEL_SF_STOP;}}
				else ClearChain(cp);
			}

			if ( tp->flg & MPT_FLG_START )
			{
				Clear64byte(tp);
				tp->flg  = MPT_FLG_EXIST;
				tp->bndR = 2;
				tp->volX = 0x40;
				tp->lfo  = 22;
				tp->typ  = 1;
			}

			while ( tp->wai == 0 )
			{
				if ( (d = *tp->adr) < W00 ) d = tp->run;
				else {tp->adr++; if ( d >= RUNSTT ) tp->run = d; }

				if ( d >= TIE ) sa->ply_note(d-TIE, ma, tp);
				else if ( d > W96 )
				{
					ma->cmd = d - W96 - 1;
					(sa->MPlyJmpTbl[ma->cmd])(ma, tp);
					if ( tp->flg == 0 ) goto next_trk;
				}
				else tp->wai = clock_tbl[d-W00];
			}
			tp->wai--;

			if ( tp->lfo && tp->mod )
			{
				if ( tp->ldlC ) tp->ldlC--;
				else
				{
					tp->lfoC += tp->lfo;

					if ( (tp->lfoC < 0x40)||(tp->lfoC >= 0xC0) ) j = (s8)tp->lfoC;
					else j = (s32)0x0080 - (u32)tp->lfoC;

					j = (j * tp->mod) >> 6;

					if ( tp->modM != (s8)j )
					{
						tp->modM = (s8)j;
						if ( tp->modT == MOD_VIB ) tp->flg |= MPT_FLG_PITCHG;
						else tp->flg |= MPT_FLG_VOLCHG;
					}
				}
			}
		next_trk:;
		}

		if ( bs ) ma->stat = bs; // | (ma->stat & ~MUSICPLAYER_STATUS_TRACK);
		else { ma->stat = MUSICPLAYER_STATUS_PAUSE; goto pause; }

		ma->TempoC -= TEMPOBASE;
	}while ( ma->TempoC >= TEMPOBASE );

	for (i=ma->mtrk,tp=ma->PlyTrk; i>0; i--,tp++)
	{
		if ( (tp->flg & MPT_FLG_EXIST)==0 ) continue;
		if ( (tp->flg & (MPT_FLG_VOLCHG | MPT_FLG_PITCHG))==0 ) continue;

		TrkVolPitSet(ma, tp);

		for (cp=tp->chn; cp!=0; cp=(SoundChannelPrv *)(cp->np))
		{
			if ( (cp->sf & SOUND_CHANNEL_SF_ON)==0 ) { ClearChain(cp); continue; }

			ch = cp->ty & SOUND_CHANNEL_TY_CGB;

			if ( tp->flg & MPT_FLG_VOLCHG )
			{
				cp->rv = (cp->ve * tp->volMR) >> 7;
				cp->lv = (cp->ve * tp->volML) >> 7;
				if ( ch ) ((CgbChannelPrv *)cp)->mo |= CGB_CHANNEL_MO_VOL;
			}

			if ( tp->flg & MPT_FLG_PITCHG )
			{
				if ( (j = cp->ky + (s32)tp->keyM) < 0 ) j = 0;
				if ( ch )
				{
					cp->fr = sa->MK2CgbFr(ch, j, tp->pitM);
					((CgbChannelPrv *)cp)->mo |= CGB_CHANNEL_MO_PIT;
				}
				else cp->fr = MidiKey2fr(cp->wp, j, tp->pitM);
			}
		}

		tp->flg &= ~(MPT_FLG_VOLCHG | MPT_FLG_PITCHG);
	}

pause:;
	ma->ident = ID_NUMBER;
	return;
}



void Clear64byte(void *da)
{
	*((u32 *)da)++ = 0;
	*((u32 *)da)++ = 0;
	*((u32 *)da)++ = 0;
	*((u32 *)da)++ = 0;
	*((u32 *)da)++ = 0;
	*((u32 *)da)++ = 0;
	*((u32 *)da)++ = 0;
	*((u32 *)da)++ = 0;
	*((u32 *)da)++ = 0;
	*((u32 *)da)++ = 0;
	*((u32 *)da)++ = 0;
	*((u32 *)da)++ = 0;
	*((u32 *)da)++ = 0;
	*((u32 *)da)++ = 0;
	*((u32 *)da)++ = 0;
	*((u32 *)da)++ = 0;
	return;
}



void ClearChain(SoundChannelPrv *cp)
{
	if ( cp->tp )
	{
		if ( cp->pp ) ((SoundChannelPrv *)(cp->pp))->np = cp->np;
		else ((MPlayTrkPrv *)(cp->tp))->chn = (void *)cp->np;
		if ( cp->np ) ((SoundChannelPrv *)(cp->np))->pp = cp->pp;
		cp->tp = 0;
	}
	return;
}



void TrackStop(MPlayAreaPrv *ma, MPlayTrkPrv *tp)
{
	int i;
	SoundChannelPrv *cp;

	if ( (tp->flg & MPT_FLG_EXIST) == 0 ) return;

	for (cp=tp->chn; cp!=0; cp=(SoundChannelPrv *)(cp->np))
	{
		if ( cp->sf == 0 ) continue;
		if ( (i=(cp->ty & SOUND_CHANNEL_TY_CGB)) ) SA(CgbOscOff)((u8)i);
		cp->sf = 0;
		cp->tp = 0;
	}

	tp->chn = 0;
	return;
}

#endif // WITH_ASM



void FadeOutBody(MPlayAreaPrv *ma)
{
	int i;
	MPlayTrkPrv *tp;

	if ( ma->FadeOI == 0 ) return;
	if ( --ma->FadeOC ) return;

	if ( (s16)(ma->FadeOV-=16)<=0 )
	{
		for (i=ma->mtrk,tp=ma->PlyTrk; i>0; i--,tp++)
		{
			TrackStop(ma, tp); tp->flg = 0;
		}
	}
	else
	{
		ma->FadeOC = ma->FadeOI;
		for (i=ma->mtrk,tp=ma->PlyTrk; i>0; i--,tp++)
		{
			if ( tp->flg & MPT_FLG_EXIST )
			{ tp->volX = (u8)(ma->FadeOV >> 2); tp->flg |= MPT_FLG_VOLCHG; }
		}
	}

	return;
}



void TrkVolPitSet(MPlayAreaPrv *ma, MPlayTrkPrv *tp)
{
	u32 vw, vc;
	s32 pw;

	if ( tp->flg & MPT_FLG_VOLSET )
	{
		vw = ((u32)tp->vol * tp->volX) >> 5;
		if ( tp->modT == MOD_TRE ) vw += (s32)tp->modM;

		pw = (s32)(tp->pam << 1) + tp->pamX;
		if ( tp->modT == MOD_PAM ) pw += (s32)tp->modM;
		if ( pw < -128 ) pw = -128; else if ( pw > 127 ) pw = 127;

		if ( (vc=(u8)((vw*(u32)(pw+128))>>8)) > 255 ) vc = 255;
		tp->volMR = vc;

		if ( (vc=(u8)((vw*(u32)(127-pw))>>8)) > 255 ) vc = 255;
		tp->volML = vc;
	}

	if ( tp->flg & MPT_FLG_PITSET )
	{
		pw = (((s32)tp->bnd * tp->bndR) << 2)
		   + ((s32)tp->tun << 2) + ((s32)tp->ksh << 8)
		   + ((s32)tp->kshX << 8) + (u32)tp->pitX;
		if ( tp->modT == MOD_VIB ) pw += ((s32)tp->modM << 4);

		tp->keyM = pw >> 8;
		tp->pitM = (u8)pw;
	}

	SA(ExtVolPit)(ma, tp);

	tp->flg &= ~(MPT_FLG_VOLSET | MPT_FLG_PITSET);
	return;
}



#ifndef WITH_ASM

void ply_note(u8 d, MPlayAreaPrv *ma, MPlayTrkPrv *tp)
{
	int i;
	SoundAreaPrv *sa;
	SoundChannelPrv *cp;
	ToneData *to;
	void *min_tp;
	SoundChannelPrv *min_cp;
	u8 min_pr, min_fs, cpky, prio, ch;

	sa = *(SoundAreaPrv **)SOUND_AREA_ADR;
	tp->gat = clock_tbl[d];

	if ( (i=*tp->adr) < W00 )
	{
		tp->key = (u8)i; tp->adr++;

		if ( (i=*tp->adr) < W00 )
		{
			tp->vel = (u8)i; tp->adr++;

			if ( (i=*tp->adr) < W00 )
			{
				tp->gat += (u8)i; tp->adr++;
			}
		}
	}

	if ( tp->typ & (TONEDATA_TYP_RHY|TONEDATA_TYP_SPL) )
	{
		if ( tp->typ & TONEDATA_TYP_SPL )
		 to = &((ToneData *)tp->wav)[(*(u8 **)&(tp->att))[tp->key]];
		else to = &((ToneData *)tp->wav)[tp->key];

		if ( to->typ & (TONEDATA_TYP_RHY|TONEDATA_TYP_SPL) ) goto NoTone;

		if ( tp->typ & TONEDATA_TYP_RHY )
		{
			if ( to->p_s & 0x80 )
			{ tp->pamX = (to->p_s-TONEDATA_P_S_PAM)<<1; tp->flg |= MPT_FLG_VOLCHG; }
			cpky = to->key;
		}
		else cpky = tp->key;
	}
	else { to = (ToneData *)&(tp->typ); cpky = tp->key; }

	if ( (i=ma->prio+tp->prio) > 255 ) prio = 255; else prio = i;

	if ( ch=(to->typ & TONEDATA_TYP_CGB) )
	{
		if ( (cp=(SoundChannelPrv *)sa->vcgb) == 0 ) goto NoTone;
		cp += (ch - 1);

		if ( (cp->sf & SOUND_CHANNEL_SF_ON)==0 ) goto SetChn;
		if ( cp->sf & SOUND_CHANNEL_SF_STOP ) goto SetChn;
		if ( cp->pr < prio ) goto SetChn;
		if ( cp->pr > prio ) goto NoTone;
		if ( cp->tp >= (void *)tp ) goto SetChn;
		goto NoTone;
	}

	min_pr = prio;
	min_tp = (void *)tp;
	min_fs = 0;
	min_cp = 0;

	for (i=sa->maxchn,cp=sa->vchn; i>0; i--,cp++)
	{
		if ( (cp->sf & SOUND_CHANNEL_SF_ON)==0 ) goto SetChn;

		if ( cp->sf & SOUND_CHANNEL_SF_STOP )
		{
			if ( min_fs == 0 )
			{ min_fs++; min_pr = cp->pr; min_tp = cp->tp; goto SetMinCp; }
			else goto ChkPrTp;
		}
		else { if ( min_fs ) continue; }

	ChkPrTp:;
		if ( cp->pr < min_pr ) { min_pr = cp->pr; min_tp = cp->tp; goto SetMinCp; }
		if ( cp->pr > min_pr ) continue;

		if ( cp->tp > min_tp ) { min_tp = cp->tp; goto SetMinCp; }
		if ( cp->tp < min_tp ) continue;

	SetMinCp:;
		min_cp = cp;
	}

	if ( (cp = min_cp) == 0 ) goto NoTone; 

SetChn:;

	ClearChain(cp);
	cp->pp = 0;
	cp->np = (void *)tp->chn;
	if ( tp->chn ) (tp->chn)->pp = (void *)cp;
	tp->chn = cp;
	cp->tp = (void *)tp;

	if( (tp->ldlC = tp->ldl) ) { tp->modM = tp->lfoC = 0; }

	TrkVolPitSet(ma, tp);

	*(u32 *)&(cp->gt) = *(u32 *)&(tp->gat);  // ,key,vel
	cp->pr = prio;
	cp->ky = cpky;
	cp->ty = to->typ;
	cp->wp = to->wav;
	*(u32 *)&(cp->at) = *(u32 *)&(to->att);  // ,dec,sus,rel
	*(u16 *)&(cp->iev) = *(u16 *)&(tp->iev); // ,iel

	cp->rv = (cp->ve * tp->volMR) >> 7;
	cp->lv = (cp->ve * tp->volML) >> 7;

	if ( (i = cp->ky + (s32)tp->keyM) < 0 ) i = 0;

	if ( ch )
	{
		((CgbChannelPrv *)cp)->le = to->len;
		if ( (to->p_s & 0x80)==0 ) ((CgbChannelPrv *)cp)->sw = to->p_s;
		cp->fr = sa->MK2CgbFr(ch, i, tp->pitM);
	}
	else cp->fr = MidiKey2fr(cp->wp, i, tp->pitM);

	cp->sf = SOUND_CHANNEL_SF_START;
	tp->flg &= ~(MPT_FLG_VOLCHG | MPT_FLG_PITCHG);

NoTone:;
	return;
}



void ply_endtie(MPlayAreaPrv *ma, MPlayTrkPrv *tp)
{
	u8 mk;
	int i;
	SoundChannelPrv *cp;

	if ( (mk = *tp->adr) < W00 ) { tp->key = mk; tp->adr++; }
	else mk = tp->key;

	for (cp=tp->chn; cp!=0; cp=(SoundChannelPrv *)(cp->np))
	{
		if ( (cp->sf & (SOUND_CHANNEL_SF_START|SOUND_CHANNEL_SF_ENV))
		  && (cp->mk == mk) )
		{ cp->sf |= SOUND_CHANNEL_SF_STOP; break; }
	}

	return;
}



void ply_fine(MPlayAreaPrv *ma, MPlayTrkPrv *tp)
{
	int i;
	SoundChannelPrv *cp;

	for (cp=tp->chn; cp!=0; cp=(SoundChannelPrv *)(cp->np))
	{
		if ( cp->sf & SOUND_CHANNEL_SF_ON ) cp->sf |= SOUND_CHANNEL_SF_STOP;
		ClearChain(cp);
	}

	tp->flg = 0;
	return;
}



u8 ld_tp_adr_i(MPlayAreaPrv *ma, MPlayTrkPrv *tp)
{
	u8 d;
	d = *tp->adr;

	//security
	if ( tp->adr < (u8 *)0x02000000 )
	{ if ( (tp->adr < (u8 *)MPlyJmpTbl )||(tp->adr >= (u8 *)0x4000) ) d = 0; }

	tp->adr++;
	return(d);
}



void ply_goto(MPlayAreaPrv *ma, MPlayTrkPrv *tp)
{
	union { u8 *a; u8 d[4]; } u;

	u.d[0] = *(tp->adr+0);
	u.d[1] = *(tp->adr+1);
	u.d[2] = *(tp->adr+2);
	u.d[3] = *(tp->adr+3);

	//security
	if ( tp->adr < (u8 *)0x02000000 )
	{ if ( (tp->adr < (u8 *)MPlyJmpTbl )||(tp->adr >= (u8 *)0x4000) ) u.a = 0; }

	tp->adr = u.a;
	return;
}



void ply_patt(MPlayAreaPrv *ma, MPlayTrkPrv *tp)
{
	if ( tp->patP < MTRACK_PATSIZ )
	{
		tp->patS[tp->patP] = tp->adr + 4;
		tp->patP++;
		ply_goto(ma, tp);
	}
	else ply_fine(ma, tp);
	return;
}



void ply_pend(MPlayAreaPrv *ma, MPlayTrkPrv *tp)
{
	if ( tp->patP )
	{
		tp->patP--;
		tp->adr = tp->patS[tp->patP];
	}
	return;
}



void ply_rept(MPlayAreaPrv *ma, MPlayTrkPrv *tp)
{
	if ( *tp->adr == 0 ) { tp->adr++; ply_goto(ma, tp); }
	else
	{
		if ( ++tp->repN < ld_tp_adr_i(ma,tp) ) ply_goto(ma, tp);
		else { tp->repN = 0; tp->adr += 4; }
	}
	return;
}



void ply_prio(MPlayAreaPrv *ma, MPlayTrkPrv *tp)
{
	tp->prio = ld_tp_adr_i(ma,tp);
	return;
}



void ply_tempo(MPlayAreaPrv *ma, MPlayTrkPrv *tp)
{
	ma->TempoD = ld_tp_adr_i(ma,tp) << 1;
	ma->TempoI = (ma->TempoD * ma->TempoU) >> 8;
	return;
}



void ply_keysh(MPlayAreaPrv *ma, MPlayTrkPrv *tp)
{
	tp->ksh = ld_tp_adr_i(ma,tp);
	tp->flg |= MPT_FLG_PITCHG;
	return;
}



void ply_voice(MPlayAreaPrv *ma, MPlayTrkPrv *tp)
{
	int i = *(tp->adr++);
	*(u32 *)&(tp->typ) = *(u32 *)&(ma->tone[i].typ);
	//security
	*(u32 *)&(tp->wav) = *(u32 *)&(ma->tone[i].wav);
	//security
	*(u32 *)&(tp->att) = *(u32 *)&(ma->tone[i].att);
	//security
	return;
}



void ply_vol(MPlayAreaPrv *ma, MPlayTrkPrv *tp)
{
	tp->vol = ld_tp_adr_i(ma,tp);
	tp->flg |= MPT_FLG_VOLCHG;
	return;
}



void ply_pam(MPlayAreaPrv *ma, MPlayTrkPrv *tp)
{
	tp->pam = ld_tp_adr_i(ma,tp) - CENTER;
	tp->flg |= MPT_FLG_VOLCHG;
	return;
}



void ply_bend(MPlayAreaPrv *ma, MPlayTrkPrv *tp)
{
	tp->bnd = ld_tp_adr_i(ma,tp) - CENTER;
	tp->flg |= MPT_FLG_PITCHG;
	return;
}



void ply_bendr(MPlayAreaPrv *ma, MPlayTrkPrv *tp)
{
	tp->bndR = ld_tp_adr_i(ma,tp);
	tp->flg |= MPT_FLG_PITCHG;
	return;
}



void ply_lfos(MPlayAreaPrv *ma, MPlayTrkPrv *tp)
{
	if ( (tp->lfo = ld_tp_adr_i(ma,tp))==0 ) tp->modM = 0;
	return;
}



void ply_lfodl(MPlayAreaPrv *ma, MPlayTrkPrv *tp)
{
	tp->ldl = ld_tp_adr_i(ma,tp);
	return;
}



void ply_mod(MPlayAreaPrv *ma, MPlayTrkPrv *tp)
{
	if ( (tp->mod = ld_tp_adr_i(ma,tp))==0 ) tp->modM = 0;
	return;
}



void ply_modt(MPlayAreaPrv *ma, MPlayTrkPrv *tp)
{
	u8 d = ld_tp_adr_i(ma,tp);
	if ( tp->modT != d )
	{
		tp->modT = d;
		tp->flg |= MPT_FLG_VOLCHG | MPT_FLG_PITCHG;
	}
	return;
}



void ply_tune(MPlayAreaPrv *ma, MPlayTrkPrv *tp)
{
	tp->tun = ld_tp_adr_i(ma,tp) - CENTER;
	tp->flg |= MPT_FLG_PITCHG;
	return;
}



void ply_port(MPlayAreaPrv *ma, MPlayTrkPrv *tp)
{
	u8 *p;
	p = (u8 *)REG_BASE + *(tp->adr++) + 0x60;
	*(vu8 *)p = ld_tp_adr_i(ma,tp);
	return;
}

#endif // WITH_ASM



#endif // USE_SYSCALL
