/********************************************************************/
/*				`faj^vO }N֐				    */
/********************************************************************/
#ifndef	_AGB_MON_MACRO_H
#define	_AGB_MON_MACRO_H

#include <AgbTypes.h>


/*------------------------------------------------------------------*/
/*     					j^̂q`ls						    */
/*------------------------------------------------------------------*/
#define BOOT_RAM		0x00800000				// u[gq`l
#define BOOT_RAM_END	(BOOT_ROM + 0x4000)
#define REG_ROMMAP		(REG_BASE + 0x400)

#define MonRom2Ram()											\
{																\
	CpuFastCopy32((u32 *)0, (u32 *)BOOT_RAM, BOOT_ROM_SIZE*2);	\
	*(u8 *)REG_ROMMAP = 0x01;									\
}

/*------------------------------------------------------------------*/
/*						bot NA							    */
/*------------------------------------------------------------------*/

#define CpuClear16_32(Data, Destp, Size, Bit)			\
{														\
	u##Bit Tmp = (vu##Bit )(Data);						\
	CpuSet16_32((u8 *)&(Tmp), (u8 *)(Destp), (			\
		DMA_SRC_FIX        |							\
		DMA_##Bit##BIT_BUS | (Size)/((Bit)/8)));		\
}

#define CpuArrayClear16_32(  Data, Destp, Bit)			\
		CpuClear16_32(       Data, Destp, sizeof(Destp), Bit)


/*------------------------------------------------------------------*/
/*						bot Rs[							    */
/*------------------------------------------------------------------*/

#define CpuCopy16_32(Srcp, Destp, Size, Bit)			\
														\
	CpuSet16_32((u8 *)(Srcp), (u8 *)(Destp),  (			\
		DMA_SRC_INC	       |							\
		DMA_##Bit##BIT_BUS | (Size)/((Bit)/8)))

#define CpuArrayCopy16_32(  Srcp, Destp, Bit)			\
		CpuCopy16_32(       Srcp, Destp, sizeof(Srcp), Bit)


/*------------------------------------------------------------------*/
/*					bot NA(32ByteP)				    */
/*------------------------------------------------------------------*/

#define CpuFastClear32(Data, Destp, Size)				\
{														\
	u32 Tmp = (vu32 )(Data);							\
	CpuFastSet32((u8 *)&(Tmp), (u8 *)(Destp), (			\
		DMA_SRC_FIX        | (Size)/(32/8)));			\
}

#define CpuArrayFastClear32(  Data, Destp)				\
		CpuFastClear32(       Data, Destp, sizeof(Destp))


/*------------------------------------------------------------------*/
/*					bot Rs[(32ByteP)				    */
/*------------------------------------------------------------------*/

#define CpuFastCopy32(Srcp, Destp, Size)				\
														\
	CpuFastSet32((u8 *)(Srcp), (u8 *)(Destp),  (		\
		DMA_SRC_INC	       | (Size)/(32/8)))

#define CpuArrayFastCopy32(  Srcp, Destp)				\
		CpuFastCopy32(       Srcp, Destp, sizeof(Srcp))


/*------------------------------------------------------------------*/
/*							Op֐							    */
/*------------------------------------------------------------------*/
#if 1
#define SinTbl(No)		Sin256Tbl[(u8 )(No)]
#define CosTbl(No)		Sin256Tbl[(u8 )(No+64)]
#else
#define SinTbl(No)		(((No) < 128 ) ? Sin256Tbl[(u8 )(No)] : -Sin256Tbl[(u8 )(255-No)])
#define CosTbl(No)		SinTbl(((No)+64) & 0xff)
#endif


#endif	/* _AGB_MON_MACRO_H */
