/********************************************************************/
/*				`faj^vO Tu[`				    */
/********************************************************************/
#ifndef	_AGB_MON_SUB_H
#define	_AGB_MON_SUB_H

#include <Agb.h>
#include "AgbMonMacro.h"


/*----------------------- ėpTu[`  ------------------------*/

s32  RomHeaderCheck( void *Datap);
void NintendoLogoSet(void *Datap);
void LogoCopyCommon(void *Srcp, void *Destp, u32 HalfWordCount);
u8   GetSumData(u8 StartNo, u8 *Srcp, s32 Count);

void JoyMain_Init(void);
s32  JoyMain_Frame(void);
void JoyIntCommon(void);

void key_unlock__nin_logo_copy(void);

void DemoSoundStop(void);

void RamInit(void);

void Agb2Cgb(void);
void BgScIncSet16(u16 StartData, u16 AddData, u32  SrcHSize, u32  SrcVSize,
				  u16 *Destp,		 		  u32 DestHSize );
void PhysicalMove(s16 ObjNo, PosData *PosDatap, s32 Counter);
void AffineInit(void);
void AffinePerspective(PosData *PosDatap, BgAffineSrcData *AffineDatap);
void PlttLinerSet(s32 DataIndex, s32 LinerParam, s32 PlttStart);

#ifndef USE_SYSCALL

void RegisterRamReset32(u32 ResetFlags);
void Intr_Wait(u8 InitIfClear, u16 IfFlags);
void VBlankIntr_Wait(void);

s32  DivS32(s32 Number, s32 Denom);
s32  __16__rt_sdiv(s32 Denom, s32 Number);
u16  SqrtU32(u32 Number);
s16  ArcTanS32(s16 Tan);
u16  ArcTanS32_2(s16 X, s16 Y);

void CpuSet16_32( u8 *Srcp, u8 *Destp, u32 DmaCntData);
void CpuFastSet32(u8 *Srcp, u8 *Destp, u32 DmaCntData);

void BgAffineSet32(BgAffineSrcData *AffineSrcp, BgAffineDestData *AffineDestp, s32 Num);
void ObjAffineSet32(ObjAffineSrcData *AffineSrcp, s8 *AffineDestp, s32 Num, s32 Offset);
void OamSortSet16(u16 *Srcp, u16 *Destp, OamSortSetParam *Paramp);

void BitUnPack32( u8  *Srcp, u32 *Destp, BitUnPackParam *BitUnPackParamp);

void RLUnComp8( u8  *Srcp, u8  *Destp);
void RLUnComp16(u8  *Srcp, u16 *Destp);
void LZ77UnComp8( u8  *Srcp, u8  *Destp);
void LZ77UnComp16(u8  *Srcp, u16 *Destp);
void HuffUnComp32(u32 *Srcp, u32 *Destp);
void DiffUnFilter8_8(  u8  *Srcp, u8  *Destp);
void DiffUnFilter8_16( u8  *Srcp, u16 *Destp);
void DiffUnFilter16_16(u16 *Srcp, u16 *Destp);

void SoundBiasChange16(u32 UpDown);

#else

#define RegisterRamReset32(P1)		RegisterRamReset(P1)
#define Intr_Wait(P1, P2)			IntrWait(P1, P2)
#define VBlankIntr_Wait()			VBlankIntrWait()
#define DivS32(P1, P2)				Div(P1, P2)
#define __16__rt_sdiv(P1, P2)		DivArm(P1, P2)
#define SqrtU32(P1)					Sqrt(P1)
#define ArcTanS32(P1)				ArcTan(P1)
#define ArcTanS32_2(P1, P2)			ArcTan2(P1, P2)
#define CpuSet16_32(P1,P2,P3)		CpuSet(P1,P2,P3)
#define CpuFastSet32(P1,P2,P3)		CpuFastSet(P1,P2,P3)

#define BgAffineSet32(P1,P2,P3)		BgAffineSet(P1,P2,P3)
#define ObjAffineSet32(P1,P2,P3,P4)	ObjAffineSet(P1,P2,P3,P4)
#define OamSortSet16(P1,P2,P3)		OamSortSet(P1,P2,P3)
#define BitUnPack32(P1,P2,P3)		BitUnPack(P1,P2,P3)

#define RLUnComp8(P1,P2)			RLUnCompWram(P1,P2)
#define RLUnComp16(P1,P2)			RLUnCompVram(P1,P2)
#define LZ77UnComp8(P1,P2)			LZ77UnCompWram(P1,P2)
#define LZ77UnComp16(P1,P2)			LZ77UnCompVram(P1,P2)
#define HuffUnComp32(P1,P2)			HuffUnComp(P1,P2)
#define DiffUnFilter8_8(P1,P2)		Diff8bitUnFilterWram(P1,P2)
#define DiffUnFilter8_16(P1,P2)		Diff8bitUnFilterVram(P1,P2)
#define DiffUnFilter16_16(P1,P2)	Diff16bitUnFilter(P1,P2)

#define SoundBiasChange16(P1)		SoundBiasChange(P1)

#endif /* USE_SYSCALL */

/*-------------------------- f[^  -------------------------------*/

extern u8				DacsCheck;			// DACS `FbN

extern u16				Cont, Trg;			// ,  ضޓ

extern u16				BG_X, BG_Y;
extern u8				CharX, CharY;

extern u8				NinLogoBak[256];

extern OamData			OamBak[128];

extern s32				LogoCounter[7];
extern PosData			LogoPosition[7];
extern BgAffineSrcData	LogoAffineSrc[7];
extern BgAffineDestData	LogoAffineDest[7];
extern BgAffineSrcData	H_AffineSrc[160];
extern BgAffineDestData	H_AffineDest[160][2];


extern s16		Sin256Tbl[256];


#endif	/* _AGB_MON_SUB_H */
