#include "AgbMon.h"
#include "AgbSoundPrv.h"

#define NO_DEMOSOUND
#ifndef NO_DEMOSOUND

#define DEMO_DA_BIT     SOUND_MODE_DA_BIT_8
#define DEMO_FREQUENCY  SOUND_MODE_FREQ_13379
#define DEMO_CHANNEL_N  10
#define DEMO_REVERB_V   0
#define DEMO_TRACK_N    6

#if DEMO_REVERB_V
	#define DEMO_REVERB_SV  (SOUND_MODE_REVERB_SET+DEMO_REVERB_V)
#else
	#define DEMO_REVERB_SV  0
#endif

extern SongHeader sd_logo;
extern SongHeader sd_piron;
extern SongHeader sd_ok;
extern SongHeader sd_cut;
extern SongHeader sd_cancel;

SoundArea demosound;
MusicPlayerArea demomusic;
MusicPlayerTrack demotrack[DEMO_TRACK_N];

#endif // NO_DEMOSOUND


#ifndef USE_SYSCALL

extern void (*MPlyJmpTbl[])();

const u8 ScaleTable[180] = {
//  0 (C-2)
	(14<<4)+ 0, (14<<4)+ 1, (14<<4)+ 2, (14<<4)+ 3,
	(14<<4)+ 4, (14<<4)+ 5, (14<<4)+ 6, (14<<4)+ 7,
	(14<<4)+ 8, (14<<4)+ 9, (14<<4)+10, (14<<4)+11,
// 12 (C-1)
	(13<<4)+ 0, (13<<4)+ 1, (13<<4)+ 2, (13<<4)+ 3,
	(13<<4)+ 4, (13<<4)+ 5, (13<<4)+ 6, (13<<4)+ 7,
	(13<<4)+ 8, (13<<4)+ 9, (13<<4)+10, (13<<4)+11,
// 24 (C0)
	(12<<4)+ 0, (12<<4)+ 1, (12<<4)+ 2, (12<<4)+ 3,
	(12<<4)+ 4, (12<<4)+ 5, (12<<4)+ 6, (12<<4)+ 7,
	(12<<4)+ 8, (12<<4)+ 9, (12<<4)+10, (12<<4)+11,
// 36 (C1)
	(11<<4)+ 0, (11<<4)+ 1, (11<<4)+ 2, (11<<4)+ 3,
	(11<<4)+ 4, (11<<4)+ 5, (11<<4)+ 6, (11<<4)+ 7,
	(11<<4)+ 8, (11<<4)+ 9, (11<<4)+10, (11<<4)+11,
// 48 (C2)
	(10<<4)+ 0, (10<<4)+ 1, (10<<4)+ 2, (10<<4)+ 3,
	(10<<4)+ 4, (10<<4)+ 5, (10<<4)+ 6, (10<<4)+ 7,
	(10<<4)+ 8, (10<<4)+ 9, (10<<4)+10, (10<<4)+11,
// 60 (C3)
	( 9<<4)+ 0, ( 9<<4)+ 1, ( 9<<4)+ 2, ( 9<<4)+ 3,
	( 9<<4)+ 4, ( 9<<4)+ 5, ( 9<<4)+ 6, ( 9<<4)+ 7,
	( 9<<4)+ 8, ( 9<<4)+ 9, ( 9<<4)+10, ( 9<<4)+11,
// 72 (C4)
	( 8<<4)+ 0, ( 8<<4)+ 1, ( 8<<4)+ 2, ( 8<<4)+ 3,
	( 8<<4)+ 4, ( 8<<4)+ 5, ( 8<<4)+ 6, ( 8<<4)+ 7,
	( 8<<4)+ 8, ( 8<<4)+ 9, ( 8<<4)+10, ( 8<<4)+11,
// 84 (C5)
	( 7<<4)+ 0, ( 7<<4)+ 1, ( 7<<4)+ 2, ( 7<<4)+ 3,
	( 7<<4)+ 4, ( 7<<4)+ 5, ( 7<<4)+ 6, ( 7<<4)+ 7,
	( 7<<4)+ 8, ( 7<<4)+ 9, ( 7<<4)+10, ( 7<<4)+11,
// 96 (C6)
	( 6<<4)+ 0, ( 6<<4)+ 1, ( 6<<4)+ 2, ( 6<<4)+ 3,
	( 6<<4)+ 4, ( 6<<4)+ 5, ( 6<<4)+ 6, ( 6<<4)+ 7,
	( 6<<4)+ 8, ( 6<<4)+ 9, ( 6<<4)+10, ( 6<<4)+11,
//108 (C7)
	( 5<<4)+ 0, ( 5<<4)+ 1, ( 5<<4)+ 2, ( 5<<4)+ 3,
	( 5<<4)+ 4, ( 5<<4)+ 5, ( 5<<4)+ 6, ( 5<<4)+ 7,
	( 5<<4)+ 8, ( 5<<4)+ 9, ( 5<<4)+10, ( 5<<4)+11,
//120 (C8)
	( 4<<4)+ 0, ( 4<<4)+ 1, ( 4<<4)+ 2, ( 4<<4)+ 3,
	( 4<<4)+ 4, ( 4<<4)+ 5, ( 4<<4)+ 6, ( 4<<4)+ 7,
	( 4<<4)+ 8, ( 4<<4)+ 9, ( 4<<4)+10, ( 4<<4)+11,
//132 (C9)
	( 3<<4)+ 0, ( 3<<4)+ 1, ( 3<<4)+ 2, ( 3<<4)+ 3,
	( 3<<4)+ 4, ( 3<<4)+ 5, ( 3<<4)+ 6, ( 3<<4)+ 7,
	( 3<<4)+ 8, ( 3<<4)+ 9, ( 3<<4)+10, ( 3<<4)+11,
//144 (C10)
	( 2<<4)+ 0, ( 2<<4)+ 1, ( 2<<4)+ 2, ( 2<<4)+ 3,
	( 2<<4)+ 4, ( 2<<4)+ 5, ( 2<<4)+ 6, ( 2<<4)+ 7,
	( 2<<4)+ 8, ( 2<<4)+ 9, ( 2<<4)+10, ( 2<<4)+11,
//156 (C11)
	( 1<<4)+ 0, ( 1<<4)+ 1, ( 1<<4)+ 2, ( 1<<4)+ 3,
	( 1<<4)+ 4, ( 1<<4)+ 5, ( 1<<4)+ 6, ( 1<<4)+ 7,
	( 1<<4)+ 8, ( 1<<4)+ 9, ( 1<<4)+10, ( 1<<4)+11,
//168 (C12)
	( 0<<4)+ 0, ( 0<<4)+ 1, ( 0<<4)+ 2, ( 0<<4)+ 3,
	( 0<<4)+ 4, ( 0<<4)+ 5, ( 0<<4)+ 6, ( 0<<4)+ 7,
	( 0<<4)+ 8, ( 0<<4)+ 9, ( 0<<4)+10, ( 0<<4)+11,
//180 (C13)
};

const u32 FreqTable[12] = {
//  0 (C-2)  8.2Hz
//	0x00020000, 0x00021E72, 0x00023EB3, 0x000260E0,
//	0x00028514, 0x0002AB70, 0x0002D414, 0x0002FF22,
//	0x00032CC0, 0x00035D14, 0x00039048, 0x0003C687,
// 12 (C-1) 16.4Hz
//	0x00040000, 0x00043CE4, 0x00047D67, 0x0004C1C0,
//	0x00050A29, 0x000556E0, 0x0005A828, 0x0005FE44,
//	0x00065980, 0x0006BA28, 0x00072090, 0x00078D0E,
// 24 (C0)  32.7Hz
//	0x00080000, 0x000879C8, 0x0008FACD, 0x0009837F,
//	0x000A1451, 0x000AADC1, 0x000B504F, 0x000BFC88,
//	0x000CB2FF, 0x000D7450, 0x000E411F, 0x000F1A1C,
// 36 (C1)  65.4Hz
//	0x00100000, 0x0010F390, 0x0011F59B, 0x001306FE,
//	0x001428A3, 0x00155B81, 0x0016A09E, 0x0017F911,
//	0x001965FF, 0x001AE8A0, 0x001C823E, 0x001E3438,
// 48 (C2) 130.8Hz
//	0x00200000, 0x0021E71F, 0x0023EB36, 0x00260DFC,
//	0x00285146, 0x002AB702, 0x002D413D, 0x002FF222,
//	0x0032CBFD, 0x0035D13F, 0x0039047C, 0x003C6870,
// 60 (C3) 261.6Hz
//	0x00400000, 0x0043CE3E, 0x0047D66B, 0x004C1BF8,
//	0x0050A28C, 0x00556E04, 0x005A827A, 0x005FE443,
//	0x006597FB, 0x006BA27E, 0x007208F8, 0x0078D0E0, // 69(A3)=440Hz
// 72 (C4) 523.3Hz
//	0x00800000, 0x00879C7D, 0x008FACD6, 0x009837F0,
//	0x00A14518, 0x00AADC08, 0x00B504F3, 0x00BFC887,
//	0x00CB2FF5, 0x00D744FD, 0x00E411F0, 0x00F1A1BF,
// 84 (C5)1046.5Hz
//	0x01000000, 0x010F38F9, 0x011F59AC, 0x01306FE1,
//	0x01428A30, 0x0155B811, 0x016A09E6, 0x017F910D,
//	0x01965FEA, 0x01AE89FA, 0x01C823E0, 0x01E3437E,
// 96 (C6)  2093Hz
//	0x02000000, 0x021E71F2, 0x023EB358, 0x0260DFC1,
//	0x0285145F, 0x02AB7021, 0x02D413CD, 0x02FF221B,
//	0x032CBFD5, 0x035D13F3, 0x039047C1, 0x03C686FD,
//108 (C7)  4186Hz
//	0x04000000, 0x043CE3E5, 0x047D66B1, 0x04C1BF83,
//	0x050A28BE, 0x0556E042, 0x05A8279A, 0x05FE4436,
//	0x06597FA9, 0x06BA27E6, 0x07208F82, 0x078D0DFA,
//120 (C8)  8372Hz
//	0x08000000, 0x0879C7C9, 0x08FACD62, 0x09837F05,
//	0x0A14517D, 0x0AADC084, 0x0B504F33, 0x0BFC886C,
//	0x0CB2FF53, 0x0D744FCD, 0x0E411F04, 0x0F1A1BF4,
//132 (C9) 16744Hz
//	0x10000000, 0x10F38F93, 0x11F59AC4, 0x1306FE0A,
//	0x1428A2FA, 0x155B8109, 0x16A09E66, 0x17F910D7,
//	0x1965FEA5, 0x1AE89F99, 0x1C823E07, 0x1E3437E7,
//144 (C10)33488Hz
//	0x20000000, 0x21E71F26, 0x23EB3588, 0x260DFC14,
//	0x285145F3, 0x2AB70212, 0x2D413CCD, 0x2FF221AF,
//	0x32CBFD4A, 0x35D13F33, 0x39047C0F, 0x3C686FCE,
//156 (C11)66976Hz
//	0x40000000, 0x43CE3E4B, 0x47D66B0F, 0x4C1BF829,
//	0x50A28BE6, 0x556E0424, 0x5A82799A, 0x5FE4435E,
//	0x6597FA95, 0x6BA27E65, 0x7208F81D, 0x78D0DF9C,
//168 (C12)133952Hz
	0x80000000, 0x879C7C97, 0x8FACD61E, 0x9837F052,
	0xA14517CC, 0xAADC0848, 0xB504F334, 0xBFC886BB,
	0xCB2FF52A, 0xD744FCCB, 0xE411F03A, 0xF1A1BF39,
};

const u16 pcmVBtbl[12] = {
	 96,	//  5734Hz
	132,	//  7884Hz
	176,	// 10512Hz
	224,	// 13379Hz
	264,	// 15768Hz
	304,	// 18157Hz
	352,	// 21024Hz
	448,	// 26758Hz
	528,	// 31536Hz
	608,	// 36314Hz
	672,	// 40137Hz
	704,	// 42048Hz
};

#endif // USE_SYSCALL



//t@NVEvg^Cv
extern u32 umul3232H32(u32 x, u32 y);
extern void ply_note(u8 d, MPlayAreaPrv *ma, MPlayTrkPrv *tp);

void SampFreqSet(u32 i);
void DummyFunc(void);



//t@NV

#ifndef NO_DEMOSOUND

void DemoSoundInit(void)
{
	SoundInit(&demosound);
	SoundMode(DEMO_DA_BIT + DEMO_FREQUENCY +
	 (DEMO_CHANNEL_N<<SOUND_MODE_MAXCHN_SHIFT) + DEMO_REVERB_SV);
	MPlayOpen(&demomusic, demotrack, DEMO_TRACK_N);
	return;
}



void DemoSongStart1(void)
{
	MPlayStart(&demomusic, &sd_logo);
	return;
}



void DemoSongStart2(void)
{
	MPlayStart(&demomusic, &sd_piron);
	return;
}

#endif // NO_DEMOSOUND


#ifndef USE_SYSCALL

void SoundInit(SoundArea *sa)
{
//|[g
	*(vu16 *)REG_DMA1CNT_H = 0x0000;
	*(vu16 *)REG_DMA2CNT_H = 0x0000;
	*(vu16 *)REG_SOUNDCNT_X = 0x008f;
	*(vu16 *)REG_SOUNDCNT_H = 0xa90e;
	*((vu8 *)REG_SOUNDBIAS+1) = (*((vu8 *)REG_SOUNDBIAS+1) & 0x3f) | 0x40; //8bit

	*(vu32 *)REG_DMA1SAD = (u32)(sa->pcmbuf);
	*(vu32 *)REG_DMA1DAD = REG_FIFO_A;
	*(vu32 *)REG_DMA2SAD = (u32)(sa->pcmbuf+PCM_DMA_BUF);
	*(vu32 *)REG_DMA2DAD = REG_FIFO_B;

//SϐNA
	*(SoundArea **)SOUND_AREA_ADR = sa;
	CpuClear16_32(0, sa, sizeof(SoundAreaPrv), 32);

//ϐ
	((SoundAreaPrv *)sa)->maxchn = 8;
	((SoundAreaPrv *)sa)->masvol = 15;
	((SoundAreaPrv *)sa)->plynote = ply_note;
	((SoundAreaPrv *)sa)->CgbSound  = DummyFunc;
	((SoundAreaPrv *)sa)->CgbOscOff = (void (*)(u8))DummyFunc;
	((SoundAreaPrv *)sa)->MK2CgbFr  = (u32 (*)(u8,u8,u8))DummyFunc;
	((SoundAreaPrv *)sa)->ExtVolPit = (void (*)(MPlayAreaPrv*, MPlayTrkPrv*))DummyFunc;
	((SoundAreaPrv *)sa)->MPlyJmpTbl = (void (**)())MPlyJmpTbl;

//^C}[X^[g
	SampFreqSet(SOUND_MODE_FREQ_13379);

	((SoundAreaPrv *)sa)->ident = ID_NUMBER;
	return;
}



void DummyFunc(void)
{
	return;
}



void SampFreqSet(u32 i)
{
	SoundAreaPrv *sa;

	sa = *(SoundAreaPrv **)SOUND_AREA_ADR;
	i = (i & SOUND_MODE_FREQ_VALUE) >> SOUND_MODE_FREQ_SHIFT;

	sa->freq  = (u8)i;
	sa->pcmVB = pcmVBtbl[i-1];
	sa->pcmDT = (u8)((s32)PCM_DMA_BUF / (s32)sa->pcmVB);
	sa->pcmFQ = ((s32)(sa->pcmVB * 597275) + 5000) / (s32)10000;
	sa->divFQ = (((s32)0x01000000 / (s32)sa->pcmFQ) + 1) >> 1;

//^C}[X^[g
	*(vu16 *)REG_TM0CNT_H = 0x0000;
	*(vu16 *)REG_TM0CNT_L = 0x10000 - ((s32)280896 / (s32)sa->pcmVB);
	SoundVSyncOn();

	while ( *(vu8 *)REG_VCOUNT == 159 ) {};
	while ( *(vu8 *)REG_VCOUNT != 159 ) {};

	*(vu16 *)REG_TM0CNT_H = 0x0080;
	return;
}



void SoundMode(u32 mode)
{
	u32 i;
	SoundChannelPrv *vc;
	SoundAreaPrv *sa;

	sa = *(SoundAreaPrv **)SOUND_AREA_ADR;
	if ( sa->ident != ID_NUMBER ) return;
	sa->ident++;

	if ( i=(mode & (SOUND_MODE_REVERB_VAL | SOUND_MODE_REVERB_SET)) )
	{
		sa->reverb = i & SOUND_MODE_REVERB_VAL;
	}

	if ( i=(mode & SOUND_MODE_MAXCHN) )
	{
		sa->maxchn = (u8)(i >> SOUND_MODE_MAXCHN_SHIFT);
		for (i=MAX_DIRECTSOUND_CHANNEL,vc=sa->vchn; i>0; i--,vc++) vc->sf = 0;
	}

	if ( i=(mode & SOUND_MODE_MASVOL) )
	{
		sa->masvol = (u8)(i >> SOUND_MODE_MASVOL_SHIFT);
	}

	if ( i=(mode & (SOUND_MODE_DA_BIT_VAL | SOUND_MODE_DA_BIT_SET)) )
	{
		i = (i & SOUND_MODE_DA_BIT_VAL) >> (SOUND_MODE_DA_BIT_SHIFT - 6);
		*((vu8 *)REG_SOUNDBIAS+1) = (*((vu8 *)REG_SOUNDBIAS+1) & 0x3f) | i;
	}

//	if ( i=(mode & (SOUND_MODE_STEREO | SOUND_MODE_MONORAL)) )
//	{
//		*(vu32 *)REG_DMA2CNT = 0x00000000;
//
//		if ( i & (SOUND_MODE_STEREO ^ SOUND_MODE_MONORAL) )
//		{
//			sa->mode |= SOUND_AREA_MODE_MONO;
//			*(vu16 *)REG_SOUNDCNT_H = 0x0b0e;
//		}
//		else
//		{
//			sa->mode &= ~SOUND_AREA_MODE_MONO;
//			*(vu16 *)REG_SOUNDCNT_H = 0xa90e;
//			*(vu32 *)REG_DMA2SAD = (u32)(sa->pcmbuf+PCM_DMA_BUF);
//			*(vu32 *)REG_DMA2DAD = REG_FIFO_B;
//		}
//	}

//	if ( i=(mode & (SOUND_MODE_CGB_ON | SOUND_MODE_CGB_OFF)) )
//	{
//		if ( i & (SOUND_MODE_CGB_ON ^ SOUND_MODE_CGB_OFF) )
//		{
//			sa->mode |= SOUND_AREA_MODE_CGB_ON;
//		}
//		else
//		{
//			sa->mode &= ~SOUND_AREA_MODE_CGB_ON;
//		}
//	}

	if ( i=(mode & SOUND_MODE_FREQ_VALUE) )
	{
		SoundVSyncOff();
		SampFreqSet(i);
	}

	sa->ident = ID_NUMBER;
	return;
}



void SoundClearAll(void)
{
	int i;
	SoundChannelPrv *vc;
	SoundAreaPrv *sa;

	sa = *(SoundAreaPrv **)SOUND_AREA_ADR;
	if ( sa->ident != ID_NUMBER ) return;
	sa->ident++;

	for (i=MAX_DIRECTSOUND_CHANNEL,vc=sa->vchn; i>0; i--,vc++) vc->sf = 0;

	if ( (vc=(SoundChannelPrv *)sa->vcgb) )
	{ for (i=1; i<=4; i++,vc++) sa->CgbOscOff(i); vc->sf = 0; }

	sa->ident = ID_NUMBER;
	return;
}



void SoundVSyncOff(void)
{
	SoundAreaPrv *sa;

	sa = *(SoundAreaPrv **)SOUND_AREA_ADR;
	if ((sa->ident < ID_NUMBER)||(sa->ident > ID_NUMBER+1)) return;
	sa->ident++;

	*(vu16 *)REG_DMA1CNT_H = 0x0000;
	*(vu16 *)REG_DMA2CNT_H = 0x0000;
	sa->DmaCount = 0;
	CpuClear16_32(0, sa->pcmbuf, sizeof(sa->pcmbuf), 32);

	sa->ident--;
	return;
}



void SoundVSyncOn(void)
{
	*(vu16 *)REG_DMA1CNT_H = 0xb600;
	*(vu16 *)REG_DMA2CNT_H = 0xb600;
	return;
}



u32 MidiKey2fr(WaveData *wa, u8 mk, u8 fp)
{
	u32 fw, f0, f1;

	fw = (u32)fp << 24;
	if ( mk > 178 ) { mk = 178; fw = 0xff000000; }

	f0 = ScaleTable[mk];
	f0 = FreqTable[f0 & 0x0f] >> (f0 >> 4);

	f1 = ScaleTable[mk+1];
	f1 = FreqTable[f1 & 0x0f] >> (f1 >> 4);

	return( umul3232H32(wa->freq, f0+umul3232H32(f1-f0, fw)) );
}



#ifndef WITH_ASM

void SoundMain(void)
{
	int i, ic, RL;
	s8 *Rpi, *Lpi, *Rp, *Lp, *Rp2, *Lp2, *cp;
	u32 ct;
	SoundChannelPrv *vc;
	SoundAreaPrv *sa;

	sa = *(SoundAreaPrv **)SOUND_AREA_ADR;
	if ( sa->ident != ID_NUMBER ) return;
	sa->ident++;

	if ( sa->func ) sa->func(sa->intp);
	sa->CgbSound();

	if ( sa->DmaCount <= 1 ) Rpi = sa->pcmbuf;
	else Rpi = sa->pcmbuf + sa->pcmVB * (sa->pcmDT + 1 - sa->DmaCount);

	Lpi = Rpi + PCM_DMA_BUF;

	if ( sa->reverb )
	{
		Rp = Rpi; Lp = Lpi;

		if ( sa->DmaCount == 2 ) Rp2 = sa->pcmbuf;
		else Rp2 = Rpi + sa->pcmVB;

		Lp2 = Rp2 + PCM_DMA_BUF;

		for (i=sa->pcmVB; i>0; i--)
		{
			RL = ((*Rp + *Lp + *Rp2 + *Lp2)*sa->reverb)>>9;
			if ( (s8)RL < 0 ) RL++;
			*Rp = *Lp = RL;
			Rp++; Lp++;
			Rp2++; Lp2++;
		}
	}
	else
	{
		for (i=sa->pcmVB/4,Rp=Rpi,Lp=Lpi; i>0; i--)
		{
			*(u32 *)Rp = *(u32 *)Lp = 0;
			Rp += 4; Lp += 4;
		}
	}

	for (ic=sa->maxchn,vc=sa->vchn; ic>0; ic--,vc++)
	{
		if ( vc->sf & SOUND_CHANNEL_SF_ON )
		{
			if ( vc->sf & SOUND_CHANNEL_SF_START )
			{
				if ( vc->sf & SOUND_CHANNEL_SF_STOP ) goto chn_stop;
				vc->sf = SOUND_CHANNEL_SF_ENV_AT;
				vc->cp = (vc->wp)->data;
				vc->ct = (vc->wp)->size;
				vc->ev = 0;
				vc->fw = 0;
				RL = 0;
				if ( (vc->wp)->stat & WAVE_STAT_LOOP ) vc->sf |= SOUND_CHANNEL_SF_LOOP;
				goto attack;
			}

			RL = vc->ev;

			if ( vc->sf & SOUND_CHANNEL_SF_IEC )
			{
				if ( (s8)(--vc->iel) <= 0 ) goto chn_stop;
			}
			else if ( vc->sf & SOUND_CHANNEL_SF_STOP )
			{
				if ( (RL = (RL*vc->re)>>8) <= vc->iev )
				{release9:;
					if ( (RL = vc->iev) == 0 ) goto chn_stop;
					vc->sf |= SOUND_CHANNEL_SF_IEC;
				}
			}
			else
			{
				if ( (i = vc->sf & SOUND_CHANNEL_SF_ENV) == SOUND_CHANNEL_SF_ENV_DE )
				{decay:;
					if ( (RL = (RL*vc->de)>>8) <= vc->su )
					{
						if ( (RL = vc->su) == 0 ) goto release9;
						vc->sf -= SOUND_CHANNEL_SF_ENV_SB;
					}
				}
				else if ( i == SOUND_CHANNEL_SF_ENV_AT )
				{attack:;
					if ( (RL += vc->at) >= 0xff )
					{
						RL = 0xff;
						vc->sf -= SOUND_CHANNEL_SF_ENV_SB;
					}
				}
			}

			vc->ev = (u8)RL;
			RL = (RL * (sa->masvol+1))>>4;
			vc->er = (u8)((RL * vc->rv)>>8);
			vc->el = (u8)((RL * vc->lv)>>8);

			if ( ct=(vc->sf & SOUND_CHANNEL_SF_LOOP) )
			{
				cp = (vc->wp)->data + (vc->wp)->loop;
				ct = (vc->wp)->size - (vc->wp)->loop;
			}

			if ( vc->ty & SOUND_CHANNEL_TY_FIX )
			{
				for (i=sa->pcmVB,Rp=Rpi,Lp=Lpi; i>0; i--)
				{
					RL = *(vc->cp++);
					*Rp += (s8)((RL * vc->er)>>8);
					*Lp += (s8)((RL * vc->el)>>8);
					Rp++; Lp++;
					if ( --vc->ct == 0 )
					{
						if ( ct ) {vc->cp = cp; vc->ct = ct; }
						else goto chn_stop;
					}
				}
			}
			else for (i=sa->pcmVB,Rp=Rpi,Lp=Lpi; ; )
			{
				while ( vc->fw >= sa->pcmFQ )
				{
					if ( --vc->ct == 0 )
					{
						if ( ct ) {vc->cp = cp; vc->ct = ct; }
						else {chn_stop:; vc->sf = 0; goto nextchn; }
					}
					else vc->cp++;
					vc->fw -= sa->pcmFQ;
				}

				do {
					RL = *(vc->cp) +
					 ((*(vc->cp+1)-*(vc->cp))*(int)(vc->fw*sa->divFQ)>>23);
					*Rp += (s8)((RL * vc->er)>>8);
					*Lp += (s8)((RL * vc->el)>>8);
					vc->fw += vc->fr;
					if ( --i == 0 ) goto nextchn;
					Rp++; Lp++;
				} while ( vc->fw < sa->pcmFQ );
			}
		nextchn:;
		}
	}

	sa->ident = ID_NUMBER;
	return;
}



void SoundVSync(void)
{
	SoundAreaPrv *sa;

	sa = *(SoundAreaPrv **)SOUND_AREA_ADR;
	if ( sa->ident != ID_NUMBER ) return;

	if ( (s8)(--sa->DmaCount) <= 0 )
	{
		sa->DmaCount = sa->pcmDT;
		*(vu16 *)REG_DMA1CNT_H = 0x0000;
		*(vu16 *)REG_DMA2CNT_H = 0x0000;
		*(vu16 *)REG_DMA1CNT_H = 0xb600;
		*(vu16 *)REG_DMA2CNT_H = 0xb600;
	}

	return;
}

#endif // WITH_ASM
#endif // USE_SYSCALL



