;********************************************************************
;*			`faj^vO X^[gAbv[`		    *
;********************************************************************

		AREA	Init, CODE, READONLY
		INCLUDE	AgbDefineArm.s
		INCLUDE	AgbMemoryMapArm.s

		INCLUDE	AgbMonDefineArm.s

		ENTRY
;====================================================================
;=						荞ݗ̈							    =
;====================================================================
		CODE32
start_v			b		start_m
undef_v			b		fiq_v
swi_v			b		swi_m
code_abort_v	b		fiq_v
data_abort_v	b		fiq_v
reserve_v		b		fiq_v
irq_v			b		irq_m

		ALIGN
;====================================================================
;=						Tu[`Q							    =
;====================================================================

;--------------------------------------------------------------------
;-				hbdvOփWv					 25-28c -
;--------------------------------------------------------------------
		CODE32
fiq_v			ldr		sp, fiq_sp				; SP ̾
				stmfd	sp!, {r12, lr}			; ڼ޽ ̑ޔ
				mrs		r12,spsr
				mrs		lr, cpsr
				stmfd	sp!, {r12, lr}
				mov		r12,  #ROM_BANK0		; ޯދ׸ 
				ldrb	lr, [r12, #MON_FIQ_FLAG - ROM_BANK0]
				cmp		lr,  #0xa5
				bne		fiq_return
				ldreqb	lr, [r12, #0xb4]
				andeqs	lr,  lr, #0x80
				adr		lr,  fiq_return
				ldrne	pc, =ICE_ROM0			; ޯޏּެ	0x80
				ldreq	pc, =ICE_ROM1			;						0x00
;--------------------------------------------------------------------
;-				hbd̕A								17c -
;--------------------------------------------------------------------
		CODE32
fiq_return		ldr		sp, fiq_return_sp		; SP ̈ړ
				ldmfd	sp!, {r12, lr}			; ڼ޽ ̕A
				msr		spsr, r12
				ldmfd	sp!, {r12, lr}
				subs	pc, lr, #4


;--------------------------------------------------------------------
;-															    -
;--------------------------------------------------------------------
		EXTERN	AgbMonMain
		EXTERN	intr_main
		CODE32
start_m			cmp		lr, #0					; fiq_return => pc = -4 ΍
				moveq	lr, #4

				mov		r12, #REG_BASE			; /հ 
				ldrb	r12, [r12, #0x300]
				teq		r12, #1
				mrseq	r12, cpsr				; IRQ/FIQs
				orreq	r12, r12, #PSR_IRQ_DISABLE | PSR_FIQ_DISABLE
				msreq	cpsr,r12
				beq		fiq_v

restart_v		mov		r0, #0xc0 | PSR_SYS_MODE ; Ӱނ֐؂芷 & IRQ/FIQs
				msr		cpsr, r0

				mov		r4, #REG_BASE			 ; IME ؾ
				strb	r4, [r4, #OFFSET_REG_IME]

				bl		bankreg_init_stack_clear ; ݸڼ޽ ؾ & ̈ ر
	    	    adr     r0, intr_main			 ; 荞ݱڽ̾
		        str     r0, [sp, #0x100-4]

				ldr		r0, =AgbMonMain			 ; Cٰݏ
				adr		lr, usr_reset
				bx		r0

usr_reset		mov		r4, #REG_BASE			 ; ެߐ l
				ldrb	r2, [r4, #INTR_CHECK_BUF - WRAM_END + 2]
				bl		bankreg_init_stack_clear ; ݸڼ޽ ؾ & ̈ ر
				cmp		r2, #0
				ldmea	r4, {r0-r12}			 ; ėpڼ޽ ر
				movne	lr, #0x2000000			 ; !0  WRAM
				moveq	lr, #0x8000000			 ;  0  ROM

				mov		r0, #PSR_SYS_MODE		 ; IRQ/FIQ
				msr		cpsr, r0
				mov		r0, #0
				bx		lr

;--------------------------------------------------------------------
;-	oNWX^ Zbg  X^bN̈ NA(r4=REG_BASE)		-
;--------------------------------------------------------------------
		CODE32
bankreg_init_stack_clear
				mov		r0, #0xc0 | PSR_SVC_MODE ; SVCӰނ֐؂芷  & IRQ/FIQs
				msr		cpsr, r0
				ldr		sp, svc_sp				 ; SP ̾
				mov		lr,	#0
				msr		spsr, lr
				mov		r0, #0xc0 | PSR_IRQ_MODE ; IRQӰނ֐؂芷  & IRQ/FIQs
				msr		cpsr, r0
				ldr		sp, irq_sp				 ; SP ̾
				mov		lr,	#0
				msr		spsr, lr
				mov		r0, #0x40 | PSR_SYS_MODE ; Ӱނ֐؂芷 & IRQ/FIQs
				msr		cpsr, r0
				ldr		sp, usr_sp				 ; SP ̾

stack_clear;	mov		r4, #REG_BASE			; r4:  REG_BASE
				adr		r0, stack_clear_10 + 1
				bx		r0
		CODE16
stack_clear_10	mov		r0, #0
				ldr		r1, =-4*128
stack_clear_20	str		r0, [r4, r1]
				add		r1, #4
				blt		stack_clear_20
				bx		lr


;--------------------------------------------------------------------
;-				hqpփWv							12c -
;--------------------------------------------------------------------
		ALIGN
		CODE32
irq_m			stmfd	sp!, {r0-r3,r12,lr}			; ڼ޽ ̑ޔ
				mov		r0, #IMG_CPU_WRAM_END
				adr		lr, irq_return
				ldr		pc, [r0, #-4]				; 32bitނżެ
;--------------------------------------------------------------------
;-				hqp̕A								11c -
;--------------------------------------------------------------------
		CODE32
irq_return		ldmfd	sp!, {r0-r3,r12,lr}			; ڼ޽ ̕A
				subs	pc, lr, #4


;--------------------------------------------------------------------
;-				VXeR[փWv		                23c -
;--------------------------------------------------------------------
		CODE32
swi_m			stmfd	sp!, {r11, r12, lr}			; SVCӰ ڼ޽ޔ
				ldrb	r12, [lr, #-2]				; ѺNo     擾
				adr		r11, sys_table				; Ѻ٥ڽ 擾
				ldr		r12, [r11, r12, lsl #2]
;				ldrh	r12, [r11, r12]
				mrs		r11, spsr					; SVCӰ SPSRޔ
				stmfd	sp!, {r11}
				and		r11, r11, #PSR_IRQ_DISABLE	; IRQ ߰
				orr		r11, r11, #PSR_SYS_MODE		; Ӱނ֐؂芷 & FIQ
				msr		cpsr,r11

				stmfd	sp!, {r2, lr}				; Ӱ ڼ޽ޔ
				adr		lr, swi_return
				bx		r12							; ނ̐؊Ƽެ
;--------------------------------------------------------------------
;-				VXeR[̕A						18c -
;--------------------------------------------------------------------
		GLOBAL	swi_return
		CODE32
swi_return		ldmfd	sp!, {r2, lr}				; Ӱ ڼ޽A
				mov		r12, #0xc0 | PSR_SVC_MODE	; SVCӰނ֐؂芷
				msr		cpsr, r12					;   & IRQ/FIQs

				ldmfd	sp!, {r11}					; SVCӰ ڼ޽A
				msr		spsr, r11
				ldmfd	sp!, {r11, r12, lr}
				movs	pc, lr


;--------------------------------------------------------------------
;-				bfa[hJ VXeR[			   8c(+14c) -
;--------------------------------------------------------------------
		GLOBAL	agb2cgb
		ALIGN
		CODE32
agb2cgb			mov		r12, #REG_BASE
				mov		r2, #0x04				; BG2\
				strb	r2, [r12, #OFFSET_REG_DISPCNT + 1]
				mov		r2, #0x08
				strb	r2, [r12, #OFFSET_REG_DISPCNT]
;--------------------------------------------------------------------
;-				g`ks VXeR[							14c -
;--------------------------------------------------------------------
		GLOBAL	halt
		CODE32
halt			mov		r2, #0x00
				b		pause_reg_h_set
;--------------------------------------------------------------------
;-				rsno  VXeR[						11c -
;--------------------------------------------------------------------
		CODE32
stop			mov		r2,  #0x80
pause_reg_h_set	mov		r12, #REG_BASE
				strb	r2, [r12, #OFFSET_REG_PAUSE + 1]
				bx		lr



;====================================================================
;=					AhXe[u							    =
;====================================================================
		ALIGN
usr_sp			DCD		WRAM_END - 0x100
irq_sp			DCD		WRAM_END - 0x60
svc_sp
fiq_return_sp	DCD		WRAM_END - 4*8
fiq_sp			DCD		WRAM_END - 4*4

		EXTERN	RegisterRamReset32
		EXTERN	Intr_Wait
		EXTERN	VBlankIntr_Wait
		EXTERN	DivS32
		EXTERN	__16__rt_sdiv
		EXTERN	SqrtU32
		EXTERN	ArcTanS32
		EXTERN	ArcTanS32_2
		EXTERN	CpuSet16_32
		EXTERN	CpuFastSet32
		EXTERN	BgAffineSet32
		EXTERN	ObjAffineSet32
		EXTERN	BitUnPack32
		EXTERN	LZ77UnComp8
		EXTERN	LZ77UnComp16
		EXTERN	HuffUnComp32
		EXTERN	RLUnComp8
		EXTERN	RLUnComp16
		EXTERN	DiffUnFilter8_8
		EXTERN	DiffUnFilter8_16
		EXTERN	DiffUnFilter16_16
		EXTERN	SoundBiasChange16
		EXTERN	SoundInit
		EXTERN	SoundMode
		EXTERN	SoundMain
		EXTERN	SoundVSync
		EXTERN	SoundClearAll
		EXTERN	SoundVSyncOff
		EXTERN	SoundVSyncOn
		EXTERN	MidiKey2fr
		EXTERN	MPlayOpen
		EXTERN	MPlayStart
		EXTERN	MPlayStop
		EXTERN	MPlayContinue
		EXTERN	MPlayFadeOut
		EXTERN	MPlyJmpTblCopy
		EXTERN	MultiBootMain
		EXTERN	MonCheckSum32
sys_table
		DCD		usr_reset				; 0
		DCD		RegisterRamReset32		; 1
		DCD		halt					; 2
		DCD		stop					; 3
		DCD		Intr_Wait				; 4
		DCD		VBlankIntr_Wait			; 5
		DCD		DivS32					; 6
		DCD		__16__rt_sdiv			; 7
		DCD		SqrtU32					; 8
		DCD		ArcTanS32				; 9
		DCD		ArcTanS32_2				; 10
		DCD		CpuSet16_32				; 11
		DCD		CpuFastSet32			; 12
		DCD		MonCheckSum32			; 13
		DCD		BgAffineSet32			; 14
		DCD		ObjAffineSet32			; 15
		DCD		BitUnPack32				; 16
		DCD		LZ77UnComp8				; 17
		DCD		LZ77UnComp16			; 18
		DCD		HuffUnComp32			; 19
		DCD		RLUnComp8				; 20
		DCD		RLUnComp16				; 21
		DCD		DiffUnFilter8_8			; 22
		DCD		DiffUnFilter8_16		; 23
		DCD		DiffUnFilter16_16		; 24
		DCD		SoundBiasChange16		; 25
		DCD		SoundInit				; 26
		DCD		SoundMode				; 27
		DCD		SoundMain				; 28
		DCD		SoundVSync				; 29
		DCD		SoundClearAll			; 30
		DCD		MidiKey2fr				; 31
		DCD		MPlayOpen				; 32
		DCD		MPlayStart				; 33
		DCD		MPlayStop				; 34
		DCD		MPlayContinue			; 35
		DCD		MPlayFadeOut			; 36
		DCD		MultiBootMain			; 37
		DCD		restart_v				; 38
		DCD		pause_reg_h_set			; 39
		DCD		SoundVSyncOff			; 40
		DCD		SoundVSyncOn			; 41
		DCD		MPlyJmpTblCopy			; 42

	END


