;********************************************************************
;*      		`faj^vO Tu[`Q			    *
;********************************************************************

		AREA	AgbCrt0Sub, CODE, READONLY
		INCLUDE	AgbDefineArm.s
		INCLUDE	AgbMemoryMapArm.s

		INCLUDE	AgbMonDefineArm.s
MON_ONLY
NDEBUG2

;		ENTRY
;		ALIGN
;		CODE32
;				add		r3, pc, #1
;				bx		r3
;--------------------------------------------------------------------
;-				荞ݕ򏈗								17c -
;--------------------------------------------------------------------
;	IF :DEF: SYSCALL_ASM
		GLOBAL	intr_main
		EXTERN	JoyIntCommon
		EXTERN	SoundVSync
		ALIGN
		CODE32
intr_main		mov		r3, #REG_BASE				; IE/IF 
				ldr		r2, [r3, #OFFSET_REG_IE]
		        and     r2, r2, r2, lsr #16
				ands	r1, r2, #SIO_INTR_FLAG			; رْʐM 荞
				ldrne	r0, =JoyIntCommon
				andeq	r1, r2, #V_BLANK_INTR_FLAG		; Vݸ 荞
				ldreq	r0, =SoundVSync
				streqh	r2, [r3, #INTR_CHECK_BUF - WRAM_END] ; IfCheck 
	IF :DEF: NDEBUG2
	ELSE
				beq		v_intr_debug
v_intr_debug_rerurn
	ENDIF
				strb	r1, [r3, #OFFSET_REG_IF]	; IF ر
				bx		r0							; հIRQּެ
;	ENDIF


	IF :DEF: NDEBUG2
	ELSE
v_intr_debug
				ldrb	r2, [r3, #INTR_CHECK_BUF - WRAM_END - 4]
				add		r2, r2, #1
				strb	r2, [r3, #INTR_CHECK_BUF - WRAM_END - 4]
				b		v_intr_debug_rerurn
	ENDIF


;--------------------------------------------------------------------
;-				uuN荞݃EFCg							-
;--------------------------------------------------------------------
;	IF :DEF: SYSCALL_ASM
		GLOBAL	VBlankIntr_Wait
		ALIGN
		CODE32
VBlankIntr_Wait	mov		r0, #1
				mov		r1, #V_BLANK_INTR_FLAG
;--------------------------------------------------------------------
;-				荞݃EFCgir0=InitCheckClear, r1=IntrFlagj	-
;--------------------------------------------------------------------
;	IF :DEF: SYSCALL_ASM
		GLOBAL	Intr_Wait
		CODE32
Intr_Wait		stmfd   sp!, {r4,lr}

				mov		r3, #0
				mov		r4, #1
				cmp		r0, #0
				blne	Intr_Wait_sub			; IfCheck ر

Intr_Wait_10	strb	r3, [r12,#REG_PAUSE+1 - REG_BASE]	; Halt()  REG_PAUSE = 0
				bl		Intr_Wait_sub
				beq		Intr_Wait_10			; while (!(IfCheck & IfFlags))

				ldmfd   sp!, {r4,lr}
				bx		lr

Intr_Wait_sub	mov		r12,#REG_BASE			; r12: #REG_BASE
				strb	r3, [r12,#REG_IME - REG_BASE]	; IME = 0
				ldrh	r2, [r12,#INTR_CHECK_BUF - WRAM_END]
				ands	r0, r1, r2				; IfCheck 
				eorne	r2, r2, r0				; IfCheck ر
				strneh	r2, [r12,#INTR_CHECK_BUF - WRAM_END]
				strb	r4, [r12,#REG_IME - REG_BASE]	; IME = 1

				bx		lr

;	ENDIF


;--------------------------------------------------------------------
;-				j^ROM `FbNT							    -
;--------------------------------------------------------------------
;	IF :DEF: SYSCALL_ASM
		GLOBAL	MonCheckSum32
		ALIGN
		CODE32
MonCheckSum32
				mov		r0,#0
				mov		r3,#0
MonCheckSum32_10
				mov		r12, #0xc0 | PSR_SYS_MODE
				ldmia	r3!,{r2}
				msr		cpsr, r12			 ; IRQ/FIQs

				add		r0, r0, r2
				movs	r1, r3, lsr	#14
				beq		MonCheckSum32_10

				bx		lr
;	ENDIF

;--------------------------------------------------------------------
;-				Βl(r0=Value)								    -
;--------------------------------------------------------------------
;	IF :DEF: SYSCALL_ASM
		GLOBAL	Abs
		CODE16
Abs				cmp		r0, #0
				bgt		Abs_End
				neg		r0, r0

Abs_End			bx		lr

;	ENDIF

;--------------------------------------------------------------------
;-	ėptZ16bit(r0/r1r0',r1%r0r1',|r0'|r3')		-
;--------------------------------------------------------------------
;	IF :DEF: SYSCALL_ASM
		GLOBAL	DivS32_T
		CODE16
DivS32_T		adr		r3, DivS32
				bx		r3
;--------------------------------------------------------------------
;-	ėptZARM_LIBΉ(r1/r0r0',r1%r0r1',|r0'|r3')	-
;--------------------------------------------------------------------
;	IF :DEF: SYSCALL_ASM
		GLOBAL	__16__rt_sdiv
		ALIGN
		CODE32
__16__rt_sdiv	mov		r3, r0
				mov		r0, r1
				mov		r1, r3
;--------------------------------------------------------------------
;-	ėptZir0/r1r0',r0%r1r1',|r0'|r3'j			-
;--------------------------------------------------------------------
;	IF :DEF: SYSCALL_ASM
		GLOBAL	DivS32
		ALIGN
		CODE32
DivS32			ands	r3, r1, #0x80000000		; r1:  ̐Βl
				rsbmi	r1, r1, #0
				eors	r12,r3, r0, asr #32		; r12: d31=ʂ̕,d30=폜̕
				rsbcs	r0, r0, #0				; r0:  폜̐Βl
				movs	r2, r1					; r2:  Rg[Erbg
;				beq		devide_by_zero

divide_just_l	cmp		r2, r0, lsr #1
				movls	r2, r2, lsl #1
				blo		divide_just_l

divide_div_l	cmp		r0, r2					; Zł邩`FbN
				adc		r3, r3, r3				; r3*2 + L[
				subcs	r0, r0, r2				; Z\Ȃ猸Z
				teq		r2, r1					; I`FbN
				movne	r2, r2, lsr #1			; IłȂ΂QŊă`FbN
				bne		divide_div_l
				mov		r1, r0
				mov		r0, r3

				movs	r12,r12,asl #1
				rsbcs	r0, r0, #0
				rsbmi	r1, r1, #0

				bx		lr
;	ENDIF


;--------------------------------------------------------------------
;-				Zoir0=Paramj								-
;--------------------------------------------------------------------
;	IF :DEF: SYSCALL_ASM
		GLOBAL	SqrtU32
		ALIGN
		CODE32
SqrtU32			stmfd   sp!, {r4}

				mov		r12,r0					; r12: ParamBak
				mov		r1, #1

Sqrt_10			cmp		r0, r1
				movhi	r0, r0, lsr #1
				movhi	r1, r1, lsl #1
				bhi		Sqrt_10

Sqrt_20			mov		r0, r12					; r0:  폜
				mov		r4, r1					; r1:  
				mov		r3, #0					; r3:  
				mov		r2, r1					; r2:  Rg[Erbg

Sqrt_30			cmp		r2, r0, lsr #1
				movls	r2, r2, lsl #1
				blo		Sqrt_30

Sqrt_40			cmp		r0, r2					; Zł邩`FbN
				adc		r3, r3, r3				; r3*2 + L[
				subcs	r0, r0, r2				; Z\Ȃ猸Z
				teq		r2, r1					; I`FbN
				movne	r2, r2, lsr #1			; IłȂ΂QŊă`FbN
				bne		Sqrt_40

				add		r1, r1, r3
				movs	r1, r1, lsr #1
				cmp		r1, r4
				bcc		Sqrt_20

				mov		r0, r4
				ldmfd   sp!, {r4}
				bx		lr
;	ENDIF


;--------------------------------------------------------------------
;-				tځir0=tanj									-
;--------------------------------------------------------------------
;	IF :DEF: SYSCALL_ASM
		GLOBAL	ArcTanS32_T
		GLOBAL	ArcTanS32
		CODE16
ArcTanS32_T		adr		r3, ArcTanS32
				bx		r3
		ALIGN
		CODE32
ArcTanS32		mul		r1, r0, r0				; r1:  -x*x
				mov		r1, r1, asr #14
				rsb		r1, r1, #0

				mov		r3, #0xa9				; r3:   =  0xa9
				mul		r3, r1, r3				;  = -x*x*(0xa9       ) >> 14
				mov		r3, r3, asr #14
				add		r3, r3, #0x390			;  = -x*x*(0x390  + ) >> 14
				mul		r3, r1, r3
				mov		r3, r3, asr #14

				add		r3, r3, #0x900			;  = -x*x*(0x91c  + ) >> 14
				add		r3, r3, #0x1c
				mul		r3, r1, r3
				mov		r3, r3, asr #14
				add		r3, r3, #0xf00			;  = -x*x*(0xfb6  + ) >> 14
				add		r3, r3, #0xb6
				mul		r3, r1, r3
				mov		r3, r3, asr #14

				add		r3, r3, #0x1600			;  = -x*x*(0x16aa + ) >> 14
				add		r3, r3, #0xaa
				mul		r3, r1, r3
				mov		r3, r3, asr #14
				add		r3, r3, #0x2000			;  = -x*x*(0x2081 + ) >> 14
				add		r3, r3, #0x81
				mul		r3, r1, r3
				mov		r3, r3, asr #14

				add		r3, r3, #0x3600			;  = -x*x*(0x3651 + ) >> 14
				add		r3, r3, #0x51
				mul		r3, r1, r3
				mov		r3, r3, asr #14
				add		r3, r3, #0xa200			;  =    x*(0xa2f9 + ) >> 14
				add		r3, r3, #0xf9
				mul		r0, r3, r0
				mov		r0, r0, asr #16

				bx		lr

;	ENDIF


;--------------------------------------------------------------------
;-				tڂQir0=x,r1=yj								-
;--------------------------------------------------------------------
;	IF :DEF: SYSCALL_ASM
		GLOBAL	ArcTanS32_2
		CODE16
ArcTanS32_2		push 	{r4-r7, lr}

				cmp		r1, #0
				bne		ArcTanS32_2_20
				cmp		r0, #0
				blt		ArcTanS32_2_10
				mov		r0, #0x00					; return 0x0000
				b		ArcTanS32_2_end
ArcTanS32_2_10	mov		r0, #0x80					; return 0x8000
				lsl 	r0, #8
				b		ArcTanS32_2_end

ArcTanS32_2_20	cmp		r0, #0
				bne		ArcTanS32_2_40
				cmp		r1, #0
				blt		ArcTanS32_2_30
				mov		r0, #0x40					; return 0x4000
				lsl 	r0, #8
				b		ArcTanS32_2_end
ArcTanS32_2_30	mov		r0, #0xc0					; return 0xc000
				lsl 	r0, #8
				b		ArcTanS32_2_end

ArcTanS32_2_40	mov		r2, r0						; r2:  x << 14
				lsl		r2, #14
				mov		r3, r1						; r3:  y << 14
				lsl		r3, #14
				neg		r4, r0						; r4:  -x
				neg		r5, r1						; r5:  -y
				mov		r6, #0x40					; r6:  0x4000
				lsl		r6, #8
				lsl		r7, r6, #1					; r7:  0x8000

				cmp		r1, #0						; if (y >= 0)
				blt		ArcTanS32_2_80

				cmp		r0, #0						; if (x >= 0)
				blt		ArcTanS32_2_60

				cmp		r0, r1						; if (x >= y)
				blt		ArcTanS32_2_50
				mov		r1, r0						; 0/4    1/4
				mov		r0, r3
				bl		DivS32_T					; 0x0000 + ArcTanS32(y/x)
				bl		ArcTanS32_T
				b		ArcTanS32_2_end
ArcTanS32_2_50	mov		r0, r2						; 1/4    3/4
				bl		DivS32_T					; 0x4000 - ArcTanS32(x/y)
				bl		ArcTanS32_T
				sub		r0, r6, r0
				b		ArcTanS32_2_end

ArcTanS32_2_60	cmp		r4, r1						; if (-x >= y)
				blt		ArcTanS32_2_50
ArcTanS32_2_70	mov		r1, r0						; 3/4    5/4
				mov		r0, r3
				bl		DivS32_T					; 0x8000 + ArcTanS32(y/x)
				bl		ArcTanS32_T
				add		r0, r7, r0
				b		ArcTanS32_2_end

ArcTanS32_2_80	cmp		r0, #0						; if (x <= 0)
				bgt		ArcTanS32_2_a0

				cmp		r4, r5						; if (-x >= -y)
				bgt		ArcTanS32_2_70
ArcTanS32_2_90	mov		r0, r2						; 5/4    7/4
				bl		DivS32_T					; 0xc000 - ArcTanS32(x/y)
				bl		ArcTanS32_T
				add		r6, r6, r7
				sub		r0, r6, r0
				b		ArcTanS32_2_end

ArcTanS32_2_a0	cmp		r0, r5						; if (x >= -y)
				blt		ArcTanS32_2_90
ArcTanS32_2_b0	mov		r1, r0						; 7/4    8/4
				mov		r0, r3
				bl		DivS32_T					; 0x10000 + ArcTanS32(y/x)
				bl		ArcTanS32_T
				add		r7, r7, r7
				add		r0, r7, r0

ArcTanS32_2_end	pop		{r4-r7}
				pop		{r3}
				bx		r3

;	ENDIF


;--------------------------------------------------------------------
;-				ZLeBEL[@@NintendoS Rs[	    -
;--------------------------------------------------------------------
KEY_START_BLOCK_NO      *       3               ;  ۯNo
		EXTERN	NinLogoBak
;		EXTERN	NinLogoCopy
		EXTERN	DacsCheck
		GLOBAL	key_unlock__nin_logo_copy
		CODE16
key_unlock__nin_logo_copy
;				bx		lr
;	IF :DEF: SYSCALL_ASM
				push	{r3, r4-r6, lr}
				mov		r6, #0x8				; r6:  ROM_BANK0
				lsl		r6, #24
				mov		r5, #MON_KEY_GROUP_NO - ROM_BANK0
				add		r5, r6					; r5:  MON_KEY_GROUP_NO
				sub		r0, r5, #1				; r4:   No ̾ Zo
				mov		r1, #27					; Srcp=MON_KEY_GROUP_NO-1,Count=27
				bl		GetKeyNo
;				mov		r0, #2					; а  No
				mov		r4, #2*6
				mul		r4, r0
				ldrb	r3, [r5]				; r3:  ٰ No(0-3) * 48
				lsl		r3, #32-2
				lsr		r3, #32-2
				mov		r2, #2*6*4
				mul		r2, r3
				add		r4, r2					; r4:   No Zo
				adr		r5, key_addr			; r5:  ڽ
				add		r5, r4
				mov		r4, #0
nin_copy		mov		r0, r4
				bl		NinLogoCopy				; Nintendoۺ ߰ (20*10Byte)
				cmp		r4, #KEY_START_BLOCK_NO
				blt		key_unlock_end
				cmp		r4, #KEY_START_BLOCK_NO + 6
				bge		key_unlock_end
key_unlock		ldrh	r1, [r5]				; r1:  ڽ ǂݍ
				lsl		r1, #1
				orr		r1, r6
				ldrh	r0, [r1]
				add		r5, #2
key_unlock_end	add		r4, #1
				cmp		r4, #11
				bne		nin_copy

				pop		{r3, r4-r6, pc}

;	ENDIF

		INCLUDE	crt0KeyAddr.s

;--------------------------------------------------------------------
;-				L[m Zo	(r0=Srcp, r1=Count  r0=KeyNo:2)	-
;--------------------------------------------------------------------
;	IF :DEF: SYSCALL_ASM
		GLOBAL	GetKeyNo
		CODE16
GetKeyNo		push	{r4, r5, lr}
				mov		r4, #3					; r4:  Ror
				mov		r3, #0					; r3:  KeyNo
GetKeyNo_10		ldrb	r2, [r0, #0]			; r2:  *Srcp
				ror		r3, r4
				mov		r5, #4					; r5:  RorCount
GetKeyNo_20		eor		r3, r2
				lsl		r2, #8
				sub		r5, #1					; while (--RorCount > 0)
				bgt		GetKeyNo_20
				add		r0, #1
				sub		r1, #1					; while (--Count > 0)
				bgt		GetKeyNo_10
				mov		r0, r3
				lsl		r0, #32-5
				lsr		r0, #32-2
				pop		{r4, r5, pc}
;	ENDIF

;--------------------------------------------------------------------
;-				mhmsdmcnS Rs[ (r0=BlockNo)			-
;--------------------------------------------------------------------
;	IF :DEF: SYSCALL_ASM
		GLOBAL	NinLogoCopy
		CODE16
NinLogoCopy		push	{r4, lr}
				mov		r4, #20					; r4:  BlockOffset = BlockNo * 20
				mul		r4, r0
				mov		r3, #0x8				; r3:  ROM_BANK0
				lsl		r3, #24

				add		r0, r3, #4				; r0:  &((u8 *)ROM_BANK0)[BlockOffset + OFFSET_MON_NINLOGO]
				add		r0, r4
				ldr		r1, =NinLogoBak+36		; r1:  &NinLogoBak[BlockOffset + 36]
				add		r1, r4
				mov		r2, #10					; r2:  0x0000000A (16bit]10)
				bl		CpuSet16_32				; CpuCopy16_32()
				pop		{r4, pc}
;	ENDIF


;--------------------------------------------------------------------
;-				o^f[^ `FbN	(r0=Datap)						-
;-				( OK: r0=0 / ERROR: r0=1)							-
;--------------------------------------------------------------------
		EXTERN	Nin_Char_Diff_Huff
;	IF :DEF: SYSCALL_ASM
		GLOBAL	RomHeaderCheck
;		EXTERN	GetSumData
;		EXTERN	DemoSoundStop
		CODE16
RomHeaderCheck
				push	{r4-r6, lr}
				ldr		r1, =Nin_Char_Diff_Huff+36	; r1:  &Nin_Char_Diff_Huff[36]

				mov		r6, #0					; for (i=0; i<OFFSET_MON_SOFT_NAME; i++)
RegDataCheck_10	mov		r4, #0xff				; r4:  CmpMask
				cmp		r6, #OFFSET_MON_FIQ_FLAG
				bne		RegDataCheck_20
				mov		r4, #0xff - 0x84
RegDataCheck_20	cmp		r6, #OFFSET_MON_KEY_GROUP_NO
				bne		RegDataCheck_30
				mov		r4, #0xff - 0x03
RegDataCheck_30	cmp		r6, #OFFSET_MON_SOFT_NAME
				bge		RegDataCheck_50

				ldrb	r2, [r0,r6]				; if ((Datap[i] & CmpMask) != Nin_Char_Diff_Huff[i])
				ldrb	r3, [r1,r6]				;		return 1;
				and		r2, r4
				add		r6, #1
				cmp		r2, r3
				beq		RegDataCheck_10
				b		RegDataCheck_70

RegDataCheck_50	mov		r4, #0x19				; r4:  SumInv = 0x19
RegDataCheck_60	ldrb	r2, [r0,r6]				; SumInv += Datap[i]
				add		r4, r2
				add		r6, #1
				cmp		r6, #OFFSET_MON_COMPLEMENT + 1
				blt		RegDataCheck_60			; while (++i<OFFSET_MON_COMPLEMENT)
				lsl		r0, r4, #24				; if (SumInv)	return 1;
				bne		RegDataCheck_70
				mov		r0, #0					; OK = 0
				b		RegDataCheck_end

RegDataCheck_70	mov		r0, #1					; ERROR = 1

RegDataCheck_end
				pop		{r4-r6,pc}

;	ENDIF


;--------------------------------------------------------------------
;-				AtBϊ									-
;--------------------------------------------------------------------
;	IF :DEF: SYSCALL_ASM
		EXTERN	LogoPosition
		GLOBAL	AffineInit
		CODE16
AffineInit		ldr      r3, =LogoPosition	; r3:  LogoPosition[]
				mov      r2, #8				; r2:  i
				mov		 r0, #126			; r0:  -126
				neg		 r0, r0
;				ldr      r0, =-126
;				ldr      r0, =-126 << 8

AffineInit_10	str      r0, [r3, r2]
				add      r2, #16			; while (++i < 7)
				cmp		 r2, #7 << 4 + 8
				blt		 AffineInit_10

				bx		lr
;	ENDIF

;--------------------------------------------------------------------
;-				vZ [` (r0=ObjNo,r1=PosDatap,r2=Counter)	-
;--------------------------------------------------------------------
;	IF :DEF: SYSCALL_ASM
		GLOBAL	PhysicalMove
		CODE16
PhysicalMove	push	{r6, lr}

				sub		r3, r0, #3			; r6:  NoTmp = (ObjNo - 3) << 2
				lsl		r6, r3, #2
;				mov		r6, #5
;				mul		r6, r3

				mul		r6, r2				; Tmp = NoTmp * Counter * (64 - Counter)
				mov		r3, #64
				sub		r3, r2
				mul		r6, r3
				sub		r0, #3				; Tmp += -24 * (ObjNo - 3) << 8
				mov		r3, #24
				mul		r3, r0
				lsl		r3, #8
				sub		r6, r3
				str		r6, [r1, #0]		; PosDatap->X = Tmp

				cmp		r2, #0x2f
				bgt		PhysicalMove_End

				mov		r6, #26				; r6: Tmp = 26 * Counter * (-72 + Counter)
				mul		r6, r2
				sub		r2, #72
				mul		r6, r2
				mov		r3, #104			; Tmp += (104 << 8);
				lsl		r3, #8
				add		r6, r3
				str		r6, [r1, #4]		; PosDatap->Y = Tmp

PhysicalMove_End
				pop		{r6, pc}
;	ENDIF

;--------------------------------------------------------------------
;-		AtBϊp ϊ [`(r0=PosDatap,r1=AffineDatap)-
;--------------------------------------------------------------------
;	IF :DEF: SYSCALL_ASM
		GLOBAL	AffinePerspective
		CODE16
AffinePerspective
				push	{r4-r7, lr}

				mov      r7, r1				; r7:  AffineDatap

				ldmia	 r0!, {r4,r5,r6}	; (r4,r5,r6):  PosDatap->(X,Y,Z)

				add      r6, #128			; Number = (PosDatap->Z >> 0) + 128
				mov		 r1, r6
				mov      r0, #128			; Denom = 128 << 16
				lsl      r0, #16
				bl		 DivS32_T			; r0:  Ratio = Denom/Number

				lsl      r3, r6, #1			; r1:  RatioInv = (PosDatap->Z + (128 << 0)) >> 7

				strh     r3, [r7, #0xc]		; AffineDatap->RatioX  = RatioInv
				strh     r3, [r7, #0xe]		; AffineDatap->RatioY  = RatioInv
				mov      r1, #0x7f			; Tmp = (64 << AFFINE_REG_SHIFT) - 0x80
				lsl      r1, #7
				str      r1, [r7, #0]		; AffineDatap->SrcCenterX = Tmp
				str      r1, [r7, #4]		; AffineDatap->SrcCenterY = Tmp
				asr      r1, r4,#8			; Tmp = (PosDatap->X >> 8) * Ratio >> 16) + 240/2
				mul      r1, r0
				asr      r1, #16
				add      r1, #240/2
				strh     r1, [r7, #8]		; AffineDatap->DispCenterX = Tmp
				asr      r1, r5,#8			; Tmp = ((PosDatap->Y >> 8) * Ratio >> 16) + 160/2
				mul      r1, r0
				asr      r1, #16
				add      r1, #160/2
				strh     r1, [r7, #0xa]		; AffineDatap->DispCenterY = Tmp

				pop		{r4-r7, pc}
;	ENDIF


;--------------------------------------------------------------------
;-				aff[^ CNgZbg						-
;-				(r0=StartData,r1=AddData,r2=SrcHSize,r3=SrcVSize)	-
;-				(sp[0]=Destp,sp[1]=DestHSize)						-
;--------------------------------------------------------------------
;	IF :DEF: SYSCALL_ASM
		GLOBAL	BgScIncSet16
		CODE16
BgScIncSet16	push	{r4-r7, lr}

				ldr		r4, [sp, #0x14  ]	; r4:  Destp
				ldr		r5, [sp, #0x14+4]	; r5:  DestHSize

				mov		r7, #0				; r7:  i
BgScIncSet16_10	mov		r6, #0				; r6:  ii

BgScIncSet16_20	strh	r0, [r4, r6]		; 	Destp[ii]  = StartData
				add		r0, r1				; 	StartData += AddData

				add		r6, #2				; 	while (++ii < SrcHSize)
				cmp		r6, r2
				blt		BgScIncSet16_20

				add		r4, r5				; Destp += DestHSize
				add		r7, #1				; while (++i < SrcVSize)
				cmp		r7, r3
				blt		BgScIncSet16_10

				pop		{r4-r7, pc}
;	ENDIF

;--------------------------------------------------------------------
;-				pbg`Zbg(r0=Index,r1=LinerParam,r2=Start) -
;--------------------------------------------------------------------
;	IF :DEF: SYSCALL_ASM
		EXTERN	Logo_Palette32
		GLOBAL	PlttLinerSet
		CODE16
PlttLinerSet	push	{r4-r7, lr}

				mov		r7, #2				; for (i=3; --i>=0; )

PlttLinerSet_10	ldr		r4, =Logo_Palette32
				lsl		r3, r0, #1
				add		r3, r0
				add		r3, r7
				lsl		r3, #2
				add		r3, r4
				ldr		r5, [r3, #4]		; r5:  PlttTmp1
				ldr		r6, [r3, #16]		; r6:  PlttTmp2

				mov		r3, #32				; r4:  PlttTmp0
				sub		r3, r1				; PlttTmp1 *= (32-LinerParam)
				mul		r3, r5
				mul		r6, r1				; PlttTmp2 *= LinerParam
				add		r3, r6
				lsr		r4, r3, #5			; PlttTmp0 = (PlttTmp1+PlttTmp2)/32

				mov		r6, #0x1f			; r6:  0x1f
				lsl		r3, r6, #20			;   (PlttTmp0 & (0x1f<<20)) >> 10
				and		r3, r4
				lsr		r5, r3, #10
				lsl		r3, r6, #10			; | (PlttTmp0 & (0x1f<<10)) >> 5
				and		r3, r4
				lsr		r3, #5
				orr		r3, r5
				and		r4, r6				; | (PlttTmp0 & 0x1f)
				orr		r4, r3
				add		r3, r2, r7			; r4:  ((u16 *)OBJ_PLTT)[Start + i]
				lsl		r6, r3, #1
				ldr		r3, =OBJ_PLTT
				add		r3, r6, r3
				strh	r4, [r3, #0]
				sub		r7, #1
				bge		PlttLinerSet_10

				pop		{r4-r7,pc}
;	ENDIF


;--------------------------------------------------------------------
;-				TEhah`r ύX (r0=UpDown)					-
;--------------------------------------------------------------------
;	IF :DEF: SYSCALL_ASM
		GLOBAL	SoundBiasChange16
		CODE16
SoundBiasChange16

SoundBiasChange16_10
				mov		r1, #2					; r12: 0x200
				lsl		r1, #8
				mov		r12, r1

				ldr		r3, =REG_SOUNDBIAS		; r3:  SoundBiasp = REG_SOUNDBIAS
				ldrh	r2, [r3, #0]			; r2:  *SoundBiasp
				ldr		r3, =REG_SOUNDBIAS
				lsl		r1, r2, #32-10			; r1:  *SoundBiasp & 0x03ff
				lsr		r1, r1, #32-10
				cmp		r0, #0					; if (UpDown)
				beq		SoundBiasChange16_20

				cmp		r1, r12					; if (*SoundBiasp >= 0x200)	break;
				bge		SoundBiasChange16_End

				add		r2, #2					; *SoundBiasp += 2
				b		SoundBiasChange16_30

SoundBiasChange16_20
				cmp		r1, #0					; if (*SoundBiasp <= 0)		break;
				ble		SoundBiasChange16_End

				sub		r2, #2					; *SoundBiasp -= 2

SoundBiasChange16_30
				strh	r2, [r3, #0]

				mov		r2,#8					; for (i=0x8; --i>=0; )	;
SoundBiasChange16_40
				sub		r2,#1
				bpl		SoundBiasChange16_40
				b		SoundBiasChange16_10

SoundBiasChange16_End
				bx		lr

;	ENDIF


;--------------------------------------------------------------------
;-				faS LN^f[^ Rs[					-
;--------------------------------------------------------------------
;	IF :DEF: SYSCALL_ASM
		EXTERN	Gb_Char_LZ_Huff
		EXTERN	CharTmpBuf
		GLOBAL	GbLogoCharCopy
		CODE16
GbLogoCharCopy
				ldr		r1, =CharTmpBuf			; r1:  CharTmpBuf
				mov		r2, #0x37				; r2:  DmaCntData = DMA_16BIT_BUS + 0x370
				lsl		r2, r2, #4
				ldr		r0, =Gb_Char_LZ_Huff	; r0:  Gb_Char_LZ_Huff
				b		LogoCopyCommon
;	ENDIF

;--------------------------------------------------------------------
;-		mS LN^f[^Ewb_ Rs[		-
;--------------------------------------------------------------------
;	IF :DEF: SYSCALL_ASM
		EXTERN	Nin_Char_Diff_Huff
		EXTERN	CharTmpBuf
		GLOBAL	NintendoLogoHeaderCopy
		CODE16
NintendoLogoHeaderCopy
				ldr		r1, =CharTmpBuf			; r1:  CharTmpBuf
				mov		r2, #36					; r2:  DmaCntData = DMA_16BIT_BUS + 36
				ldr		r0, =Nin_Char_Diff_Huff	; r0:  Gb_Char_LZ_Huff
				b		LogoCopyCommon
;	ENDIF

;--------------------------------------------------------------------
;-				fa^mS n`lf[^ Rs[		-
;--------------------------------------------------------------------
;	IF :DEF: SYSCALL_ASM
		EXTERN	OamMonData
		EXTERN	OamBak
		GLOBAL	LogoOamCopy
		CODE16
LogoOamCopy
				mov		r1, #7					; r1:  OAM
				lsl		r1, #24
;				ldr		r1, =OamBak
				mov		r2, #8*10				; r2:  DmaCntData = DMA_16BIT_BUS + 8*10
				ldr		r0, =OamMonData			; r0:  Gb_Char_LZ_Huff
				b		LogoCopyCommon
;	ENDIF

;--------------------------------------------------------------------
;-				nCCg pbgf[^ Rs[ (r0=BgObjSelect)	-
;--------------------------------------------------------------------
;	IF :DEF: SYSCALL_ASM
		EXTERN	Hilite_Palette
		GLOBAL	HilitePlttCopy
		CODE16
HilitePlttCopy
				ldr		r1, =BG_PLTT + 2*4*7	; r1:   BG_PLTT + 2*4*7
				cmp		r0, #0
				beq		HilitePlttCopy_10
				lsl		r0, #9					; r1:  OBJ_PLTT + 2*4*7
				add		r1, r0

HilitePlttCopy_10
				mov		r2, #2*4				; r2:  DmaCntData = DMA_16BIT_BUS + 2*4
				ldr		r0, =Hilite_Palette		; r0:  Gb_Char_LZ_Huff

;--------------------------------------------------------------------
;-				Sf[^ pRs[ (r0=Srcp,r1=Destp,r2=Size)	-
;--------------------------------------------------------------------
		EXTERN	Logo_Palette32

LogoCopyCommon
				push	{r4, r5, lr}

;				lsl		r2, #1
				add		r2, r1
LogoCopyCommon_10
				ldr		r3, =Logo_Palette32
				cmp		r0, r3
				blt		LogoCopyCommon_End
;	IF :DEF: MON_ONLY
				mov		r3, #4
				lsl		r3, #12
				cmp		r0, r3
				bge		LogoCopyCommon_End
;	ENDIF
				ldmia	r0!, {r3}				; *((vu32 *)(Destp))++ = *((vu32 *)(Srcp))++
				stmia	r1!, {r3}
				cmp		r1, r2
				blt		LogoCopyCommon_10
LogoCopyCommon_End
				pop		{r4, r5, pc}

;	ENDIF


;--------------------------------------------------------------------
;-						q`l								-
;--------------------------------------------------------------------
;	IF :DEF: SYSCALL_ASM
;		EXTERN	GbLogoCharCopy
;		EXTERN	NintendoLogoHeaderCopy
;		EXTERN	LogoOamCopy
;		EXTERN	HilitePlttCopy

		EXTERN	CpuSet
		EXTERN	CpuFastSet
		EXTERN	HuffUnComp
		EXTERN	LZ77UnCompWram
		EXTERN	BitUnPack

		EXTERN	Logo_BitUnPackParamInit
		EXTERN	ObjCharOffset
		EXTERN	CharTmpBuf
		GLOBAL	RamInit
		CODE16
RamInit			push	{r4-r7, lr}

				sub		sp, #20			; sp[8]:  Logo_BitUnPackParam
				ldr		r1, =Logo_BitUnPackParamInit
				ldmia	r1!, {r5, r7}
				add		r0, sp, #8
				stmia	r0!, {r5, r7}

				ldr		r0, =DACS_KEY_REG0
				ldr		r3, =ROM_BANK0 + 0xb4
				ldrb	r3, [r3, #0]
				lsr		r3, #7
				bne		RamInit_05
				ldr		r0, =DACS_KEY_REG1
RamInit_05		ldr		r1, =CharTmpBuf
				mov		r2, #2*10/2
				bl		CpuSet16_32
				bl		key_unlock__nin_logo_copy

nin_clear		ldr		r1, =NinLogoBak+36
				mov		r3, r1
				add		r3, #0xb2 - 4
				ldrb	r0, [r3, #0]
;	IF :DEF: SYSCALL_ASM
				cmp		r0, #0x96
				beq		nin_clear_end
				ldr		r2, =DMA_ENABLE + DMA_SRC_FIX + DMA_32BIT_BUS + MON_NINLOGO_SIZE/4
				asr		r3, r2, #31		; Src = 0xffffffff
				str		r3, [sp, #16]
				add		r0, sp, #16
				bl		CpuSet16_32
;	ENDIF
nin_clear_end

				bl		GbLogoCharCopy

				ldr		r0, =CharTmpBuf
				ldr		r1, =CharTmpBuf+0x1000
				bl		HuffUnComp32_T

				ldr		r0, =CharTmpBuf+0x1000
				ldr		r1, =CharTmpBuf
				bl		LZ77UnComp8_T

				mov		r7, #0			; for (i=0; i<8; i++)
RamInit_10
				lsl		r0, r7, #2		; Logo_BitUnPackParam.DestOffset = 4*i
				str		r0, [sp, #12]

				ldr		r2, =CharTmpBuf
				lsl		r0, r7, #8		; i*2*8*16
				add		r0, r2
				ldr		r3, =BG_VRAM+8*8
				lsl		r1, r7, #10		; i*8*8*16
				add		r1, r3
				add		r2, sp, #8
				bl		BitUnPack32_T
				add		r7, #1
				cmp		r7, #8
				blt		RamInit_10

				mov		r7, #7*2		; for (i=8; --i>=0; )
RamInit_20
				mov		r4, #3			;	for (ii=4; --ii>=0; )
RamInit_30
				ldr		r3, =BG_VRAM+64*1 ; BG_VRAM+64*1+8*8*4*(4*i+ii)
				lsl		r0, r7, #1
				add		r0, r4
				lsl		r0, #8
				add		r0, r3
				ldr		r3, =ObjCharOffset ; BG_VRAM+8*8*(1+i*16)
				ldrh	r2, [r3, r7]
				ldr		r3, =OBJ_MODE0_VRAM
				lsl		r1, r4, #4		; 16*ii
				add		r1, r2
				lsl		r1, #6
				add		r1, r3
				mov		r2, #8*8*4/2
				bl		CpuSet16_32
;				bl		CpuFastSet32_T
				sub		r4, #1
				bge		RamInit_30
				sub		r7, #2
				bge		RamInit_20

				ldr		r0, =NinLogoBak+36
				bl		NintendoLogoSet0
				bl		NintendoLogoSet1
				bl		NintendoLogoSet2

				mov		r2, #32
				str		r2, [sp, #4]
				ldr		r1, =BG_VRAM+0x8080+0x800*7
				str		r1, [sp, #0]
				mov		r3, #4
				mov		r2, #4
				ldr		r1, =0x0202
				ldr		r0, =0x1010*7+0x0201
				bl		BgScIncSet16

				mov		r1, #5			; BG_PLTT = 0xffff
				lsl		r1, #24
				mvn		r0, r1
				strh	r0, [r1, #0]

				mov		r0, #0
				bl		HilitePlttCopy
				mov		r0, #1
				bl		HilitePlttCopy

				bl		LogoOamCopy

				add		sp, #20
				pop		{r4-r7, pc}

;	ENDIF

;--------------------------------------------------------------------
;-				mS Zbg	(r0=Datap)				-
;--------------------------------------------------------------------
;	IF :DEF: SYSCALL_ASM
		EXTERN	Diff16bitUnFilter

		EXTERN	Nin_BitUnPackParam
		GLOBAL	NintendoLogoSet0
		GLOBAL	NintendoLogoSet1
		GLOBAL	NintendoLogoSet2
		CODE16
NintendoLogoSet0
				push	{r0,r4-r7, lr}

				ldr		r4, =INTR_CHECK_BUF - 1
				strb	r0, [r4, #0]

				bl		NintendoLogoHeaderCopy

				ldr		r0, [sp, #0]		; r0:  Datap
				ldr		r1, =CharTmpBuf+36
				mov		r2, #MON_NINLOGO_SIZE/2
				bl		CpuSet16_32

				ldr		r0, =CharTmpBuf
				ldr		r1, =CharTmpBuf+0x1000
				bl		HuffUnComp32_T

				ldr		r0, =CharTmpBuf+0x1000
				ldr		r2, =0x0000d082
				str		r2, [r0,#0]

				ldr		r1, =CharTmpBuf
				bl		DiffUnFilter16_16

				pop		{r0,r4-r7, pc}

NintendoLogoSet1
				push	{r0,r4-r7, lr}

				ldr		r0, =CharTmpBuf
				ldr		r1, =CharTmpBuf+0x1000
				ldr		r2, =Nin_BitUnPackParam
				bl		BitUnPack32_T

				pop		{r0,r4-r7, pc}

NintendoLogoSet2
				push	{r0,r4-r7, lr}

				ldr		r6, =CharTmpBuf+0x1000
				ldr		r4, =BG_VRAM+0x2000+8*8*(1+16+2)

				mov		r7, #2				; for (i=2; --i>=0; )
NintendoLogoSet_10
				mov		r5, #8*8*13/4/4		;	for (ii=0; ii<8*8*13/4; ii++)
NintendoLogoSet_20
				ldmia	r6!, {r0-r3}
				stmia	r4!, {r0-r3}
				sub		r5, #1
				bgt		NintendoLogoSet_20

				add		r4, #0xc0
				sub		r7, #1
				bgt		NintendoLogoSet_10

				mov		r7, #3				; for (i=3; i>=0; i--)
NintendoLogoSet_30
				lsl		r3, r7, #10			; i*8*8*16
				ldr		r0, =BG_VRAM+0x2000+8*8*1
				add		r0, r3
				ldr		r1, =OBJ_MODE0_VRAM+0x1a0*8*8
				add		r1, r3
				mov		r2, #1				; 8*8*16/2
				lsl		r2, #8
;				bl		CpuSet16_32
				bl		CpuFastSet32_T
				sub		r7, #1
				bgt		NintendoLogoSet_30

				mov		r0,  sp				; ޯ̧ ر
				str		r7, [r0]
				ldr		r1, =CharTmpBuf
				mov		r2, #0x10*2/4
				lsl		r2, #8
				bl		CpuFastClear32_Call_10

NintendoLogoSet_End
				pop		{r0,r4-r7, pc}

;	ENDIF

;--------------------------------------------------------------------
;-				WX^q`l Zbg (r0=ResetFlags)			-
;--------------------------------------------------------------------
DMA_CLEAR32_DEFAULT		*   (DMA_ENABLE + DMA_SRC_FIX + DMA_32BIT_BUS)	; DmaClear ̫ޯ
;	IF :DEF: SYSCALL_ASM
		GLOBAL	RegisterRamReset32
		CODE16
RegisterRamReset32
				push 	{r4-r7, lr}
				sub		sp, #4
				mov		r7, r0					; r7:  ResetFlags

				ldr		r5, =DMA_CLEAR32_DEFAULT ;r5:  DMA_CLEAR32_DEFAULT
				mov		r4, #4					; r4:  REG_BASE = 0x04000000
				lsl		r4, #24
				mov		r3, #0					; *sp = 0
				str		r3, [sp, #0]

				mov		r1, #DISP_LCDC_OFF		; LCDC OFF
				strh	r1, [r4, #0]

RegisterRamReset32_00
				mov		r6, #RESET_REG_FLAG		; r6:  ResetCheck
				tst		r6, r7
				beq		RegisterRamReset32_10

				lsr		r1, r4, #17				; r1:  REG_IE
				add		r1, r4
;				ldr		r1, =REG_IE				; CpuFastClear32(0, REG_IE, 0x20)
				mov		r2, #0x20/4
				bl		CpuFastClear32_Call
				sub		r1, #0x20				; r1:  REG_IE
				mvn		r0, r2					; r0:  0xffffffff
				strh	r0, [r1, #2]			; REG_IF = 0xffff

				lsr		r1, r4, #16				; OBJ]Sړ
				add		r1, r4
				strb	r0, [r1, #0x10]			; REG_OBJ_CENTER = 0xff

				add		r1, r4, #4				; CpuFastClear32(0, REG_BASE+4, OFFSET_REG_SOUND1CNT-4)
				mov		r2, #0x20/4
				bl		CpuFastClear32_Call
				sub		r1, #4
				mov		r2, #0x20*2/4
				bl		CpuFastClear32_Call

				mov		r1, #OFFSET_REG_DMA0	; CpuFastClear32(0, REG_DMA0, REG_SIOMLT_RECV-REG_DMA0-0x10)
				add		r1, r4
				mov		r2, #0x20*3/4
				bl		CpuFastClear32_Call
				str		r2, [r1, #0x20]			; REG_KEYINPUT = REG_KEYCNT = 0

				lsr		r0, r4, #18				; r0:  0x0100
				strh	r0, [r4, #0x20]			; REG_BG2PA = 0x0100
				strh	r0, [r4, #0x30]			; REG_BG3PA = 0x0100
				strh	r0, [r4, #0x26]			; REG_BG2PD = 0x0100
				strh	r0, [r4, #0x36]			; REG_BG3PD = 0x0100

RegisterRamReset32_10
				mov		r6, #RESET_REG_SIO_FLAG	; r6:  ResetCheck
				ldr		r1, =REG_SIOMLT_RECV-0x10 ; CpuFastClear32(0, REG_SIOMLT_RECV-0x10, 0x20)
				mov		r2, #0x20/4
				bl		CpuFastClear32_Call
				lsr		r2, r4, #11				; REG_RCNT = 0x8000;
				strh	r2, [r1, #4]
				add		r1, #0x10				; CpuFastClear32(0, REG_JOYCNT, 0x20)
				mov		r2, #0x07
				strb	r2, [r1, #0]			; JIF ؾ
				bl		CpuFastClear32_Call

RegisterRamReset32_20
				mov		r6, #RESET_REG_SOUND_FLAG	; r6:  ResetCheck
				tst		r6, r7
				beq		RegisterRamReset32_30

				mov		r1, #OFFSET_REG_SOUNDCNT ;r1:  REG_SOUNDCNT
				add		r1, r4
				ldr		r0, =0x880e0000
				strb	r0, [r1, #4]			; S OFF
				strb	r1, [r1, #4]			; S ON, r1=0x80
				str		r0, [r1, #0] 			; FIFO ؾ
				ldrh	r0, [r1, #8] 			; ޻ݸގg ؾ
				lsl		r0, #32-10
				lsr		r0, #32-10
				strh	r0, [r1, #8]

				sub		r1, #0x10				; r1:	REG_SOUND3CNT
				strb	r1,	[r1, #0]			; g`RAM ݸ 1, r1=0x70
				add		r1, #0x20				; g`RAM = 0
				mov		r2, #0x20/4
				bl		CpuFastClear32_Call

				sub		r1, #0x40				; r1:	REG_SOUND3CNT
				strb	r2,	[r1, #0]			; g`RAM ݸ 0, r2=0
				add		r1, #0x20				; g`RAM = 0
				mov		r2, #0x20/4
				bl		CpuFastClear32_Call

				mov		r2, #0
				mov		r1, #OFFSET_REG_SOUNDCNT ;r1:  REG_SOUNDCNT
				add		r1, r4
				strb	r2, [r1, #4]			; S OFF, r2 = 0

RegisterRamReset32_30
				mov		r6, #RESET_EX_WRAM_FLAG
				lsr		r1, r4, #1				; CpuFastClear32(0, EX_WRAM, EX_WRAM_SIZE)
				lsr		r2, r4, #8 + 2			; EX_WRAM  = 0x02000000
				bl		CpuFastClear32_Call		; EX_WRAM_SIZE/4 = 0x40000/4 = 0x10000

				mov		r6, #RESET_VRAM_FLAG
				mov		r1, #6					; CpuFastClear32(0, VRAM, VRAM_SIZE)
				lsl		r1, #24					; VRAM     = 0x06000000
				lsr		r2, r1, #10 + 2			; VRAM_SIZE/4 = 0x18000/4 = 0x6000
				bl		CpuFastClear32_Call

				mov		r6, #RESET_OAM_FLAG
				mov		r1, #7					; CpuFastClear32(0, OAM, OAM_SIZE)
				lsl		r1, #24					; OAM      = 0x07000000
				lsr		r2, r4, #16 + 2			; OAM_SIZE/4 = 0x400/4 = 0x100
				bl		CpuFastClear32_Call

				mov		r6, #RESET_PLTT_FLAG
				mov		r1, #5					; CpuFastClear32(0, PLTT, PLTT_SIZE)
				lsl		r1, #24					; PLTT     = 0x05000000
				lsr		r2, r4, #16 + 2			; PLTT_SIZE/4 = 0x400/4 = 0x100
				bl		CpuFastClear32_Call

				mov		r6, #RESET_CPU_WRAM_FLAG
				mov		r1, #3					; CpuFastClear32(0, CPU_WRAM, CPU_WRAM_SIZE-4*128)
				lsl		r1, #24					; CPU_WRAM = 0x03000000
				ldr		r2, =((CPU_WRAM_SIZE-4*128)/4)
				bl		CpuFastClear32_Call

				add		sp, #4
				pop		{r4-r7}
				pop		{r3}
				bx		r3

CpuFastClear32_Call
				tst		r6, r7
				bne		CpuFastClear32_Call_10
				bx		lr
CpuFastClear32_Call_10
				mov		r0, sp
				orr		r2, r5
				b		CpuFastSet32_T
;	ENDIF

		LTORG

;--------------------------------------------------------------------
;-			bot Zbg (r0=Srcp, r1=Destp, r2=DmaCntData)		-
;--------------------------------------------------------------------
;	IF :DEF: SYSCALL_ASM
		GLOBAL	CpuSet16_32
		CODE16
CpuSet16_32		push	{r4, r5, lr}

				lsl		r4, r2, #11				; r4:  Count = DmaCntData & 0x1fffff
				lsr		r4, #11-2

				bl		SrcpCheck16_32			; ڽ 
				beq		CpuSet16_32_End

CpuSet16_32_00	mov		r5, #0					; r5:  i = 0

				lsr		r3, r2, #27				; if ((DmaCntData) & DMA_32BIT_BUS)
				bcc		CpuSet16_32_30

				add		r5,	r1, r4				; r5: DestEndp = Destp + Count*4

				lsr		r3, r2, #25				; if ((DmaCntData) & DMA_SRC_FIX)
				bcc		CpuSet16_32_20

				ldmia	r0!, {r3}
CpuSet16_32_10	cmp		r1, r5					; while (Destp < DestEndp)
				bge		CpuSet16_32_End
				stmia	r1!, {r3}				; *((vu32 *)(Destp))++ = *((vu32 *)(Srcp))
				b		CpuSet16_32_10

CpuSet16_32_20	cmp		r1, r5					; while (Destp < DestEndp)
				bge		CpuSet16_32_End
				ldmia	r0!, {r3}				; *((vu32 *)(Destp))++ = *((vu32 *)(Srcp))++
				stmia	r1!, {r3}
				b		CpuSet16_32_20

CpuSet16_32_30	lsr		r4, #1

				lsr		r3, r2, #25				; if ((DmaCntData) & DMA_SRC_FIX)
				bcc		CpuSet16_32_50

				ldrh	r3, [r0, #0]
CpuSet16_32_40	cmp		r5, r4					; for ( ; i<Count; i++)
				bge		CpuSet16_32_End
				strh	r3, [r1, r5]			; ((vu16 *)(Destp))[i] = ((vu16 *)(Srcp))[0]
				add		r5, #2
				b		CpuSet16_32_40

CpuSet16_32_50	cmp		r5, r4					; for ( ; i<Count; i++)
				bge		CpuSet16_32_End
				ldrh	r3, [r0, r5]			; ((vu16 *)(Destp))[i] = ((vu16 *)(Srcp))[i]
				strh	r3, [r1, r5]
				add		r5, #2
				b		CpuSet16_32_50

CpuSet16_32_End	pop		{r4, r5}
				pop		{r3}
				bx      r3
;	ENDIF


;--------------------------------------------------------------------
;-	\[XAhX `FbN 16bitC^tF[X(r4=Count  r12)	-
;--------------------------------------------------------------------
;	IF :DEF: SYSCALL_ASM
		GLOBAL	SrcpCheck16_32
		CODE16
SrcpCheck16_32	adr		r3, SrcpCheck
				mov		r12,r4
				bx		r3
;--------------------------------------------------------------------
;-	\[XAhX `FbN (r0=Srcp,r12=Count  ZtO)			-
;--------------------------------------------------------------------
		GLOBAL	SrcpCheck
		ALIGN
		CODE32
SrcpCheck		cmp		r12, #0					; if (!Count)
				beq		SrcpCheck_End

				bic		r12, r12,#0xfe000000
				add		r12, r0, r12			; r12: SrcEndp  = Srcp  + Count

	IF :DEF: MON_ONLY
	ELSE
				mov		r3, #REG_BASE			; /հ 
				ldrb	r3, [r3, #0x300]
				teq		r3, #1
				bne		SrcpCheck_End
	ENDIF
				tst		r0, #0x0e000000			; Srcp 
				tstne	r12,#0x0e000000			; SrcEndp 

SrcpCheck_End	bx      lr

;	ENDIF


;--------------------------------------------------------------------
;-	bot Zbg(32Byte) (r0=Srcp, r1=Destp, r2=DmaCntData)	-
;--------------------------------------------------------------------
;	IF :DEF: SYSCALL_ASM
		GLOBAL	CpuFastSet32_T
		GLOBAL	CpuFastSet32
		CODE16
CpuFastSet32_T	mov		r3, pc
				bx		r3
		ALIGN
		CODE32
CpuFastSet32	stmfd   sp!, {r4-r10, lr}

				mov		r10, r2,  lsl #11		; r10: Count = DmaCntData & 0x1fffff

				movs	r12, r10, lsr #11-2		; r12: SrcCount
				bl		SrcpCheck				; ڽ 
				beq		CpuFastSet32_End

				add		r10, r1, r10, lsr #11-2	; r10: DestEndp = Destp + Count

CpuFastSet32_00	movs	r2,  r2,  lsr #25		; if ((DmaCntData) & DMA_SRC_FIX)
				bcc		CpuFastSet32_20

				ldr		r2, [r0, #0]
				mov		r3, r2
				mov		r4, r2
				mov		r5, r2
				mov		r6, r2
				mov		r7, r2
				mov		r8, r2
				mov		r9, r2
CpuFastSet32_10	cmp		r1, r10					; while (Destp < DestEndp)
				stmltia	r1!, {r2-r9}			; *((vu32 *)(Destp++)) = *((vu32 *)(Srcp))
				blt		CpuFastSet32_10
				b		CpuFastSet32_End

CpuFastSet32_20	cmp		r1, r10					; while (Destp < DestEndp)
				ldmltia	r0!, {r2-r9}			; *((vu32 *)(Destp)++) = *((vu32 *)(Srcp)++)
				stmltia	r1!, {r2-r9}
				blt		CpuFastSet32_20

CpuFastSet32_End
				ldmfd   sp!, {r4-r10, lr}
				bx      lr
;	ENDIF


;--------------------------------------------------------------------
;-	afAtBϊp[^ Zbg (r0=Srcp, r1=Destp, r2=Num)	-
;--------------------------------------------------------------------
;	IF :DEF: SYSCALL_ASM
;		EXTERN	Sin256Tbl
		GLOBAL	BgAffineSet32
		ALIGN
		CODE32
BgAffineSet32
				stmfd   sp!, {r4-r11}

BgAffineSet32_10
				subs	r2, r2, #1				; I`FbN
				blt		BgAffineSet32_End

				ldrh	r3, [r0, #16]			; 
				mov		r3, r3, lsr #8

				adr		r12, Sin256Tbl
				add		r8, r3, #0x40			; r11: Cos
				and		r8, r8, #0xff
				mov		r8, r8, lsl #1
				ldrsh	r11, [r8, r12]
				mov		r8, r3, lsl #1			; r12: Sin
				ldrsh	r12, [r8, r12]

				ldrsh	r9, [r0, #12]			; r9:  RatioX
				ldrsh	r10,[r0, #14]			; r10: RatioY

				mul		r8, r11,r9				; r3:  Cos_RatioX_8
				mov		r3, r8, asr #14
				mul		r8, r12,r9				; r4:  Sin_RatioX_8
				mov		r4, r8, asr #14
				mul		r8, r12,r10				; r5:  Sin_RatioY_8
				mov		r5, r8, asr #14
				mul		r8, r11,r10				; r6:  Cos_RatioY_8
				mov		r6, r8, asr #14

				ldmia	r0, {r9, r10, r12}
				mov		r11, r12, lsl #16
				mov		r11, r11, asr #16
				mov		r12, r12, asr #16
;				ldr		r9, [r0, #0]			; r9:  SrcCenterX
;				ldr		r10,[r0, #4]			; r10: SrcCenterY
;				ldrsh	r11,[r0, #8]			; r11: DispCenterX
;				ldrsh	r12,[r0, #10]			; r12: DispCenterY

				rsb		r8, r11,#0				; StartX
				mla		r9, r3, r8, r9
				mla		r8, r4, r12,r9
				str		r8, [r1, #8]

				rsb		r8, r11, #0				; StartY
				mla		r10,r5, r8, r10
				rsb		r8, r12,#0
				mla		r8, r6, r8, r10
				str		r8, [r1, #12]

				strh	r3, [r1, #0]			; H_DiffX
				rsb		r4,  r4, #0				; V_DiffX
				strh	r4, [r1, #2]
				strh	r5, [r1, #4]			; H_DiffY
				strh	r6, [r1, #6]			; V_DiffY

				add		r0, r0, #0x14			; r0:  AffineSrcp++
				add		r1, r1, #0x10			; r1:  AffineDestp++

				b		BgAffineSet32_10

BgAffineSet32_End
				ldmfd	sp!, {r4-r11}
				bx      lr
;	ENDIF


;--------------------------------------------------------------------
;- naiAtBϊp[^ (r0=Srcp,r1=Destp,r2=Num,r3=Offset) -
;--------------------------------------------------------------------
;	IF :DEF: SYSCALL_ASM
;		EXTERN	Sin256Tbl
		GLOBAL	ObjAffineSet32
		ALIGN
		CODE32
ObjAffineSet32
				stmfd   sp!, {r8-r11}

;				and		r3, r2, #0xff			; r3:  AddrOffset
;				mov		r2, r2, asr #8			; r2:  ArrayNum
ObjAffineSet32_10
				subs	r2, r2, #1				; I`FbN
				blt		ObjAffineSet32_End

				ldrh	r9, [r0, #4]			; 
				mov		r9, r9, lsr #8

				adr		r12, Sin256Tbl
				add		r8, r9, #0x40			; r11: Cos
				and		r8, r8, #0xff
				mov		r8, r8, lsl #1
				ldrsh	r11, [r8, r12]
				mov		r8, r9, lsl #1			; r12: Sin
				ldrsh	r12, [r8, r12]

				ldrsh	r9, [r0, #0]			; r9:  RatioX
				ldrsh	r10,[r0, #2]			; r10: RatioY

				mul		r8, r11,r9				;  Cos_RatioX_8
				mov		r8, r8, asr #14
				strh	r8, [r1], r3
				mul		r8, r12,r9				; -Sin_RatioX_8
				mov		r8, r8, asr #14
				rsb		r8, r8, #0
				strh	r8, [r1], r3
				mul		r8, r12,r10				;  Sin_RatioY_8
				mov		r8, r8, asr #14
				strh	r8, [r1], r3
				mul		r8, r11,r10				;  Cos_RatioY_8
				mov		r8, r8, asr #14
				strh	r8, [r1], r3

				add      r0,r0,#8				; r0: AffineSrcp++

				b		ObjAffineSet32_10
ObjAffineSet32_End
				ldmfd	sp!, {r8-r11}
				bx      lr

;	ENDIF


		INCLUDE	crt0SinTable.s


;--------------------------------------------------------------------
;-		Bitkf[^WJ (r0=Srcp, r1=Destp, r2=BitUnPackParamp)	-
;--------------------------------------------------------------------
;	IF :DEF: SYSCALL_ASM
		GLOBAL	BitUnPack32_T
		GLOBAL	BitUnPack32
		CODE16
BitUnPack32_T	mov		r3, pc
				bx		r3
		ALIGN
		CODE32
BitUnPack32
				stmfd   sp!, {r4-r11, lr}
				sub		sp, sp, #8

				ldrh	r7, [r2, #0]			; r7:  SrcNum    = BitUnPackParamp->SrcNum

				movs	r12, r7					; r12: SrcCount
				bl		SrcpCheck				; ڽ 
				beq		BitUnPack32_End

BitUnPack32_00	ldrb	r6, [r2, #2]			; r6:  SrcBitNum = BitUnPackParamp->SrcBitNum
				rsb		r10, r6, #8				; r10: SrcBitNumInv = 8 - SrcBitNum
				mov		r14, #0					; r14: DestBak = 0
				ldr		r11, [r2, #4]			; r8:  DestOffset0_On
				mov		r8, r11, lsr #31		;       = BitUnPackParamp->DestOffset0_On
				ldr		r11,[r2, #4]			;      DestOffset = BitUnPackParamp->DestOffset
				mov		r11,r11, lsl #1
				mov		r11,r11, lsr #1
				str		r11,[sp, #4]
				ldrb	r2, [r2, #3]			; r2:  DestBitNum = BitUnPackParamp->DestBitNum
;				str		r2, [sp, #0]
				mov		r3, #0					; r3:  DestBitCount = 0

BitUnPack32_10	subs	r7, r7, #1				; while (--SrcNum >= 0)
				blt		BitUnPack32_End

				mov		r11, #0xff				; r5:  SrcMask = 0xff >> SrcBitNumInv
				mov		r5, r11, asr r10
				ldrb	r9, [r0], #1			; r9:  SrcTmp = *Srcp++
				mov		r4, #0					; r4:  SrcBitCount = 0

BitUnPack32_20	cmp		r4, #8					; while (SrcBitCount < 8)
				bge		BitUnPack32_10

				and		r11, r9, r5				; r12: DestTmp = ((SrcTmp&SrcMask) >>SrcBitCount)
				movs	r12, r11, lsr r4
;				bne		BitUnPack32_30			; if (DestTmp != 0 || DestOffset0_On)
				cmpeq	r8,  #0
				beq		BitUnPack32_40

BitUnPack32_30	ldr		r11, [sp, #4]			;      DestTmp += DestOffset
				add		r12, r12, r11
BitUnPack32_40	orr		r14, r14, r12, lsl r3	;      DestBak |= DestTmp << DestBitCount
;				ldr		r11, [sp, #0]			;      DestBitCount += DestBitNum
				add		r3, r3, r2

				cmp		r3, #0x20				; if (DestBitCount >= 32)
				blt		BitUnPack32_50

				str		r14, [r1], #4			;     *Destp++ = DestBak
				mov		r14, #0					;      DestBak = 0
				mov		r3,  #0					;      DestBitCount = 0

BitUnPack32_50	mov		r5, r5, lsl r6			;      SrcMask    <<= SrcBitNum
				add		r4, r4, r6				;      SrcBitCount += SrcBitNum
				b		BitUnPack32_20

BitUnPack32_End	add		sp, sp, #8
				ldmfd	sp!, {r4-r11, lr}
				bx      lr
;	ENDIF


;--------------------------------------------------------------------
;-			nt}f[^WJi32Bit32Bitj(r0=Srcp, r1=Destp)	-
;--------------------------------------------------------------------
;	IF :DEF: SYSCALL_ASM
		GLOBAL	HuffUnComp32_T
		GLOBAL	HuffUnComp32
		CODE16
HuffUnComp32_T	mov		r3, pc
				bx		r3
		ALIGN
		CODE32
HuffUnComp32
				stmfd   sp!, {r4-r11, lr}
				sub		sp, sp, #8

				movs	r12, #0x2000000
				bl		SrcpCheck				; ڽ 
				beq		HuffUnComp32_End

				add		r2, r0, #4				; r2:  *Treep = (u8 *)Srcp + 4
				add		r7, r2, #1				; r7:  *TreeStartp = Treep + 1
				ldrb	r10,[r0, #0]			; r4:  DataBit = *(u8 *)Srcp & 0x0f
				and		r4, r10, #0xf
				mov		r3, #0					; r3:  DestTmp = 0
				mov		r14,#0					; r14: DestTmpCount = 0
				and		r10,r4,  #7				;      DestTmpDataNum = 4 + (DataBit & 0x7)
				add		r11,r10, #4
				str		r11,[sp, #4]
;				rsb		r11,r4,  #32			;      DestTopShift   = 32 - DataBit
;				str     r11,[sp,#0]
				ldr		r10,[r0, #0]			; r12: DestCount = *Srcp >> 8
				mov		r12,r10, lsr #8
				ldrb	r10,[r2, #0]			; r0:  Srcp  = (u32 *)(Treep + ((*Treep + 1) << 1))
				add		r10,r10, #1
				add		r0, r2, r10, lsl #1
				mov		r2, r7					;      Treep = TreeStartp

HuffUnComp32_10	cmp		r12, #0					; while (DestCount > 0)
				ble		HuffUnComp32_End

				mov		r8,	 #32				; r8:  SrcCount = 32
				ldr		r5, [r0], #4			; r5:  SrcTmp = *Srcp++

HuffUnComp32_20	subs	r8, r8,  #1				; while (--SrcCount >= 0)
				blt		HuffUnComp32_10

				mov		r10,#1					; r9:  TreeShift = (SrcTmp >> 31) & 0x1
				and		r9, r10, r5, lsr #31
				ldrb	r6, [r2, #0]			; r6:  TreeCheck = *Treep
				mov		r6, r6, lsl r9			; r10: TreeCheck <<= TreeShift
				mov		r10,r2, lsr #1			; r2:  Treep = (u8 *)((((u32 )Treep>>1) <<1)
				mov		r10,r10,lsl #1			;            + (((*Treep & 0x3f)+1) <<1)+TreeShift)
				ldrb	r11,[r2,#0]
				and		r11,r11,#0x3f
				add		r11,r11,#1
				add		r10,r10,r11,lsl #1
				add		r2, r10,r9

				tst		r6, #0x80				; if (TreeCheck & TREE_END)
				beq		HuffUnComp32_30

				mov		r3, r3, lsr r4			; r3:  DestTmp >>= DataBit
				ldrb	r10,[r2, #0]			;      DestTmp |= *Treep << DestTopShift
				rsb		r11, r4,  #32
;				ldr		r11,[sp, #0]
				orr		r3, r3, r10, lsl r11
				mov		r2, r7					;      Treep = TreeStartp
				add		r14,r14,#1				; if (++DestTmpCount == DestTmpDataNum) 
				ldr		r11,[sp, #4]
				cmp		r14,r11

				streq	r3, [r1], #4			; r1:  *Destp++ = DestTmp
				subeq	r12,r12,  #4			;       DestCount -= 4
				moveq	r14,#0					;       DestTmpCount = 0

HuffUnComp32_30	cmp		r12,#0					; if (DestCount <= 0)	break;
				movgt	r5, r5, lsl #1			; r5:  SrcTmp <<= 1
				bgt		HuffUnComp32_20
				b		HuffUnComp32_10

HuffUnComp32_End
				add		sp, sp, #8
				ldmfd	sp!, {r4-r11, lr}
				bx      lr
;	ENDIF


;--------------------------------------------------------------------
;-			kyVVf[^WJi8Bit8Bitj(r0=Srcp, r1=Destp)		-
;--------------------------------------------------------------------
;	IF :DEF: SYSCALL_ASM
		GLOBAL	LZ77UnComp8_T
		GLOBAL	LZ77UnComp8
		CODE16
LZ77UnComp8_T	mov		r3, pc
				bx		r3
		ALIGN
		CODE32
LZ77UnComp8
				stmfd   sp!, {r4-r6, lr}

				ldr		r5, [r0], #4			; r2:  DestCount = *(u32 *)Srcp >> 8
				mov		r2, r5, lsr #8			; r0:  Srcp += 4

				movs	r12, r2					; r12: SrcCount
				bl		SrcpCheck				; ڽ 
				beq		LZ77UnComp8_End

LZ77UnComp8_10	cmp		r2, #0					; while (DestCount > 0)
				ble		LZ77UnComp8_End

				ldrb	r14, [r0], #1			; r14: Flags = *Srcp++
				mov		r4, #8					; for (i=8; --i>=0; )
LZ77UnComp8_20	subs	r4, r4, #1
				blt		LZ77UnComp8_10

				tst		r14, #0x80				; if (!(Flags & 0x80))
				bne		LZ77UnComp8_30

				ldrb	r6, [r0], #1			;      *Srcp++
				strb	r6, [r1], #1			; r1:  *Destp++
				sub		r2, r2, #1				;       DestCount--
				b		LZ77UnComp8_50

LZ77UnComp8_30	ldrb	r5, [r0, #0]			; r3:  Length = (*Srcp >> 4) + 3
				mov		r6, #3
				add		r3, r6, r5, asr #4
				ldrb	r6, [r0], #1			; r12: Offset = (*Srcp++ & 0x0f) << 8
				and		r5, r6, #0xf
				mov		r12,r5, lsl #8
				ldrb	r6, [r0], #1			;      Offset = (Offset | *Srcp++) + 1
				orr		r5, r6, r12
				add		r12, r5, #1
				sub		r2, r2, r3				;      DestCount -= Length

LZ77UnComp8_40	ldrb	r5, [r1, -r12]			;     *Destp++ = Destp[-Offset]
				strb	r5, [r1], #1
				subs	r3, r3, #1				; while (--Length > 0)
				bgt		LZ77UnComp8_40

LZ77UnComp8_50	cmp		r2, #0					; if (DestCount <= 0)	break;
				movgt	r14, r14, lsl #1		;      Flags <<= 1
				bgt		LZ77UnComp8_20
				b		LZ77UnComp8_10

LZ77UnComp8_End	ldmfd	sp!, {r4-r6, lr}
				bx      lr
;	ENDIF


;--------------------------------------------------------------------
;-			kyVVf[^WJi8Bit16Bitj(r0=Srcp, r1=Destp)	-
;--------------------------------------------------------------------
;	IF :DEF: SYSCALL_ASM
		GLOBAL	LZ77UnComp16
		ALIGN
		CODE32
LZ77UnComp16
				stmfd   sp!, {r4-r10, lr}

				mov		r3, #0					; r3:  DestTmp = 0
				ldr		r8, [r0], #4			; r10: DestCount = *(u32 *)Srcp >> 8
				mov		r10, r8, lsr #8			; r0:  Srcp += 4
				mov		r2, #0					; r2:  Shift = 0

				movs	r12, r10				; r12: SrcCount
				bl		SrcpCheck				; ڽ 
				beq		LZ77UnComp16_End

LZ77UnComp16_10	cmp		r10, #0					; while (DestCount > 0)
				ble		LZ77UnComp16_End

				ldrb	r6, [r0], #1			; r6:  Flags = *Srcp++
				mov		r7, #8					; for (i=8; --i>=0; )
LZ77UnComp16_20	subs	r7, r7, #1
				blt		LZ77UnComp16_10

				tst		r6, #0x80				; if (!(Flags & 0x80))
				bne		LZ77UnComp16_30

				ldrb	r9, [r0], #1			;      DestTmp |= *Srcp++ << Shift
				orr		r3, r3, r9, lsl r2
				sub		r10, r10, #1			;      DestCount--

				eors	r2, r2, #8				; if (!(Shift ^= 8))
				streqh	r3, [r1], #2			;     *Destp++ = DestTmp
				moveq	r3, #0					;      DestTmp = 0
				b		LZ77UnComp16_50

LZ77UnComp16_30	ldrb	r9, [r0, #0]			; r5:  Length = (*Srcp >> 4) + 3
				mov		r8, #3
				add		r5, r8, r9, asr #4
				ldrb	r9, [r0], #1			; r4:  Offset = (*Srcp++ & 0x0f) << 8
				and		r8, r9, #0xf
				mov		r4, r8, lsl #8
				ldrb	r9, [r0], #1			;      Offset = (Offset | *Srcp++) + 1
				orr		r8, r9, r4
				add		r4, r8, #1
				rsb		r8, r2, #8				; r14: Offset0_8 = (8 - Shift)
				and		r9, r4, #1				;                ^ ((Offset & 1) << 3)
				eor		r14, r8, r9, lsl #3
				sub		r10, r10, r5			;      DestCount -= Length

LZ77UnComp16_40	eor		r14, r14, #8			;      Offset0_8 ^= 8
				rsb		r8, r2, #8				;      DestTmp |= (Destp[-((Offset
				add		r8, r4, r8, lsr #3		;                   + ((8 - Shift) >> 3)) >> 1)]
				mov		r8, r8, lsr #1
				mov		r8, r8, lsl #1
				ldrh	r9, [r1, -r8]
				mov		r8, #0xff
				and		r8, r9, r8, lsl r14
				mov		r8, r8, asr r14
				orr		r3, r3, r8, lsl r2
				eors	r2, r2, #8				; if (!(Shift ^= 8))
				streqh	r3, [r1], #2			;     *Destp++ = DestTmp
				moveq	r3, #0					;      DestTmp = 0

				subs	r5, r5, #1				; while (--Length > 0)
				bgt		LZ77UnComp16_40

LZ77UnComp16_50	cmp		r10, #0					; if (DestCount <= 0)	break;
				movgt	r6, r6, lsl #1			; Flags <<= 1
				bgt		LZ77UnComp16_20
				b		LZ77UnComp16_10

LZ77UnComp16_End
				ldmfd	sp!, {r4-r10, lr}
				bx      lr
;	ENDIF


;--------------------------------------------------------------------
;-		OXf[^WJi8Bit8Bitj(r0=Srcp, r1=Destp)		-
;--------------------------------------------------------------------
;	IF :DEF: SYSCALL_ASM
		GLOBAL	RLUnComp8
		CODE16
RLUnComp8
				push	{r4-r7, lr}

				ldmia	r0!, {r3}				; r7:  DestCount = *(u32 *)Srcp >> 8
				lsr		r7, r3, #8				; r0:  Srcp += 4

				mov		r4, r7					; r4: Count
				bl		SrcpCheck16_32			; ڽ 
				beq		RLUnComp8_End

RLUnComp8_10	cmp		r7, #0					; while (DestCount > 0)
				ble		RLUnComp8_End

				ldrb	r4, [r0, #0]			; r4:  Flags = *Srcp++
				add		r0, #1
				lsl		r2, r4, #25				; r2:  Length = Flags & 0x7f
				lsr		r2, #25
				lsr		r3, r4, #8				; if (!(Flags & 0x80))
				bcs		RLUnComp8_30

				add		r2, #1					;      Length++
				sub		r7, r2					;      DestCount -= Length
RLUnComp8_20	ldrb	r3, [r0, #0]			;     *Destp++ = *Srcp++
				strb	r3, [r1, #0]
				add		r0, #1
				add		r1, #1
				sub		r2, r2, #1				; while (--Length > 0)
				bgt		RLUnComp8_20
				b		RLUnComp8_10

RLUnComp8_30	add		r2, #3					;      Length += 3
				sub		r7, r2					;      DestCount -= Length
				ldrb	r5, [r0, #0]			;      SrcTmp  = *Srcp++
				add		r0, #1
RLUnComp8_40	strb	r5, [r1, #0]			;     *Destp++ =  SrcTmp
				add		r1, #1
				sub		r2, r2, #1				; while (--Length > 0)
				bgt		RLUnComp8_40
				b		RLUnComp8_10

RLUnComp8_End	pop		{r4-r7}
				pop		{r3}
				bx		r3

;	ENDIF


;--------------------------------------------------------------------
;-		OXf[^WJi8Bit16Bitj(r0=Srcp, r1=Destp)	-
;--------------------------------------------------------------------
;	IF :DEF: SYSCALL_ASM
		GLOBAL	RLUnComp16
		CODE16
RLUnComp16
				push	{r4-r7, lr}
				sub		sp, #0xc

				mov		r7, #0					; r7:  DestTmp = 0
				ldmia	r0!, {r3}				; r5:  DestCount = *(u32 *)Srcp >> 8
				lsr		r5, r3, #8				; r0:  Srcp += 4

				mov		r4, r5					; r4: Count
				bl		SrcpCheck16_32			; ڽ 
				beq		RLUnComp16_End

				mov		r4, #0					; r4:  Shift = 0
RLUnComp16_10	cmp		r5, #0					; while (DestCount > 0)
				ble		RLUnComp16_End

				ldrb	r3, [r0,  #0]			;      Flags = *Srcp++
				str		r3, [sp, #4]
				add		r0, #1
				ldr		r3, [sp, #4]			; r2:  Length = Flags & 0x7f
				lsl		r2, r3,#25
				lsr		r2, #25

				ldr		r6, [sp, #4]			; if (!(Flags & 0x80))
				lsr		r3, r6, #8
				bcs		RLUnComp16_40

				add		r2, #1					;      Length++
				sub		r5, r2					;      DestCount -= Length
RLUnComp16_20	ldrb	r6, [r0, #0]			;      DestTmp |= *Srcp++ << Shift
				lsl		r6, r4
				orr		r7, r6
				add		r0, #1
				mov		r3, #8					; if (!(Shift ^= 8))
				eor		r4, r3
				bne		RLUnComp16_30
				strh	r7, [r1, #0]			;     *Destp++ = DestTmp
				add		r1, #2
				mov		r7, #0					;      DestTmp = 0
RLUnComp16_30	sub		r2, r2, #1				; while (--Length > 0)
				bgt		RLUnComp16_20
				b		RLUnComp16_10

RLUnComp16_40	add		r2, #3					;      Length += 3
				sub		r5, r2					;      DestCount -= Length
				ldrb	r6, [r0, #0]			;      SrcTmp  = *Srcp++
				str		r6, [sp, #8]
				add		r0, #1

RLUnComp16_50	ldr		r6, [sp, #8]			;      DestTmp |= SrcTmp  << Shift
				lsl		r6, r4
				orr		r7, r6
				mov		r3, #8					; if (!(Shift ^= 8))
				eor		r4, r3
				bne		RLUnComp16_60
				strh	r7, [r1, #0]			;     *Destp++ = DestTmp
				add		r1, #2
				mov		r7, #0					;      DestTmp = 0
RLUnComp16_60	sub		r2, r2, #1				; while (--Length > 0)
				bgt		RLUnComp16_50
				b		RLUnComp16_10

RLUnComp16_End	add		sp, #0xc
				pop		{r4-r7}
				pop		{r3}
				bx		r3

;	ENDIF


;--------------------------------------------------------------------
;-			tB^WJi8Bit8Bitj (r0=Srcp, r1=Destp)		-
;--------------------------------------------------------------------
;	IF :DEF: SYSCALL_ASM
		GLOBAL	DiffUnFilter8_8
		CODE16
DiffUnFilter8_8
				push	{r4, lr}

				ldmia	r0!, {r4}				; r4:  DestCount = *(u32 *)Srcp >> 8
				lsr		r4, r4, #8				; r0:  Srcp += 4

				bl		SrcpCheck16_32			; ڽ 
				beq		DiffUnFilter8_8_End

DiffUnFilter8_8_00
				ldrb	r2, [r0, #0]			; r2:  DestTmp = *Srcp++
				add		r0, #1
				strb	r2, [r1, #0]			; r1: *Destp++ = DestTmp
				add		r1, #1

DiffUnFilter8_8_10
				sub		r4, r4, #1				; while (--DestCount > 0)
				ble		DiffUnFilter8_8_End
				ldrb	r3, [r0, #0]			;      DestTmp += *Srcp++
				add		r2, r3, r2
				add		r0, #1
				strb	r2, [r1, #0]			;     *Destp++ = DestTmp
				add		r1, #1
				b		DiffUnFilter8_8_10

DiffUnFilter8_8_End
				pop		{r4}
				pop		{r3}
				bx		r3
;	ENDIF


;--------------------------------------------------------------------
;-			tB^WJi8Bit16Bitj (r0=Srcp, r1=Destp)		-
;--------------------------------------------------------------------
;	IF :DEF: SYSCALL_ASM
		GLOBAL	DiffUnFilter8_16
		CODE16
DiffUnFilter8_16
				push	{r4-r7, lr}

				ldmia	r0!, {r3}				; r5:  DestCount = *(u32 *)Srcp >> 8
				lsr		r5, r3, #8				; r0:  Srcp += 4

				mov		r4, r5					; r4: Count
				bl		SrcpCheck16_32			; ڽ 
				beq		DiffUnFilter8_16_End

				mov		r4, #8					; r4:  Shift  = 8
DiffUnFilter8_16_00
				ldrb	r7, [r0, #0]			; r7:  SrcTmp  = *Srcp++
				add		r0, #1
				mov		r2, r7					; r2:  DestTmp =  SrcTmp

DiffUnFilter8_16_10
				sub		r5, r5, #1				; while (--DestCount > 0)
				ble		DiffUnFilter8_16_End
				ldrb    r3, [r0, #0]			;      SrcTmp  += *Srcp++
				add		r7, r3, r7
				add		r0, #1
				lsl		r6, r7, #24				;      DestTmp |= (SrcTmp & 0xff) << Shift
				lsr		r6, #24
				lsl		r6, r4
				orr		r2, r6
				mov		r3, #8					; if (!(Shift ^= 8))
				eor		r4, r3
				bne		DiffUnFilter8_16_10
				strh	r2, [r1, #0]			;     *Destp++ = DestTmp
				add		r1, #2
				mov		r2, #0					;      DestTmp = 0
				b		DiffUnFilter8_16_10

DiffUnFilter8_16_End
				pop		{r4-r7}
				pop		{r3}
;	ENDIF
;--------------------------------------------------------------------
;-				r3WX^ɂ郋[`Ăяo				    -
;--------------------------------------------------------------------
		GLOBAL	__call_via_r3
		CODE16
__call_via_r3	bx		r3


;--------------------------------------------------------------------
;-			tB^WJi16Bit16Bitj (r0=Srcp, r1=Destp)	-
;--------------------------------------------------------------------
;	IF :DEF: SYSCALL_ASM
		GLOBAL	DiffUnFilter16_16
		CODE16
DiffUnFilter16_16
				push	{r4, lr}

				ldmia	r0!, {r4}				; r4:  DestCount = *(u32 *)Srcp >> 8
				lsr		r4, r4, #8				; r0:  Srcp += 2

				bl		SrcpCheck16_32			; ڽ 
				beq		DiffUnFilter16_16_End

DiffUnFilter16_16_00
				ldrh	r2, [r0, #0]			; r2:  DestTmp = *Srcp++
				add		r0, #2
				strh	r2, [r1, #0]			; r1: *Destp++ = DestTmp
				add		r1, #2

DiffUnFilter16_16_10
				sub		r4, r4, #2				; while ((DestCount-=2) > 0)
				ble		DiffUnFilter16_16_End

				ldrh	r3, [r0, #0]			;      DestTmp += *Srcp++
				add		r2, r3, r2
				add		r0, #2
				strh	r2, [r1, #0]			;     *Destp++ = DestTmp
				add		r1, #2
				b		DiffUnFilter16_16_10

DiffUnFilter16_16_End
				pop		{r4}
				pop		{r2}
;	ENDIF
;--------------------------------------------------------------------
;-				r2WX^ɂ郋[`Ăяo				    -
;--------------------------------------------------------------------
		GLOBAL	__call_via_r2
		CODE16
__call_via_r2	bx		r2

;--------------------------------------------------------------------
;-				r1WX^ɂ郋[`Ăяo				    -
;--------------------------------------------------------------------
		GLOBAL	__call_via_r1
		CODE16
__call_via_r1	bx		r1



	END

