/*
 * $Id: famicom_emu.c,v 1.86 2001-02-08 02:50:07+09 hayakawa Exp $
 *
 * եߥ󥨥ߥ졼
 * ΥեϥС쥤Ǥ
 *
 * ֥֤˥ɤ֥֤Τ
 * nesinfoե뤫ɤȥ֥֤Τ
 * λ˥ޡ򳰤Ƥư

 * ȥѥåؤξ֥ 0x5600ʤ
 *
 * ΰɡ
 * I/O save.element                 ϥ
 *  O  famicomemu.error_code        0: 1:।᡼ɤʤ
 *  I  famicomemu.cassette_no       ५åֹ
 *  I  emu_ret_data.next_scene_no   !0: 0:   
 *  O  set_msg_fail_emu             顼Υå
 *
 */

#undef LEOFILEOUT
#if defined(MAKE3_RUNNING)
#if defined(ROM_D)
#define U_hayakawa_U 1
#endif /* defined(ROM_D) */
#endif

#include "famicom_emu.h"
#include "ks_nes.h"
#include "sys_cfb.h"		/* sys_cfb_get_pointer sys_cfb_get_bottom */
#include "m_cpak_lib.h"         /* m_osPfsFindFile_Alt */
#include "m_std_dma.h"		/* dmacopy_fg */
#include "audioMgr.h"		/* CLEAR_DISABLE_AUDIO_MAIN_AND_TASK() */
#include "ThreadPriority.h"	/* PRIORITY_FAMICOM_AUDIO */
#include "ThreadID.h"		/* THREAD_ID_FAMICOM_AUDIO*/
#include "m_select.h"
#include "m_play.h"
#include "m_rcp.h"              /* RSP_RDP_clear_data */
#include "m_trademark.h"        /* trademark_init GAME_TRADEMARK */
#include "sys_zb.h"             /* sys_zb */
#include "audio.h"		/* sAdo_SubGame */
#include "sys_vimgr.h"		/* viBlack */
#include <sleep.h>		/* usleep */
#include "stackcheck.h"		/* stackcheck */
#include "m_common_data.h"	/* ZCommonGetP */
#include "m_player.h"           /* M_PLAYER_SET_MSG_FAIL_EMU_TYPE0 */
#include "zurumode.h"		/* isZuruMode */
#include "padmgr.h"		/* padmgr_LockSerialMesgQ */
#include "PreRender.h"		/* PreRender */
#include "gfxalloc.h"		/* gfxopen */
#include <string.h>             /* memset */
#include <debug.h>              /* PRINTF */
#include <assert64.h>           /* assert */
#if defined(LEOFILEOUT)
#define u32 unsigned long
#include <filesys.h>            /* fopen */
#undef u32
#endif /* if defined(LEOFILEOUT) */
#include "m_malloc.h"		/* zelda_DisplayArena */
#include <rcp.h>                /* AI_STATUS_DMA_BUSY */
#include "m_nmibuf.h"           /* M_APPNMI_SET_ZURUMODE2, M_APPNMI_TST_ZURUMODE3 */

enum {
    FAMICOM_ROM_UNKNOWN = -1,
    FAMICOM_ROM_CONT_PAK = 0,
    FAMICOM_ROM_CLUCLU_LAND = 1,
    FAMICOM_ROM_BALLOON_FIGHT = 2,
    FAMICOM_ROM_DONKEY_KONG = 3,
    FAMICOM_ROM_S_ASOBIJ = 4,
    FAMICOM_ROM_PINBALL = 5,
    FAMICOM_ROM_TENNIS = 6,
    FAMICOM_ROM_GOLF = 7,
#if defined(NES_TESTROM)
    FAMICOM_ROM_TEST = 8,
#endif
    FAMICOM_ROM_MAX
};

typedef union {

    struct {
        short     type;
    } gen;

    irqmgr_msg_t  app;
    
} FamicomAudioMsg;

EXTERN_DEFSEG_RAW(nes_noise);
EXTERN_DEFSEG_RAW(nes_cluclu);  /* 륯 */
EXTERN_DEFSEG_RAW(nes_balloon); /* Х롼ե */
EXTERN_DEFSEG_RAW(nes_donkey);  /* ɥ󥭡 */
EXTERN_DEFSEG_RAW(nes_s_asobij); /* ͷ */
EXTERN_DEFSEG_RAW(nes_pinball); /* ԥܡ */
EXTERN_DEFSEG_RAW(nes_tennis);  /* ƥ˥ */
EXTERN_DEFSEG_RAW(nes_golf);    /*  */
#if defined(NES_TESTROM)
EXTERN_DEFSEG_RAW(nes_testrom); /* ƥ */
#endif
EXTERN_DEFSEG(ovl_famicom_emu);

static irqmgr_client_t famicom_game_client;
static OSMesgQueue famicom_gameFrameMsgQ; /* ȥ졼Υåʤ */
static OSMesg      famicom_gameFrameMsgBuf[8];
static OSMesgQueue famicom_audioFrameMsgQ; /* ȥ졼Υåʤ */
static OSMesg      famicom_audioFrameMsgBuf[8];
static OSMesgQueue famicom_audioDestroyMsgQ; /* ˲å */
static OSMesg      famicom_audioDestroyMsgBuf[1];
static OSThread    famicom_audioThread;
static OSMesgQueue ostaskmsgQ;
static OSMesg      ostaskmsgbuf[1];
static OSScTask    os_sc_task;

#define FAMICOM_AUDIOSTACK_SIZE 1024 /*  0x230 */
static u64	famicom_audioStack[FAMICOM_AUDIOSTACK_SIZE]; /* եߥ󥪡ǥåѥå */
StackCheckDecl(famicom_audio);

static volatile s8 audio_doing; /* !0:ks_nes_audio_main¹ */
static s8	frame_cnt;	/* ե졼५(100ե졼ǥȥȥå) */
static u8	famicom_sp_doing;	/* !0:ϥɥɬ */
static u8	need_maketask;  /* !0:maketaskɬ */
static u8       returnable;     /* !0:ܤˤϤޤ٤꤬ */
static u8       cassette_no;    /* 0,1-7:åֹ */
static volatile s8 play_left;   /* -1,0,1,2:ưǽե졼५ */
static u8       force_pause_sub; /* !0:LRΥȥݡ */
static volatile u8 audio_pause; /* !0: (ߥ졼ǤΥݡǤʤ) */
static u8       force_reset;    /* !0:ꥻå */

static u8       state_save_no;  /* !0:ֹ */
static u8       state_load_no;  /* !0:ֹ */
static u8       state_loaded;   /* !0:٤Ǥ֥ɤԤä */
static u8       state_saved;    /* ӥå0-7Τ줾줬:٤Ǥ֥֤Ԥä */

static u8       nesinfo_cpak_cont_no; /* ȥѥåֹ */
static u8       nesinfo_cpak_game_name[PFS_FILE_NAME_LEN]; /* ȥѥå̾ */
static u8       lrz_pressed;    /* !0:L+R+ZꥻåȤ */
static u8       fade_alpha;     /* !0:L+R+Zꥻåѥեɥե */

#define nesinfo_cpak_company_code    M_CPAK_COMPANY_CODE
#define nesinfo_cpak_game_code       M_CPAK_GAME_CODE

static cfbinfo_t *cfbinfo_p;    /* ե졼ХåեؤΥݥ  */

/* ֥ΰ */
#undef STATE_SAVE_ALL           /* Ⱦ֥֤Ϥ٤Ƥ򥻡֤ */
typedef struct {
#if defined(STATE_SAVE_ALL)
    u8 u8buf[sizeof(rfcstate_object)]; /*  */
#else
    u8 u8buf[sizeof(rfcstate_object) - (sizeof(u8) * SIZEOF_GFXBUF + sizeof(u8) * SIZEOF_GFXBUF2 + sizeof(u16) * 0x80)];
    u8 vram_bak[SIZEOF_DRAW_VRAM];
#endif
} rfcstate_save;
static rfcstate_save *rfcstate_bank[6]; /* ֥ΰؤΥݥ(ޥ˥奢룴ܥȣ) */

static rfcstate_object *rfcstate_objectp; /* եߥ֤ؤΥݥ */

static u8 *noise_datap;         /* Υǡݥ */
static u8 *ucode_workp;         /* UCODE */
static u8 *headerp;             /* 528B */


/*
 * ǥХåѵĥե饰
 */
static u8 enables[16];
#define enable_force_reset      enables[0] /* !0:եߥꥻå */
#define enable_force_pause      enables[1] /* !0: */
#define enable_speed_control    enables[2] /* !0:ԡɥȥ */
#define enable_no9over_mode     enables[3] /* !0:С̵⡼ */
#define enable_state_save       enables[4] /* !0:֥ 1:ưֳִ10 >=2:ưֳִ */
#define enable_auto_fire        enables[5] /* ϢͲǽޥ */
#define enable_bbram_save       enables[6] /* !0:£¥򥳥ȥѥå˥ */
#define max_fire                enables[7] /* ǹϢ® */
#define enable_update_highscore_if_state_loaded enables[8] /* !0:֥ɤȤ˥ϥǧ */
#define enable_speed_x2_alt     enables[9] /* !0:®⡼ɤǥץ饤Ȥ褦ʥߥ󥰤 */
#define enable_state_cpak       enables[10] /* !0:֥ǡ򥳥ȥѥå˥ */
#define blackout_frame          enables[11] /* !0:ꥻåľΥ֥åȥե졼 */
#define max_speed               (1 + enables[12]) /* ®⡼ɤκǹ® */
#define min_speed               (1 - enables[13]) /* ®⡼ɤκ® */
#define clear_wram_on_reset     enables[14] /* !0:ꥻåȻˣץ򥯥ꥢɬ */



#if defined(LEOFILEOUT)
/****************************************************************************
 * ۥI/O  START
 ****************************************************************************/
/*
 * եĹĴ٤
 */
static long
filesys_length(
    char *filename		/* ե̾ */
    )
{
    FILE *fp = NULL;
    long length = -1;
    
    fp = fopen((unsigned char *)filename, (unsigned char *)"rb");
    if (fp == NULL) {
        goto error_exit;
    }

    fseek(fp, 0L, SEEK_END);
    length = (long)ftell(fp);
    fseek(fp, 0L, SEEK_SET);
	    
error_exit:
    if (fp != NULL) {
        fclose(fp);
        fp = NULL;
    }

    return length;
}

/*
 * եХåեɹ
 */
static int
filesys_load(
    u8 *bufferP,		/* Хåե */
    char *filename,		/* ե̾ */
    size_t length		/* ɹХȿ(0ΤȤϥեĹ) */
    )
{
    FILE *fp = NULL;
    size_t r;
    int return_value = -1;
    size_t offset;

    fp = fopen((unsigned char *)filename, (unsigned char *)"rb");
    if (fp == NULL) {
        PRINTF("fopen error [%s]\n", filename);
        goto error_exit;
    }

    if (length == 0) {
	fseek(fp, 0L, SEEK_END);
	length = (size_t)ftell(fp);
	fseek(fp, 0L, SEEK_SET);
    }
    
    /* ʤǤɤޤʤ */
    fseek(fp, 0L, SEEK_SET);
    for (offset = 0; offset < length; offset += r) {
        size_t fread_len;
        if (length - offset > 0x4000)
            fread_len = 0x4000;
        else
            fread_len = length - offset;
        r = fread(bufferP + offset, 1, fread_len, fp);
        PRINTF("%08x %d\n", offset, r);
    }
    
    return_value = 0;
    
error_exit:
    if (fp != NULL) {
        fclose(fp);
        fp = NULL;
    }

    return return_value;
}
/****************************************************************************
 * ۥI/O  END
 ****************************************************************************/
#endif /*if defined(LEOFILEOUT)*/



/************************************************************************
 * my_alloc START
 ************************************************************************/
static GAME  *my_alloc_game;
static char  *my_alloc_memptr;
static size_t my_alloc_memsiz;
static char  *my_alloc_zbuf_ptr;
static size_t my_alloc_zbuf_siz;

/*
 * 
 */
static void
my_alloc_init(GAME *game, void *memptr, size_t memsiz, void *zbfptr, size_t zbfsiz)
{
    my_alloc_game = game;
    my_alloc_memptr = (char *)memptr;
    my_alloc_memsiz = memsiz;
    my_alloc_zbuf_ptr = (char *)zbfptr;
    my_alloc_zbuf_siz = zbfsiz;
}

static void
my_alloc_dispinfo(void)
{
    if (my_alloc_game != 0)
        PRINTF1(ESC_GREEN "Ĥ %08x Х\n" ESC_NORMAL, game_getFreeBytes(my_alloc_game));
    disp(08x, my_alloc_memptr);
    disp(08x, my_alloc_memsiz);
    disp(08x, my_alloc_zbuf_ptr);
    disp(08x, my_alloc_zbuf_siz);
}

/*
 * 
 */
static void *
my_alloc(size_t size)
{
    void *p;
    size_t bound_size;

    if (size <= 0) {
        return NULL;
    }
    
    bound_size = (size_t)UPBOUND((u32)size, 16);

    if (my_alloc_zbuf_ptr != NULL && bound_size <= my_alloc_zbuf_siz) {
        p = my_alloc_zbuf_ptr;
        my_alloc_zbuf_ptr += bound_size;
        my_alloc_zbuf_siz -= bound_size;
    } else if (my_alloc_game == NULL || (p = game_alloc(my_alloc_game, size)) == NULL) {
        if (my_alloc_memptr != NULL && bound_size <= my_alloc_memsiz) {
            p = my_alloc_memptr;
            my_alloc_memptr += bound_size;
            my_alloc_memsiz -= bound_size;
        } else {
            p = NULL;
        }
    }
    if (p != NULL) {
        bzero(p, (int)bound_size);
    }
#if DEBUG
    if (p == NULL) {
        PRINTF1(ESC_ERROR "my_alloc ݼ %08x byte\n" ESC_NORMAL, size);
    } else {
        PRINTF3(ESC_GREEN "my_alloc %08x-%08x  %08x byte\n" ESC_NORMAL, p, (char *)p + size, size);
    }
#endif /* DEBUG */
    
    return p;
}
/************************************************************************
 * my_alloc END
 ************************************************************************/

/*
 * åֹॢɥ쥹Ѵ
 */
static void
get_rom_start_end(int cassette_no, u32 *rom_start_p, u32 *rom_end_p)
{
    u32 rom_start;
    u32 rom_end;

#if DEBUG
    assert(rom_start_p != NULL);
    assert(rom_end_p != NULL);
#endif /* DEBUG */
    
    rom_start = *rom_start_p;
    rom_end = *rom_end_p;

    switch (cassette_no) {
    case FAMICOM_ROM_CLUCLU_LAND:
        rom_start = (u32)_nes_clucluSegmentRomStart;
        rom_end = (u32)_nes_clucluSegmentRomEnd;
        break;
        
    case FAMICOM_ROM_BALLOON_FIGHT:
        rom_start = (u32)_nes_balloonSegmentRomStart;
        rom_end = (u32)_nes_balloonSegmentRomEnd;
        break;
        
    case FAMICOM_ROM_DONKEY_KONG:
        rom_start = (u32)_nes_donkeySegmentRomStart;
        rom_end = (u32)_nes_donkeySegmentRomEnd;
        break;
        
    case FAMICOM_ROM_S_ASOBIJ:
        rom_start = (u32)_nes_s_asobijSegmentRomStart;
        rom_end = (u32)_nes_s_asobijSegmentRomEnd;
        break;
		
    case FAMICOM_ROM_PINBALL:
        rom_start = (u32)_nes_pinballSegmentRomStart;
        rom_end = (u32)_nes_pinballSegmentRomEnd;
        break;
		
    case FAMICOM_ROM_TENNIS:
        rom_start = (u32)_nes_tennisSegmentRomStart;
        rom_end = (u32)_nes_tennisSegmentRomEnd;
        break;
		
    case FAMICOM_ROM_GOLF:
        rom_start = (u32)_nes_golfSegmentRomStart;
        rom_end = (u32)_nes_golfSegmentRomEnd;
        break;
		
#if defined(NES_TESTROM)
    case FAMICOM_ROM_TEST:
        rom_start = (u32)_nes_testromSegmentRomStart;
        rom_end = (u32)_nes_testromSegmentRomEnd;
        break;
#endif
    default:
        rom_start = (u32)_nes_clucluSegmentRomStart;
        rom_end = (u32)_nes_clucluSegmentRomEnd;
    }

    *rom_start_p = rom_start;
    *rom_end_p = rom_end;
}


/*
 * ȥѥå()
 *
 * ҥ  :1
 * ॳ:NSGJ
 * ̾    :FORESTʳ
 */
static void *
game_cpak_read_alloc(int cont_no)
{
    void *data_buffer = NULL;
    static u8 ext_name[PFS_FILE_EXT_LEN];
    s32 file_no;
    u32 nbytes;
    s32 r;
    OSPfs pfs;
    OSMesgQueue *Q = NULL;	/* SI Q */
    OSPfsState state;

    /*
     * SI¾ѥå
     */
    Q = padmgr_LockSerialMesgQ();

    /*
     * ȥѥå
     */
    r = osPfsInitPak(Q, &pfs, cont_no);
    if (r != 0)
	goto error_exit;

    /*
     * եõʤХ顼
     */
    r = m_osPfsFindFile_Alt(&pfs, nesinfo_cpak_company_code, nesinfo_cpak_game_code, (u8 *)M_CPAK_GAME_NAME, ext_name, &file_no);
    if (r != 0)
        goto error_exit;
    r = osPfsFileState(&pfs, file_no, &state);
    if (r != 0)
        goto error_exit;
    bcopy(state.game_name, nesinfo_cpak_game_name, PFS_FILE_NAME_LEN);
    nbytes = state.file_size;

    /*
     * 
     */
    data_buffer = my_alloc((size_t)nbytes);
    if (data_buffer == 0) {
	goto error_exit;
    }
    
    
    /*
     * ǡɤࡣ
     */
    r = osPfsReadWriteFile(&pfs, file_no, PFS_READ, 0, (int)nbytes, (u8 *)data_buffer);
    if (r != 0) {
        data_buffer = NULL;
	goto error_exit;
    }
    
    /*
     * 
     */
    
error_exit:

    if (r != 0) {
	disp(d, r);
    }
    
    /*
     * SI¾ѥå
     */
    if (Q != NULL) {
	padmgr_UnlockSerialMesgQ( Q );
	Q = NULL;
    }

    return data_buffer;
}



/****************************************************************************
 * nesinfo  START
 ****************************************************************************/
/*
 NESINFO_ID             8byte   NESINFO^Z
 С             1Byte+1Byte             ܾ
              2Byte   -64KB
 ǡ           4Byte   -4GB!
 ---------------------------------------------------------------------
 ID           'GID' 0x04      ե뼱
 ID               4byte   'NBFJ' 
 ̾           'GNM' 0x10      ̾ɽ
 ̾               16byte  "Balloon Fight" (ASCII)
 CPAK̾       'CPN' 0x10      ȥѥåѥ̾
 CPAK̾           16byte  "Balloon Fight" (N64FONT)
-ե륲̾       'FGN' 0x10      ̾ɽ
-ե륲̾           16byte  "Х롼ե" (shift-jis+0x00)
 ϥ         'HSC'   0x0c    ϥΥХȿ*2+2
 ϥեå 2byte   0x400
 ϥ     xbyte   02500
 ϥ         'HSC'   0x0c    Υʣֲ
 ϥեå 2byte   0x400
 ϥ     yByte   02500
 λ               'END'   0x00    (νꡣѥǥѤ˿ǽ)
-ॵ         'ISZ'   0x02    (ŪˤϣХȤ⤢ꤨ)
-ॵ             2Byte   0x6010
-եޥåȥ   'IFM'   0x01
-եޥå       1Byte 0:ENDľ夫 1:̥ե
-إå             'NHD'   0x10    (Υʤϥ।᡼ˤäĤƤΤȤ)
-إå                 16Byte          (.nesեƬ16Х)
-åॿ   'TCS'   0x02    
-å       2Byte           (NESINFOEND00ޤ­ƣ)
-åॿ   'ICS'   0x04
-å       4Byte           (إåޤޤʤ­)
-إååॿ 'HCS'   0x01
-إåå     1Byte           (إåХȤ­)
-ѥǥ󥰥         'PAD'   0x00-0xff       ̵뤷ޤƤ
-ȥ           'REM'   0x00-0xff       ɤͤäƤ̵뤷ޤŪ˰ǽʸƤ
-ץꥱ󥿥   'APL'   0x00-0xff       ɤͤäƤ̵뤷ޤ¾Υץꥱ󤬻Ȥѡ
 */

#define NESINFO_HEADER  'N', 'E', 'S', 'I', 'N', 'F', 'O', 0x1a
#define GID_TAG(len)    'G', 'I', 'D', (len)
#define GNM_TAG(len)    'G', 'N', 'M', (len)
#define HSC_TAG(x)      'H', 'S', 'C', (2 + (x))
#define HSC_OFFSET(off) ((u32)(off) / 256), ((u32)(off) % 256)
#define END_TAG()       'E', 'N', 'D', 0

#define TAG_LEN         (TAG_ID_LEN + TAG_SIZE_LEN)
#define TAG_ID_LEN      3
#define TAG_SIZE_LEN    1

#define TAG_ID_NESINFO  ""
#define TAG_ID_GID      "GID"   /* ɣ */
#define TAG_ID_GNM      "GNM"   /* ̾ */
#define TAG_ID_HSC      "HSC"   /* ϥ */
#define TAG_ID_END      "END"   /*  */
#define TAG_ID_ISZ      "ISZ"   /* ᡼ */
#define TAG_ID_PAD      "PAD"   /* ѥǥ */
#define TAG_ID_CPN      "CPN"   /* ȥѥå̾ */
#define TAG_ID_IFM      "IFM"   /* ᡼եޥå */
#define TAG_ID_REM      "REM"   /*  */
#define TAG_ID_APL      "APL"   /* ץꥱ */
#define TAG_ID_TCS      "TCS"   /* Υå */
#define TAG_ID_ICS      "ICS"   /* ᡼Υå */
#define TAG_ID_ESZ      "ESZ"   /* ŸΥॵ */
#define TAG_ID_FIL      "FIL"   /* wramǡ */
#define TAG_ID_ROM      "ROM"   /* ǡ */
#define TAG_ID_MOV      "MOV"   /* ֥åž */
#define TAG_ID_NHD      "NHD"   /* NESإåѹ */
#define TAG_ID_DIF      "DIF"   /* ʬ */
#define TAG_ID_PAT      "PAT"   /* ѥå */
#define TAG_ID_VEQ      "VEQ"   /* С׻˼Υ¹ */
#define TAG_ID_VNE      "VNE"   /* С԰׻˼Υ¹ */

/* nesinfoإå 16Bytes */
typedef struct {
    u8          nesinfo_id[8];  /* NESINFO^Z */
    u8          version[2];     /* !00:С ܾ */
    u16         tags_size;      /* !0: max64KB */
    u32         data_size;      /* !0:ǡ max4GB */
} nesinfo_header_t;

#if defined(LEOFILEOUT)
static u8
tags_table_unknown[] = {
    END_TAG(),
};
#define nesinfo_template tags_table_unknown
#endif /* defined(LEOFILEOUT) */


#define HIGHSCORE_BYTES         127
typedef union {
    struct {
        u8 highscore_tbl[HIGHSCORE_BYTES];      /* ǡ */
        u8 check_sum;               /* å */
    } s;
} highscore_t;
static u8 highscore_num;        /* ϥο */
static u8 highscore_updated;     /* !0:ϥι */
static highscore_t highscore_buf[2]; /* ϥơ֥Хåե */
static u8 *highscore_flags;     /* ϥե饰ơ֥Ƭ */
                                /* 3:ϥǡ̵ */
                                /* 0:ϥ̤ */
                                /* 1:ϥ */
                                /* xx 2:ϥ */
enum highscore_flag_e {
    HIGHSCORE_FLAG_NOSET = 0,   /* wram̤ */
    HIGHSCORE_FLAG_SETED = 1,   /* wram */
    HIGHSCORE_FLAG_NONE = 3     /* ¸ѥϥΥǡʤ */
};

static u8 *nesinfo_ptr;         /* nesinfoƬ */
static nesinfo_header_t *nesinfo_header_p;      /* NESإå */
static size_t nesinfo_tags_size;   /* ǡơ֥륵 */
static u8 *nesinfo_tags_start;  /* ǡơ֥Ƭ */
static u8 *nesinfo_tags_end;    /* ǡơ֥ */
static size_t nesinfo_data_size;   /* ǡ(ॵ) */
static u8 *nesinfo_data_start;  /* ǡ(ʤ) = nesinfo_ptr + sizeof(nesinfo_header_t) + nesinfo_tags_size */
static u8 *nesinfo_data_end;    /* ǡλ(ʤ) */
static size_t nesinfo_rom_size;   /* ॵ */
static u8 *nesinfo_rom_start;   /* ೫ϥݥ */
static u8 *nesinfo_rom_end;     /* ཪλݥ */
static size_t nesinfo_expand_rom_size; /* ̤ƤŸΥॵ */

static const char nesz[] = { 'N', 'E', 'S', 0x1a }; /* ।᡼̥ */
static const char nesinfoz[] = { NESINFO_HEADER }; /* nesinfo̥ */

/*
 * ϥ
 */
static void
update_highscore_raw(
    int offset,                 /* եå */
    int bytes,                  /* Хȿ */
    u8 *initial_value,          /* ꥻåľνϥ */
    u8 *high_score,             /* ¸ϥ */
    u8 *flag                    /* ϥե饰 */
    )
{
    u8 *bcd_ptr = rfcstate_objectp->wram + offset;
    
    if (*flag == 3) {           /* ϥʤ */
        bcopy(initial_value, high_score, bytes);
        *flag = 0;
        PRINTF0("ϥǡʤΤǽޤ\n");
    }
    if (*flag == 0) {           /* ϥ̤ */
        if (bcmp(bcd_ptr, initial_value, bytes) == 0) {
            PRINTF0("WRAMΥϥͤˤʤޤ\n");
            bcopy(high_score, bcd_ptr, bytes);
            *flag = 1;          /* ϥ */
#if DEBUG
            {
                int i;
                PRINTF0("ϥWRAM");
                for (i = 0; i < bytes; i++) {
                    PRINTF1(" %02x", high_score[i]);
                }
                PRINTF0("\n");
            }
#endif /* DEBUG */
        } else {
            PRINTF0("WRAMΥϥͤˤʤäƤޤ ");
#if DEBUG
                {
                    int i;
                    for (i = 0; i < bytes; i++) {
                        PRINTF1(" %02x", bcd_ptr[i]);
                    }
                    PRINTF0(" : ");
                }
                {
                    int i;
                    for (i = 0; i < bytes; i++) {
                        PRINTF1(" %02x", initial_value[i]);
                    }
                    PRINTF0("\n");
                }
#endif /* DEBUG */
        }
    } else {
        if (bcmp(bcd_ptr, high_score, bytes)) {
            if (!state_loaded || enable_update_highscore_if_state_loaded) {
                PRINTF0("WRAMΥϥޤ");
                bcopy(bcd_ptr, high_score, bytes);
                highscore_updated = 1;
#if DEBUG
                {
                    int i;
                    for (i = 0; i < bytes; i++) {
                        PRINTF1(" %02x", high_score[i]);
                    }
                    PRINTF0("\n");
                }
#endif /* DEBUG */
            }
        }
    }
}

/*
 * u8ʥݥ󥿤Х˱ƶ줺u16ǡФ
 */
static u16
nesinfo_get_u16(u8 *data)
{
    return (u16)(((u32)*(data + 0) << 8) + (u32)*(data + 1));
}

#if 0                           /* ̤ */
/*
 * u8ʥݥ󥿤˥Х˱ƶ줺u16ǡꤹ
 */
static void
nesinfo_set_u16(u8 *data, u16 *u16data)
{
    *(data + 0) = (u8)(((u32)u16data >> 8) & 0xff);
    *(data + 1) = (u8)((u32)u16data & 0xff);
}
#endif


/*
 * Υ
 * !NULL:ΥΥݥ
 * NULL :Υ̵
 */
static u8 *
nesinfo_next_tag(u8 *data)
{
    if (data == NULL ||
        (nesinfo_tags_end != NULL && data >= nesinfo_tags_end) ||
        bcmp(data, TAG_ID_END, TAG_ID_LEN) == 0) {
        return NULL;
    } else {
        return data + (unsigned long)data[3] + TAG_LEN;
    }
}

/*
 * λ꥿
 * !NULL:λꤷ
 * NULL:λꤷ̵
 */
static u8 *
nesinfo_find_tag(u8 *data, u8 *tag)
{
    while (1) {
        data = nesinfo_next_tag(data);
        if (data == NULL) {
            return NULL;
        } else if (bcmp(data, tag, TAG_ID_LEN) == 0) {
            return data;
        }
    }
}

/*
 * å׻
 * ptr  nbytes ʬΥǡ򤹤٤Ʋû֤ͤޤ
 */
static u8
calc_check_sum(u8 *ptr, size_t nbytes)
{
    u8 sum;
    size_t cnt;

    sum = 0;
    for(cnt = 0; cnt < nbytes; cnt++) {
        sum += *ptr++;
    }

    return sum;
}

/*
 * å׻
 * ptr  nbytes ʬΥǡ򤹤٤Ʋû֤ͤޤ
 */
static u16
calc_check_sum2(void *ptr, size_t nbytes)
{
    if (((u32)ptr & 1) == 0) {
        u16 sum;
        size_t cnt;
        u16 *ptr2;

        ptr2 = (u16 *)ptr;
        sum = 0;
        for(cnt = 0; cnt < nbytes; cnt += 2) {
            sum += *ptr2++;
        }
        
        return sum;
    } else {
        u16 sum;
        u16 sum1;
        u16 sum2;
        size_t cnt;
        u8 *ptr1;

        ptr1 = (u8 *)ptr;
        sum1 = 0;
        sum2 = 0;
        for(cnt = 0; cnt < nbytes - 1; cnt += 2) {
            sum1 += *(ptr1 + 0);
            sum2 += *(ptr1 + 1);
            ptr1 += 2;
        }
        if (cnt < nbytes) {
            sum1 += *(ptr1 + 0);
            ptr1 += 1;
        }
        sum = (u16)((sum1 << 8) + sum2);
        
        return sum;
    }
}

/*
 * ʸɽ
 */
static void
print_stringn_lf(u8 *data, size_t len)
{
    while (len-- > 0) {
        PRINTF1("%c", *data++);
    }
    PRINTF("\n");
}

/*
 * ʤɽ
 */
static void
print_hex_lf(u8 *data, size_t len)
{
    while (len-- > 0) {
        PRINTF1(" %02x", *data++);
    }
    PRINTF("\n");
}

/*
 * ŸΥ
 */
static u8 tcs_bad;              /* å۾ */
static u8 ics_bad;              /* ᡼()å۾ */
static void
nesinfo_tag_process1(u8 *data)
{
    PRINTF("nesinfo_tag_process1 \n");
    while (1) {
        data = nesinfo_next_tag(data);
        if (data == NULL) {
            break;
        }
        PRINTF2("%.3s Ĺ%d\n", data, *(data + 3));
        if (bcmp(data, TAG_ID_VEQ, TAG_ID_LEN) == 0) {
            /*
             * Сå
             * С󤬰פ˼Υ
             */
            if (*(data + 4) != 0) {
                data = nesinfo_next_tag(data);
            }
        } else if (bcmp(data, TAG_ID_VNE, TAG_ID_LEN) == 0) {
            /*
             * Сå
             * С󤬰פʤ˼Υ
             */
            if (*(data + 4) == 0) {
                data = nesinfo_next_tag(data);
            }
        } else if (bcmp(data, TAG_ID_GID, TAG_ID_LEN) == 0) {
            print_stringn_lf(data + 4, (size_t)*(data + 3));
        } else if (bcmp(data, TAG_ID_GNM, TAG_ID_LEN) == 0) {
            print_stringn_lf(data + 4, (size_t)*(data + 3));
        } else if (bcmp(data, TAG_ID_CPN, TAG_ID_LEN) == 0) {
            bcopy(data + 4, nesinfo_cpak_game_name, 16);
        } else if (bcmp(data, TAG_ID_HSC, TAG_ID_LEN) == 0) {
            PRINTF1("ϥ: եåȡ%04x ͡", nesinfo_get_u16(data + 4));
            print_hex_lf(data + 6, (size_t)*(data + 3) - 2);
        } else if (bcmp(data, TAG_ID_ISZ, TAG_ID_LEN) == 0) {
            print_hex_lf(data + 4, (size_t)*(data + 3));
        } else if (bcmp(data, TAG_ID_IFM, TAG_ID_LEN) == 0) {
            print_hex_lf(data + 4, (size_t)*(data + 3));
        } else if (bcmp(data, TAG_ID_REM, TAG_ID_LEN) == 0) {
            print_stringn_lf(data + 4, (size_t)*(data + 3));
        } else if (bcmp(data, TAG_ID_END, TAG_ID_LEN) == 0) {
            break;
        } else if (bcmp(data, TAG_ID_TCS, TAG_ID_LEN) == 0) {
            u16 sum1 = calc_check_sum2(nesinfo_tags_start, nesinfo_tags_size);
            if (sum1 != 0) {
                PRINTF1(ESC_WARNING "BAD %04x\n" ESC_NORMAL, sum1);
                tcs_bad = 1;
                break;
            } else {
                PRINTF("OK\n");
            }
        } else if (bcmp(data, TAG_ID_ICS, TAG_ID_LEN) == 0) {
            u16 sum1 = calc_check_sum2(nesinfo_data_start, nesinfo_data_size);
            u16 sum2 = nesinfo_get_u16(data + 4);
            if (sum1 != sum2) {
                ics_bad = 1;
                PRINTF2(ESC_WARNING "BAD %04x %04x\n" ESC_NORMAL, sum1, sum2);
            } else {
                PRINTF("OK\n");
            }
        } else if (bcmp(data, TAG_ID_ESZ, TAG_ID_LEN) == 0) {
            /* (ŸΥॵ+15)/16 */
            nesinfo_expand_rom_size = (size_t)((u32)nesinfo_get_u16(data + 4) << 4);
        } else if (bcmp(data, TAG_ID_FIL, TAG_ID_LEN) == 0) {
            /* wramǡ */
            ks_nes_wram_fill_data = *(data + 4);
        } else if (bcmp(data, TAG_ID_ROM, TAG_ID_LEN) == 0) {
            u32 rom_start,
                rom_end;
            size_t rom_size;
            int cassette_no;

            cassette_no = (int)*(data + 4);
            PRINTF1("ǡ: %d\n", cassette_no);
            
            get_rom_start_end(cassette_no, &rom_start, &rom_end);
            rom_size = (size_t)(rom_end - rom_start);
            if (nesinfo_expand_rom_size != 0) {
                nesinfo_rom_start = (u8 *)my_alloc(nesinfo_expand_rom_size);
            } else {
                nesinfo_rom_start = (u8 *)my_alloc(rom_size);
            }
 
            if (nesinfo_rom_start != NULL) {
                dmacopy_fg(nesinfo_rom_start, rom_start, (u32)rom_size);
            } else {
                PRINTF(ESC_ERROR "ΰγݤ˼Ԥޤ" ESC_NORMAL);
            }
        }
    } /* while (1) */
    PRINTF("nesinfo_tag_process1 λ\n");
}

/*
 * ŸΥ
 */
static void
nesinfo_tag_process2(u8 *data)
{
    PRINTF("nesinfo_tag_process2 \n");
#if 0
    if (nesinfo_rom_start == NULL) {
        PRINTF0(ESC_ERROR "nesinfo_rom_start == NULL\n" ESC_NORMAL);
        return;
    }
#endif
    while (1) {
        data = nesinfo_next_tag(data);
        if (data == NULL) {
            break;
        }
        PRINTF2("%.3s Ĺ%d\n", data, *(data + 3));
        if (bcmp(data, TAG_ID_VEQ, TAG_ID_LEN) == 0) {
            /*
             * Сå
             * С󤬰פ˼Υ
             */
            if (*(data + 4) != 0) {
                data = nesinfo_next_tag(data);
            }
        } else if (bcmp(data, TAG_ID_VNE, TAG_ID_LEN) == 0) {
            /*
             * Сå
             * С󤬰פʤ˼Υ
             */
            if (*(data + 4) == 0) {
                data = nesinfo_next_tag(data);
            }
        } else if (bcmp(data, TAG_ID_MOV, TAG_ID_LEN) == 0) {
            /*
             * ֥åž
             */
            size_t src = (size_t)nesinfo_get_u16(data + 4) << 4;
            size_t dst = (size_t)nesinfo_get_u16(data + 6) << 4;
            size_t siz = (size_t)nesinfo_get_u16(data + 8) << 4;
            if (nesinfo_rom_start != NULL) {
                bcopy(nesinfo_rom_start + src, nesinfo_rom_start + dst, (int)siz);
            }
        } else if (bcmp(data, TAG_ID_NHD, TAG_ID_LEN) == 0) {
            /*
             * NESإåѹ
             */
            if (nesinfo_rom_start != NULL) {
                bcopy(data + 4, nesinfo_rom_start, (int)*(data + 3));
            }
        } else if (bcmp(data, TAG_ID_DIF, TAG_ID_LEN) == 0) {
            if (nesinfo_rom_start != NULL) {
                /*
                 * ʬѹ
                 */
                u8 *rom;
                u8 *dif;
                int n;
                
                size_t rom_size = (size_t)(*(nesinfo_rom_start + 4) * 0x4000 + *(nesinfo_rom_start + 5) * 0x2000) + 16;
                u8 *rom_end = nesinfo_rom_start + rom_size;
                
                rom = nesinfo_rom_start;
                dif = nesinfo_data_start;
                for (; rom < rom_end; ) {
                    rom += (u32)*dif++;
                    if (!(rom < rom_end))
                        break;
                    for (n = (int)*dif++; n > 0; n--) {
                        *rom++ = *dif++;
                    }
                    if (!(rom < rom_end))
                        break;
                }
            }
        } else if (bcmp(data, TAG_ID_PAT, TAG_ID_LEN) == 0) {
            /*
             * ѥå
             */
            int patch_type;
            size_t length;
            size_t offset;
            u8 *u8datas;
            u8 *next_tag = nesinfo_next_tag(data);
            u8 *address;

            u8datas = data + 4;
            while (u8datas < next_tag) {
                patch_type = (int)*(u8datas + 0);
                length = (size_t)*(u8datas + 1);
                offset = (size_t)nesinfo_get_u16(u8datas + 2);
                u8datas = u8datas + 4;

                switch (patch_type) {
                case 1: address = &enables[offset]; break;
                case 2: address = nesinfo_rom_start + offset; break;
                case 3: address = (u8 *)osAppNMIBuffer + offset; break;
//                case 2: address = (u8 *)kspRFCTextStart + offset; break;
//                case 3: address = (u8 *)ks_reset_rfcstate_asm + offset; break;
                case 4: address = (u8 *)_ovl_famicom_emuSegmentTextStart + offset * 4;  break;/* 80823e40-8082fd50 */
                case 5: address = (u8 *)_ovl_famicom_emuSegmentDataStart + offset * 4;  break;/* 8082fd50-8084feb0 */
                case 6: address = (u8 *)_ovl_famicom_emuSegmentBssStart + offset * 4; break; /* 8084feb0-80856210 */
//                case 7: break;
                default:
                    if (0x80 <= patch_type && patch_type <= 0x7f) {
                        address = (u8 *)((0x8000 + (patch_type - 0x80)) << 16) + offset; /* 80000000-807fffff */
                    } else {
                        address = NULL; /* ̵ */
                    }
                }
                if (address != NULL) {
                    while (length-- > 0) {
                        *address++ = *u8datas++;
                    }
                } else {
                    u8datas += length;
                }
            }
        }

    } /* while (1) */
    PRINTF("nesinfo_tag_process2 λ\n");
}

/*
 * ϥ
 */
static void
nesinfo_update_highscore(void)
{
    u8 *tag_p;
    u8 *flags_p;
    int highscore_i;
    
    tag_p = nesinfo_tags_start;
    flags_p = highscore_flags;
    highscore_i = 0;
    while (1) {
        tag_p = nesinfo_find_tag(tag_p, (u8 *)TAG_ID_HSC);
        if (tag_p == NULL) {
            break;
        } else {
            int bytes = *(tag_p + TAG_ID_LEN) - 2;
            int offset = (int)nesinfo_get_u16(tag_p + TAG_LEN + 0) & 0x7ff;
            u8 *initial_value_p = tag_p + TAG_LEN + 2;

            if (highscore_i + bytes > HIGHSCORE_BYTES) {
                PRINTF(ESC_ERROR "ϥǡ¿ޤ\n" ESC_NORMAL);
                break;
            }
            
            update_highscore_raw(offset, bytes, initial_value_p, &highscore_buf[0].s.highscore_tbl[highscore_i], flags_p);
            highscore_i += bytes;
            flags_p++;
        }
    }
}

/*
 * ꥻåȻΥϥ
 */
static void
nesinfo_reset_highscore(void)
{
    register u8 *tag_p;
    register u8 *flags_p;
    
    tag_p = nesinfo_tags_start;
    flags_p = highscore_flags;
    while (1) {
        tag_p = nesinfo_find_tag(tag_p, (u8 *)TAG_ID_HSC);
        if (tag_p == NULL) {
            break;
        } else {
            int reset_keep = (int)nesinfo_get_u16(tag_p + TAG_LEN + 0) >> 15;

            if (*flags_p == 1 && !reset_keep) {
                *flags_p = 0;
            }
            
            flags_p++;
        }
    }
}

/*
 * ϥο
 */
static void
nesinfo_count_highscore(void)
{
    u8 *tag_p = nesinfo_tags_start;
    int count = 0;
    
    while (1) {
        tag_p = nesinfo_find_tag(tag_p, (u8 *)TAG_ID_HSC);
        if (tag_p == NULL) {
            highscore_num = (u8)count;
            return;
        } else {
            count++;
        }
    }
}

/*
 * եΥإåĴ٤
 * 󤬤ʤ餽
 * 󤬤ʤʤ
 * i nesinfo_ptr
 * o
 nesinfo_header_p
 nesinfo_tags_size
 nesinfo_tags_start
 nesinfo_tags_end
 nesinfo_data_size
 nesinfo_data_start
 nesinfo_data_end
 nesinfo_rom_size
 nesinfo_rom_start
 nesinfo_rom_end
 */
static void
nesinfo_head_check(void)
{
    nesinfo_header_p = NULL;
    nesinfo_tags_size = 0;
    nesinfo_tags_start = NULL;
    nesinfo_tags_end = NULL;
    nesinfo_data_size = 0;
    nesinfo_data_start = NULL;
    nesinfo_data_end = NULL;
    nesinfo_rom_size = 0;
    nesinfo_rom_start = NULL;
    nesinfo_rom_end = NULL;
    
    if (bcmp(nesinfo_ptr, nesinfoz, sizeof(nesinfoz)) == 0) {
        PRINTF("NESINFOޤ\n");
        nesinfo_header_p = (nesinfo_header_t *)nesinfo_ptr;
        nesinfo_tags_size = (size_t)nesinfo_header_p->tags_size;
        if (nesinfo_tags_size != 0) {
            nesinfo_tags_start = (u8 *)(nesinfo_header_p + 1);
            nesinfo_tags_end = nesinfo_tags_start + nesinfo_tags_size;
        } else {
            PRINTF(ESC_WARNING "ޤ\n" ESC_NORMAL);
        }
        nesinfo_data_size = (size_t)nesinfo_header_p->data_size;
        if (nesinfo_data_size != 0) {
            nesinfo_data_start = ((nesinfo_tags_end != 0) ? nesinfo_tags_end : (u8 *)(nesinfo_header_p + 1));
            nesinfo_data_end = nesinfo_data_start + nesinfo_data_size;
        } else {
            PRINTF(ESC_WARNING "ǡޤ\n" ESC_NORMAL);
        }
        
    } else if (M_APPNMI_TST_ZURUMODE2() && bcmp(nesinfo_ptr, nesz, sizeof(nesz)) == 0) {
        PRINTF(ESC_WARNING "NESINFOϤޤ󤬡Ϥޤ\n" ESC_NORMAL);
        nesinfo_rom_start = (u8 *)nesinfo_ptr;
    } else {
        PRINTF(ESC_ERROR "Ƚ̤ǤIDޤ\n" ESC_NORMAL);
    }
}

static void
nesinfo_init(void)
{
    nesinfo_ptr = NULL;
    nesinfo_header_p = NULL;
    nesinfo_tags_size = 0;
    nesinfo_tags_start = NULL;
    nesinfo_tags_end = NULL;
    nesinfo_data_size = 0;
    nesinfo_data_start = NULL;
    nesinfo_data_end = NULL;
    nesinfo_rom_size = 0;
    nesinfo_rom_start = NULL;
    nesinfo_rom_end = NULL;
}

/*
 * ϥǡȥѥå
 * ȥѥåե̾ᥲ̾.S
 */
static int
higscore_cpak_readwrite(
    int save                    /* 0:load !0:save */
    )
{
    int status = -1;		/* return value */
    static char ext_name_ascii[] = "S";
    static u8 ext_name[PFS_FILE_EXT_LEN];
    s32 file_no;
    size_t nbytes = sizeof(highscore_t);
    size_t nbytes2 = nbytes * 2;
    s32 r;
    OSPfs pfs;
    OSMesgQueue *Q = NULL;	/* SI Q */

    /*
     * ext_name򥢥ɤϿʸɤѴ
     */
    ascii_to_n64font(ext_name_ascii, ext_name, PFS_FILE_EXT_LEN);

    /*
     * SI¾ѥå
     */
    Q = padmgr_LockSerialMesgQ();

    /*
     * ȥѥå
     */
    r = osPfsInitPak(Q, &pfs, (int)nesinfo_cpak_cont_no);
    if (r != 0) {
        PRINTF(ESC_WARNING "ȥѥå˼Ԥޤ\n" ESC_NORMAL);
	goto error_exit;
    }

    /*
     * եõʤХֻʤ롣
     */
    r = osPfsFindFile(&pfs, nesinfo_cpak_company_code, nesinfo_cpak_game_code, nesinfo_cpak_game_name, ext_name, &file_no);
    if (r != 0) {
        if (save) {
            r = osPfsAllocateFile(&pfs, nesinfo_cpak_company_code, nesinfo_cpak_game_code, nesinfo_cpak_game_name, ext_name, (int)nbytes2, &file_no);
            if (r != 0) {
                PRINTF(ESC_WARNING "֥ե˼Ԥޤ\n" ESC_NORMAL);
                goto error_exit;
            } else {
                PRINTF("֥եޤ\n");
            }
        } else {
            PRINTF(ESC_WARNING "֥եΥץ˼Ԥޤ\n" ESC_NORMAL);
            goto error_exit;
        }
    }

    /*
     * ǡ
     *
     * å׻
     * ХååΰΥǡɤ߹ߥåबǧ
     * ΣǤξϥᥤȥХååפ񤯽֤ؤޤ
     * ᥤΰ˥ǡ񤭹
     * ᥤΰΥǡɤ߹ߥåबǧ
     * Хååΰ˥ǡ񤭹
     * ХååΰΥǡɤ߹ߥåबǧ
     */
    if (save) {
        int first_bank;
        int second_bank;
        
        highscore_buf[0].s.check_sum -= calc_check_sum((u8 *)&highscore_buf[0], nbytes);
        
        r = osPfsReadWriteFile(&pfs, file_no, PFS_READ, (int)nbytes, (int)nbytes, (u8 *)&highscore_buf[1]);
        if (r == 0 && calc_check_sum((u8 *)&highscore_buf[1], nbytes) == 0) {
            first_bank = 0;
            second_bank = (int)nbytes;
            PRINTF("ХååפΥåϣϣˤǤ\n");
        } else {
            first_bank = (int)nbytes;
            second_bank = 0;
            PRINTF(ESC_WARNING "ХååפΥåϣΣǤǤ\n" ESC_NORMAL);
        }
    
        r = osPfsReadWriteFile(&pfs, file_no, PFS_WRITE, first_bank, (int)nbytes, (u8 *)&highscore_buf[0]);
        if (r == 0) {
            r = osPfsReadWriteFile(&pfs, file_no, PFS_READ, first_bank, (int)nbytes, (u8 *)&highscore_buf[1]);
            if (r == 0) {
                if (calc_check_sum((u8 *)&highscore_buf[1], nbytes) == 0) {
                    PRINTF("եȥХ󥯤Υ֤ޤ\n");
                    r = osPfsReadWriteFile(&pfs, file_no, PFS_WRITE, second_bank, (int)nbytes, (u8 *)&highscore_buf[0]);
                    if (r == 0) {
                        r = osPfsReadWriteFile(&pfs, file_no, PFS_READ, second_bank, (int)nbytes, (u8 *)&highscore_buf[1]);
                        if (r == 0) {
                            if (calc_check_sum((u8 *)&highscore_buf[1], nbytes) == 0) {
                                PRINTF("ɥХ󥯤Υ֤ޤ\n");
                            }
                        }
                    }
                }
            }
        }
    } else {
        /*
         * 
         *
         * ᥤХååפΥǡɹ
         * ᥤΥåबϣˤʤ餽Τޤޤ
         * ᥤ󤬣ΣǤǥХååפϣˤʤ餽ᥤ˥ԡ
         * ξȤΣǤξϥǡ
         */
        r = osPfsReadWriteFile(&pfs, file_no, PFS_READ, 0, (int)nbytes2, (u8 *)&highscore_buf[0]);
        if (r == 0) {
            if (calc_check_sum((u8 *)&highscore_buf[0], nbytes) == 0) {
                PRINTF("ᥤΥǡϣϣˤǤ\n");
                if (bcmp((u8 *)&highscore_buf[0], (u8 *)&highscore_buf[1], (int)nbytes) == 0) {
                    PRINTF("ᥤȥХååפƤפƤޤ\n");
                } else {
                    PRINTF(ESC_WARNING "ᥤȥХååפƤפƤޤ\n" ESC_NORMAL);
                }
            } else if (calc_check_sum((u8 *)&highscore_buf[1], nbytes) == 0) {
                PRINTF(ESC_WARNING "ᥤϣΣǤǥХååפϣϣˤǤᥤ˥ԡ\n" ESC_NORMAL);
                bcopy(&highscore_buf[1], &highscore_buf[0], (int)nbytes);
            } else {
                PRINTF(ESC_WARNING "ǰʤξȤΣǤǤ\n" ESC_NORMAL);
                goto error_exit;
            }
        }
    }
    if (r != 0) {
        PRINTF(ESC_WARNING "ȥѥåɤ߽˥顼ȯޤ\n" ESC_NORMAL);
        goto error_exit;
    }
    
    /*
     * 
     */
    status = 0;
    
error_exit:

    if (r != 0) {
	disp(d, r);
    }
    
    /*
     * SI¾ѥå
     */
    if (Q != NULL) {
	padmgr_UnlockSerialMesgQ( Q );
	Q = NULL;
    }

    return status;
}

static void
highscore_load(void)
{
    bzero(highscore_flags, (int)highscore_num);
    if (cassette_no == FAMICOM_ROM_CONT_PAK) {
        if (higscore_cpak_readwrite(0) != 0) {
            int i;
            for (i = 0; i < (int)highscore_num; i++) {
                highscore_flags[i] = 3;
            }
        }
    }
}

static void
highscore_setup_num(void)
{
    if (cassette_no == FAMICOM_ROM_CONT_PAK) {
        nesinfo_count_highscore();  /* highscore_num */
    } else {
        highscore_num = 20;
    }
}

static void
highscore_save(void)
{
    if (cassette_no == FAMICOM_ROM_CONT_PAK) {
        if (highscore_updated) {
            higscore_cpak_readwrite(1);
        }
    }
}

/*
 * Хåƥ꡼Хååץॳȥѥå
 */
static int
bbram_cpak_readwrite(
    int save,                    /* 0:load !0:save */
    int cont_no
    )
{
    int status = -1;		/* return value */
    static char ext_name_ascii[] = "R";
    static u8 ext_name[PFS_FILE_EXT_LEN];
    s32 file_no;
    size_t nbytes = 0x2000;     /* bbram */
    s32 r;
    OSPfs pfs;
    OSMesgQueue *Q = NULL;	/* SI Q */
    u8 *bbram = rfcstate_objectp->bbram;

    /*
     * ext_name򥢥ɤϿʸɤѴ
     */
    ascii_to_n64font(ext_name_ascii, ext_name, PFS_FILE_EXT_LEN);

    /*
     * SI¾ѥå
     */
    Q = padmgr_LockSerialMesgQ();

    /*
     * ȥѥå
     */
    r = osPfsInitPak(Q, &pfs, cont_no);
    if (r != 0) {
        PRINTF(ESC_WARNING "ȥѥå˼Ԥޤ\n" ESC_NORMAL);
        goto error_exit;
    }

    /*
     * եõʤХֻʤ롣
     */
    r = osPfsFindFile(&pfs, nesinfo_cpak_company_code, nesinfo_cpak_game_code, nesinfo_cpak_game_name, ext_name, &file_no);
    if (r != 0) {
        if (save) {
            r = osPfsAllocateFile(&pfs, nesinfo_cpak_company_code, nesinfo_cpak_game_code, nesinfo_cpak_game_name, ext_name, (int)nbytes, &file_no);
            if (r != 0) {
                PRINTF(ESC_WARNING "֥ե˼Ԥޤ\n" ESC_NORMAL);
                goto error_exit;
            } else {
                PRINTF(ESC_WARNING "֥եޤ\n" ESC_NORMAL);
            }
        } else {
            PRINTF(ESC_WARNING "֥եΥץ˼Ԥޤ\n" ESC_NORMAL);
            goto error_exit;
        }
    }

    /*
     * ǡ
     *
     * ᥤΰ˥ǡ񤭹
     * (ᥤΰΥǡɤ߹߽񤭹ͤƱǧ)
     */
    if (save) {
        r = osPfsReadWriteFile(&pfs, file_no, PFS_WRITE, 0, (int)nbytes, (u8 *)bbram);
        if (r == 0) {
            PRINTF("BBRAMΥ֤ޤ\n");
        } else {
            PRINTF(ESC_ERROR "BBRAMΥ֤˼Ԥޤ(ꥫХ̤)\n" ESC_NORMAL);
        }
    } else {
        /*
         * 
         *
         * ᥤХååפΥǡɹ
         */
        r = osPfsReadWriteFile(&pfs, file_no, PFS_READ, 0, (int)nbytes, (u8 *)bbram);
        if (r == 0) {
            PRINTF("BBRAMΥɤޤ\n");
        } else {
            PRINTF(ESC_ERROR "BBRAMΥɤ˼Ԥޤ(ꥫХ̤)\n" ESC_NORMAL);
        }
    }
    if (r != 0) {
        PRINTF(ESC_WARNING "ȥѥåɤ߽˥顼ȯޤ\n" ESC_NORMAL);
        goto error_exit;
    }
    
    /*
     * 
     */
    status = 0;
    
error_exit:

    if (r != 0) {
	disp(d, r);
    }
    
    /*
     * SI¾ѥå
     */
    if (Q != NULL) {
	padmgr_UnlockSerialMesgQ( Q );
	Q = NULL;
    }

    return status;
}

/*
 * Хåƥ꡼Хååץ(BBRAM)Υɡ
 */
#define BBRAM_MASK      0x02    /* NESإå+6ΤΥӥåȤΩäƤBBRAM */
static void
bbram_load(void)
{
    if (cassette_no == FAMICOM_ROM_CONT_PAK) {
        if ((*((u8 *)nesinfo_rom_start + 6) & BBRAM_MASK) != 0) {
            if (bbram_cpak_readwrite(0, (int)nesinfo_cpak_cont_no) != 0) {
                PRINTF1(ESC_WARNING "ȥѥå%dˤϣ£¥ǡϤʤ\n" ESC_NORMAL, nesinfo_cpak_cont_no);
                if (bbram_cpak_readwrite(0, 1 - (int)nesinfo_cpak_cont_no) != 0) {
                    PRINTF1(ESC_WARNING "ȥѥå%dˤ£¥ǡϤʤ\n" ESC_NORMAL, 1 - nesinfo_cpak_cont_no);
                }
            }
        } else {
            PRINTF("BBRAMϻȤäƤʤ褦Ǥ\n");
        }
    }
}

static void
bbram_save(void)
{
    if (cassette_no == FAMICOM_ROM_CONT_PAK) {
        if ((*((u8 *)nesinfo_rom_start + 6) & BBRAM_MASK) != 0) {
            if (bbram_cpak_readwrite(1, (int)nesinfo_cpak_cont_no) != 0) {
                PRINTF1(ESC_WARNING "ȥѥå%dˤϣ£¥ǡ򥻡֤Ǥʤ\n" ESC_NORMAL, nesinfo_cpak_cont_no);
                if (bbram_cpak_readwrite(1, 1 - (int)nesinfo_cpak_cont_no) != 0) {
                    PRINTF1(ESC_WARNING "ȥѥå%dˤ£¥ǡ򥻡֤Ǥʤ\n" ESC_NORMAL, 1 - nesinfo_cpak_cont_no);
                }
            }
        } else {
            PRINTF("BBRAMϻȤäƤʤ褦Ǥ\n");
        }
    }
}

#if !defined(STATE_SAVE_ALL)
/*
 * ֥ȥѥå
 */
static int
state_cpak_readwrite(
    int save,                    /* 0:load !0:save */
    int cont_no
    )
{
    int status = -1;		/* return value */
    static char ext_name_ascii[] = "W";
    static u8 ext_name[PFS_FILE_EXT_LEN];
    s32 file_no;
    size_t nbytes = sizeof(rfcstate_save);     /* state */
    s32 r;
    OSPfs pfs;
    OSMesgQueue *Q = NULL;	/* SI Q */
    u8 *state = (u8 *)rfcstate_bank[0];

    /*
     * ext_name򥢥ɤϿʸɤѴ
     */
    ascii_to_n64font(ext_name_ascii, ext_name, PFS_FILE_EXT_LEN);

    /*
     * SI¾ѥå
     */
    Q = padmgr_LockSerialMesgQ();

    /*
     * ȥѥå
     */
    r = osPfsInitPak(Q, &pfs, cont_no);
    if (r != 0) {
        PRINTF(ESC_WARNING "ȥѥå˼Ԥޤ\n" ESC_NORMAL);
        goto error_exit;
    }

    /*
     * եõʤХֻʤ롣
     */
    r = osPfsFindFile(&pfs, nesinfo_cpak_company_code, nesinfo_cpak_game_code, nesinfo_cpak_game_name, ext_name, &file_no);
    if (r != 0) {
        if (save) {
            r = osPfsAllocateFile(&pfs, nesinfo_cpak_company_code, nesinfo_cpak_game_code, nesinfo_cpak_game_name, ext_name, (int)nbytes, &file_no);
            if (r != 0) {
                PRINTF(ESC_WARNING "֥ե˼Ԥޤ\n" ESC_NORMAL);
                goto error_exit;
            } else {
                PRINTF(ESC_WARNING "֥եޤ\n" ESC_NORMAL);
            }
        } else {
            PRINTF(ESC_WARNING "֥եΥץ˼Ԥޤ\n" ESC_NORMAL);
            goto error_exit;
        }
    }

    /*
     * ǡ
     *
     * ᥤΰ˥ǡ񤭹
     * (ᥤΰΥǡɤ߹߽񤭹ͤƱǧ)
     */
    if (save) {
        r = osPfsReadWriteFile(&pfs, file_no, PFS_WRITE, 0, (int)nbytes, (u8 *)state);
        if (r == 0) {
            PRINTF("STATEΥ֤ޤ\n");
        } else {
            PRINTF(ESC_ERROR "STATEΥ֤˼Ԥޤ(ꥫХ̤)\n" ESC_NORMAL);
        }
    } else {
        /*
         * 
         *
         * ᥤХååפΥǡɹ
         */
        r = osPfsReadWriteFile(&pfs, file_no, PFS_READ, 0, (int)nbytes, (u8 *)state);
        if (r == 0) {
            PRINTF("STATEΥɤޤ\n");
        } else {
            PRINTF(ESC_ERROR "STATEΥɤ˼Ԥޤ(ꥫХ̤)\n" ESC_NORMAL);
        }
    }
    if (r != 0) {
        PRINTF(ESC_WARNING "ȥѥåɤ߽˥顼ȯޤ\n" ESC_NORMAL);
        goto error_exit;
    }
    
    /*
     * 
     */
    status = 0;
    
error_exit:

    if (r != 0) {
	disp(d, r);
    }
    
    /*
     * SI¾ѥå
     */
    if (Q != NULL) {
	padmgr_UnlockSerialMesgQ( Q );
	Q = NULL;
    }

    return status;
}

/*
 * ֤Υɡ
 */
static void
state_cpak_load(void)
{
    if (cassette_no == FAMICOM_ROM_CONT_PAK && rfcstate_bank[0] != NULL) {
        register int n;
        register int cont_no;
        
        for (n = 0; n < 2; n++) {
            cont_no = (int)nesinfo_cpak_cont_no ^ n;
            if (state_cpak_readwrite(0, cont_no) != 0) {
                PRINTF1(ESC_WARNING "ȥѥå%dˤϾ֥ǡϤʤ\n" ESC_NORMAL, cont_no);
            } else {
                PRINTF1(ESC_YELLOW "ȥѥå%dξ֥ǡɤޤ\n" ESC_NORMAL, cont_no);
                state_saved |= 1;
                break;
            }
        }
    }
}

static void
state_cpak_save(void)
{
    if (cassette_no == FAMICOM_ROM_CONT_PAK && ((state_saved & 1) != 0)) {
        register int n;
        register int cont_no;
        
        for (n = 0; n < 2; n++) {
            cont_no = (int)nesinfo_cpak_cont_no ^ n;
            if (state_cpak_readwrite(1, cont_no) != 0) {
                PRINTF1(ESC_WARNING "ȥѥå%dˤϾ֥ǡ򥻡֤Ǥʤ\n" ESC_NORMAL, cont_no);
            } else {
                PRINTF1(ESC_WARNING "ȥѥå%d˾֥ǡ򥻡֤ޤ\n" ESC_NORMAL, cont_no);
                break;
            }
        }
    }
}
#endif /* if !defined(STATE_SAVE_ALL) */

/****************************************************************************
 * nesinfo END
 ****************************************************************************/


/****************************************************************************
 * Ȥ߹ߥѥϥ START
 ****************************************************************************/
/*
 * BCD
 */
static int
getbcd(
    u8 *bcd_ptr,                /* Ƭݥ */
    int bcd_bytes,              /* Хȿ */
    int mode                    /* 0:12 34 (packed BCD) */
                                /* 1:01 02 03 04 (BCD) */
                                /* 2:04 03 02 01 (BCD reverse) */
                                /* 3:04 d2 (BIN) */
    )
{
    u32 high4bits;
    u32 low4bits;
    int sum;
    int add;
    int i;

    sum = 0;
    for (i = 0; i < bcd_bytes; i++) {
	if (mode == 3) {
	    add = (int)bcd_ptr[i];
	    sum *= 256;
	} else if (mode == 2) {
	    add = (int)bcd_ptr[bcd_bytes - i - 1] & 0xf;
	    sum *= 10;
	} else {		/* 0 or 1 */
	    high4bits = ((u32)bcd_ptr[i] >> 4) & 0xf;
	    low4bits = (u32)bcd_ptr[i] & 0xf;
	    add = (int)(high4bits * 10 + low4bits);
	    if (mode == 0) {
		sum *= 100;
	    } else {
		sum *= 10;
	    }
	}
	sum += add;
    }

    return sum;
}

/*
 * BCD
 */
static void
setbcd(
    u8 *bcd_ptr,                /* Ƭݥ */
    int bcd_bytes,              /* Хȿ */
    int mode,                   /* 0:12 34 (packed BCD) */
                                /* 1:01 02 03 04 (BCD) */
                                /* 2:04 03 02 01 (BCD reverse) */
                                /* 3:04 d2 (BIN) */
    int value                   /*  */
    )
{
    u32 high4bits;
    u32 low4bits;
    u32 work;
    u32 uvalue;
    int i;

    uvalue = (u32)value;
    for (i = 0; i < bcd_bytes; i++) {
	if (mode == 3) {
	    work = uvalue % 256;
	    uvalue /= 256;
	} else if (mode == 0) {
	    low4bits = uvalue % 10;
	    uvalue /= 10;
	    high4bits = uvalue % 10;
	    uvalue /= 10;
	    work = (high4bits << 4) | low4bits;
	} else {		/* 1 or 2 */
	    work = uvalue % 10;
	    uvalue /= 10;
	}
	if (mode == 2) {
	    bcd_ptr[i] = (u8)work;
	} else {
	    bcd_ptr[bcd_bytes - 1 - i] = (u8)work;
	}
    }
}

/*
 * ϥ
 */
static void
update_highscore_sub(
    int index,                  /* 0-19 */
    int index2,                 /* 0-6 */
    int offset,
    int bcd_bytes,
    int mode,
    int initial_value)
{
    Save_c *save = ZCommonGetP(save.element);
    u8 *bcd_ptr = rfcstate_objectp->wram + offset;
    int score1, score2;

    mode &= 0x7fff;
    score1 = (int)save->famicom_high_scores[index];
    if (index2 >= 0) {
        score1 += (int)save->famicom_high_scores2[index2] << 16;
    }
    score2 = getbcd(bcd_ptr, bcd_bytes, mode);

    if (highscore_flags[index] == 0) {
	if (score2 == initial_value) {
	    PRINTF1(ESC_YELLOW "ϥ %d\n" ESC_NORMAL, score1);
	    setbcd(bcd_ptr, bcd_bytes, mode, score1);
	    highscore_flags[index] = 1;
	}
    } else {
        if (score1 != score2)  {
            if (!state_loaded || enable_update_highscore_if_state_loaded) {
                PRINTF1(ESC_YELLOW "ϥ %d\n" ESC_NORMAL, score2);
                save->famicom_high_scores[index] = (u16)(score2 & 0xffff);
                if (index2 >= 0) {
                    save->famicom_high_scores2[index2] = (u8)((score2 >> 16) & 0xff);
                }
            }
        }
    }
}

/*
 * ꥻåȻΥϥ
 */
static void
reset_highscore(void)
{
    size_t idx;

    for (idx = 0; idx < (size_t)highscore_num; idx++) {
        if (highscore_flags[idx] == 1) {
            highscore_flags[idx] = 0;
        }
    }
}



/*
 * ϥ
 */
static void
getset_highscore(void)
{
    switch (cassette_no) {
    case FAMICOM_ROM_CLUCLU_LAND: /* 3-34bc 24: 00 00 73 80 */
	update_highscore_sub(0, 0, 0x20, 4, 0, HIGH_SCORE_CLUCLU_LAND);
	break;                  /* max 999990 */

    case FAMICOM_ROM_BALLOON_FIGHT:
	update_highscore_sub(1, 1, 0x629, 5, 2, HIGH_SCORE_BALLOON_FIGHT_1P);
	update_highscore_sub(2, 2, 0x62e, 5, 2, HIGH_SCORE_BALLOON_FIGHT_2P);
	update_highscore_sub(3, 3, 0x633, 5, 2, HIGH_SCORE_BALLOON_FIGHT_BT);
	break;                  /* max 999990 */

    case FAMICOM_ROM_DONKEY_KONG:
	update_highscore_sub(4, -1, 0x507, 2, 0, HIGH_SCORE_DONKEY_KONG_A);
	update_highscore_sub(5, -1, 0x509, 2, 0, HIGH_SCORE_DONKEY_KONG_B);
	break;                  /* max 999900 */

    case FAMICOM_ROM_PINBALL:
	update_highscore_sub(6, 4, 0x10e, 5, 1, HIGH_SCORE_PINBALL_A);
	update_highscore_sub(7, 5, 0x113, 5, 1, HIGH_SCORE_PINBALL_B);
	break;                  /* max 999990 */

    case FAMICOM_ROM_GOLF:
	update_highscore_sub(8, -1, 0xe, 1, 3, HIGH_SCORE_GOLF_STROKE_PLAY);
	break;                  /* max 0(-72) 18(-54)? */

    case FAMICOM_ROM_TENNIS:
				/* ϥʤ */
	break;

    case FAMICOM_ROM_S_ASOBIJ:
	update_highscore_sub(10, -1, 0x4d7, 2, 0, HIGH_SCORE_SANSU_ASOBI_1);
	update_highscore_sub(11, -1, 0x4d9, 2, 0, HIGH_SCORE_SANSU_ASOBI_2);
	update_highscore_sub(12, -1, 0x4db, 2, 0, HIGH_SCORE_SANSU_ASOBI_3);
	update_highscore_sub(13, -1, 0x4dd, 2, 0, HIGH_SCORE_SANSU_ASOBI_4);
	update_highscore_sub(14, -1, 0x4df, 2, 0, HIGH_SCORE_SANSU_ASOBI_5);
	update_highscore_sub(15, -1, 0x4e1, 2, 0, HIGH_SCORE_SANSU_ASOBI_6);
	update_highscore_sub(16, -1, 0x4e3, 2, 0, HIGH_SCORE_SANSU_ASOBI_7);
	update_highscore_sub(17, -1, 0x4e5, 2, 0, HIGH_SCORE_SANSU_ASOBI_8);
	update_highscore_sub(18, -1, 0x4e7, 2, 0, HIGH_SCORE_SANSU_ASOBI_9);
	break;                  /* max 999999 10000ĶȥХ ºݤ1000Ķ뤳ȤϤʤ */
    }
}
/****************************************************************************
 * Ȥ߹ߥѥϥ END
 ****************************************************************************/



/***************************************************************************
 * եߥ󥪡ǥ START
 ***************************************************************************/
/*
 * եߥ󥪡ǥᥤ
 */
static void
famicom_audio_main(void *arg)
{
    irqmgr_client_t client;
    FamicomAudioMsg *msg = NULL;
    int done;

#if DEBUG
    PRINTF0("եߥ󥪡ǥåɼ¹Գ\n");
#endif

    /* ȥ졼å褦ˤ */
    irqmgr_AddClient(&client, &famicom_audioFrameMsgQ);
    
    /*
     *	ᥤ 롼
     */
    done = 0;
    while (!done) {
	/* åԤ */
	osRecvMesg(&famicom_audioFrameMsgQ, (OSMesg *)&msg, OS_MESG_BLOCK);
	if ((int)msg == 999) {
	    done = 1;
	} else {
	    switch (msg->gen.type) {
	    case (IRQMGR_RETRACE_MSG): /* ȥ졼ȯ */
                audio_doing = 1;
                if (play_left != 0 && !audio_pause) {
                    ks_nes_audio_main();
                }
                audio_doing = 0;
		break;
	    case (IRQMGR_PRE_NMI_MSG): /* PRENMI */
		break;
	    case (IRQMGR_PRENMI500_MSG): /* PRENMI */
		break;
	    }
	}
    }
    
    irqmgr_RemoveClient(&client);
    
    PRINTF0("եߥ󥪡ǥåɼ¹Խλ\n");

    if (arg != NULL) {
	osSendMesg((OSMesgQueue *)arg, NULL, OS_MESG_BLOCK);
    }
}

/*
 * եߥ󥪡ǥ
 */
static void
famicom_audio_init(void)
{

    audio_doing = 0;

    /*
     * ߥ
     */
    ks_nes_audio_init(noise_datap);

    /*
     * å塼ν
     */
    osCreateMesgQueue(&famicom_audioFrameMsgQ, famicom_audioFrameMsgBuf, number(famicom_audioFrameMsgBuf));
    osCreateMesgQueue(&famicom_audioDestroyMsgQ, famicom_audioDestroyMsgBuf, number(famicom_audioDestroyMsgBuf));
    
    /*
     * ǥåɤκȵư
     */
    StackCheckInit(famicom_audio);
    osCreateThread(&famicom_audioThread, THREAD_ID_FAMICOM_AUDIO, famicom_audio_main, &famicom_audioDestroyMsgQ, famicom_audioStack + number(famicom_audioStack), PRIORITY_FAMICOM_AUDIO);
    osStartThread(&famicom_audioThread);
}

/*
 * եߥ󥪡ǥ
 */
static void
famicom_audio_cleanup(GAME *game)
{
    (void)game;

    /* åɽλ */
    osSendMesg(&famicom_audioFrameMsgQ, (OSMesg)999, OS_MESG_BLOCK);
    osRecvMesg(&famicom_audioDestroyMsgQ, NULL, OS_MESG_BLOCK);
    osDestroyThread(&famicom_audioThread);
    stackcheck_check_stack(&famicom_audio_stackcheck);
    StackCheckCleanup(famicom_audio);

    /* ɥ饤нλ */
    ks_nes_audio_cleanup();

    /* ֥Υʤʤ褦˥ */
    while (osAiGetStatus() & AI_STATUS_DMA_BUSY)
        usleep(1000);
}

/***************************************************************************
 * եߥ󥪡ǥ END
 ***************************************************************************/


/***************************************************************************
 * state save/load START
 ***************************************************************************/

/*
 * ȥ
 * ˥֤
 */
static OSTime auto_save_last_time; /* Ǹ˥֤ */
static s8 auto_save_next_bank = 4; /* Υ֥Х(̣ӥåȤȿž) */
static s8 auto_save_last_bank = -1;  /* 4,5:Ǹ˥ȥ֤Х */

/*
 * ֥ΰ
 */
static void
state_alloc(int bank)
{
#if DEBUG
    assert(bank < (int)number(rfcstate_bank));
#endif /* DEBUG */
    if (rfcstate_bank[bank] == NULL) {
        rfcstate_bank[bank] = (rfcstate_save *)my_alloc(sizeof(rfcstate_save));
    }
}

static void
audio_stop(void)
{
    audio_pause = 1;
    while (audio_doing)
        ;
}
static void
audio_continue(void)
{
    audio_pause = 0;
}

/*
 * ֥
 */
static void
state_save(int bank)
{
#if DEBUG
    assert(bank < (int)number(rfcstate_bank));
#endif /* DEBUG */
    if (rfcstate_bank[bank] != NULL) {
        audio_stop();
        osWritebackDCache(rfcstate_objectp, (s32)sizeof(rfcstate_object));
#if defined(STATE_SAVE_ALL)
        bcopy(rfcstate_objectp, rfcstate_bank[bank], sizeof(rfcstate_save));
#else
        bcopy(rfcstate_objectp, rfcstate_bank[bank]->u8buf, sizeof(rfcstate_bank[bank]->u8buf));
        bcopy(&rfcstate_objectp->gfxbuf[OFFSET_GFXBUF_DRAW_VRAM], rfcstate_bank[bank]->vram_bak, sizeof(rfcstate_bank[bank]->vram_bak));
#endif
        audio_continue();
        PRINTF1("֥ %d\n", bank);
    }
}

/*
 * ֥
 */
static void
state_load(int bank)
{
    if (rfcstate_bank[bank] != NULL) {
        audio_stop();
#if defined(STATE_SAVE_ALL)
        bcopy(rfcstate_bank[bank], rfcstate_objectp, sizeof(rfcstate_save));
#else
        bcopy(rfcstate_bank[bank]->u8buf, rfcstate_objectp, sizeof(rfcstate_bank[bank]->u8buf));
        bcopy(rfcstate_bank[bank]->vram_bak, &rfcstate_objectp->gfxbuf[OFFSET_GFXBUF_DRAW_VRAM], sizeof(rfcstate_bank[bank]->vram_bak));
#endif
        osWritebackDCache(rfcstate_objectp, (s32)sizeof(rfcstate_object));
        audio_continue();
        PRINTF1("֥ %d\n", bank);
        auto_save_last_time = osGetTime();
    }
}

/*
 * ֥ɤΣ(ͽ)
 */
static void
state_load3(int bank)
{
    state_load_no = (u8)(bank + 1);
}

/*
 * ֥֤Σ(ͽ)
 */
static void
state_save3(int bank)
{
    state_save_no = (u8)(bank + 1);
}

/*
 * ֥ɤΣ
 * ݡĤ
 */
static void
state_load2(int bank)
{
    if ((u32)state_saved & (u32)(1lu << bank)) {
        u32 work_rspsignal_bak;

        work_rspsignal_bak = rfcstate_objectp -> work_rspsignal;
        state_load(bank);
        rfcstate_objectp -> work_rspsignal = work_rspsignal_bak;
        state_loaded |= (u8)(1lu << bank);
    }
}

/*
 * ֥֤Σ(ΰݤĤ)
 */
static void
state_save2(int bank)
{
#if DEBUG
    assert(bank < (int)number(rfcstate_bank));
#endif /* DEBUG */
    state_save(bank);
    state_saved |= (u8)(1lu << bank);
}

/*
 * ֽ֥
 */
static void
state_save_init(void)
{
    int bank;
    
    bzero(rfcstate_bank, sizeof(rfcstate_bank));
    for (bank = 0; bank < (int)number(rfcstate_bank); bank++)
        state_alloc(bank);
}

/*
 * ȥ֥ե졼()
 */
static void
auto_save_move(void)
{
    OSTime now_time;
    unsigned int sec;

    now_time = osGetTime();
    sec = (enable_state_save <= 1) ? 10u : (unsigned int)enable_state_save;
    if (now_time > auto_save_last_time + OS_USEC_TO_CYCLES(sec * 1000 * 1000)) {
        state_save3((int)auto_save_next_bank);
        auto_save_last_bank = auto_save_next_bank;
        auto_save_next_bank ^= 1;
        auto_save_last_time = now_time;
    }
}

/*
 * ȥ֤
 */
static void
auto_save_load(int n)
{
    int auto_save_load_bank;

    if ((int)auto_save_last_bank == 4 || (int)auto_save_last_bank == 5) {
        auto_save_load_bank = (int)auto_save_last_bank ^ (n != 0);
        state_load3(auto_save_load_bank);
        auto_save_next_bank = (s8)(auto_save_load_bank ^ 1);
    }
}

/*
 * ȥֽ
 */
static void
auto_save_init(void)
{
    auto_save_next_bank = 4;
    auto_save_last_bank = -1;
    auto_save_last_time = osGetTime();
}
/***************************************************************************
 * state save/load END
 ***************************************************************************/

/*
 * ̤Ƥ।᡼Ÿ
 */
extern void slidstart(unsigned char *,unsigned char *);
static void
game_expand(void)
{
    if (nesinfo_expand_rom_size == 0) {
        nesinfo_expand_rom_size = nesinfo_data_size * 2 + 0x8000;
    }
    nesinfo_rom_start = (u8 *)my_alloc(nesinfo_expand_rom_size);
    if (nesinfo_rom_start != NULL) {
        slidstart(nesinfo_data_start, nesinfo_rom_start);
    }
}

/*
 * ˥ɤ
 * ؿ  NULL:ɤǤʤä(ޤϥ­)
 *        !NULL:ݥ
 */
static u8 *
game_load(void)
{
    bcopy(M_CPAK_GAME_NAME, nesinfo_cpak_game_name, sizeof(nesinfo_cpak_game_name));
    
    nesinfo_rom_start = NULL;
    if (!returnable) {
#if defined(ROM_D)
#if defined(LEOFILEOUT)
        char fnm[] = "testrom.nes" ;
        size_t file_size;
        size_t tags_size;
        int r;
        
        PRINTF0("ե뤫ɤޤ\n");
        cassette_no = FAMICOM_ROM_CONT_PAK;
        file_size = (size_t)filesys_length(fnm);
        if (file_size > 0) {
            u8 *fileread_ptr = NULL;
            nesinfo_header_t nesinfo_temp;
            
            PRINTF1("եĹ:%d\n", file_size);
            r = filesys_load((u8 *)&nesinfo_temp, fnm, 16);
            if (bcmp(nesinfo_temp.nesinfo_id, nesinfoz, sizeof(nesinfoz)) == 0) {
                PRINTF("NESINFOޤ\n");
                PRINTF1(ESC_GREEN "ߥ졼।᡼ѥ %08x Х\n" ESC_NORMAL, file_size);
                nesinfo_ptr = (u8 *)my_alloc(file_size);
                if (nesinfo_ptr != NULL) {
                    fileread_ptr = nesinfo_ptr;
                }
            } else {
                PRINTF("NESINFOޤ\n");
                
                tags_size = UPBOUND(sizeof(nesinfo_template), 16);
                
                PRINTF1(ESC_GREEN "ߥ졼।᡼ѥ %08x Х\n" ESC_NORMAL, sizeof(nesinfo_header_t) + tags_size + file_size);
                nesinfo_ptr = (u8 *)my_alloc(sizeof(nesinfo_header_t) + tags_size + file_size);
                if (nesinfo_ptr != NULL) {
                    bzero(nesinfo_ptr, (int)(sizeof(nesinfo_header_t) + tags_size));
                    nesinfo_header_p = (nesinfo_header_t *)nesinfo_ptr;
                    bcopy(nesinfoz, nesinfo_header_p->nesinfo_id, sizeof(nesinfo_header_p->nesinfo_id));
                    nesinfo_header_p->version[0] = 0; /* С */
                    nesinfo_header_p->version[1] = 0; /* С󾮿 */
                    nesinfo_header_p->tags_size = (u16)tags_size;
                    nesinfo_header_p->data_size = (u32)file_size;
                    
                    nesinfo_template[sizeof(nesinfo_template) - 1] = (u8)(tags_size - sizeof(nesinfo_template)); /* 'E' 'N' 'D' θ˥ѥǥ󥰥Хȿ */
                    bcopy(nesinfo_template, (u8 *)(nesinfo_header_p + 1), sizeof(nesinfo_template));
                    
                    fileread_ptr = nesinfo_ptr + sizeof(nesinfo_header_t) + tags_size;
                }
            }
            if (fileread_ptr != NULL) {
                r = filesys_load(fileread_ptr, fnm, file_size);
                if (r != 0) {
                    PRINTF1(ESC_ERROR "եɹ߼ %s\n" ESC_NORMAL, fnm);
                    nesinfo_ptr = NULL;
                } else {
                    nesinfo_head_check();
                }
            }
            
       }
#else
        {
            /*
             * 0x03000000-0x030fffffޤǤŪɤǤߤ
             */
            u32 rom_start = 0x03000000;
            size_t rom_size = 0x00100000;
            
            nesinfo_ptr = (u8 *)my_alloc(rom_size);
            if (nesinfo_ptr != NULL) {
                dmacopy_fg(nesinfo_ptr, rom_start, (u32)rom_size);
                nesinfo_head_check();
            } else {
                PRINTF(ESC_ERROR "1MBΥΰγݤ˼Ԥޤ" ESC_NORMAL);
            }
        }
#endif /* if defined(LEOFILEOUT) */
#endif /* defined(ROM_D) */
    } else if (cassette_no == FAMICOM_ROM_CONT_PAK) {
        PRINTF0("򥳥ȥѥåɤޤ\n");
        /*
         * ȥѥå।᡼ɹ
         */
        nesinfo_ptr = (u8 *)game_cpak_read_alloc((int)(nesinfo_cpak_cont_no = 0));
        if (nesinfo_ptr == NULL) {
            nesinfo_ptr = (u8 *)game_cpak_read_alloc((int)(nesinfo_cpak_cont_no = 1));
        }
        if (nesinfo_ptr != NULL) {
            nesinfo_head_check();
        }
    } else {
        /*
         * åȤ।᡼ɹ
         */
        u32 rom_start,
            rom_end;
        size_t rom_size;
        
        PRINTF0("򣶣åȤɤޤ\n");

        get_rom_start_end((int)cassette_no, &rom_start, &rom_end);
        rom_size = (size_t)(rom_end - rom_start);
        
#if DEBUG
        PRINTF1(ESC_GREEN "ߥ졼।᡼ѥ %08x Х\n" ESC_NORMAL, sizeof(nesinfo_header_t) + rom_size);
#endif /* DEBUG */
        nesinfo_ptr = (u8 *)my_alloc(sizeof(nesinfo_header_t) + rom_size);

        if (nesinfo_ptr != NULL) {
            nesinfo_header_p = (nesinfo_header_t *)nesinfo_ptr;
            bcopy(nesinfoz, nesinfo_header_p->nesinfo_id, sizeof(nesinfo_header_p->nesinfo_id));
            nesinfo_header_p->version[0] = 0;
            nesinfo_header_p->version[1] = 0;
            nesinfo_header_p->tags_size = 0;
            nesinfo_header_p->data_size = (u32)rom_size;
            nesinfo_rom_start = (u8 *)(nesinfo_header_p + 1);
            
            dmacopy_fg(nesinfo_rom_start, rom_start, (u32)rom_size);
            
            nesinfo_head_check();
        }
    }

    return nesinfo_rom_start;
}

/*
 * ѥåɾ򥨥ߥ졼Ѥ˥С
 */
static void
famicom_convert_buttons(Pad *pads, u16 *buttons)
{
    int padno;

    buttons[0] = pads[0].now.button;
    buttons[1] = pads[1].now.button;
    buttons[2] = pads[2].now.button;
    buttons[3] = pads[3].now.button;

    /*
     * ĥƥåǤǽˤ
     */
    for (padno = 0; padno < 2; padno++) {
	if ((buttons[padno] & (U_JPAD|L_JPAD|R_JPAD|D_JPAD)) == 0) {
	    int x = (int)pad_logical_stick_x(&pads[padno]);
	    int y = (int)pad_logical_stick_y(&pads[padno]);
	    
	    if (x <= -JMAX / 4) {
		buttons[padno] |= L_JPAD;
	    } else if (x >= JMAX / 4) {
		buttons[padno] |= R_JPAD;
	    }
	    if (y <= -JMAX / 4) {
		buttons[padno] |= D_JPAD;
	    } else if (y >= JMAX / 4) {
		buttons[padno] |= U_JPAD;
	    }
	}
    }
 
}

static u32 c_buttons_or;        /* !0:줫ΥȥǣäƤ */
static u8 auto_save_n;          /* ȥ֤ΥɥХ */

/*
 * ⡼ɤǥեߥ󤹤ȰʲΥǥХåǽȤޤ
 *
 * ̣Ʊܣڤǽλ()
 * ڡܸ̣Ʊǥꥻå
 * ̣ƱǶݡ
 * ¡쥯ȡȤΤɤ줫ܸ̤ǤΥϢ
 * ̡ܣþ ®⡼
 * ̡ܣò ®⡼
 * ̡ܣú ɸ®⡼
 * ҡܣä줫 ֥
 * ä줫ܸ ֥
 * Ʊܸ ξ֥
 */
static void
famicom_debug_proc(GAME *game)
{
    int pad_no;
    
    for (pad_no = 0; pad_no < 2; pad_no++) {
        Pad *pad = &game->pads[pad_no];

        u32 a_buttons = (u32)Pad_button() | (u32)Pad_trigger();
        u32 b_buttons = a_buttons & (A_BUTTON | B_BUTTON | Z_TRIG | START_BUTTON | U_JPAD | D_JPAD | L_JPAD | R_JPAD);
        u32 c_buttons = a_buttons & (U_CBUTTONS | L_CBUTTONS | R_CBUTTONS | D_CBUTTONS);

        c_buttons_or |= c_buttons;
    
        /*
         * ̣Ʊܣڤǽλ
         */
        if (Pad_on_trigger(Z_TRIG) && a_buttons == (Z_TRIG|R_TRIG|L_TRIG)) {

            PRINTF(ESC_YELLOW "̣Ʊܣڤǽλ()\n" ESC_NORMAL);
            if (lrz_pressed == 0) {
                lrz_pressed = 1;
                highscore_save();
                if (enable_bbram_save) {
                    bbram_save();
                }
                if (enable_state_cpak) {
                    state_cpak_save();
                }
            }
        }
        if (Pad_on_trigger(0x0080)) { /* L+R+START */
            ks_nes_autofire_set(pad_no, 0xff00, 3);
        }
        if (Pad_push_also(R_TRIG) && Pad_push_also(L_TRIG)) {
            if (Pad_on_trigger(R_TRIG) || Pad_on_trigger(L_TRIG)) {
                if (a_buttons == (Z_TRIG|R_TRIG|L_TRIG)) {
                    if (enable_force_reset && force_reset == 0) {
                        PRINTF(ESC_YELLOW "ڡܸ̣Ʊǥꥻå\n" ESC_NORMAL);
                        force_reset = 1;
                        play_left = -1;
                    }
                } else {
                    if (enable_force_pause) {
                        if (play_left < 0) {
                            PRINTF(ESC_YELLOW "̣ƱǶݡ\n" ESC_NORMAL);
                            play_left = 2;
                        } else if (play_left == 0) {
                            PRINTF(ESC_YELLOW "θ̣ƱΥǶݡ\n" ESC_NORMAL);
                            force_pause_sub = 1;
                        }

                    }
                }
            }
#if DEBUG
            /*
             * ϥĴ
             */
            if (Pad_on_trigger(U_CBUTTONS)) {
                dump(rfcstate_objectp->wram + 0x000, 0x200);
            }
            if (Pad_on_trigger(L_CBUTTONS)) {
                dump(rfcstate_objectp->wram + 0x200, 0x600);
            }
            if (Pad_on_trigger(R_CBUTTONS)) {
                int score = getbcd(rfcstate_objectp->wram + (int)GETHREG(3), (int)GETHREG(4), (int)GETHREG(5));
                SETHREG(1, (short)(score / 10000));
                SETHREG(2, (short)(score % 10000));
            }
            if (Pad_on_trigger(D_CBUTTONS)) {
                setbcd(rfcstate_objectp->wram + (int)GETHREG(3), (int)GETHREG(4), (int)GETHREG(5), (int)GETHREG(1) * 10000 + (int)GETHREG(2));
            }
#endif /* DEBUG */
        } else if (Pad_push_also(L_TRIG) && !Pad_push_also(R_TRIG)) {
            if (Pad_on_trigger(L_TRIG)) {
                u32 af_buttons;

                af_buttons = b_buttons & (u32)(enable_auto_fire << 8);
                if (enable_auto_fire) {
                    if (af_buttons != 0) {
                        ks_nes_autofire_change(pad_no, af_buttons, (u32)max_fire);
                    }
                }
            }
            /* ԡɥȥ */
            if (enable_speed_control) {
                if (ks_nes_speed < max_speed && Pad_on_trigger(U_CBUTTONS))/* ԡɥå */
                    ks_nes_speed += 1;
                if ((int)ks_nes_speed > min_speed && Pad_on_trigger(D_CBUTTONS)) /* ԡɥ */
                    ks_nes_speed -= 1;
                if (Pad_on_trigger(L_CBUTTONS)) /* ԡɥΡޥ */
                    ks_nes_speed = 1;
            }
            if (Pad_on_trigger(R_CBUTTONS) ) {
                if (Pad_push_also(L_CBUTTONS)) {/* Сʤ⡼ */
                    if (enable_no9over_mode) {
                        ks_nes_no9over_mode = (u8)!ks_nes_no9over_mode;
                    }
                } else {        /* 1.5®⡼ */
                    if (enable_speed_x2_alt) {
                        ks_nes_speed_x2_alt = (u8)!ks_nes_speed_x2_alt;
                    }
                }
            }
        } else if (Pad_on_trigger(R_TRIG) && !Pad_push_also(L_TRIG)) {
            if (enable_state_save) {
                if (c_buttons == (U_CBUTTONS|L_CBUTTONS|R_CBUTTONS|D_CBUTTONS)) {
                    auto_save_load((int)auto_save_n);
                    auto_save_n ^= 1;
                }
                else if (c_buttons == (U_CBUTTONS)) { state_load3(0); }
                else if (c_buttons == (L_CBUTTONS)) { state_load3(1); }
                else if (c_buttons == (R_CBUTTONS)) { state_load3(2); }
                else if (c_buttons == (D_CBUTTONS)) { state_load3(3); }
            }
        } else if (Pad_push_also(R_TRIG) && !Pad_push_also(L_TRIG)) {
            if (enable_state_save) {
                if (Pad_on_trigger(U_CBUTTONS)) { state_save3(0); }
                if (Pad_on_trigger(L_CBUTTONS)) { state_save3(1); }
                if (Pad_on_trigger(R_CBUTTONS)) { state_save3(2); }
                if (Pad_on_trigger(D_CBUTTONS)) { state_save3(3); }
            }
        } else if ((Pad_off_trigger(R_TRIG) || Pad_off_trigger(L_TRIG)) && !Pad_push_also(R_TRIG) && !Pad_push_also(L_TRIG)) {
            if (force_pause_sub) {
                force_pause_sub = 0;
                play_left = -1;
            }
        }
    } /* for (pad_no = 0; pad_no < 2; pad_no++) */
} /* famicom_debug_proc */

/*
 * ֽ
 */
static void
famicom_state_process(void)
{
    /*
     * ϥå
     * ֥ɤԤä,ϥ򹹿ʤ
     */
    if (nesinfo_tags_start != NULL) {
        nesinfo_update_highscore();
    } else {
        getset_highscore();
    }
    
    if (enable_state_save) {
        if (c_buttons_or == 0) {
            auto_save_move();         /* ˥֤ */
            auto_save_n = 0;
        }
    }

    if (state_save_no) {
        state_save2(state_save_no - 1);
        state_save_no = 0;
    }
    if (state_load_no) {
        state_load2(state_load_no - 1);
        state_load_no = 0;
        if (play_left == 0)
            play_left = 2;
    }
}

/***************************************************************************
 * ߥᥤ START
 ***************************************************************************/

static void
ovl_draw(gfxprint_t *gfxprint)
{
#if DEBUG
    if (play_left == 0) {
	Gfxprint_color(255, 255, 255, 255);
	Gfxprint_locate8x8(14, 17);
	Gfxprint_printf0("PAUSE!!");
    }
#else
    (void)gfxprint;
#endif /* DEBUG */
}

/*
 * ߥᥤե졼
 */
static void
famicom_emu_main(GAME *game)
{
    GRAPH *graph = game->graph;
    u16 buttons[4];
    Pad *pad = &game->pads[0];

    /*
     * ե졼ꤷ SP ¹
     */
    if (game->_doing && need_maketask && force_reset == 0) {
        need_maketask = 0;
	ks_nes_maketask(&os_sc_task.list, graph->FrameBufferP); /* 1800us */
	os_sc_task.flags = OS_SC_NEEDS_RSP | OS_SC_LAST_TASK | OS_SC_SWAPBUFFER;
        os_sc_task.flags &= ~(OS_SC_LAST_TASK |OS_SC_SWAPBUFFER);
	os_sc_task.flags = OS_SC_NEEDS_RSP;
        if ((int)frame_cnt < 100) {
            if ((int)frame_cnt < blackout_frame) {
                DisableNextSwapFrame(); /* Τɽʤ */
            }
	    frame_cnt++;
	}
	/*
	 * cfbinfo 
	 */
        cfbinfo_p = next_cfbinfo();
        
        cfbinfo_p->framebuffer = graph->FrameBufferP;;
        os_sc_task.cfbinfo = cfbinfo_p;
                
	/*
	 * Ͽ
	 */
	osSendMesg(osScGetCmdQ(), (OSMesg)&os_sc_task, OS_MESG_BLOCK);
	osScKickEntryMsg();
        famicom_sp_doing = 1;
    } /* if (game->_doing) */

    c_buttons_or = 0;
    famicom_debug_proc(game);

    /*
     * ̣ңڤƤȤեɥȡߥ彪λԤ
     */
    if (lrz_pressed != 0) {
        if (force_reset != 0) {
            PRINTF0(ESC_YELLOW "ꥻåȺϸʤ\n" ESC_NORMAL);
        } else {
            register int next_fade_alpha;

            next_fade_alpha = (int)fade_alpha + 5;
            if (next_fade_alpha <= 255) {
                fade_alpha = (u8)next_fade_alpha;
            } else if (returnable) {
                return_emu_game(game);
            } else {
                PRINTF(ESC_ERROR "Ȥʤ\n" ESC_NORMAL);
                game_goto_next_game_name(game, trademark, TRADEMARK);
            }
        }
    }

    /*
     * ѥåɾ򥨥ߥ졼Ѥ˥С
     */
    famicom_convert_buttons(pad, buttons);
    
    /*
     * SP ʬޤǿʤߡCPU ȤΥϥɥԤ
     */
    ks_nes_wait_rsp();
    
    /*
     * ߥ졼ϥɥ
     */
    if (game->_doing && play_left != 0) {
        if (play_left > 0)
            play_left--;
        if (force_reset == 2)
            force_reset = 0;
        ks_nes_handshake(buttons); /* 5000us */
        need_maketask = 1;
    }
    
    /*
     * ԡĴ
     */
    if (ks_nes_speed <= 0) {
        SetGameFrame(2 - ks_nes_speed);
    } else {
        SetGameFrame(1);
    }

    /*
     * ֽ
     */
    famicom_state_process();

    if (GETHREG(7)) {
        DisableNextGfxTask();   /*  */
    } else {
        PreRender_t prerender;
        register void *zbuf = sys_zb_get_pointer();
        register void *fbuf = graph->FrameBufferP;
        Gfx *gp;

        OPEN_DISP(graph);
        gp = NOW_POLY_OPA_DISP;
        PreRender_init(&prerender);
        PreRender_setup_renderbuf(&prerender, 320, 240, fbuf, NULL);
        PreRender_setup_savebuf(&prerender, 320, 240, zbuf, NULL, NULL);
        if (GETHREG(8)) {
            /* ֥ХåեƤե졼ХåեȾƩǽ񤭲ä */
            PreRender_loadFrameBufferAlpha(&prerender, &gp, (int)HREG(9));
            /* ե졼ХåեƤ򥻡֥Хåե¸ */
            PreRender_saveFrameBuffer(&prerender, &gp);
        } else if (play_left == 0) {
            PreRender_TransBufferCopy(&prerender, &gp, zbuf, fbuf, G_AC_NONE);
                                /* wbcfbԡ */
        } else if (play_left == 1) {
            PreRender_TransBufferCopy(&prerender, &gp, fbuf, zbuf, G_AC_NONE);
                                /* cfbwbԡ */
        }
        PreRender_cleanup(&prerender);
        SET_NOW_POLY_OPA_DISP(gp);
        
        gSPDisplayList(NEXT_POLY_OPA_DISP, RSP_RDP_clear_data);
        gDPSetScissor(NEXT_POLY_OPA_DISP, G_SC_NON_INTERLACE, 0, 0, 320, 240);
        gDPSetColorImage(NEXT_POLY_OPA_DISP, G_IM_FMT_RGBA, G_IM_SIZ_16b, 320, graph->FrameBufferP);
        
        if (fade_alpha != 0) {
            gp = NEXT_OVERLAY_DISP;
            fade_black_draw(&gp, (u32)fade_alpha);
            SET_NOW_OVERLAY_DISP(gp);
        }

        {
            gfxprint_t gfxprintx, *gfxprint = &gfxprintx;
            Gfx *gp_save;
            
            Gfxprint_init();
            gp = gfxopen(gp_save = NOW_DISP);
            gSPDisplayList(NEXT_OVERLAY_DISP, gp);
            Gfxprint_open(gp);
            ovl_draw(gfxprint);
            gp = Gfxprint_close();
            gSPEndDisplayList(gp++);
            gfxclose(gp_save, gp);
            SET_NOW_DISP(gp);
        }
        
        CLOSE_DISP(graph);
        game_debug_draw_last(game, graph); /* ǥХåɽ */
    }
    
    /*
     * ꥻå
     * λӣФߤޤäƤ뤳Ȥ
     */
    if (force_reset == 1) {
        force_reset = 2;
        if (nesinfo_tags_start != NULL) {
            nesinfo_reset_highscore();
        } else {
            reset_highscore();
        }
#if 0
        if (enable_force_reset == 2) {
            ks_nes_clear_wram();
        }
#else
        if (clear_wram_on_reset) {
            ks_nes_clear_wram();
        }
#endif
        ks_nes_reset();
        viBlack(1);
        sched_class.firsttime = 1;
        frame_cnt = 0;
        graph->need_viupdate = 1;
//      osSendMesg(&ostaskmsgQ, NULL, OS_MESG_BLOCK); /* ߡå */
    }

    /*
     * SPλԤ
     */
    if (famicom_sp_doing) {
        osRecvMesg(&ostaskmsgQ, NULL, OS_MESG_BLOCK);
        famicom_sp_doing = 0;
    }
} /* famicom_emu_main */

/*
 * եߥ󥨥ߥ
 * ROMɹߤϣ
 *  64Υå
 *  ȥѥå
 *  host I/O(ȥѥåؤΥ֤)
 * 
 */
extern void
famicom_emu_init(GAME *game)
{
    GRAPH *graph = game->graph;
    const u32 noise_rom_size = (u32)_nes_noiseSegmentRomEnd - (u32)_nes_noiseSegmentRomStart;      /* Υǡ */
    const size_t resize_max = 1024 * 8000;

    /*
     * ϥꥵκ()
     */
    game_resize_hyral(game, resize_max);

    ZCommonGetP(famicomemu)->error_code = 0;
    cassette_no = (u8)ZCommonGetP(famicomemu)->cassette_no;
    returnable = (u8)(ZCommonGetP(emu_ret_data)->next_scene_no != 0);

    /*
     * ؿݥ󥿽
     */
    game->exec = famicom_emu_main;
    game->cleanup = famicom_emu_cleanup;

    /*
     * եߥ󤺤⡼
     */
    if (M_APPNMI_TST_ZURUMODE3()) {
        osAppNMIBuffer[14] = (s32)0xffffffffu;
        osAppNMIBuffer[13] = (s32)((A_BUTTON|B_BUTTON|START_BUTTON|Z_TRIG) >> 8);
    }
    {
        u32 flags = (u32)osAppNMIBuffer[14];
        size_t i;

        for (i = 0; i < number(enables); i++) {
            enables[i] = (u8)((flags >> i ) & 1u);
        }
        enable_auto_fire = (u8)osAppNMIBuffer[13];
    }

    
    blackout_frame = 1;
    
    /*
     * ֥å
     */
    viBlack(1);
    sched_class.firsttime = 1;

#if DEBUG
    /*
     * ǥХåϣͤΥ򾡼˻Ȥ
     */
    {
        char *memptr;
        
        memptr = (char *)UPBOUND(sys_cfb_get_bottom(), 64);
        my_alloc_init(game, (void *)memptr, (size_t)(osMemSize - ((u32)memptr - 0x80000000lu)), (void *)NULL, 0);
    }
#else
    my_alloc_init(game, (void *)NULL, 0, (void *)NULL, 0);
#endif /* DEBUG */
    
    /* nesinfo */
    nesinfo_init();

    /*
     * ߥ졼
     */
    noise_datap = (u8 *)my_alloc((size_t)noise_rom_size); /* Υǡΰ */
    rfcstate_objectp = (rfcstate_object *)my_alloc(SIZEOF_RFCSTATE);
    ucode_workp = (u8 *)my_alloc(SIZEOF_UCODEWK);
    headerp = (u8 *)my_alloc(SIZEOF_EMUHEADER);

#if DEBUG
    PRINTF2(ESC_GREEN "rfcstate_object %08x Х %08x\n" ESC_NORMAL, SIZEOF_RFCSTATE, rfcstate_objectp);
    PRINTF2(ESC_GREEN "headerp %08x Х %08x\n" ESC_NORMAL, SIZEOF_EMUHEADER, headerp);
    PRINTF2(ESC_GREEN "UCODE %08x Х %08x\n" ESC_NORMAL, SIZEOF_UCODEWK, ucode_workp);
#endif /* DEBUG */

#if DEBUG
    zelda_DisplayArena();
    DisplayArena();
#endif /* DEBUG */
    /*
     * ˥ɤ
     */
    game_load();

    /*
     * 
     */
    nesinfo_tag_process1(nesinfo_tags_start);

    /*
     * λ nesinfo_rom_start ꤵƤʤ
     * nesinfo_data_start Ƥ NES ä nesinfo_rom_start ꤹ
     * ̤ƤŸ
     */
    if (nesinfo_rom_start == NULL && nesinfo_data_start != NULL) {
        if (bcmp(nesinfo_data_start, nesz, sizeof(nesz)) == 0) {
            nesinfo_rom_start = nesinfo_data_start;
        } else if (bcmp(nesinfo_data_start, "Yay0", 4) == 0) {
            PRINTF("̥ǡŸޤ\n");
            game_expand();
            PRINTF("̥ǡŸޤ\n");
        }
    }
    
    /*
     * 2
     */
    nesinfo_tag_process2(nesinfo_tags_start);

    /*
     * NESإå򸵤˥ॵȥཪλɥ쥹׻
     */
    if (nesinfo_rom_start != NULL) {
        nesinfo_rom_size = (size_t)(*(nesinfo_rom_start + 4) * 0x4000 + *(nesinfo_rom_start + 5) * 0x2000) + 16;
        nesinfo_rom_end = nesinfo_rom_start + nesinfo_rom_size;
    }

#if DEBUG
    if (nesinfo_rom_start != NULL && nesinfo_expand_rom_size > 0) {
        memset(nesinfo_rom_end, 0x55, nesinfo_expand_rom_size - nesinfo_rom_size);
    }
#endif /* DEBUG */

    
    /*
     * ϥ
     */
    highscore_setup_num();
    highscore_flags = (u8 *)my_alloc((size_t)highscore_num);
    highscore_load();

    /*
     * 뤯ɤȥХ롼եȤϥꥻåȤƤϥäʤ
     */
    if (cassette_no == FAMICOM_ROM_CLUCLU_LAND || cassette_no == FAMICOM_ROM_BALLOON_FIGHT) {
        clear_wram_on_reset = 1;
#if 0
        if (enable_force_reset != 0) {
            enable_force_reset = 2;
        }
#endif
    }

    /*
     * ֽ֥
     */
    state_save_init();
    auto_save_init();
	
    disp(08x,nesinfo_rom_start);
    disp(08x,nesinfo_rom_end);
    disp(08x,nesinfo_header_p);
    disp(08x,nesinfo_tags_start);
    disp(08x,nesinfo_tags_end);
    disp(08x,nesinfo_data_start);
    disp(08x,nesinfo_data_end);
    
    my_alloc_dispinfo();
#if DEBUG
    zelda_DisplayArena();
    DisplayArena();
#endif /* DEBUG */
    
    /*
     * Υǡģͣ
     */
    dmacopy_fg(noise_datap, (u32)_nes_noiseSegmentRomStart, noise_rom_size);
	
    /*
     * ԤΥǥ
     */
    if (sAdo_SubGameOK()) {
        PRINTF0(ESC_CYAN "֥¹ԤƤ褤褦Ǥ\n" ESC_NORMAL);
    } else {
        PRINTF0(ESC_CYAN "֥¹ԤƤ褯ʤޤԤޤ\n" ESC_NORMAL);
        while (!sAdo_SubGameOK()) {
            usleep(16666);		/* Ԥ */
            sAdo_GameFrame();	/* ǰΤᥪǥ̤ */
        }
        PRINTF0(ESC_CYAN "֥¹ԤƤ褯ʤޤ\n" ESC_NORMAL);
    }
    amStop();			/* ǥ */

    /*
     * 顼ǥ।᡼ʤ罪λ
     */
    if (nesinfo_rom_start == NULL || ics_bad || tcs_bad) {
        if (tcs_bad) {
            PRINTF(ESC_WARNING "åब㤤ޤ\n" ESC_NORMAL);
        }
        if (ics_bad) {
            PRINTF(ESC_WARNING "᡼åब㤤ޤ\n" ESC_NORMAL);
        }
        if (nesinfo_rom_start) {
            PRINTF(ESC_WARNING "NES᡼ޤǤ\n" ESC_NORMAL);
        }
	if (returnable) {
            PRINTF0("Ԥޤ\n");
	    return_emu_game(game);
	} else {
            PRINTF0(ESC_WARNING "ǽʤΤǥȥޤ\n" ESC_NORMAL);
	    game_goto_next_game_name(game, trademark, TRADEMARK);
        }
        ZCommonGetP(famicomemu)->error_code = 1;
        ZCommonSet(set_msg_fail_emu, M_PLAYER_SET_MSG_FAIL_EMU_TYPE0);
        goto error_exit;
    }
    
    /*
     * եߥ󥪡ǥ
     */
    famicom_audio_init();

    /*
     * ߥ졼
     */
    ks_nes_init(rfcstate_objectp, headerp, ucode_workp, nesinfo_rom_start);

    /*
     * λå塼
     */
    osCreateMesgQueue(&ostaskmsgQ, ostaskmsgbuf, 1);
//    osSendMesg(&ostaskmsgQ, NULL, OS_MESG_BLOCK); /* ߡå */

    /*
     * ȥ졼å塼
     */
    osCreateMesgQueue(&famicom_gameFrameMsgQ, famicom_gameFrameMsgBuf, number(famicom_gameFrameMsgBuf));
    /* ȥ졼å褦ˤ */
    irqmgr_AddClient(&famicom_game_client, &famicom_gameFrameMsgQ);
    
    frame_cnt = 0;
    
//    famicom_sp_doing = 0;
    need_maketask = 0;
    force_pause_sub = 0;
    audio_pause = 0;
    force_reset = 2;
    state_save_no = 0;
    state_load_no = 0;
    state_loaded = 0;
    state_saved = 0;
    play_left = -1;
    fade_alpha = 0;
    lrz_pressed = 0;
    
//    cfbinfo_p = NULL;

    os_sc_task.next = NULL;
    os_sc_task.flags = 0;
    os_sc_task.state = 0;
    os_sc_task.msgQ = &ostaskmsgQ;

    bbram_load();
    state_cpak_load();

    SetGameFrame(1);
    graph->need_viupdate = 1;
    graph->vimode = &osViModeNtscLpn1;
    graph->vispecial = OS_VI_GAMMA_OFF | OS_VI_GAMMA_DITHER_OFF | OS_VI_DIVOT_OFF | OS_VI_DITHER_FILTER_OFF;
    graph->vixscale = 0.888f;
    graph->viyscale = 1.0f;

#if SYS_CFB_WD == 640
    gfxprint_default_clrLow2high(); /* 쥾 */
#endif

error_exit:
    return;
}

/*
 * եߥ󥨥ߥ
 */
extern void
famicom_emu_cleanup(GAME *game)
{
//    GRAPH *graph = game->graph;

    if (nesinfo_rom_start != NULL) {
        famicom_audio_cleanup(game); /* եߥ󥪡ǥλ */
        ks_nes_cleanup();		/* ߥ彪λ */
#if 0
        if (famicom_sp_doing) {
            PRINTF(ESC_ERROR "SPưƤ褦Ǥ" ESC_NORMAL);
            if (osRecvMesg(&ostaskmsgQ, NULL, OS_MESG_NOBLOCK) != 0) {
                osScCanselGraphTaskMsg();
                osRecvMesg(&ostaskmsgQ, NULL, OS_MESG_BLOCK);
            }
            famicom_sp_doing = 0;
        }
#endif

        irqmgr_RemoveClient(&famicom_game_client);
        
    }
    
    viBlack(1);
    sched_class.firsttime = 1;

    amContinue();		/* ԥǥƳ */

    sAdo_SubGameEnd();	/* ǥ֥ཪλѽ */

#if DEBUG
    {
        size_t i;
        
        if (nesinfo_rom_start != NULL && nesinfo_expand_rom_size > 0) {
            for (i = 0; i < nesinfo_expand_rom_size - nesinfo_rom_size; i++) {
                if (*(nesinfo_rom_end + i) != 0x55) {
                    PRINTF(ESC_WARNING "θѡ i = %08x\n" ESC_NORMAL, i);
                    break;
                }
            }
        }
        
    }
#endif /* DEBUG */

#if DEBUG
    zelda_DisplayArena();
    DisplayArena();
#endif /* DEBUG */
}

/***************************************************************************
 * ߥᥤ END
 ***************************************************************************/


#if 0
static Gfx
rdpinit_dl[] = {
    gsDPSetScissor(G_SC_NON_INTERLACE, 0, 0, SCREEN_WD, SCREEN_HT), /* ed 00 00 00 00 50 03 c0 */
    gsDPFullSync(),  /* e9 00 00 00 00 00 00 00 */
};




/*
 * DPľ륳ޥɤ
 */





#define	G_CC_TEX_ALPHA		0, 0, 0, TEXEL0, 0, 0, 0, PRIMITIVE
#define G_CC_RGB_ENV 	TEXEL0, 0, ENVIRONMENT, 0, 0, 0, 0, 1
extern void copyrect_make_dl(
    Gfx **glistpp,              /* ݥ */
    u32 from_fb,                /* ԡ */
    u32 to_fb                   /* ԡ */
    )
{
    Gfx *glistp = *glistpp;
    int rtile = 0;
    int y;
    int y6 = 6;		/* 6 * 320 * 2 < 4096 */
  

    gDPPipeSync(glistp++);      /* 00b0  e7 00 00 00 00 00 00 00 */
    gDPSetScissor(glistp++, G_SC_NON_INTERLACE, 0, 0, SCREEN_WD, SCREEN_HT); /* ed 00 00 00 00 50 03 c0 */
    gDPSetColorImage(gp++, G_IM_FMT_RGBA, G_IM_SIZ_16b, SCREEN_WD, to_fb);
    
    for (y = 0; y < SCREEN_HT - (y6 - 1); y += y6) {
	
	/* ƥ */
	gDPLoadTextureBlock(glistp++,
			    from_fb,
			    G_IM_FMT_RGBA, G_IM_SIZ_16b, SCREEN_WD, y6, 0,
			    G_TX_CLAMP|G_TX_NOMIRROR,
			    G_TX_CLAMP|G_TX_NOMIRROR,
			    G_TX_NOMASK, G_TX_NOMASK,
			    G_TX_NOLOD, G_TX_NOLOD);
        /* gDPSetTextureImage   fd 10 00 00 00 10 00 00
           gDPSetTile           f5 10 00 00 07 08 02 00 
           gDPLoadSync          e6 00 00 00 00 00 00 00
           gDPLoadBlock         f3 00 00 00 07 77 f0 1a
           gDPPipeSync          e7 00 00 00 00 00 00 00
           gDPSetTile           f5 10 a0 00 00 08 02 00
           gDPSetTileSize       f2 00 00 00 00 4f c0 14 */
                                                       
	/* Ѵɽ */
#if 0
	gSPTextureRectangle(glistp++,
			    0 << 2, y << 2,
			    (SCREEN_WD - 0) << 2, (y + y6) << 2,
			    rtile, 0, 0, 1 << 10, 1 << 10);
#else
        gDPTextureRectangle(glistp++,
			    0 << 2, y << 2,
			    (SCREEN_WD - 0) << 2, (y + y6) << 2,
			    rtile, 0, 0, 1 << 10, 1 << 10);
#endif
        /* gDPTextureRectangle e4 50 00 18 00 00 00 00 00 00 00 00 04 00 04 00 */
          
	from_fb += SCREEN_WD * y6 * 2;
    }
    gDPPipeSync(glistp++);

    *glistpp = glistp;
}

extern void make_dl(
    Gfx **glistpp,              /* ݥ */
    void *cfb,                  /* ե졼Хåե */
    void *wfb                   /* Хåե */
    )
{
    Gfx *glistp = *glistpp;
    int rtile = 0;
    int y;
    int y6 = 6;		/* 6 * 320 * 2 < 4096 */
    u32 cfb0;                   /* ե졼Хåե ʪɥ쥹 */
    u32 wfb0;                   /* Хåե ʪɥ쥹 */

    cfb0 = (u32)cfb & 0x00ffffff;
    wfb0 = (u32)wfb & 0x00ffffff;
    
    gDPPipeSync(glistp++);      /* 00b0  e7 00 00 00 00 00 00 00 */
    gDPSetOtherMode(gp++,
                    G_PM_NPRIMITIVE | G_CYC_1CYCLE | G_TP_NONE | G_TD_CLAMP | G_TL_TILE | G_TT_NONE | G_TF_POINT | G_TC_FILT | G_CK_NONE |
                    G_CD_DISABLE | G_AD_DISABLE, G_AC_NONE | G_ZS_PRIM | G_RM_CLD_SURF | G_RM_CLD_SURF2);
    gDPSetCombineMode(glistp++, G_CC_TEX_ALPHA, G_CC_TEX_ALPHA); /* fc ff ff ff ff fc f6 7b */
    gDPSetPrimColor(glistp++, 0, 0, 0, 0, 0, 128); /* fa 00 00 00 ff ff ff ff */
    copyrect_make_dl(&gp, cfb0, wfb0);

    gDPPipeSync(glistp++);
    gDPSetOtherMode(glistp++,
                    G_PM_NPRIMITIVE | G_CYC_1CYCLE | G_TP_NONE | G_TD_CLAMP | G_TL_TILE | G_TT_NONE | G_TF_POINT | G_TC_FILT | G_CK_NONE |
                    G_CD_DISABLE | G_AD_DISABLE, G_AC_NONE | G_ZS_PRIM | G_RM_OPA_SURF | G_RM_OPA_SURF2); /* ef 00 0c 30 0f 0a 40 04 */
    
    gDPSetCombineMode(gp++, G_CC_TEX_ALPHA, G_CC_TEX_ALPHA);
    copyrect_make_dl(&gp, wfb0, cfb0);
    
    gDPFullSync(glistp++);  /* e9 00 00 00 00 00 00 00 */

    *glistpp = glistp;
}

static void
illusion(void *cfb, void *wfb)
{
    Gfx *gp;

    gp = gfxbuf;
    make_dl( &gp, cfb, wfb );
    osWritebackDCache(gfxbuf, (char *)gp - (char *)gfxbuf);
    osDpSetNextBuffer(gfxbuf, (char *)gp - (char *)gfxbuf);
    
}
#endif
