/*
 ******************************************************************************
 *              
 *     ꥢ륿ࡦåν
 *
 *     $Id: lb_rtc.c,v 1.82 2001-02-14 14:19:33+09 gen Exp $
 *
 ******************************************************************************
 */

#include <ultra64.h>
#include "lb_rtc.h"
#include "padmgr.h"
#include "m_common_data.h"

/*
 ******************************************************************************
 ******************************************************************************
 *     
 *  ꥢ륿ࡦåϢν
 *
 *   : 
 *         ꥢ륿ࡦåؤλ, , ȽԤʤ
 *
 *  ­ :
 *         lb_rtc.hƬˤޥ, ʲԤʤʤФʤʤ
 *
 *         lbRTC_LOC_SERIAL_MSGQ()    : åå塼뤿
 *                                    
 *         lbRTC_UNLOC_SERIAL_MSGQ(p) : å塼뤿Υå
 *                                    
 *
 *  ؿ :
 *         lbRTC_WriteArea()      : Хååΰ˽񤭹
 *         lbRTC_ReadArea()       : Хååΰ褫ɤ߹
 *         lbRTC_Settime()        : ꥢ륿ࡦåλ
 *         lbRTC_Gettime()        : ꥢ륿ࡦåλ֤
 *
 *         lbRTC_IsEqualDate()    : դΰפȽ
 *         lbRTC_IsEqualTime()    : ֤ΰפȽ
 *         lbRTC_IsOverTime()     : ֱۤȽ
 *         lbRTC_IsJustAtRTC()    : ꥢ륿ࡦåΰȽ
 *
 *         lbRTC_GetDaysByMonth() : 
 *         lbRTC_GetIntervalDays(): 
 *         lbRTC_IntervalTime()   : ֤κʬ׻
 *
 *         lbRTC_Add_YY()         : ǯβû
 *         lbRTC_Add_MM()         : βû
 *         lbRTC_Add_DD()         : βû 
 *         lbRTC_Add_hh()         : ֤βû
 *         lbRTC_Add_mm()         : ʬβû
 *         lbRTC_Add_ss()         : äβû
 *         lbRTC_Add_Date()       : դβû
 *
 *         lbRTC_Sub_YY()         : ǯθ
 *         lbRTC_Sub_MM()         : θ
 *         lbRTC_Sub_DD()         : θ 
 *         lbRTC_Sub_hh()         : ֤θ
 *         lbRTC_Sub_mm()         : ʬθ
 *         lbRTC_Sub_ss()         : äθ
 *         lbRTC_Sub_Date()       : դθ
 *
 *         lbRTC_Week()           : 
 *
 *         lbRTC_IsOverRTC()      : ꥢ륿ࡦåλֱۤȽ
 *         lbRTC_IsOverWeekRTC()  : ꥢ륿ࡦåۤȽ
 *
 *         lbRTC_TimeCopy()       : դΥԡ
 *         lbRTC_IsValidTime()    : դΥå
 *
 ******************************************************************************
 ******************************************************************************
 */
//#define RTC_DEBUG

static int l_lbRTC_isInitial = TRUE;
/*
 ******************************************************************************
 *  ǽ :
 *         ꥢ륿ࡦåν
 *   :
 *         ꥢ륿ࡦåν
 *   :
 *           == 0 : 
 *           != 0 : 顼ֹ(ޥ˥奢򻲾)
 ******************************************************************************
 */
extern int lbRTC_Initial(void)
{
    static int ret;
    
    if (l_lbRTC_isInitial == TRUE) {
	/* ԤäƤʤ */
	OSMesgQueue  *siMessegeQ = lbRTC_LOC_SERIAL_MSGQ();

	l_lbRTC_isInitial = FALSE;
	ret = (int)osRTCInit(siMessegeQ);
	lbRTC_UNLOC_SERIAL_MSGQ(siMessegeQ);
#ifdef RTC_DEBUG    
	PRINTF("RTC initial\n");
#endif
    }
#ifdef RTC_DEBUG    
    PRINTF("RTC init return value ? = %x\n", ret);
#endif
    return ret;
}
/*
 ******************************************************************************
 *  ǽ :
 *         ꥢ륿ࡦåνȾֳǧ
 *   :
 *         ꥢ륿ࡦåνȾ֤ǧ롣۾郎ä, 
 *       ٽԤη̤֤
 *   :
 *         == 0 : 
 *         != 0 : 顼ֹ(ޥ˥奢򻲾)
 ******************************************************************************
 */
static int lbRTC_IsOki(lbRTC_time_c *i_Time)
{
    int  ret = lbRTC_Initial();

    if (!ret) {
	/* ߤΣңԣä˽Ƥ,
	   ңԣɤ߹Ԥ֤ǧ */
	OSMesgQueue   *siMessegeQ = lbRTC_LOC_SERIAL_MSGQ();
	
	ret = (int)osRTCGetTime(siMessegeQ, i_Time);
	lbRTC_UNLOC_SERIAL_MSGQ(siMessegeQ);
	if (!ret) {
	    return ret;
	}
    }
    /* ңԣä۾ä,
       ңԣä˺ٽԤԤ */
    l_lbRTC_isInitial = TRUE;
    return ret;
}
/*
 ******************************************************************************
 *  ǽ :
 *         ꥢ륿ࡦåξֳǧ
 *   :
 *         ꥢ륿ࡦåξ֤ǧ롣۾郎ä, 
 *       Ԥη̤֤
 *         lbRTC_Sampling()Ԥ, ðʾвˤν̤Ȥˤä
 *        , ңԣä֤ιԤƤ뤫ƳǧǤ롣
 *         ֳ̤֤÷вᤷƤʤ⥨顼֤Τդɬס
 *   :
 *         == 0 : 
 *         != 0 : 顼ֹ(ޥ˥奢򻲾)
 ******************************************************************************
 */
static int l_lbRTC_IsSampled = FALSE;
static lbRTC_time_c  l_lbRTC_Time;

extern int lbRTC_IsAbnormal(void)
{
    lbRTC_time_c  time;
    int           ret = lbRTC_IsOki(&time);
    
    if (ret == 0) {
	/* ңԣä֤ξ */
	if (l_lbRTC_IsSampled == TRUE) {
	    /* ңԣäλֹǧͤ򿷤ץ뤷Ƥ */
	    int  sec1, sec2;
	    
	    sec1 = time.sec + time.min * lbRTC_SECCONDS;
	    sec2 = l_lbRTC_Time.sec + l_lbRTC_Time.min * lbRTC_SECCONDS;
	    if (sec1 != sec2) {
		/* ץ륿ȺΥब԰פξ,
		   ư */
#ifdef RTC_DEBUG    
		PRINTF("RTC Normal = %x\n", ret);
#endif
		return ret;
	    }
	}
#ifdef RTC_DEBUG    
	PRINTF("RTC Abnormal = -1\n");
#endif
#ifndef DEBUG
	l_lbRTC_IsSampled = FALSE;
	l_lbRTC_isInitial = TRUE;
	return -1;
#endif
    }
    else {
	/* ңԣä۾ξ */
#ifdef RTC_DEBUG    
	PRINTF("RTC Abnormal = %x\n", ret);
#endif
    }
    return ret;
}
/*
 ******************************************************************************
 *  ǽ :
 *         ꥢ륿ࡦåξֳǧΤΥץ
 *   :
 *         ңԣä֤ιԤƤ뤫ǧ뤿Υץ󥰤Ԥ
 *         ν̤ƣðʾвlbRTC_IsAbnormal()̤Ȥˤ
 *       , ңԣä֤ιԤƤ뤫ƳǧǤ롣ֳ̤֤
 *       ÷вᤷƤʤ⥨顼֤Τդɬס
 *   :
 *         == 0 : 
 *         != 0 : 顼ֹ(ޥ˥奢򻲾)
 ******************************************************************************
 */
extern void lbRTC_Sampling(void)
{
    lbRTC_time_c  time;
    
    if ((lbRTC_IsOki(&time) == 0) && (l_lbRTC_IsSampled == FALSE)) {
	/* ңԣäλֹǧͤ򿷤ץ뤹 */
	l_lbRTC_Time.sec = time.sec;
	l_lbRTC_Time.min = time.min;
#ifdef RTC_DEBUG    
	PRINTF("RTC Sampling : %d sec\n", l_lbRTC_Time.sec);
#endif
	l_lbRTC_IsSampled = TRUE;
    }
}
/*
 ******************************************************************************
 *  ǽ :
 *         Хååΰ˽񤭹
 *   :
 *         ңԣäģХȤΥХååΰ˽񤭹ࡣ
 *   :
 *         *Buffer : ХȤν񤭹ߥǡƬݥ󥿡
 ******************************************************************************
 */
extern void lbRTC_WriteArea(u8 *Buffer)
{
    if (lbRTC_Initial() == 0) {
	/* RTCʾ */
	OSMesgQueue *siMessegeQ = lbRTC_LOC_SERIAL_MSGQ();

	osRTCWriteData(siMessegeQ, Buffer);
	lbRTC_UNLOC_SERIAL_MSGQ(siMessegeQ);
    }
}

/*
 ******************************************************************************
 *  ǽ :
 *         Хååΰ褫ɤ߹
 *   :
 *         ңԣäģХȤΥХååΰ褫Ƥɤ߹ࡣ
 *   :
 *         *Buffer : ХȤɤ߹ΰƬݥ󥿡
 ******************************************************************************
 */
extern void lbRTC_ReadArea(u8 *Buffer)
{
    if (lbRTC_Initial() == 0) {
	/* RTCʾ */
	OSMesgQueue *siMessegeQ = lbRTC_LOC_SERIAL_MSGQ();

	osRTCReadData(siMessegeQ, Buffer);
	lbRTC_UNLOC_SERIAL_MSGQ(siMessegeQ);
    }
}

/*
 ******************************************************************************
 *  ǽ :
 *         ꥢ륿ࡦåλ
 *   :
 *         ꥢ륿ࡦå˻λ֤ꤹ
 *   :
 *         *Time : ֤Υݥ󥿡
 ******************************************************************************
 */
extern void lbRTC_SetTime(lbRTC_time_c *Time)
{
    if ((ZCommonGet(time.rtc_use) == ON) &&
	(ZCommonGet(time.rtc_crash) == OFF)) {
	/* RTCѲǽʾ */
	OSMesgQueue *siMessegeQ;
	    
	Time->week = lbRTC_Week(Time->year, Time->month, Time->day);
	siMessegeQ = lbRTC_LOC_SERIAL_MSGQ();
	osRTCSetTime(siMessegeQ, Time);
	lbRTC_UNLOC_SERIAL_MSGQ(siMessegeQ);
	    
#if DEBUG
	PRINTF("*** ꥢ륿ࡦåλ ***\n");
	PRINTF("Time->year=%d \n", Time->year);
	PRINTF("Time->month=%d \n", Time->month);
	PRINTF("Time->day=%d \n", Time->day);
	PRINTF("Time->week=%d \n", Time->week);
#endif	/* DEBUG */
    }
    else {
	lbRTC_TimeCopy(ZCommonGetP(time.rtcTime), Time);
    }
}

#if 0 // 2000/7/26 otsuki
extern void	lbRTC_SetTime(
    lbRTC_time_c	*Time
    )
{
    /* ңԣäȤ ? */
    if (ZCommonGet(time.rtc_use) == ON) {
	/* ߤλ֤ */
	lbRTC_Settime(Time);
    }
    else {
	lbRTC_TimeCopy(ZCommonGetP(time.rtcTime), Time);
    }
}
#endif	/* DEBUG */

/*
 ******************************************************************************
 *  ǽ :
 *         ꥢ륿ࡦåλ֤
 *   :
 *         ꥢ륿ࡦå֤
 *   :
 *         *Time : ɤ߹߻֤ǼΰΥݥ󥿡
 ******************************************************************************
 */
extern void lbRTC_GetTime(lbRTC_time_c *Time)
{
    if ((ZCommonGet(time.rtc_use) == ON) &&
	(ZCommonGet(time.rtc_crash) == OFF)) {
	/* RTCѲǽʾ */
	OSMesgQueue *siMessegeQ = lbRTC_LOC_SERIAL_MSGQ();
	    
	osRTCGetTime(siMessegeQ, Time);
	lbRTC_UNLOC_SERIAL_MSGQ(siMessegeQ);
#if 0 /* def DEBUG */
	PRINTF("*** ꥢ륿ࡦåμ ***\n");
	PRINTF("Time->year=%d \n", Time->year);
	PRINTF("Time->month=%d \n", Time->month);
	PRINTF("Time->day=%d \n", Time->day);
	PRINTF("Time->week=%d \n", Time->week);
#endif	/* DEBUG */
    }
    else {
	lbRTC_TimeCopy(Time, ZCommonGetP(time.rtcTime));
    }
}

#if 0 // 2000/7/26 otsuki
extern void	lbRTC_GetTime(
    lbRTC_time_c	*Time
    )
{
    /* ңԣäȤ ? */
    if (ZCommonGet(time.rtc_use) == ON) {
	/* ߤλ֤ */
	lbRTC_Gettime(Time);
    }
    else {
	lbRTC_TimeCopy(Time, ZCommonGetP(time.rtcTime));
    }
}
#endif	/* DEBUG */

/*
 ******************************************************************************
 *  ǽ :
 *         
 *   :
 *         ȷ, η֤
 *   :
 *         Year  : 
 *         Month : 
 *   :
 *         lbRTC_GetDaysByMonth() : 
 ******************************************************************************
 */
extern lbRTC_DD_t lbRTC_GetDaysByMonth(lbRTC_YY_t Year, lbRTC_MM_t Month)
{
    static const lbRTC_DD_t  days_month[lbRTC_MODE][lbRTC_MONTH_NUM + 1] =
    {
	{0, 31,28,31,30,31,30,31,31,30,31,30,31},            /* ̾ǯ */
	{0, 31,29,31,30,31,30,31,31,30,31,30,31}             /* ǯ */
    };
    int  YYmode = lbRTC_IS_LEAP_YEAR(Year) == TRUE ? 1 : 0;

    return days_month[YYmode][(int)Month];
}

/*
 ******************************************************************************
 *  ǽ :
 *         դȽ
 *   :
 *         ĤդȽꤹ롣
 *   :
 *         *i_dYear  : գǯ
 *         *i_dMonth : գη
 *         *i_dDay   : գ
 *         *i_sYear  : գ¤ǯ
 *         *i_sMonth : գ¤η
 *         *i_sDay   : գ¤
 *   :
 *         lbRTC_IsEqualDate() == -1 : դʣ¡
 *         lbRTC_IsEqualDate() == 0  : ȣ¤Ʊդξʣ¡
 *         lbRTC_IsEqualDate() == 1  : դ礭ʣ¡
 ******************************************************************************
 */
typedef union {
    int  yymmdd;
    struct {
	lbRTC_YY_t year; 
	lbRTC_MM_t month;
	lbRTC_DD_t day;
    } part;
} lbRTC_date_c;

extern int lbRTC_IsEqualDate(lbRTC_YY_t i_dYear, 
			     lbRTC_MM_t i_dMonth,
			     lbRTC_DD_t i_dDay,  
			     lbRTC_YY_t i_sYear, 
			     lbRTC_MM_t i_sMonth,
			     lbRTC_DD_t i_sDay)
{
    lbRTC_date_c  dDate;
    lbRTC_date_c  sDate;
    int           result;

    dDate.part.year  = i_dYear;
    dDate.part.month = i_dMonth;
    dDate.part.day   = i_dDay;
    sDate.part.year  = i_sYear;
    sDate.part.month = i_sMonth;
    sDate.part.day   = i_sDay;

    result = dDate.yymmdd - sDate.yymmdd;
    if (result == 0) {
	/* ȣ¤Ʊդξ */
	return 0;
    }
    if (result < 0) {
	/* դ̤ξ */
	return -1;
    }
    /* դ̤ξ */
    return 1;
}

/*
 ******************************************************************************
 *  ǽ :
 *         ֤ΰפȽ
 *   :
 *         Ĥλ֤Ƚ⡼ɤΥ٥Ǵ˰פƤ뤫Ƚꤹ롣
 *   :
 *         *dTime : ֣Υݥ󥿡
 *         *sTime : ֣¤Υݥ󥿡
 *         Mode   : Ƚ⡼
 *
 *                 lbRTC_JUST_YY : 'ǯ'Ƚ
 *                 lbRTC_JUST_MM : ''Ƚ
 *                 lbRTC_JUST_DD : ''Ƚ
 *                 lbRTC_JUST_WW : ''Ƚ
 *                 lbRTC_JUST_hh : ''Ƚ
 *                 lbRTC_JUST_mm : 'ʬ'Ƚ
 *                 lbRTC_JUST_ss : ''Ƚ
 *                 lbRTC_JUST    : ƤȽ
 *                 
 *                 Ȥ߹碌ƤȽξ, '|'Ȥäꤹ롣
 *
 *                   ()  '''ʬ'Ƚꤹ
 *                         lbRTC_JUST_hh | lbRTC_JUST_mm
 *   :
 *         lbRTC_IsEqualTime() == TRUE  : ֤פ
 *         lbRTC_IsEqualTime() == FALSE : ֤פʤä
 ******************************************************************************
 */
extern int lbRTC_IsEqualTime(const lbRTC_time_c *dTime,
			     const lbRTC_time_c *sTime,
			     int          Mode)
{
    int  just = 0;
    
    /* 򤷤Ƚ⡼ɤ,֤Ƚ */
    if (Mode & lbRTC_JUST_ss) {
	/* ''Ƚ */
	if(dTime->sec == sTime->sec) {
	    just |= lbRTC_JUST_ss;
	}
    }
    if (Mode & lbRTC_JUST_mm) {
	/* 'ʬ'Ƚ */
	if(dTime->min == sTime->min) {
	    just |= lbRTC_JUST_mm;
	}
    }
    if (Mode & lbRTC_JUST_hh) {
	/* ''Ƚ */
	if(dTime->hour == sTime->hour) {
	    just |= lbRTC_JUST_hh;
	}
    }
    if (Mode & lbRTC_JUST_WW) {
	/* ''Ƚ */
	if(dTime->week == sTime->week) {
	    just |= lbRTC_JUST_WW;
	}
    }
    if (Mode & lbRTC_JUST_DD) {
	/* ''Ƚ */
	if(dTime->day == sTime->day) {
	    just |= lbRTC_JUST_DD;
	}
    }
    if (Mode & lbRTC_JUST_MM) {
	/* ''Ƚ */
	if(dTime->month == sTime->month) {
	    just |= lbRTC_JUST_MM;
	}
    }
    if (Mode & lbRTC_JUST_YY) {
	/* 'ǯ'Ƚ */
	if(dTime->year == sTime->year) {
	    just |= lbRTC_JUST_YY;
	}
    }

    /* 򤷤Ƚ⡼ɤ,֤פȽ */
#if 0
    if ((just & Mode) == Mode) {
	return TRUE;             /*  */
    }
    return FALSE;                /* ԰ */
#else
    return ((just & Mode) == Mode);
#endif
}

/*
 ******************************************************************************
 *  ǽ :
 *         ֱۤȽ
 *   :
 *         ֣¤֣ۤƤ뤫Ƚꤹ
 *   :
 *         *dTime : ֣Υݥ󥿡
 *         *sTime : ֣¤Υݥ󥿡
 *   :
 *         lbRTC_IsOverTime() == lbRTC_LESS_TIME : ۤƤʤ
 *         lbRTC_IsOverTime() == lbRTC_OVER_TIME : פƤ뤫ۤƤ
 ******************************************************************************
 */
extern int lbRTC_IsOverTime(const lbRTC_time_c *dTime, const lbRTC_time_c *sTime)
{
    if (sTime->year < dTime->year) {
	/* 'ǯ'ãƤʤ  */
	return lbRTC_LESS_TIME;
    }
    if (sTime->year == dTime->year) {
	if (sTime->month >= dTime->month) {
	    if (sTime->month == dTime->month) {
		if (sTime->day >= dTime->day) {
		    if (sTime->day == dTime->day) {
			if (sTime->hour >= dTime->hour) {
			    if (sTime->hour == dTime->hour) {
				if (sTime->min >= dTime->min) {
				    if (sTime->min == dTime->min) {
					if (sTime->sec < dTime->sec) {
					    /* ''ãƤʤ */
					    return lbRTC_LESS_TIME;
					}
				    }
				}
				else {
				    /* 'ʬ'ãƤʤ  */
				    return lbRTC_LESS_TIME;
				}
			    }
			}
			else {
			    /* ''ãƤʤ  */
			    return lbRTC_LESS_TIME;
			}
		    }
		}
		else {
		    /* ''ãƤʤ  */
		    return lbRTC_LESS_TIME;
		}
	    }
	}
	else {
	    /* ''ãƤʤ  */
	    return lbRTC_LESS_TIME;
	}
    }
    /* (dTimeλ)ã */
    return lbRTC_OVER_TIME;
}

/*
 ******************************************************************************
 *  ǽ :
 *         ꥢ륿ࡦåΰȽ
 *   :
 *         ꥢ륿ࡦå, Ƚ⡼ɤΥ٥ǻ֤˴˰פ
 *       Ƚꤹ롣
 *   :
 *         *Time : ׻֤Υݥ󥿡
 *         Mode  : Ƚ⡼
 *
 *                 lbRTC_JUST_YY : 'ǯ'Ƚ
 *                 lbRTC_JUST_MM : ''Ƚ
 *                 lbRTC_JUST_DD : ''Ƚ
 *                 lbRTC_JUST_WW : ''Ƚ
 *                 lbRTC_JUST_hh : ''Ƚ
 *                 lbRTC_JUST_mm : 'ʬ'Ƚ
 *                 lbRTC_JUST_ss : ''Ƚ
 *                 lbRTC_JUST    : ƤȽ
 *                 
 *                 Ȥ߹碌ƤȽξ, '|'Ȥäꤹ롣
 *
 *                   ()  '''ʬ'Ƚꤹ
 *                         lbRTC_JUST_hh | lbRTC_JUST_mm
 *   :
 *         lbRTC_IsJustAtRTC() == TRUE  : 
 *         lbRTC_IsJustAtRTC() == FALSE : ԰
 ******************************************************************************
 */
extern int lbRTC_IsJustAtRTC(const lbRTC_time_c *Time, int Mode)
{
    lbRTC_time_c  currentTime;
    
    /* ߤλ֤ */
    lbRTC_GetTime(&currentTime);

    /* 򤷤Ƚ⡼ɤ,֤Ƚ */
#if 0
    if (lbRTC_IsEqualTime(&currentTime, Time, Mode) == TRUE) {
	/* פ */
	return TRUE;
    }
    /* ԰פξ */
    return FALSE;
#else
    return lbRTC_IsEqualTime(&currentTime, Time, Mode);
#endif
}

/*
 ******************************************************************************
 *  ǽ :
 *         ꥢ륿ࡦåλֱۤȽ
 *   :
 *         ꥢ륿ࡦå֤вᤷȽꤹ롣
 *   :
 *         *Time : вȽ֤Υݥ󥿡
 *   :
 *         lbRTC_IsOverRTC() == TRUE  : ֤в
 *         lbRTC_IsOverRTC() == FALSE : ֤̤в
 ******************************************************************************
 */
extern int lbRTC_IsOverRTC(const lbRTC_time_c *Time)
{
    lbRTC_time_c  currentTime;

    /* ߤλ֤ */
    lbRTC_GetTime(&currentTime);

#if 0
    if (lbRTC_IsOverTime(Time, &currentTime) == lbRTC_OVER_TIME) {
	/* ֤вᤷ */
	return TRUE;
    }
    /* ֤ˤʤäƤʤ */
    return FALSE;
#else  /* 01/01/29 20:43 hayakawa  */
    return (lbRTC_IsOverTime(Time, &currentTime) == lbRTC_OVER_TIME);
#endif
}

/*
 ******************************************************************************
 *  ǽ :
 *         ꥢ륿ࡦåۤȽ
 *   :
 *         ꥢ륿ࡦåȽ곫ϻ֤ȽвᤷȽꤹ
 *       롣
 *   :
 *         *StartTime : Ƚ곫ϻ֤Υݥ󥿡
 *         AlarmWeek  : Ƚ
 *   :
 *         lbRTC_IsOverWeekRTC() == TRUE  : в
 *         lbRTC_IsOverWeekRTC() == FALSE : ̤в
 ******************************************************************************
 */
extern int lbRTC_IsOverWeekRTC(const lbRTC_time_c *StartTime, lbRTC_WW_t AlarmWeek)
{
    int           days = (int)(AlarmWeek - StartTime->week);
    lbRTC_time_c  alarmTime = *StartTime;

    if (days < 1) {
	days += lbRTC_WEEK;
    }
    /* 顼դ */
    alarmTime.hour = 0;
    alarmTime.min = 0;
    alarmTime.sec = 0;
    lbRTC_Add_DD(&alarmTime, days);       
    /* ߤλ֤顼դвᤷå */
    return lbRTC_IsOverRTC(&alarmTime);   
}

/*
 ******************************************************************************
 *  ǽ :
 *         ֤κʬ׻
 *   :
 *         ֣Ȼ֣¤κ롣
 *   :
 *         纹ʬ֤, lbRTC_MAX_INTERVAL_TIME_e
 *   :
 *         *a_time : ֣
 *         *b_time : ֣
 *   :
 *         lbRTC_IntervalTime() != 0 : ʬ(ʬñ)
 *         lbRTC_IntervalTime() == 0 : ʤ (֣ < ֣) ξ硣
 ******************************************************************************
 */
extern unsigned int lbRTC_IntervalTime(const lbRTC_time_c *a_time,
				       const lbRTC_time_c *b_time)
{
    /*
     *   osRTCGetIntervalTime(), եȤˤ黻ʤΤ RTC ߤƤƤ
     * ʤ
     */
#if 0
    return (unsigned int)osRTCGetIntervalTime(b_time, a_time);
#else /* osRTCGetIntervalTimeΰconstˤʤäƤʤΤǥåѿ򤫤ޤ */
    {
        lbRTC_time_c a_time1 = *a_time;
        lbRTC_time_c b_time1 = *b_time;

        return (unsigned int)osRTCGetIntervalTime(&b_time1, &a_time1);
    }
#endif
}
/*
 ******************************************************************************
 *  ǽ :
 *         
 *   :
 *         ֣֣¤ޤǤ롣
 *         ʻ֣  ֣ Ǥ뤳ȡ
 *   :
 *         *i_TimeA : ֣
 *         *i_TimeB : ֣
 *   :
 *         lbRTC_GetIntervalDays() : ֣Ȼ֣¤
 ******************************************************************************
 */
extern int lbRTC_GetIntervalDays(const lbRTC_time_c *i_TimeA, const lbRTC_time_c *i_TimeB)
{
  static const int total_days[2][lbRTC_MONTH_NUM + 1] =
  {
      {0,31,59,90,120,151,181,212,243,273,304,334,365},
      {0,31,60,91,121,152,182,213,244,274,305,335,366}
  };
  
  int  four_years = (i_TimeB->year - i_TimeA->year) / 4;   /* ǯñ̤*/
  int  surplus_years = (i_TimeB->year - i_TimeA->year) % 4;/* ; */
  int  i_TimeA_leap = ((i_TimeA->year % 4)==0);          /* ǯǯ */
  int  i_TimeB_leap = ((i_TimeB->year % 4)==0);          /* λǯǯ */
  int  add_leap = (((4 - (i_TimeA->year % 4)) % 4)
		   < surplus_years);                     /* ;ǯαǯ */
  int  days;

  if(i_TimeA->year > i_TimeB->year) {
      return(0);
  }
  else {
      if(i_TimeA->year == i_TimeB->year) {
	  if(i_TimeA->month > i_TimeB->month) {
	      return(0);
	  }
	  else {
	      if(i_TimeA->month == i_TimeB->month) {
		  if(i_TimeA->day > i_TimeB->day) {
		      return(0);
		  }
		  else {
		      if(i_TimeA->day == i_TimeB->day) {
			  if(i_TimeA->hour > i_TimeB->hour) {
			      return(0);
			  }
			  else {
			      if(i_TimeA->hour == i_TimeB->hour) {
				  if(i_TimeA->min > i_TimeB->min) {
				      return(0);
				  }
			      }
			  }
		      }
		  }
	      }
	  }
      }
  }
  
  /* η׻
   * ǯᣳܣᣱ
   * ;äǯäǸ˱ǯ;¸ߤУû롣
   */
  days = four_years * 1461 + surplus_years * 365 + add_leap;
  /* ܺǸǯΣˤ */
  days += (i_TimeB->day - 1);              /* ܤη */
  days += total_days[i_TimeB_leap]
                    [i_TimeB->month - 1];  /* ηޤǤι */
  /* ݺǽǯΣˤ */
  days -= (i_TimeA->day - 1);             /* ݤη */
  days -= total_days[i_TimeA_leap]
                    [i_TimeA->month - 1]; /* ηޤǤι */

  return days;
}

/*
 ******************************************************************************
 *  ǽ :
 *         ǯβû
 *   :
 *         դǯû롣
 *   :
 *         ׻̤ݾڤΤ 2099ǯޤǡ
 *   :
 *         *dTime : ûդΥݥ󥿡
 *         Year   : ûǯ
 *   :
 *         *dTime : û줿դΥݥ󥿡
 ******************************************************************************
 */
extern void lbRTC_Add_YY(lbRTC_time_c *dTime, int Year)
{
    dTime->year += (lbRTC_YY_t)Year;
}

/*
 ******************************************************************************
 *  ǽ :
 *         βû
 *   :
 *         դ˷û롣
 *   :
 *         *dTime : ûդΥݥ󥿡
 *         Month  : û
 *   :
 *         *dTime : û줿դΥݥ󥿡
 ******************************************************************************
 */
extern void lbRTC_Add_MM(lbRTC_time_c *dTime, int Month)
{
    int  c_month = (int)dTime->month;

    c_month += Month;
    if (c_month > lbRTC_DECEMBER) {
	lbRTC_Add_YY(dTime, c_month / lbRTC_MONTH_NUM);
	c_month %= lbRTC_MONTH_NUM;
    }
    dTime->month = (lbRTC_MM_t)c_month;
}

/*
 ******************************************************************************
 *  ǽ :
 *         βû
 *   :
 *         դû롣
 *   :
 *         ûκͤ lbRTC_MAX_ADD_DATE_e ʾξϡ
 *       ̤ݾڤʤ
 *   :
 *         *dTime : ûդΥݥ󥿡
 *         Day    : û
 *   :
 *         *dTime : û줿դΥݥ󥿡
 ******************************************************************************
 */
#define	lbRTC_IS_LEAP_YEAR(x)	((((x) % 4) == 0) ? TRUE : FALSE)

extern void lbRTC_Add_DD(lbRTC_time_c *dTime, int Days)
{
    int  MMdays = (int)lbRTC_GetDaysByMonth(dTime->year,
					    (lbRTC_MM_t)(dTime->month));
    int  c_day = (int)dTime->day;

    c_day += Days;
    if (c_day > MMdays) {
	c_day -= MMdays;
	lbRTC_Add_MM(dTime, 1);
    }
    dTime->day = (lbRTC_DD_t)c_day;
}

/*
 ******************************************************************************
 *  ǽ :
 *         ֤βû
 *   :
 *         դ˻֤û롣
 *   :
 *         *dTime : ûդΥݥ󥿡
 *         Hour   : û
 *   :
 *         *dTime : û줿դΥݥ󥿡
 ******************************************************************************
 */
extern void lbRTC_Add_hh(lbRTC_time_c *dTime, int Hour)
{
    int  c_hour = (int)dTime->hour;

    c_hour += Hour;
    if (c_hour >= lbRTC_HOURS) {
	lbRTC_Add_DD(dTime, c_hour / lbRTC_HOURS);
	c_hour %= lbRTC_HOURS;
    }
    dTime->hour = (lbRTC_hh_t)c_hour;
}

/*
 ******************************************************************************
 *  ǽ :
 *         ʬβû
 *   :
 *         դʬû롣
 *   :
 *         *dTime : ûդΥݥ󥿡
 *         Minute : ûʬ
 *   :
 *         *dTime : û줿դΥݥ󥿡
 ******************************************************************************
 */
extern void lbRTC_Add_mm(lbRTC_time_c *dTime, int Minute)
{
    int  c_minute = (int)dTime->min;

    c_minute += Minute;
    if (c_minute >= lbRTC_MINUTES) {
	lbRTC_Add_hh(dTime, c_minute / lbRTC_MINUTES);
	c_minute %= lbRTC_MINUTES;
    }
    dTime->min = (lbRTC_mm_t)c_minute;
}

/*
 ******************************************************************************
 *  ǽ :
 *         äβû
 *   :
 *         դäû롣
 *   :
 *         *dTime  : ûդΥݥ󥿡
 *         Seccond : ûÿ
 *   :
 *         *dTime : û줿դΥݥ󥿡
 ******************************************************************************
 */
extern void lbRTC_Add_ss(lbRTC_time_c *dTime, int Seccond)
{
    int  c_seccond = (int)dTime->sec;

    c_seccond += (int)Seccond;
    if (c_seccond >= lbRTC_SECCONDS) {
	lbRTC_Add_mm(dTime, c_seccond / lbRTC_SECCONDS);
	c_seccond %= lbRTC_SECCONDS;
    }
    dTime->sec = (lbRTC_mm_t)c_seccond;
}

/*
 ******************************************************************************
 *  ǽ :
 *         դβû
 *   :
 *          *dTime ˻ *sTime û롣
 *   :
 *         *dTime : ûդΥݥ󥿡
 *         *sTime : ûդΥݥ󥿡
 *   :
 *         *dTime : û줿դΥݥ󥿡
 ******************************************************************************
 */
extern void lbRTC_Add_Date(lbRTC_time_c *dTime, const lbRTC_time_c *sTime)
{
    lbRTC_Add_ss(dTime, (int)sTime->sec);
    lbRTC_Add_mm(dTime, (int)sTime->min);
    lbRTC_Add_hh(dTime, (int)sTime->hour);
    lbRTC_Add_DD(dTime, (int)sTime->day);
    lbRTC_Add_MM(dTime, (int)sTime->month);
    lbRTC_Add_YY(dTime, (int)sTime->year);
}

/*
 ******************************************************************************
 *  ǽ :
 *         ǯθ
 *   :
 *         դǯ򸺻롣
 *   :
 *         ׻̤ݾڤΤ 2099ǯޤǡ
 *   :
 *         *dTime : դΥݥ󥿡
 *         Year   : ǯ
 *   :
 *         *dTime : 줿դΥݥ󥿡
 ******************************************************************************
 */
extern void lbRTC_Sub_YY(lbRTC_time_c *dTime, int Year)
{
    dTime->year -= (lbRTC_YY_t)Year;
}

/*
 ******************************************************************************
 *  ǽ :
 *         θ
 *   :
 *         դ˷򸺻롣
 *   :
 *         *dTime : դΥݥ󥿡
 *         Month  : 
 *   :
 *         *dTime : 줿դΥݥ󥿡
 ******************************************************************************
 */
extern void lbRTC_Sub_MM(lbRTC_time_c *dTime, int Month)
{
    int  t_month;

    t_month = (int)dTime->month - Month;
    if (t_month < lbRTC_JANUARY) {
	int  t_sub_month = t_month;
	int  t_sub_year;

	if (t_month == 0) {
	    t_month = lbRTC_DECEMBER;
	    t_sub_year = 1;
	}
	else {
	    t_sub_month = ABS(t_month);
	    t_sub_year = t_sub_month / lbRTC_MONTH_NUM + 1;
	    t_month = lbRTC_MONTH_NUM - (t_sub_month % lbRTC_MONTH_NUM);
	}
	lbRTC_Sub_YY(dTime, t_sub_year);
    }
    dTime->month = (lbRTC_MM_t)t_month;
}

/*
 ******************************************************************************
 *  ǽ :
 *         θ
 *   :
 *         դ򸺻롣
 *   :
 *         κͤ lbRTC_MAX_SUB_DATE_e ʾξϡ
 *       ̤ݾڤʤ
 *   :
 *         *dTime : դΥݥ󥿡
 *         Day    : 
 *   :
 *         *dTime : 줿դΥݥ󥿡
 ******************************************************************************
 */
extern void lbRTC_Sub_DD(lbRTC_time_c *dTime, int Days)
{
    int  day = (int)dTime->day;
    int  MMdays;
#if 0
    int  MMdays = (int)lbRTC_GetDaysByMonth(dTime->year,
					    (lbRTC_MM_t)(dTime->month - 1));
#endif

    if( dTime->month == JANUARY ){
	MMdays = (int)lbRTC_GetDaysByMonth(dTime->year,
					   (lbRTC_MM_t)(DECEMBER));
    } else {
	MMdays = (int)lbRTC_GetDaysByMonth(dTime->year,
					   (lbRTC_MM_t)(dTime->month - 1));
    }
    day -= Days;
    if (day <= 0) {
	if (day == 0) {
	    day = MMdays;
	}
	else {
	    day += MMdays;
	}
	lbRTC_Sub_MM(dTime, 1);
    }
    dTime->day = (lbRTC_DD_t)day;
}

/*
 ******************************************************************************
 *  ǽ :
 *         ֤θ
 *   :
 *         դ˻֤򸺻롣
 *   :
 *         *dTime : դΥݥ󥿡
 *         Hour   : (023)
 *   :
 *         *dTime : 줿դΥݥ󥿡
 ******************************************************************************
 */
extern void lbRTC_Sub_hh(lbRTC_time_c *dTime, int Hour)
{
    int  t_hour = (int)dTime->hour;

    t_hour -= Hour;
    if (t_hour < 0) {
	int  t_sub_hour = t_hour;
	int  t_sub_days;

	t_sub_hour = ABS(t_hour);
	t_sub_days = t_sub_hour / lbRTC_HOURS + 1;
	t_hour = lbRTC_HOURS - (t_sub_hour % lbRTC_HOURS);
	if (t_hour == lbRTC_HOURS) {
	    t_hour = 0;
	    t_sub_days--;
	}
	lbRTC_Sub_DD(dTime, t_sub_days);
    }
    dTime->hour = (lbRTC_hh_t)t_hour;
}

/*
 ******************************************************************************
 *  ǽ :
 *         ʬθ
 *   :
 *         դʬ򸺻롣
 *   :
 *         *dTime : դΥݥ󥿡
 *         Minute : ʬ
 *   :
 *         *dTime : 줿դΥݥ󥿡
 ******************************************************************************
 */
extern void lbRTC_Sub_mm(lbRTC_time_c *dTime, int Minute)
{
    int  t_minute = (int)dTime->min;

    t_minute -= Minute;
    if (t_minute < 0) {
	int  t_sub_minute = t_minute;
	int  t_sub_hours;

	t_sub_minute = ABS(t_minute);
	t_sub_hours = t_sub_minute / lbRTC_MINUTES + 1;
	t_minute = lbRTC_MINUTES - (t_sub_minute % lbRTC_MINUTES);
	if (t_minute == lbRTC_MINUTES) {
	    t_minute = 0;
	    t_sub_hours--;
	}
	lbRTC_Sub_hh(dTime, t_sub_hours);
    }
    dTime->min = (lbRTC_mm_t)t_minute;
}

/*
 ******************************************************************************
 *  ǽ :
 *         äθ
 *   :
 *         դä򸺻롣
 *   :
 *         *dTime  : դΥݥ󥿡
 *         Seccond : ÿ
 *   :
 *         *dTime : 줿դΥݥ󥿡
 ******************************************************************************
 */
extern void lbRTC_Sub_ss(lbRTC_time_c *dTime, int Second)
{
    int  t_second = (int)dTime->sec;

    t_second -= Second;
    if (t_second < 0) {
	int  t_sub_second = t_second;
	int  t_sub_minutes;

	t_sub_second = ABS(t_second);
	t_sub_minutes = t_sub_second / lbRTC_SECCONDS + 1;
	t_second = lbRTC_SECCONDS - (t_sub_second % lbRTC_SECCONDS);
	if (t_second == lbRTC_SECCONDS) {
	    t_second = 0;
	    t_sub_minutes--;
	}
	lbRTC_Sub_mm(dTime, t_sub_minutes);
    }
    dTime->sec = (lbRTC_ss_t)t_second;
}

/*
 ******************************************************************************
 *  ǽ :
 *         դθ
 *   :
 *          *dTime ˻ *sTime 򸺻롣
 *   :
 *         *dTime : դΥݥ󥿡
 *         *sTime : դΥݥ󥿡
 *   :
 *         *dTime : 줿դΥݥ󥿡
 ******************************************************************************
 */
extern void lbRTC_Sub_Date(lbRTC_time_c *dTime, const lbRTC_time_c *sTime)
{
    lbRTC_Sub_ss(dTime, (int)sTime->sec);
    lbRTC_Sub_mm(dTime, (int)sTime->min);
    lbRTC_Sub_hh(dTime, (int)sTime->hour);
    lbRTC_Sub_DD(dTime, (int)sTime->day);
    lbRTC_Sub_MM(dTime, (int)sTime->month);
    lbRTC_Sub_YY(dTime, (int)sTime->year);
}

/*
 ******************************************************************************
 *  ǽ :
 *         
 *   :
 *         դ롣
 *   :
 *         i_Year  : ǯ
 *         i_Month : 
 *         i_Day   : 
 *   :
 *         lbRTC_Week() : 
 ******************************************************************************
 */
extern lbRTC_WW_t lbRTC_Week(lbRTC_YY_t i_Year,
			     lbRTC_MM_t i_Month,
			     lbRTC_DD_t i_Day)
{
    static const lbRTC_time_c  a_time = {0,0,0, 1,0,1, 1901};
    lbRTC_time_c  b_time = {0,0,0, 0,0,0, 0000};
    
    b_time.year = i_Year;
    b_time.month = i_Month;
    b_time.day = i_Day;
    
    return (lbRTC_WW_t)((lbRTC_GetIntervalDays(&a_time, &b_time) + 2)
			% lbRTC_WEEK);
}

/*
 ******************************************************************************
 *  ǽ :
 *         դΥԡ
 *   :
 *         դ򥳥ԡ롣
 *   :
 *         *dTime : դΥԡΥݥ󥿡
 *         *sTime : դΥԡΥݥ󥿡
 ******************************************************************************
 */
extern void lbRTC_TimeCopy(lbRTC_time_c *dTime, const lbRTC_time_c *sTime)
{
#if 0                           /* 12&loop */
    short  *des = (short *)dTime;
    const short  *src = (const short *)sTime;
    int    sz = sizeof(lbRTC_time_c) / sizeof(short);
    
    while(sz-- > 0) {
	*des++ = *src++;
    }
#else  /* 8+2 */
    *dTime = *sTime;
#endif
}

/*
 ******************************************************************************
 *  ǽ :
 *         դΥå
 *   :
 *         դͤå롣
 *   :
 *         1999ǯ2099ǯǤդǧ롣
 *   :
 *         lbRTC_IsValidTime() == TRUE  : 
 *         lbRTC_IsValidTime() == FALSE : 
 ******************************************************************************
 */
extern int lbRTC_IsValidTime(const lbRTC_time_c *Time)
{
    static const unsigned char  day_tbl[]={
	00,
	31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31
    };
    int  ret;
    
    if ((Time->year < 1901) || (Time->year > 2099) ||
	(Time->month == 0) || (Time->month > 12) ||
	(Time->day == 0) ||
	(Time->hour > 23) || (Time->min > 59) || (Time->sec > 59)) {
	ret = FALSE;
    } else {
	if ((Time->day == 29) && (Time->month == 2)) {
	    ret = lbRTC_IS_LEAP_YEAR(Time->year);
	} else if (Time->day > day_tbl[Time->month]) {
	    ret = FALSE;
	} else {
	    ret = TRUE;
	}
    }
    
    return ret;

}

#if 0 /* ƥȥץ */
/*
 ******************************************************************************
 *  ֤ɽ
 ******************************************************************************
 */
void lbRTC_PrintTime(void)
{
    lbRTC_time_c  time;
    
    lbRTC_Gettime(&time);
    PRINTF("year=%d \n", time.year);
    PRINTF("month=%d \n", time.month);
    PRINTF("day=%d \n", time.day);
    PRINTF("week=%d \n", time.week);
    PRINTF("hour=%d \n", time.hour);
    PRINTF("min=%d \n", time.min);
    PRINTF("sec=%d \n", time.sec);
}
/*
 ******************************************************************************
 *   ֱۤΥƥ
 ******************************************************************************
 */
void lbRTC_TestOfOverTime(void)
{
    static lbRTC_time_c  timer = {43,3,15,12,2,10,1999};
    static int  fg = 0;
    lbRTC_time_c  time;
    
    if ((lbRTC_IsOverRTC(&timer) == TRUE) && (fg == 0)) {
	lbRTC_Gettime(&time);
	PRINTF("## ֤衪\n");
	PRINTF("year=%d \n", time.year);
	PRINTF("month=%d \n", time.month);
	PRINTF("day=%d \n", time.day);
	    PRINTF("week=%d \n", time.week);
	    PRINTF("hour=%d \n", time.hour);
	    PRINTF("min=%d \n", time.min);
	    PRINTF("sec=%d \n", time.sec);
	    fg = 1;
    }
}
#endif
