/*
 ******************************************************************************
 *
 *	̥ǡ
 *	$Id: m_common_data.h,v 1.376 2001-02-07 13:28:26+09 hayakawa Exp $
 ******************************************************************************
 */
#ifndef INCLUDE_M_COMMON_DATA_H
#define INCLUDE_M_COMMON_DATA_H

#ifdef _LANGUAGE_C_PLUS_PLUS
extern "C" {
#endif	/* _LANGUAGE_C_PLUS_PLUS */

#include "m_scene.h"
#include "audio.h"
#include "m_scene_table.h"

#include "m_submenu_h.h"

#include "m_clip.h"
#include "m_demo.h"

#include "m_npc.h"

#include "m_event.h"
#include "m_plant.h"

#include "m_post_office_h.h"
#include "m_police_box_h.h"
#include "m_notice.h"
#include "m_snowman_h.h"
#include "m_weather_type.h"
#include "m_npc_schedule_h.h"
#include "m_npc_walk.h"
#include "famicom_emu.h"	/* FamicomEmu_Common */
#include "m_museum_h.h"

/*
 ************************************************
 *						*
 *		ǡ			*
 *						*
 ************************************************
 */
/* ƥ */
#define	ITEM_POSSESS_NUM	(15)
/* ץ졼䡼ٳ */
#define	PLAYER_MONEY_MAX	(50000)
/* ɥ쥹ĢϿǤ */
#define	ADDRESS_REGIST_NUM	(16)
/* ȶκ */
#define mCm_FURNITURE_PLACE_MAX	(10*10)
/* ͹ؼμ */
#define MAIL_BOX_CAPA		(10)
/* ϥ˥λäƤ륢ƥο */
#define	HANIWA_ITEM_POSSESS_NUM	(4)
/* ϥ˥Υåʸ */
#define HANIWA_MESSAGE_COL	(16)
/* ϥ˥ΥåԿ */
#define HANIWA_MESSAGE_LINE	(4)
/* ϥ˥Υåʸ */
#define	HANIWA_MESSAGE_NUM	(HANIWA_MESSAGE_COL * HANIWA_MESSAGE_LINE)

/* ŹԿ */
#define mSP_VISITOR_MAX		(10)
/* ʿ */
#define mSP_GOODS_MAX		(31)
/* ʡʿ */
#define	mSP_GIFT_MAX		(3)

/** Ͽ NPC	;ʬ˼äƤޤ */
#define	mNpc_RGSTD_NPC_NUM	(0xff)
/** Ͽ NPCѥӥåȾơ֥륵	char */
#define	mNpc_RGSTD_NPC_BIT_TBL_SIZE_u8	\
		 		(((mNpc_RGSTD_NPC_NUM + 7) & 0xfff8)/ CHAR_BIT)

/** Flashrom Υ */
#define FLASH_SIZE_BYTE		(0x00000080)
#define FLASH_SIZE_BYTE_U32	(int)(FLASH_SIZE_BYTE /4)

/*
 *	ʪ
 */
enum {
    mSP_SEEDLING,	/* ڤ	*/

    mSP_PLANT_ONLY_MAX,
    
    mSP_SEED1_1 = mSP_PLANT_ONLY_MAX,
    mSP_SEED1_2,
    mSP_SEED1_3,
    mSP_SEED2_1,
    mSP_SEED2_2,
    mSP_SEED2_3,
    mSP_SEED3_1,
    mSP_SEED3_2,
    mSP_SEED3_3,

    mSP_PLANT_MAX
};

/**  ͥѷ */
typedef unchar mSP_list_t;

/*
 * ͥꥹȤľʤμ
 */
enum {
  mSP_FTR_LIST,
  mSP_BINSEN_LIST,
  mSP_CLOTH_LIST,
  mSP_CARPET_LIST,
  mSP_WALL_LIST,

  mSP_LIST_MAX
};

/*
 *	ϥʸ
 */
enum {
    /* Ȥʸ	*/
    SMALL_ROOM_SIZE_ORDER_e,
    /* 椯餤βȤʸ	*/
    MEDIUM_ROOM_SIZE_ORDER_e,
    /* 礭Ȥʸ	*/
    LARGE_ROOM_SIZE_ORDER_e,

    ROOM_SIZE_ALL_TYPES,

    /* Ƽʸ		*/
    BRONZE_STATUE_ORDER_e = ROOM_SIZE_ALL_TYPES,

    ALL_REHOUSE_ORDERS
};

/*
 *	Ȥ
 */
#define	SMALL_HOUSE_PRICE	17400
#define	MEDIUM_HOUSE_PRICE	49800
#define	LARGE_HOUSE_PRICE	498000
#define	BRONZE_STATUE_PRICE	0

/*
 *	ޤȤγ
 */
enum {
    SMALL_SACK_AMOUNT_e = 1000,
    NORMAL_SACK_AMOUNT_e = 10000,
    LARGE_SACK_AMOUNT_e = 30000,
    LITTLE_SACK_AMOUNT_e = 100
};

/*
 *	ޤ礭
 */
enum {
    SMALL_SACK_SIZE,
    NORMAL_SACK_SIZE,
    LARGE_SACK_SIZE,
    LITTLE_SACK_SIZE,

    SACK_SIZE_ALL_TYPES
};

/*
 *	֤ο
 */
enum {
    SMALL_KABU_NUM = 10,
    MEDIUM_KABU_NUM = 50,
    LARGE_KABU_NUM = 100,
    BAD_KABU_NUM = 0
};

/*
 *	֤μ
 */
enum {
    SMALL_KABU,		/* 	*/
    MEDIUM_KABU,	/* 	*/
    LARGE_KABU,		/* 	*/
    BAD_KABU,		/* ä	*/

    KABU_ALL_TYPES
};

/*
 *	ƥξ
 */
enum {
    ITEM_CD_NORMAL,		/* Ρޥ		*/
    ITEM_CD_PRESENT,		/* ץ쥼		*/
    ITEM_CD_QUEST,		/* 		*/
    ITEM_CD_CHK_ALL		/* ӥåȥå	*/
};


/*
 *	ⷿ
 */
typedef unint	money_t;

/*
 *	ϥ˥μ
 */
enum {
    HANIWA_FREE_TRADE_COND_e,
    HANIWA_ONLY_SHOW_COND_e,
    HANIWA_SELL_COND_e,

    HANIWA_ALL_TRADE_CONDS
};

/*
 *	ɥ⡼
 */
enum {
    SOUND_MODE_STEREO,		/* ƥ쥪	*/
    SOUND_MODE_MONO,		/* Υ	*/
    SOUND_MODE_HEADPHONE,	/* إåɥե	*/

    SOUND_ALL_MODES
};

/*
 *	ܥ⡼
 */
enum {
    VOICE_MODE_HANAMOGERA,	/* ϥʥ⥲	*/
    VOICE_MODE_CLICK,		/* å	*/
    VOICE_MODE_SILENT,		/* ò		*/

    VOICE_ALL_MODES
};

/*
 *	ꥻåλΥꥢ
 */
enum {
    NO_RESET_REACT,

    OPEN_DOOR_RESET_REACT,		/* ɥ򳫤		*/
    OUT_OF_BLOCK_RESET_REACT,		/* ֥åФ	*/
    OPEN_SUBMENU_RESET_REACT,		/* ֥˥塼򳫤	*/
    TALK_WITH_HANIWA_RESET_REACT,	/* Ϥˤä	*/
    OPEN_MAILBOX_RESET_REACT,		/* ͹ؼ򳫤	*/

    ALL_RESET_REACT_TYPES
};



/*
 ************************************************
 *						*
 *	Ƽ說饹ʥѡ		*
 *						*
 ************************************************
 */

/*
 *	󥯥饹	Ϻ
 */
typedef struct land_info_class {
    unchar	name[COUNTRY_NAME_NUM];	/** ̾ */
    char	player_exist;	/** ץ졼䡼¸  TRUE ¸ / FALSE  */
    lndid_t	id;			/**  ID */
} mLd_lnd_c;


/*
 *	ɥ쥹Ģ饹
 */
#if 0
typedef struct {
    Mail_nm_c	name;
} Address_c;
#endif

#define	NO_USE_ADDRESS_CHK_CODE	((lndid_t)0xffff)/* ̤ѥ */

/*
 *	ֲ
 */
typedef struct {
    unshort	price[SEVENDAYS_IN_A_WEEK];	/* ֲ塼	*/
    unshort	trade_market;			/* ʵ			*/
    OSRTCTime	rtcTime;			/* ֲ	*/

} Kabu_price_c;

/*
 *	ۥ饹
 */
typedef struct {
    unshort	num;		/* ǡֹ		*/
    mAc_nfs_t	name;		/* ץ쥤䡼̾	*/

} Cloth_c;

/*
 *	
 */
typedef struct {
    unchar	sound;		/* 	*/
    unchar	voice;		/* ܥ	*/
    unshort	pad_s;

} Config_c;

/*
 *	Źǹȶ
 */
typedef struct	shop_ftr_order_info		mPr_sftr_c;
struct	shop_ftr_order_info {
    mAc_nfs_t	itemNo;		/* ȶΥƥʥС */
    unchar	shopLevel;	/* ŹΥ٥ */
    unchar	pad;
};

/*
 *	Ŀ;󥯥饹
 */
typedef struct {
    PersonalID_c	pID;			/* ̾ */

    signed char		Distinction;		/* ͸ */
    signed char		face_type;		/* ץ졼䡼 */

    unchar		reset;			/* ꥻåȥ */
    mMsm_record_c	museum_record;		/** ʪ۾ */

    /* ͭ */
    struct {
	mAc_nfs_t	itemNo[ITEM_POSSESS_NUM];/*ͭƥ(ûʪޤ)*/
	u8		ticket_expiration;	/* ʡξ̣ */
	unchar		ticket_remain;		/* ϤƤʤʡο */
	unint		item_cond;		/* ƥξ */
	money_t		money;			/*  */
	money_t		loan;			/* ڶ */

    } possession;

    mQst_dlv_c		delivery[DELIVERY_QUEST_MAX];	/** ã */
    mQst_erd_c		errand[ERRAND_QUEST_MAX];	/** Ȥ */

    /*  */
    struct {
	mAc_nfs_t	item;			/*  */

    } equipment;

    Mail_mh_c	mail_header;			/* إåơʴѶ */
    Mail_c	mail[MAIL_POSSESS_NUM];		/*  */

    mAc_nfs_t	back_tex_name;		/* ʪ̤΢Ϥ̾ */
    unchar	exist;			/** ץ졼䡼¸(ˤ뤫)*/
    unchar	hint;			/** ҥʹ */

    Cloth_c	cloth;				/* ץ쥤䡼 */

    AnmPersonalID_c	foreign_npc_id;		/**  NPCĿ; */

    mPr_dst_c	destiny;			/** ̿ */

    mPr_bth_c	birthday;			/**  */

    mPr_sftr_c	shop_ftr[SHOP_FTR_ORDER_MAX];	/** Źǹȶ */

    mAc_nfs_t	mobile_ftr[MOBILE_FTR_ORDER_MAX];	/** Хȶ */

    u32		fish_collect_bit;	/*  */
    u32		insect_collect_bit;	/*  */

    unint	md_collect_bit[2];	/** MDʥե饰뤳ͭ*/

    Anm_remail_c	remail;		/** äưʪؤμ */

    unint	reset_code;		/** ꥻåȥå */

    mPr_ranm_c	animal_memory;		/** ֤Ƥ NPC */

    unchar	comp_ins_fish;		/** ץ꡼Ⱦ */

    u32		furniture_collect_bit[30];	/* ȶСϥ˥ޤ
						   ξ̤ */
    u32		wall_collect_bit[2];	/* ɻ */
    u32		carpet_collect_bit[2];	/* ߼ */
    u32		paper_collect_bit[2];	/* 䵼 */
    u32		music_collect_bit[2];	/* ڼʥե饰뤳Ȥʤ */

    mPr_map_c	map[GET_MAP_MAX];	/** ޥå׽ */

    u64		pad;			/* ͽ */
} Private_c;

#define	NO_USE_PLAYER_CHK_CODE	((lndid_t)0xffff)/* ץ졼䡼̤ѥ */

/*
 *	( ɻ桦 )ξ
 */
typedef struct	interior_class {
    unchar	floor_num;	/* ߤֹ */
    unchar	wall_num;	/* ɤֹ */
} Interior_c;


typedef struct {
    mAc_nfs_t	name;		/* ̾ */
    short	trade;		/* 򴹾 */
    unshort	arg_data;	/* Τۤǡ */

} Haniwa_Item_c;

/*
 *	ϥ˥
 */
typedef struct {
    Haniwa_Item_c	item[HANIWA_ITEM_POSSESS_NUM];	/* ƥ */

    unchar	message[HANIWA_MESSAGE_NUM];		/* å */

    money_t	proceeds;				/* 夲 */

} Haniwa_c;

/** 渶ͥåľ礭  */
#define	ROOM_RHYTHM_MAX					(8)

/*
 *	֥ץ졼䡼	ӥåȾ
 */
typedef struct	player_rooms_bit_info {
    unchar	room_write:1;	/** ե饰 */
    unchar	saved:1;	/** ֤򤷤Ȥե饰 **/	
    unchar	hello_happy_room:1;
    unchar	pad3:1;
    unchar	pad4:1;
    unchar	pad5:1;
    unchar	pad6:1;
    unchar	pad7:1;
} mHm_bit_c;


/*
 *	֥ץ졼䡼	礭ѹ
 */
typedef struct	player_rooms_size_info {
    /** ʸ */
    struct {
	u8	day;
	u8	month;
	u16	year;
    } order_date;

    unchar	level:2;	/** 礭 */
    unchar	new_level:2;	/** 礭 */
    unchar	renew:1;	/** Ωؤե饰 */
    unchar	ranking:2;	/** Ƽ󥭥 */
    unchar	bronze_order:1;	/** Ƽʸ */
} mHm_rmsz_c;

/*
 *	֥
 */
typedef u8 mHm_num_t;
typedef struct	__goki_info__ {
    lbRTC_ymd_c		time;
    mHm_num_t		num;	/** © */
    unchar		pad;
} mHm_goki_c;

/*
 *	֥ץ졼䡼׾
 */
typedef struct	player_rooms_information_class {
    /* λ */
    struct   {
	PersonalID_c	pID;	/* Ŀ; */
	char		secret[3];      /* ̩ */
    } owner;

    Interior_c	interior;	/** ɻ桦߾ */

    NA_RHYTHM_INFO	rhythm_info;	/** ġƥ */

    lbRTC_ymd_c	mark_time;	/**  */
    mHm_bit_c	bit_info;	/** ӥåȾ */
    mHm_rmsz_c	size;			/** 礭 */
    unchar	outlook_pal;		/* ѥѥå */
    unchar	next_outlook_pal;	/* γѥѥå */
    
    u64		ftr_switch[mFM_ROOM_FG_LAYER_MAX];	/** ֤Ƥȶ ON/OFF */
    mAc_nfs_t	on_utinfo[mFM_UT_W_NUM][mFM_UT_H_NUM];	/** FG  */
    mAc_nfs_t	on_on[mFM_UT_W_NUM][mFM_UT_H_NUM];/** ˾ʪ FG  */
    u32		rhythm[mFM_ROOM_FG_LAYER_MAX][ROOM_RHYTHM_MAX];	/**  */
    
    Mail_c	mail_box[MAIL_BOX_CAPA];		/** ͹ؼ */

    Haniwa_c	haniwa;

    mHm_goki_c	goki;	/** ֥ */

} mHm_hs_c;

/*
 *	֥å FG
 */
typedef struct field_fg_infomation_class {
    mAc_nfs_t	on[mFM_UT_H_NUM][mFM_UT_W_NUM];		/** FG  */
} mFM_bfg_c;


/*
 * ʥꥹȾ
 */
typedef struct __priority_list__ {
    mSP_list_t	a:2;
    mSP_list_t	b:2;
    mSP_list_t	c:2;   
    mSP_list_t	dummy:2;
} mSP_priority_c;


/*
 * Ź¿
 */
typedef struct __shop_misc__ {
    unshort	shop_level:2;			/* Ź٥		*/
    unshort	renewal_chirashi_appoday:1;	/* 饷ե饰 */
    unshort	renewal_chirashi_notice:1;	/* ͽ饷ե饰	*/
    unshort	first_start_data_init:1;	/* start_data_init̲*/
    unshort	pad:11;				/* ͽ			*/
} mSP_miscInf_c;

/*
 * Ź
 */
typedef	struct shop_class {
    mSP_priority_c	priority[mSP_LIST_MAX];		/* ꥹȤͥ */
    PersonalID_c	visitor[mSP_VISITOR_MAX];	/* ̾(10) */
    mAc_nfs_t		goods[mSP_GOODS_MAX];		/*  */
    mAc_nfs_t		rare;				/* 쥢ȶ */
    mAc_nfs_t		gift[mSP_GIFT_MAX];		/* ʡ */
    signed char		plant_goods[mSP_PLANT_MAX];	/* ʪʿ */
    mSP_miscInf_c	misc;			/* ¿ */
    money_t		sales_sum;		/* ̻夲 */
    lbRTC_time_c	exchange_time;		/* ξؤ */
    lbRTC_time_c	renewal_time;		/* Ź */
    int			visitor_flag;		/* ҥե饰 */
} mSP_shop_c;





/*
 *	֥ǡå饹
 * 4+4+2+64+2 = 76 Х
 */
typedef struct save_data_check_class {
    int			version;	/*  4 ֥ǡΥС */
    unint		code;           /*  4 ɤ֤ĤοID NAFJ */
    lndid_t		land_id;        /*  2  ID */
    lbRTC_time_c	time;		/* 64 ֻ */
    unshort		check_sum;	/*  2 å(Τβûͤ 0 ˤʤ褦) */
} mFRm_chk_c;
/** ֥ */
#define mFRm_SAVE_ID                    (('N' << 24) | ('A' << 16) | ('F' << 8) | ('J')) /* ॳɤƱ */

/*
 *	֥饹
 */
typedef struct flash_save_class		Save_c;
struct flash_save_class {

    mFRm_chk_c	save_check;		/** ֥ǡå饹 */
    
    Scene_No 	scene_no;		/* ֹ */

    unchar	now_npc_max;		/** ߽Ǥ NPC */

    unchar	remove_animal_no;	/** ñۤͽ NPCưʪֹ */

    Private_c	privateInfo[COMPATRIOT_PLAYER_NUM];	/* ץ쥤䡼ǡ */

    mLd_lnd_c	landinfo;		/*  */

    mNtc_ntc_c	boardinfo[mNtc_BOARD_MAX];	/* Ǽľ */

    mHm_hs_c	home[COMPATRIOT_PLAYER_NUM];			/* Ⱦ */

    mFM_bfg_c	fg[mFM_FD_BK_H_NUM][mFM_FD_BK_W_NUM];	/* ֥å FG */

    mFM_cmb_c	combitable[mFM_FD_BK_H_MAX_NUM][mFM_FD_BK_W_MAX_NUM];

    Animal_c	animal[mNpc_REMOVE_NPC_MAX];	/** ñۤNPCưʪ */

    AnmPersonalID_c	last_remove_animal_id;	/** Ƕñۤưʪ */

    mSP_shop_c	shop;			/** Ź */

    Kabu_price_c	kabu_schedule;	/* ֲ */

    mEv_sec_c	event_save;		/** ٥ȥ־ */
    mEv_Save    event;                  /** ƥ **/

    mAc_nfs_t	fruit;			/** ͭβʪ */

    unchar	house_arrange;		/* Ȥ */
    unchar	next_figure;		/** ˷ƤƼ */

    lbRTC_time_c	GrowTime;		/* Ĺ */

    PostOffice_c	postOffice;	/* ͹ض */

    PoliceBox_c	policeBox;		/*  */

    mSN_save_c	snowman;		/*  */

    u64		melody;			/* β */

    Config_c	config;			/*  */

    lbRTC_ymd_c	renew_time;		/* ѹι */

    unchar	station_type;		/* ؤμ */
    unchar	weatherInfo;		/* ŷ  4bit */
    unshort	pad_s;

    unshort	deposit[mFM_FD_BK_W_NUM * mFM_FD_BK_H_NUM][mFM_UT_H_NUM]; /* ¢ */

    lbRTC_time_c	remove_time;	/** ưʪõϿ */

    mPr_pmm_c	mother_mail[COMPATRIOT_PLAYER_NUM];	/** 줫μ */

    lbRTC_ymd_c	mushroom_time;		/** ޤĤå */
    lbRTC_ymd_c	event_time;		/** ٥ȥå */
    
    u16		famicom_high_scores[20]; /* եߥϥ¸(0-8,10-18) */

    u8		used_npc[mNpc_RGSTD_NPC_BIT_TBL_SIZE_u8];
    lbRTC_time_c	debug_time;	/* ǥХåѤλ֤Ǥ */

    u8		zuru_check_flg;	/* ֤ѹե饰ʤåѡ */
    u8		famicom_high_scores2[7]; /* եߥϥ¸ѣ(0-5) */

    lbRTC_time_c	treasure_set_time;	/* ȢåȻ */
    lbRTC_time_c	treasure_check_time;	/* Ȣå */

    unchar	saved_rom_d;	/** ON rom_dǥ֤ / OFF Ȥʤ */
    u8		snowman_date_year;	/* ޴ǯ  */
    u8		snowman_date_month;	/* ޴ */
    u8		snowman_date_day;	/* ޴ */
    u8		snowman_date_hour;	/* ޴ */
    unchar	deposit_haniwa;		/** ϥ˥¢̿ */
    unchar	pad[2];
    /** ܥǤΥǡɲäϤξ  ˤäƲ */
    u64		dummy_alignment0;	/** 饤 */
    
    /** ¸ΥǡɲäϤǤäơ˾˰ưƲ */
    u64		pading[15];	/** ɲäλϥäƻȤäƲ */
    
    /*
     *
     *	θˤϥФڤʤǥͥ
     *	ڤȤpading[]ȤäƤäƥͥ
     *	;äpad_?ˤƶƤ뤳Ȥƥͥ
     *
     */
};

/* 2001.01.24	֥ǡС󥢥å	*/
typedef struct flash_save_class_old	Save_c_old;
struct flash_save_class_old {

    mFRm_chk_c	save_check;		/** ֥ǡå饹 */
    
    Scene_No 	scene_no;		/* ֹ */
    
    unchar	now_npc_max;		/** ߽Ǥ NPC */

    unchar	remove_animal_no;	/** ñۤͽ NPCưʪֹ */

    Private_c	privateInfo[COMPATRIOT_PLAYER_NUM];	/* ץ쥤䡼ǡ */

    mLd_lnd_c	landinfo;		/*  */

    mNtc_ntc_c	boardinfo[mNtc_BOARD_MAX];	/* Ǽľ */

    mHm_hs_c	home[COMPATRIOT_PLAYER_NUM];			/* Ⱦ */

    mFM_bfg_c	fg[mFM_FD_BK_H_NUM][mFM_FD_BK_W_NUM];	/* ֥å FG */

    mFM_cmb_c	combitable[mFM_FD_BK_H_MAX_NUM][mFM_FD_BK_W_MAX_NUM];

    Animal_c	animal[mNpc_REMOVE_NPC_MAX];	/** ñۤNPCưʪ */

    AnmPersonalID_c	last_remove_animal_id;	/** Ƕñۤưʪ */

    mSP_shop_c	shop;			/** Ź */

    Kabu_price_c	kabu_schedule;	/* ֲ */

    mEv_sec_c_old	event_save;		/** ٥ȥ־ */
    mEv_Save_old	event;                  /** ƥ **/

    mAc_nfs_t	fruit;			/** ͭβʪ */

    unchar	house_arrange;		/* Ȥ */
    unchar	next_figure;		/** ˷ƤƼ */

    lbRTC_time_c	GrowTime;		/* Ĺ */

    PostOffice_c	postOffice;	/* ͹ض */

    PoliceBox_c	policeBox;		/*  */

    mSN_save_c	snowman;		/*  */

    u64		melody;			/* β */

    Config_c	config;			/*  */

    lbRTC_ymd_c	renew_time;		/* ѹι */

    unchar	station_type;		/* ؤμ */
    unchar	weatherInfo;		/* ŷ  4bit */
    unshort	pad_s;

    unshort	deposit[mFM_FD_BK_W_NUM * mFM_FD_BK_H_NUM][mFM_UT_H_NUM]; /* ¢ */

    lbRTC_time_c	remove_time;	/** ưʪõϿ */

    mPr_pmm_c	mother_mail[COMPATRIOT_PLAYER_NUM];	/** 줫μ */

    lbRTC_ymd_c	mushroom_time;		/** ޤĤå */
    lbRTC_ymd_c	event_time;		/** ٥ȥå */
    
    u16		famicom_high_scores[20]; /* եߥϥ¸(0-8,10-18) */

    u8		used_npc[mNpc_RGSTD_NPC_BIT_TBL_SIZE_u8];
    lbRTC_time_c	debug_time;	/* ǥХåѤλ֤Ǥ */

    u8		zuru_check_flg;	/* ֤ѹե饰ʤåѡ */
    u8		famicom_high_scores2[7]; /* եߥϥ¸ѣ(0-5) */

    lbRTC_time_c	treasure_set_time;	/* ȢåȻ */
    lbRTC_time_c	treasure_check_time;	/* Ȣå */

    unchar	saved_rom_d;	/** ON rom_dǥ֤ / OFF Ȥʤ */
    u8		snowman_date_year;	/* ޴ǯ  */
    u8		snowman_date_month;	/* ޴ */
    u8		snowman_date_day;	/* ޴ */
    u8		snowman_date_hour;	/* ޴ */
    unchar	deposit_haniwa;		/** ϥ˥¢̿ */
    unchar	pad[2];
    /** ܥǤΥǡɲäϤξ  ˤäƲ */
    u64		dummy_alignment0;	/** 饤 */
    
    /** ¸ΥǡɲäϤǤäơ˾˰ưƲ */
    u64		pading[15];	/** ɲäλϥäƻȤäƲ */
    
    /*
     *
     *	θˤϥФڤʤǥͥ
     *	ڤȤpading[]ȤäƤäƥͥ
     *	;äpad_?ˤƶƤ뤳Ȥƥͥ
     *
     */
};

/*
 *	֥ǡե륯饹
 */
#define	ALIGNMENT_128(a)	(((a)+127) & 0xffffff80u )
#define SAVE_DATA_SIZE		(1024 * 64)
#define SAVE_DATA_SIZE_U32	((int)(ALIGNMENT_128(SAVE_DATA_SIZE) / sizeof(u32)))

typedef	union {
    u32		data[SAVE_DATA_SIZE_U32];
    Save_c	element;
    Save_c_old	element_old;
    u64		dummy;				/* Хȥ饤Ȥΰ(ޥ˥奢ǤϣХȤ侩) */
} RWF_c;





/*
 ************************************************
 *						*
 *	Ƽ說饹󥻡ѡ		*
 *						*
 ************************************************
 */
/*
 *	ִط饹
 */
typedef struct {
    unint	season;			/* 			*/
    unint	termIdx;		/* ֥ǥå	*/
    short	bgItem_profile;		/* £ƻץե	*/
    Object_Bank	bgItem_bank;		/* £ƻХ	*/
    int		now_sec;		/* βܤ	*/
    OSRTCTime	rtcTime;		/* ңԣåޡ	*/
    short	rad_min;		/* פûˤΥ饸	*/
    short	rad_hour;		/* פĹˤΥ饸	*/
    unchar	timeSignal;		/* ե饰		*/
    unchar	under_sec;		/* ̤		*/
#if DEBUG || defined(FDEBUG)
    unchar	disp;			/* 		*/
#else	/* DEBUG || defined(FDEBUG) */
    unchar	pad;			/* 			*/
#endif	/* DEBUG || defined(FDEBUG) */

    unchar	rtc_crash;		/* ңԣåå	*/

    int		rtc_use;		/* ңԣûѥե饰	*/
    int		add_sec;		/* ûÿ		*/
#if DEBUG || defined(FDEBUG)
    int		add_idx;		/* ûʳ		*/
#else	/* DEBUG || defined(FDEBUG) */
    int		pad_i;
#endif	/* DEBUG || defined(FDEBUG) */

} Time_c;

/* ңԣûѥå */
#define	RTC_USE_CHK	((ZCommonGet(time.rtc_use) == ON) && (ZCommonGet(time.rtc_crash) == OFF))

/*
 *	꡼󥨥ե
 */
typedef struct {
    unchar	fade_go;		/* ǥեɼϤ */
    unchar	fade_speed;		/* եɥԡ */
    unchar	wipe_speed;		/* 磻  ԡ */
    unchar	next_wipe;		/* 磻ץֹ */
} Screff_c;

/*
 *	ץܥ饹
 */
typedef struct {
    unchar	j_n;			/* (ɤ֤ĤοǤ̤)ʣУ  Σţ */
    unchar	s_sound;		/* ӣϣգΣ ƥ쥪Υ롿إåɥۥ󡿣 */
    unchar	language;		/*  */
    unchar	pad_c;			/*  */
} Option_c;



/*
 ************************************************
 *						*
 *		ǡ饹		*
 *						*
 ************************************************
 */
typedef struct common_data_class {
    /* ӣ֣ */
    RWF_c	save;
    /* 嵭Ρաۤ򸫤Ƥ */



    /* ΣϨӣ֣ */
    unchar	game_1_patu;		/* ࣱȯ */
    unchar	field_type;		/* եɥ */
    unchar	field_draw_type;	/* ե西 */
    unchar	player_no;		/* ץ쥤䡼ʥС */

    Scene_No	before_scene_no;	/* ΥΣ */

    int		player_data_mode;	/** Ѥץ졼䡼ǡμ */

    Clip_c	clip;			/* å׾ */

    Time_c	time;			/* ִط */

#if 0
    Address_c	plAddress[COMPATRIOT_PLAYER_NUM];	/*ץ쥤䡼ɥ쥹*/

    Address_c	anmAddress[ADDRESS_REGIST_NUM];	/* ưʪɥ쥹 */
#endif

    Private_c	*now_private;		/* ߤΥץ졼䡼θĿ; */
    mHm_hs_c	*now_home;		/* Ⱦ */

    unchar	map_flg;		/* ޥåɽĥե饰 */
    unchar	fish_location;		/* ȯ־ */
    unshort	pad_ss;

    Option_c	option;			/* ץ */

    Screff_c	screff;			/* ꡼󥨥ե */

    short	item_type;		/* £ƻ񥿥 */
    short	item_profile;		/* £ƻץե */

    int		item_idx;		/* Ϥƥ।ǥå */

    PlantGrow_c	plantGrow;		/* ʪĹ */

    Npclist_c	npclist[mNpc_REMOVE_NPC_MAX];	/** NPCȯ󥯥饹 */
    mAc_nfs_t	houseIdx;		/* ץ쥤䡼äȤλFG̾ */
    mAc_nfs_t	before_fieldID;		/* Υեɣɣ */
    unchar	first_block;		/* եɤäƤϤƤΥ֥å */
    unchar	submenu_call_refuse;	/* ֥˥塼̵ե饰Υեɤλۤ */
    unchar	sun_light_flg;		/* ۸ե饰 */
    unchar	train_set_flg;		/* ﵥȯѤߥե饰 */

    Mail_c	send_mail;		/* Ǽ */
    mAc_nfs_t	toBox;			/* ݥȰ or ͹ؼ */
    mAc_nfs_t	from;			/* Ф */

    Mail_nm_c	send_npc_mail;		/* NPCμ永̾ */
    mAc_nfs_t	npc_new_cloth;		/* NPCȤؤ̾ */

    Weather_c	weather;		/* ŷ */

    mEv_nsc_c	event_chk;		/** ٥ȥå */

    mQst_uni_c	quest;			/** ȶͭ */

    Scene_No 	start_demo_scene_no;	/* ȥǥ⥷ֹ */

    NpcSche_c	npc_sche[mNpc_REMOVE_NPC_MAX];	/* ΣУå塼 */

    mNpcW_wlk_c	npc_walk;		/* NPC */

    EventNpc_c	event_npc[mNpc_EVENT_NPC_NUM];		/* ٥ȣΣУ */

    int		snowman_msg;		/* ޤθ */

    short	moneyPower;		/* Ɀѥ */
    short	goodsPower;		/* ʪѥ */

    Door_data	door_data;		/* ɥǡ */
    Door_data	str_out_data;		/* ¤ʪФΥɥǡ */
    M_DEMO_CLIENT  start_demo;		/* Ȼ˶Ūǥ */
    Door_data	event_door_data;	/* ٥ȤΥɥǡ */
    Door_data	emu_ret_data;		/* ߥ奲फΥɥǡ*/

    unchar	clear_cut_tree;		/** ڤڤä󥯥ꥢӥåȾ */
    signed char	floor_idx;		/* ­ֹ */

    short	sp_demo_profile;	/* üǥץե */

    int		event_pstat[4];		/* ٥ȤäƤե饰 */

    Position_Angle	p_world;	/* ٥ȲڤؤѰΰ	*/
    unchar		evfade_fg;	/* ٥Ȳڤؤѥե饰		*/

    signed char request_warp;	/* ץ쥤䡼˥ײǽ򤵤ե饰 */
    signed char exist_player;	/* ץ쥤䡼¸ߤƤ뤫 */
    signed char complete_payment_demo_type;	/* ڶֺѴλǥ⥿ */
    signed char player_decoy;	/* ץ쥤䡼гݤǤΥץ쥤 */
    
    u8		furniture_set;

    short	title_event, title_event_flag;

    mEv_Common  event;			/* ٥ */

    FamicomEmu_Common	famicomemu; /* եߥ󥨥ߥѥǡ(8B) */

    signed char bee_swell_player;		/* ץ쥤䡼˪˻ɤ줿 */
    signed char bee_chase_player;		/* ץ쥤䡼˪ɤƤ뤫 */
    signed char already_shock_goki;		/* ֥򸫤ƥå˼ */
    unchar	time_change_flg;		/* ֤ѹե饰ʣңԣѡ */
    signed char unable_wade;			/* ζػ */
    signed char set_msg_fail_emu;		/* ߥ쥿ɤ߹߼ԥåɽ̿ */

    /* ִ	by sumiyosi 00/09/27(WED)	*/
    unchar	mTRC_train_set_flag;		/* ֥åȥե饰	*/
    unchar	mTRC_train_exist;		/* ¸		*/
    unchar	mTRC_control_now;		/* ֥ե饰	*/
    unchar	mTRC_control_old;		/* ֥ե饰-old-	*/
    unchar	mTRC_signal;			/* SIGNAL		*/
    unchar	mTRC_day;			/* ؤå	*/
    unchar	mTRC_action;			/* ֤ξ		*/
    unchar	mTRC_timer;			/*  TIMER		*/
    u32		mTRC_start_timer;		/* ȯ(ñ: )	*/
    float	mTRC_train_speed;		/* ֤®		*/
    xyz_t	mTRC_train_pos;			/* ֤ΰ		*/
    f32		mTRC_mic_distanceXYZ_1;
    f32		mTRC_mic_distanceXYZ_2;
    u16		mTRC_angleY_1;
    u16		mTRC_angleY_2;
    /* ޤǡ	*/

    unchar	reset_flag;		/** ꥻåȲ줿ե饰 */
    unchar	reset_react;		/* ꥻåȥꥢ */
    unchar	mail_extra_delivery;	/* ͹׻ã */
    unchar	post_npc_type;		/* ڥꥳڥߥ */

    xyz_t	ball_pos;		/* ܡݥХåե */
    char	ball_type;		/* ܡμ		    */
    unchar	auto_nwrite_num;	/* Ǽļư񤭹ѥʥС */
    unshort	auto_nwrite_year;	/* Ǽļư񤭹ǯǡ */

    unchar	flash_rom_condition;		/** FLASHROM˲ */

    /* ִ 	*/
    unchar	mTRC_approach_trg;

    unchar	treasure_set_flg;	/* õѥե饰 */

    unchar	pad_c[2];
    unshort	event_message;          /* ٥ȹΥǥե饰 */ 

    OSRTCTime		new_set_time;		/*  */
    OSRTCTime		old_RTC_time;		/* ꤷΣңԣäλ */

    short       balloon_live;           /* Ƥ */
    short       balloon_min;            /* ȯ֡ʬ */
    float       balloon_ratio;          /* ȯΨ   */
    
    int 	ins_check_flag;		/* åȺɸåե饰		*/
    unchar	ins_ut_xnum_bak[ 2 ];	/* 嵭åѣإ˥åȺɸ	*/
    unchar	ins_ut_znum_bak[ 2 ];	/* 嵭åѣڥ˥åȺɸ	*/
    
    int		tanuki_shop_status;	/* ̤Ź */
    
    int 	gyo_check_flag;		/* åȺɸåե饰		*/
    unchar	gyo_ut_xnum_bak[ 2 ];	/* 嵭åѣإ˥åȺɸ	*/
    unchar	gyo_ut_znum_bak[ 2 ];	/* 嵭åѣڥ˥åȺɸ	*/
    unchar	pad_connect_chk;	/* ȥ³å	*/
    
    short	weather_se;		/*ŷɥ٥Хåե	*/
    short	pad_s;			/*ѥǥ󥰤Υ硼ȤǤȤä
					  ޤ		*/
    /** ܥǤΥǡɲäϤξ  ˤäƲ */
#if DEBUG
    u64	dummy_alignment0;		
#endif	/* DEBUG */
    /** ¸ΥǡɲäϤǤäơ˾˰ưƲ */
#if DEBUG
    int		pad_i[19];		/** ɲäλϥäƻȤäƲ */
#endif	/* DEBUG */

    
#if DEBUG
    mAc_nfs_t	test_npc;		/* ƥѣΣУ */
    u64	dummy_alignment1;
#endif	/* DEBUG */

    /*
     *
     *	θˤϥФڤʤǥͥ
     *	ڤȤpad_i[]ȤäƤäƥͥ
     *	;äpad_?ˤƶƤ뤳Ȥƥͥ
     *
     */

} Common_data_c;

/*
 ************************************************
 *						*
 *					*
 *						*
 ************************************************
 */
/*
 * ̥ǡ
 * ɬޥͳƤ
 */
extern Common_data_c	common_data;

/*
 *	̥ǡ
 */
extern void	common_data_init(void);

/*
 *	̥ǡƽ
 * (⡼ɤ¸ޤ)
 */
extern void	common_data_reinit(void);

/*
 *	ڤؤäȤΥꥢ
 */
extern void	common_data_clear(void);

/*
 * ޥ
 */
/* Фͤ */
#define ZCommonGet(member)		(common_data.member)
/* ФΥݥ󥿤ʹ¤ΤΥϤ侩 */
#define ZCommonGetP(member)		(&common_data.member)
/* Фͤ */
#define ZCommonSet(member, value)	(common_data.member = (value))



/*
 * ֥ǡޥ
 */
#define SaveGet(member)			(ZCommonGet(save.element.member))
#define SaveGetP(member)		(ZCommonGetP(save.element.member))
#define SaveSet(member, value)		(ZCommonSet(save.element.member,value))

#define SaveGet_old(member)		(ZCommonGet(save.element_old.member))
#define SaveGetP_old(member)		(ZCommonGetP(save.element_old.member))
#define SaveSet_old(member, value)	(ZCommonSet(save.element_old.member,value))

/* ץ饤١ȥ饹Ƭ */
#define	PrivateGet(member,who)		(SaveGet(privateInfo[who].member))
#define	PrivateGetP(member,who)		(SaveGetP(privateInfo[who].member))
#define	PrivateSet(member, who, value)	(SaveSet(privateInfo[who].member, value))

/* ߤΥץ졼䡼Υץ饤١ȥ饹Ƭ */
#define	nowPrivateGet(member)	(ZCommonGet(now_private->member))
#define	nowPrivateGetP(member)	(ZCommonGetP(now_private->member))
#define	nowPrivateSet(member, value)	(ZCommonSet(now_private->member,value))


/* ƥξ */
#define	itemCondGet(i)		((nowPrivateGet(possession.item_cond) >> ((unint)(i) << 1)) & ITEM_CD_CHK_ALL)
#define	itemCondSet(i,v)	(nowPrivateSet(possession.item_cond, ((nowPrivateGet(possession.item_cond) & ~((unint)ITEM_CD_CHK_ALL << ((unint)(i) << 1))) | ((unint)(v) << ((unint)(i) << 1)))))





#ifdef _LANGUAGE_C_PLUS_PLUS
} /* extern "C" */
#endif	/* _LANGUAGE_C_PLUS_PLUS */

#endif /* INCLUDE_M_COMMON_DATA_H */


/*** m_common_data.h ***/
