/*
 *****************************************************************************
 *
 * 	File		: m_cpak.c
 *	Programer	: Gentaro Takaki
 * 
 *	$Id: m_cpak.c,v 1.90 2001-02-06 13:38:27+09 gen Exp $
 *
 *****************************************************************************
 */

#include "padmgr.h"		/* padmgr_LockSerialMesgQ */
#include "m_controller.h"
#include "m_cpak.h"
#include "m_basic.h"

#include "m_private.h"
#include "m_font.h"
#include "assert64.h"
#include "m_land.h"
#include "m_immig.h"
#include "m_malloc.h"
#include "m_flashrom.h"
#include "m_cpak_lib.h"

/** ³ȥ */
#define	mCPk_CONT_NUM		1
/** Ѵޥ */
#define ABC(a)        ((a) - 'A' + 0x1a)
#define __SPC( )      (0x0f)

/** ԡץƥȺ */
#define	mCPk_PROTECT_MAX		(0xfffe)
#define	mCPk_PROTECT_MAX_F		(float)((0xfffe))
/** ԡץƥȥ顼 */
#define	mCPk_PROTECT_ERR_CODE		(0xffff)

/** 32ХȤΥ饤 */
#define	mCPk_ALIGNMENT_32(a)	(((a) + 31 ) & 0xffffffe0 )
/** 256ХȤΥ饤 */
#define	mCPk_ALIGNMENT_256(a)	(((a) + 255 ) & 0xffffff00 )


/** ץ졼䡼ѥݡȥ */
#define	mCPk_PASSPORT_SIZE	(mCPk_ALIGNMENT_256(sizeof(mCPk_passport_c)))
/** ե륵 */
#define	mCPk_MAIL_FILE_SIZE	(mCPk_ALIGNMENT_256(sizeof(mCPk_mail_c)))

/** ȥѥå˥֤뤿ι¤ */
typedef struct	pak_private_info_c {
    unshort	check_sum;	/** å */
    Private_c	pr_info;
    Animal_c	remove;		/** ñۤưʪ */
    unshort	copy_protect;	/** ƥॳԡк */
} mCPk_passport_c;

typedef union	pak_read_write_file {
    unchar		file[mCPk_PASSPORT_SIZE];
    mCPk_passport_c	passport;
} mCPk_rwf_c;

/*
 *	ȥѥå֥ǡǡ
 */
typedef struct	pak_control_info {
    mCPk_rwf_c		rwfile;		/** ѥåؤΥ֥ǡ */
    OSMesgQueue		*serialMsgQ;	/** ꥢå塼 */
    int			status;		/** ǡɤ߹߾ */
    unshort		protect_code;	/** ԡк */
} mCPk_ctrl_c;


/** ҥ */
#if 1
static const u16	l_company_code = M_CPAK_COMPANY_CODE;
#else	/** #if 1 else */
#define	mCPk_COMPANY_CODE_MAX		(2)
const u8	l_company_code[mCPk_COMPANY_CODE_MAX] = {
    0x30, 0x31
//    0x00, 0x01
};
#endif	/** #if 1 else end */

/** ॳ */
#if 1
static const u32	l_game_code = M_CPAK_GAME_CODE;
#else	/** #if 1 else */
#define	mCPk_GAME_CODE_MAX		(4)
const u8	l_game_code[mCPk_GAME_CODE_MAX] = {
    ABC('N'),ABC('A'),ABC('F'),ABC('J'),
//    0x00, 0x00, 0x00, 0x001
};
#endif	/** #if 1 else end */

/** ͡ */
#define	mCPk_GAME_NAME_MAX		(16)
#if 1
static const u8	*l_game_name = (u8 *)M_CPAK_GAME_NAME;
#else
const u8	l_game_name[mCPk_GAME_NAME_MAX] = {
    ABC('F'), ABC('O'), ABC('R'), ABC('E'), 
    ABC('S'), ABC('T'), __SPC( ), ABC('T'), 
    ABC('E'), ABC('S'), ABC('T'), __SPC( ), 
    ABC('T'), ABC('Y'), ABC('P'), ABC('E'), 
};
#endif


#define	mCPk_EXT_NAME_MAX		(4)
/** ץ졼䡼ǡĥ A */
static const u8	l_ext_name_player[mCPk_EXT_NAME_MAX] = {
    0x1a, 0x00, 0x00, 0x00
//    0x2e, 0x00, 0x00, 0x00
};
/** ǡĥ B */
static const u8	l_ext_name_letter[mCPk_EXT_NAME_MAX] = {
    0x1b, 0x00, 0x00, 0x00
//    0x35, 0x00, 0x00, 0x00
};
static const u8	*l_ext_name_table[mCPk_DATA_END_e] = {
    l_ext_name_player,
    l_ext_name_letter,
};

/** Ρȥ */
static const u32	l_note_size[mCPk_DATA_END_e] = {
    mCPk_PASSPORT_SIZE,
    mCPk_MAIL_FILE_SIZE,
};

/** ȥ顼ѥå */
static mCPk_ctrl_c		l_pak_ctrl;

static mCPk_pkinfo_c		l_paks_info;
static mCPk_pkinfo_c		*g_paks_info_p = &l_paks_info;

/*
 ****************************************************************
 *	ե륹ơɽؿ( ǥХå )
 ****************************************************************
 */
#if	defined(U_gen_U)
static void mCPk_PrintFileState(
    OSPfsState	*pakState
    ){

    int		i;

    PRINTF(ESC_YELLOW"pak file state\n"ESC_NORMAL);
    PRINTF(ESC_YELLOW" file size     %#010x\n"ESC_NORMAL,
	   pakState->file_size);
    PRINTF(ESC_YELLOW" game code     %#010x\n"ESC_NORMAL,
	   pakState->game_code);
    PRINTF(ESC_YELLOW" company code  %#010x\n"ESC_NORMAL,
	   pakState->company_code);
    PRINTF(ESC_YELLOW" ext name      "ESC_NORMAL);
    for( i = 0; i < 4; i++ ){
	PRINTF(ESC_YELLOW"%#010x "ESC_NORMAL,pakState->ext_name[i]);
    }
    PRINTF(ESC_YELLOW"\n game name     "ESC_NORMAL);
    for( i = 0; i < 16; i++ ){
	PRINTF(ESC_YELLOW"%#010x "ESC_NORMAL,pakState->game_name[i]);
    }
    PRINTF(ESC_YELLOW"\n\n"ESC_NORMAL);
    
}
#endif

/*
 ****************************************************************
 *	ȥѥå顼åϴؿ
 ****************************************************************
 */
#if DEBUG
extern void mCPk_PrintErrMsg(
    sCPk_pkf_c	*pakf,
    int		idx
    ){

    int	err = (int)pakf->error;

    switch( err ){
      case 0:
	  PRINTF(ESC_CYAN"PACK%d\tProcess OK.\n"ESC_NORMAL,idx+1);
	  break;
      case PFS_ERR_NOPACK:	/** ѥåäƤʤ */
	  PRINTF(ESC_ERROR"PACK%d\tPFS_ERR_NOPACK\n"ESC_NORMAL,idx+1);
	  break;
      case PFS_ERR_NEW_PACK:	/** ̤ΥѥåˤѤäƤ */
	  PRINTF(ESC_ERROR"PACK%d\tPFS_ERR_NEW_PACK\n"ESC_NORMAL,idx+1);
	  break;
      case PFS_ERR_INCONSISTENT:	/** ե륷ƥδΰ˰۾ */
	  PRINTF(ESC_ERROR"PACK%d\tPFS_ERR_INCONSISTENT\n"ESC_NORMAL,idx+1);
	  break;
      case PFS_ERR_CONTRFAIL:	/** ǡž */
	  PRINTF(ESC_ERROR"PACK%d\tPFS_ERR_CONTRFAIL\n"ESC_NORMAL,idx+1);
	  break;
      case PFS_ERR_INVALID:	/** ѥ᡼۾. ΡȤ¸ߤʤ */
	  PRINTF(ESC_ERROR"PACK%d\tPFS_ERR_INVALID\n"ESC_NORMAL,idx+1);
	  break;
      case PFS_ERR_BAD_DATA:	/** 񤭹ɤ߹⤦ȤƤ */
	  PRINTF(ESC_ERROR"PACK%d\tPFS_ERR_BAD_DATA\n"ESC_NORMAL,idx+1);
	  break;
      case PFS_DATA_FULL:	/** ΰ­ */
	  PRINTF(ESC_ERROR"PACK%d\tPFS_DATA_FULL\n"ESC_NORMAL,idx+1);
	  break;
      case PFS_DIR_FULL:	/** Ρȿ */
	  PRINTF(ESC_ERROR"PACK%d\tPFS_DIR_FULL\n"ESC_NORMAL,idx+1);
	  break;
      case PFS_ERR_EXIST:	/** ΡȤǤ¸ߤƤ */
	  PRINTF(ESC_ERROR"PACK%d\tPFS_ERR_EXIST\n"ESC_NORMAL,idx+1);
	  break;
      case PFS_ERR_ID_FATAL:	/** IDΰ褬˲Ƥ */
	  PRINTF(ESC_ERROR"PACK%d\tPFS_ERR_ID_FATAL\n"ESC_NORMAL,idx+1);
	  break;
      case PFS_ERR_DEVICE:	/** ѥåʳΤΤäƤ */
	  PRINTF(ESC_ERROR"PACK%d\tPFS_ERR_DEVICE\n"ESC_NORMAL,idx+1);
	  break;
      default:			/** ̤ΤΥ顼 */
	  PRINTF(ESC_ERROR"PACK%d\tUNKNOWN ERROR\n"ESC_NORMAL,idx+1);
	  break;
    }
}
#endif	/* DEBUG */


/*
 ****************************************************************
 *	ѥå IDؿ
 ****************************************************************
 */
#if 0
static void mCPk_RepairID(
    mCPk_pkinfo_c	*pakinfo
    ){

    int	ret = 0;
    
    do {
	if( chkTriggerC4( A_BTN )){
	    ret = sCPk_RepairID( &pakinfo->pakFile );
	    break;
	} else if( ){
	}
    } while( 1 );
    
}
#endif

/*
 ****************************************************************
 *	ȥѥåΥץ
 *
 *  	֤	: 0 ۾ｪλ / 1 ｪλ
 ****************************************************************
 */
extern int mCPk_PakOpen(
    mCPk_pkinfo_c	*pak_p,
    int			idx
    ){

    int		ret;

    /*== ȥѥåǧ ==*/
    ret = sCPk_PakOpen( &(pak_p->pakFile), idx );
#if	defined(U_gen_U)
    mCPk_ErrMsg( &(pak_p->pakFile), idx );
#endif
#if	defined(U_gen_U) && 0
    {
	int	i;
	
	PRINTF("\n\n");
	for( i = 0; i < 32; i++ ){
	    PRINTF(ESC_CYAN"%#02x "ESC_NORMAL,
		   pak_p->pakFile.pfs.id[i] );
	}
	PRINTF("\n\n");
    }
#endif
    return ret;
}

/*
 ********************************************************************
 *	ץ󤷤ȥѥåΥåؿ
 *
 *  	ȥѥå顼Ƥ饳ȥֹ֤.
 *	Ǥ -1֤.
 ********************************************************************
 */
#if 0
int mCPk_ChkState(
    int		ContPakOpen
    ){
    
    int idx;
    
    for(idx = 0; idx < 4; idx++){
	if( ContPakOpen != 0 ){ /*== ȥѥå顼ξ ==*/
	    return idx;
	}
    }
    /*== ȥѥåǤ -1֤ ==*/
    return -1;
}
#endif

/*
 ****************************************************************
 *	ΡȤκؿ
 *
 *  	֤	: 0 ۾ｪλ / 1 ｪλ
 ****************************************************************
 */
static int mCPk_NoteMake(
    mCPk_pkinfo_c	*pak_p
    ){

    OSPfsState	*pakState_p = &(pak_p->pakState);
    int		ret;

#if	defined(U_gen_U)
    mCPk_PrintFileState( pakState_p );
#endif
    ret = sCPk_MakeFile( &(pak_p->pakFile), pakState_p,
			 (int)(pakState_p->file_size));
#if	defined(U_gen_U)
    mCPk_ErrMsg( &(pak_p->pakFile), 0 );
#endif
    return ret;
}

/*
 ********************************************************************
 *	ץ󤷤ȥѥåΥΡȤ򥪡ץ󤹤
 *
 *  	֤	: 0 ۾ｪλ / 1 ｪλ
 ********************************************************************
 */
static int mCPk_NoteOpen(
    mCPk_pkinfo_c	*pak_p
    ){
    
    int		ret = 0;

#if	defined(U_gen_U)
    mCPk_PrintFileState( &(pak_p->pakState) );
#endif
    /* ΡȤΥץ */
    ret = sCPk_FileOpen( &(pak_p->pakFile), &(pak_p->pakState));
#if	defined(U_gen_U)
    mCPk_ErrMsg( &(pak_p->pakFile), 0 );
    PRINTF("ret : %d\n",ret);
#endif
    return ret;
}

/*
 ****************************************************************
 *	ΡȤκؿ
 *
 *  	֤	: 0 ۾ｪλ / 1 ｪλ
 ****************************************************************
 */
#if 0
static int mCPk_NoteDelete(
    mCPk_pkinfo_c	*pak_p
    ){
			    
    int		ret;
    
    /* ΡȤκ */
    ret = sCPk_DeleteFile( &(pak_p->pakFile), &(pak_p->pakState));
#if	defined(U_gen_U)
    mCPk_ErrMsg( &(pak_p->pakFile), 0 );
#endif
    return ret;
}
#endif

/*
 ****************************************************************
 *	ΡȤκȻѿ򻻽Фؿ
 *
 *  	֤ 	: 0 ۾ｪλ / 1 ｪλ
 ****************************************************************
 */
extern int mCPk_NoteNum(
    mCPk_pkinfo_c	*pak_p
    ){

    return  sCPk_FileNum( &(pak_p->pakFile),
			  &(pak_p->max_file), &(pak_p->use_file));
}

/*
 ****************************************************************
 *	ΡȤΥơؿ
 *
 *  	֤	: 0 ۾ｪλ / 1 ｪλ
 ****************************************************************
 */
extern int mCPk_AllFileState(
    mCPk_pkinfo_c	*pak_p
    ){

    sCPk_pkf_c	*pakFile = &(pak_p->pakFile);
    OSPfsState	*pakState = &(pak_p->fileState[0]);
    s32		*fileState_ret = &(pak_p->fileState_ret[0]);
    int		i;
    int		ret = 0;

    for( i = 0; i < mCPk_MAX_FILE_NUM; i++ ){
	fileState_ret[i] = 0;
	pakFile->file_no = (s32)i;
	ret = (int)(sCPk_FileState( pakFile, &pakState[i] ));
	if( ret == 0 ){
	    if( pakFile->error == PFS_ERR_INVALID ){
		fileState_ret[i] = -1;
	    } else {
		return ret;
	    }
	}
    }
    return ret;
}

/*
 ****************************************************************
 *	ΡȤζ֥åؿ
 *
 *	֤	: 0 ۾ｪλ / 1 ｪλ
 ****************************************************************
 */
extern int mCPk_FreeBlockNum(
    mCPk_pkinfo_c	*pak_p
    ){

    int		ret = 0;

    pak_p->free_blocks = sCPk_PakFreeArea(&(pak_p->pakFile));

    if( pak_p->pakFile.error == 0 ){
	ret = 1;
    }
#if	defined(U_gen_U)
    PRINTF(ESC_ERROR"free block %#010x\n"ESC_NORMAL,pak_p->free_blocks);
#endif
    return ret;
}

/*
 ****************************************************************
 *	ΡȤ˥֤뤫å
 *
 *		TRUE
 *	ʤ	FALSE
 ****************************************************************
 */
static int mCPk_CheckNoteRest(
    mCPk_pkinfo_c	*pak_p
    ){

    int		ret = FALSE;
    int		rec;

    /** ֥åμ */
    rec = mCPk_FreeBlockNum( pak_p );
    if(( rec == 1 ) &&
       ((u32)pak_p->free_blocks >= pak_p->pakState.file_size )){
	ret = TRUE;
    }
    return ret;
}

/*
 ****************************************************************
 *	ѥåǡݴΰΥꥢ
 ****************************************************************
 */
static void mCPk_ClearPassport(
    mCPk_passport_c	*passport_p
    ){

    passport_p->check_sum = 0;
    mPr_ClearPrivateInfo(&(passport_p->pr_info));
    mNpc_ClearAnimalInfo(&(passport_p->remove));
    passport_p->copy_protect = mCPk_PROTECT_ERR_CODE;
}

/*
 ****************************************************************
 *	ȥѥåν
 *
 *  	֤	: 0 ۾ｪλ / 1 ｪλ
 ****************************************************************
 */
extern int mCPk_InitPak(
    int			idx
    ){

    mCPk_pkinfo_c	*pak_p = mCPk_get_pkinfo( );
    OSPfsState		*pakState_p;
    OSPfsState		*fileState_p;
    int			ret = 0;
    int			i;

    pak_p->ContPakOpen = 0;
	
    pakState_p = &(pak_p->pakState);
    bzero( pakState_p, sizeof(OSPfsState));

    fileState_p = &(pak_p->fileState[0]);
    
    for( i = 0; i < mCPk_MAX_FILE_NUM; i++ ){
	bzero( fileState_p, sizeof(OSPfsState));
	fileState_p++;
    }

    sCPk_SetCode( pakState_p, (const u8 *)&l_company_code, (const u8 *)&l_game_code);
    bcopy( l_game_name, (u8*)&(pakState_p->game_name), mCPk_GAME_NAME_MAX );
    /** ȥѥåΥץ */
    ret = mCPk_PakOpen( pak_p, idx );
    
    /** ȥ顼ѥåν */
    mCPk_ClearPassport(&(l_pak_ctrl.rwfile.passport));
    
    l_pak_ctrl.serialMsgQ = NULL;
    l_pak_ctrl.status = OFF;
    l_pak_ctrl.protect_code = mCPk_PROTECT_ERR_CODE;
    
    return ret;
}

/*
 ****************************************************************
 *	ѥåե빽¤Τưʪο󥻥å
 ****************************************************************
 */
static void mCPk_SetForestPakState(
    mCPk_pkinfo_c	*pak_info_p,
    unchar		data_kind	/** åȤưʪοѥǡ */
    ){

    OSPfsState		*pakState_p = &(pak_info_p->pakState);

    if( data_kind < mCPk_DATA_END_e ){
	/** ƥǡѤγĥҥå */
	bcopy( l_ext_name_table[data_kind],
	       (u8*)&(pakState_p->ext_name),
	       mCPk_EXT_NAME_MAX );
	/** Ρȥå */
	pakState_p->file_size = (u32)(l_note_size[data_kind]);
    }
#if	DEBUG
    else {
	PRINTF("data kind : %d\n",data_kind);
	assert(0);
    }
#endif	/** DEBUG end */
}


/*
 ****************************************************************
 *	ǡ򥳥ȥѥå˽񤭹ؿ
 *
 *	֤	: 0 ۾ｪλ / 1 ｪλ
 *
 *---------------------------------------------------------------
 *	  
 *
 *	δؿǤϥѥåΥץϹԤäƤޤ
 *	ɬȥѥåΰϢνκǽ
 *	ѥåΥץؿ򥳡뤷Ƥ
 ****************************************************************
 */
static int mCPk_Save(
    mCPk_pkinfo_c	*pak_p,
    unchar		*uniq_file_p
    ){
    
    int 		idx;		/** ȥ顼ֹ */
    int			ret = 0;	/** 0:۾ｪλ / 1:ｪλ */
    int			size;		/** ֥ */
    sCPk_pkf_c		*pakFile;	/** ȥѥåե빽¤ */
    OSPfsState		*pakState;	/** ե륹ơ¤ */

    for(idx = 0; idx < 1; idx++){
	pakFile = &(pak_p->pakFile);
	pakState = &(pak_p->pakState);
	/** ꥢåθ */
	l_pak_ctrl.serialMsgQ = padmgr_LockSerialMesgQ( );
#if	defined(U_gen_U)
	PRINTF(ESC_CYAN"Gamenote Open -----\n"ESC_NORMAL);
#endif
	/** ΡȤΥץ */
	ret = mCPk_NoteOpen( pak_p );
	/** FORESTΥΡȤ¸ߤʤп */
	if( pakFile->error == PFS_ERR_INVALID ){
#if	defined(U_gen_U)
	    PRINTF(ESC_CYAN"Gamenote Make -----\n"ESC_NORMAL);
#endif
	    ret = mCPk_NoteMake( pak_p );
#if	defined(U_gen_U)
	    mCPk_ErrMsg( pakFile, idx );
#endif
	}
	/** ѥå˥ץ褿饻֤ */
	if(( ret == 1 ) || ( pakFile->error == PFS_ERR_EXIST )){
	    size = ( int )pakState->file_size;
#if	defined(U_gen_U)
	    PRINTF(ESC_CYAN"Pak Save -----\n"ESC_NORMAL);
	    PRINTF(ESC_CYAN"\tSave size %#010x\n"ESC_NORMAL,size);
#endif
	    /**  */
	    ret = sCPk_Save( pakFile, 0, size, uniq_file_p );
#if	defined(U_gen_U)
	    mCPk_ErrMsg( pakFile, idx );
#endif	/** defined(U_gen_U) end */
	}
	/** ꥢåθ */
	padmgr_UnlockSerialMesgQ( l_pak_ctrl.serialMsgQ );
    }
    return ret;
}

/*
 ****************************************************************
 *	ǡ򥳥ȥѥåɤ߽Фؿ
 *
 *	ｪλ			1
 *	ΡȤΥץǼ		0
 *	ǡɤǼ		-1
 *---------------------------------------------------------------
 *	  
 *
 *	δؿǤϥѥåΥץϹԤäƤޤ
 *	ɬȥѥåΰϢνκǽ
 *	ѥåΥץؿ򥳡뤷Ƥ
 ****************************************************************
 */
static int mCPk_Load(
    mCPk_pkinfo_c	*pak,
    unchar		*uniq_file_p
    ){
    
    int			ret = 0;
    int			size;		/** ɥ */
    sCPk_pkf_c		*pakFile;	/** ȥѥåե빽¤ */
    OSPfsState		*pakState;	/** ե륹ơ¤ */

    pakFile = &(pak->pakFile);
    pakState = &(pak->pakState);
    
    /** ꥢåθ */
    l_pak_ctrl.serialMsgQ = padmgr_LockSerialMesgQ( );
#if	defined(U_gen_U)
    PRINTF(ESC_CYAN"Gamenote Open -----\n"ESC_NORMAL);
#endif
    /** ΡȤΥץ */
    ret = mCPk_NoteOpen( pak );
    if( ret == 1 ){
	size = ( int )pakState->file_size;
#if	defined(U_gen_U)
	PRINTF(ESC_CYAN"Pak Load -----\n"ESC_NORMAL);
	PRINTF(ESC_CYAN"\tLoad size %#010x\n"ESC_NORMAL, size);
	mCPk_PrintFileState(pakState);
#endif
	ret = sCPk_Load( pakFile, 0, size, uniq_file_p );
	if( ret == 0 ){
	    ret = -1;
	}
#if 0
	if( ret == 1 ){
	    l_pak_ctrl.status = ON;
	}
#endif
#if	defined(U_gen_U)
	mCPk_ErrMsg( pakFile, 0 );
#endif
    }
    /** ꥢåθ */
    padmgr_UnlockSerialMesgQ( l_pak_ctrl.serialMsgQ );
    return ret;
}

/*
 ****************************************************************
 *	ѥåΰ˥ץ졼䡼ǡå
 ****************************************************************
 */
extern void mCPk_SetPrivateSavefile(
    Private_c	*private_p
    ){

    if( private_p != NULL ){
	mem_copy((unchar *)(&(l_pak_ctrl.rwfile.passport.pr_info)),
		 (unchar *)private_p,
		 (size_t)sizeof(Private_c));
    }
}

/*
 ****************************************************************
 *	ѥåΰΥץ졼䡼ǡݥ󥿼
 ****************************************************************
 */
extern Private_c *mCPk_GetSaveFilePrivateP( void ){

    return &(l_pak_ctrl.rwfile.passport.pr_info);
}

/*
 ****************************************************************
 *	Фǡѥå˥
 *
 *	ｪλ	TRUE
 *	۾ｪλ	FALSE
 *---------------------------------------------------------------
 *	  
 *
 *	δؿǤϥѥåΥץϹԤäƤޤ
 *	ɬȥѥåΰϢνκǽ
 *	ѥåΥץؿ򥳡뤷Ƥ
 ****************************************************************
 */
extern int mCPk_SavePak(
    Private_c		*private_p,
    Animal_c		*animal_p,
    mCPk_pkinfo_c	*pak_info_p
    ){

    unshort	check_sum;
    int		ret;

    /** ץ졼䡼ǡѤΥե륹ơ򥻥å */
    mCPk_SetForestPakState( pak_info_p, mCPk_DATA_PRIVATE_e );
   
    /** ǡΥԡ */
    mCPk_SetPrivateSavefile( private_p );
    mem_copy((unchar *)(&(l_pak_ctrl.rwfile.passport.remove)),
	     (unchar *)animal_p,
	     (size_t)sizeof(Animal_c));
    /** åλ */
    check_sum = mFRm_GetFlatCheckSum((unshort *)(&(l_pak_ctrl.rwfile.file[0])),
				     (int)mCPk_PASSPORT_SIZE,
				     l_pak_ctrl.rwfile.passport.check_sum );
    /** åॻå */
    l_pak_ctrl.rwfile.passport.check_sum = check_sum;

#if	DEBUG
    {
	unshort		flat_check_sum;
	
	flat_check_sum =
	    mFRm_ReturnCheckSum((unshort *)(&(l_pak_ctrl.rwfile.file[0])),
				(int)mCPk_PASSPORT_SIZE );
	PRINTF(ESC_YELLOW
	       "ȥѥåΥå %#010x\n"ESC_NORMAL,
	       flat_check_sum);
	if( flat_check_sum != 0 ){
	    assert(0);
	}
    }
#endif	/** DEBUG end */
    
    ret = mCPk_Save( pak_info_p, &(l_pak_ctrl.rwfile.file[0]));
    return ret;
}

/*
 **********************************************************************
 *	ȥѥåץ쥤䡼ɤ߹ߥåȤؿ
 *
 *  	֤	: 0 ۾ｪλ / 1 ｪλ
 **********************************************************************
 */
extern int mCPk_PakPrivateLoad(
    Private_c		*private_p,
    Animal_c		*animal_p,
    mCPk_pkinfo_c	*pak_info_p
    ){

    int		ret;

#if	defined(U_gen_U) && 1
    PRINTF("Private Info Load \n");
#endif
    /** ץ졼䡼ǡѤΥե륹ơ򥻥å */
    mCPk_SetForestPakState( pak_info_p, mCPk_DATA_PRIVATE_e );

    ret = mCPk_Load( pak_info_p, &(l_pak_ctrl.rwfile.file[0]));
    if( ret == 1 ){
	l_pak_ctrl.status = ON;
    }
#if	defined(U_gen_U) && 1
    PRINTF("Load PrivateData\n");
#if	DEBUG
    mPr_PrintPersonalID( &(l_pak_ctrl.rwfile.passport.pr_info.pID));
#endif
    PRINTF(ESC_CYAN"money = %d\n"ESC_NORMAL,
	   l_pak_ctrl.rwfile.passport.pr_info.possession.money);
#endif
    

    if( ret == 1 ){
	if( mPr_CheckPrivate(&(l_pak_ctrl.rwfile.passport.pr_info)) == TRUE ){

	    /** ǡΥԡ */
	    mem_copy((unchar *)private_p,
		     (unchar *)(&(l_pak_ctrl.rwfile.passport.pr_info)),
		     (size_t)sizeof( Private_c ));
	    mem_copy((unchar *)animal_p,
		     (unchar *)(&(l_pak_ctrl.rwfile.passport.remove)),
		     sizeof(Animal_c));
	} else {
#if	defined(U_gen_U)
	    PRINTF(ESC_RED
		   "ץ졼䡼ǡƤޤäƤޤ\n"
		   ESC_NORMAL);
#endif
	    ret = 0;
	}
    } else {
#if	defined(U_gen_U)
	PRINTF(ESC_RED
	       "ѥåɤ߹߼ԤǤ\n"
	       ESC_NORMAL);
#endif
	ret = 0;
    }
    return ret;
}

/*
 ****************************************************************
 *	ȥ顼ѥåΥǡå
 *
 *	in	:	ʤ
 *
 *	out	:	ǡ ( cpak_data_status )
 *
 *	֤	:	ｪλ	TRUE
 *			۾ｪλ	FALSE
 *---------------------------------------------------------------
 *	֤ͤ FALSEξϥȥѥå
 *	ɤ߼꤬ˤǤƤޤ
 *	ξ, data_statusˤ mCPk_DATA_ERR_eäƤޤ
 *---------------------------------------------------------------
 *	  
 *
 *	δؿǤϥѥåΥץϹԤäƤޤ
 *	ɬȥѥåΰϢνκǽ
 *	ѥåΥץؿ򥳡뤷Ƥ
 ****************************************************************
 */
static int mCPk_CheckData_common(
    int			*data_status,
    int			data_kind,
    mCPk_pkinfo_c	*pak_info_p,
    unchar		*buf_p		/** ΰ */
    ){

    sCPk_pkf_c		*pakFile_p;	/** ȥѥåե빽¤ */
    OSPfsState		*pakState;	/** ե륹ơ¤ */
    int			ret = FALSE;
    unchar		*read_buf_p;
    int			rec;

#if	defined(U_gen_U)
    PRINTF("ǡå\n");
#endif
#if	DEBUG
    if(( data_kind < 0 ) || ( data_kind >= mCPk_DATA_END_e )){
	PRINTF("data kind : %d\n",data_kind);
	assert(0);
    }
#endif	/** DEBUG end */
    
    (*data_status) = mCPk_DATA_ERR_e;
    /** ꥢåθ */
    l_pak_ctrl.serialMsgQ = padmgr_LockSerialMesgQ( );
    
    pakFile_p = &(pak_info_p->pakFile);
    pakState = &(pak_info_p->pakState);
    /** ưʪοΥΡȥץ */
    rec = mCPk_NoteOpen( pak_info_p );
    /** ˥ץǤ */
    if(( rec == 1 ) || ( pakFile_p->error == PFS_ERR_EXIST )){

#if	defined(U_gen_U)
	PRINTF("ΡȤΥץǤ rec : %d file size %d plsize : %d\n",
	       rec,pakState->file_size, sizeof(mCPk_rwf_c));
#endif	/** defined(U_gen_U) end */
	
	if( data_kind == mCPk_DATA_PRIVATE_e ){
	    read_buf_p = (unchar *)(&(l_pak_ctrl.rwfile));
	} else {
	    read_buf_p = buf_p;
	}
	/** ѥåǡɤ߹ */
#if	DEBUG
	assert(read_buf_p);
#endif	/** DEBUG end */
	if( read_buf_p != NULL ){
	    rec = sCPk_Load( &(pak_info_p->pakFile), 0,
			     (int)(pakState->file_size),
			     read_buf_p );
	    if( rec == 1 ){
#if	defined(U_gen_U)
		PRINTF("ǡΥɽޤ\n");
#endif	/** defined(U_gen_U) end */
		if( data_kind == mCPk_DATA_PRIVATE_e ){
		    if( mPr_NullCheckPersonalID(
			&(l_pak_ctrl.rwfile.passport.pr_info.pID)) == FALSE ){
			l_pak_ctrl.status = ON;
			(*data_status) = mCPk_DATA_EX_e;
		    } else {
			(*data_status) = mCPk_DATA_EX_NO_PLAYER_e;
		    }
		} else {
		    (*data_status) = mCPk_DATA_EX_NO_PLAYER_e;
		}
		ret = TRUE;
	    }
	}
    } else if( pakFile_p->error == PFS_ERR_INVALID ){
#if	defined(U_gen_U)
	PRINTF("Υǡޤ\n");
#endif

	/* Ρȿۤʤå */
	rec = mCPk_NoteNum(pak_info_p);

#if	defined(U_gen_U)
	PRINTF("rec = %d:use_file = %d\n",
	       rec,pak_info_p->use_file);
#endif
	if(rec == 1 &&
	   pak_info_p->use_file >=  mCPk_MAX_FILE_NUM) {
	    (*data_status) = mCPk_DATA_NOTE_FULL_e;
#if	defined(U_gen_U)
		PRINTF("ΡȤ˶ʤ\n");
#endif
	    ret = True;
	} else {
	    /** ưʪοΥΡȤ¸ߤʤ */
	    rec = mCPk_CheckNoteRest( pak_info_p );
	    /** ȥѥåζΰ褬 */
	    if( rec == 1 ){
#if	defined(U_gen_U)
		PRINTF("\n");
#endif
		(*data_status) = mCPk_DATA_NO_e;
		ret = TRUE;
	    } else if( pakFile_p->error == 0 ){
#if	defined(U_gen_U)
		PRINTF("ޤ\n");
#endif
		/** ѥå˶ΰ褬ʤ */
		(*data_status) = mCPk_DATA_LACK_AREA_e;
		ret = TRUE;
	    }
	}
    } else {
#if	defined(U_gen_U)
	PRINTF("Ρȥץ󥨥顼\n");
#endif
    }
    /** ꥢåθ */
    padmgr_UnlockSerialMesgQ( l_pak_ctrl.serialMsgQ );
    
    return ret;
}

static int mCPk_CheckData(
    int			*data_status,
    int			data_kind,
    mCPk_pkinfo_c	*pak_info_p
    ){

    OSPfsState		*pakState;	/** ե륹ơ¤ */
    int			ret = FALSE;
    unchar		*buf_p = NULL;

    if( data_kind == mCPk_DATA_PRIVATE_e ){
	buf_p = (unchar *)(&(l_pak_ctrl.rwfile));
    } else {
	pakState = &(pak_info_p->pakState);
	buf_p = (unchar *)zelda_malloc((unint)(pakState->file_size));
#if	DEBUG
	if( buf_p != NULL ){
	    PRINTF(ESC_CYAN" %#010x\n"ESC_NORMAL,
		   pakState->file_size);
	} else {
	    PRINTF(ESC_CYAN" %#010xݼ\n"ESC_NORMAL,
		   pakState->file_size);
	    assert(0);
	}
#endif	/** DEBUG end */
    }
    ret = mCPk_CheckData_common( data_status, data_kind, pak_info_p, buf_p );
    if(( data_kind != mCPk_DATA_PRIVATE_e ) && ( buf_p != NULL )){
	zelda_free( buf_p );
#if	defined(U_gen_U)
	PRINTF("ΰβ\n");
#endif
    }
    return ret;
}

/*
 ****************************************************************
 *	ѥåΥǡ( cpak_data_status )
 *	ֵ( cpak_save_permission )ؤѴ
 *
 *	֤	: ֵ
 ****************************************************************
 */
static int mCPk_PakDataStatus2Permission(
    int		data_status
    ){

    int		ret_perm = mCPk_SAVE_PRM_ERR_e;

    switch( data_status ){
	case mCPk_DATA_EX_e :
	    ret_perm = mCPk_SAVE_PRM_EX_OK_e;
	    break;
	case mCPk_DATA_NO_e :
	case mCPk_DATA_EX_NO_PLAYER_e :
	    ret_perm = mCPk_SAVE_PRM_NO_OK_e;
	    break;
	case mCPk_DATA_LACK_AREA_e :
	    ret_perm = mCPk_SAVE_PRM_NO_AREA_e;
	    break;
	case mCPk_DATA_NOTE_FULL_e :
	    ret_perm = mCPk_SAVE_PRM_NOTE_FULL_e;
	    break;
	case mCPk_DATA_ERR_e :
	    ret_perm = mCPk_SAVE_PRM_ERR_e;
	    break;
	default :
	    ret_perm = mCPk_SAVE_PRM_ERR_e;
	    break;
    }
    return ret_perm;
}

/*
 ****************************************************************
 *	ȥѥåΥץ졼䡼Υץ졼䡼ʥС
 *
 *	֤
 *
 *		ץ졼䡼ʥС
 *		ιο	0  (COMPATRIOT_PLAYER_NUM - 1)
 *		㤦ο	mPr_FOREIGNER_PLAYER_NO
 *
 *		-1
 *---------------------------------------------------------------
 *	  
 *
 *	δؿǤϥѥåΥץϹԤäƤޤ
 *	ɬȥѥåΰϢνκǽ
 *	ѥåΥץؿ򥳡뤷Ƥ
 ****************************************************************
 */
extern int mCPk_GetPakPlayerNo( void ){

    mCPk_pkinfo_c	*pak_info_p = mCPk_get_pkinfo( );
    Private_c		*private_p = SaveGetP(privateInfo[0]);
    int			ret_pl_no = -1;
    int			rec;
    int			i;
	
    /** ץ졼䡼ǡѤΥե륹ơ򥻥å */
    mCPk_SetForestPakState( pak_info_p, mCPk_DATA_PRIVATE_e );
    /** ȥѥåǡɤ߹ */
    rec = mCPk_Load( pak_info_p, &(l_pak_ctrl.rwfile.file[0]));
    if( rec == 1 ){
	l_pak_ctrl.status = ON;
    }

    /** ɤ߹ߤץ졼䡼ǡΥå */
    if( rec == 1 ){
#if	defined(U_gen_U)
	PRINTF("ɤ߹\n");
#endif
	/*
	 *	ѥåǡ˥ץ졼䡼ǡ
	 *	ιΥץ졼䡼ǡȰפΥå
	 */
	if( mPr_NullCheckPersonalID(&(l_pak_ctrl.rwfile.passport.pr_info.pID))
	    == FALSE ){
	    /** Ȥꤢͤ˥å */
	    ret_pl_no = mPr_FOREIGNER_PLAYER_NO;
	    for( i = 0; i < COMPATRIOT_PLAYER_NUM; i++ ){
		if( mPr_CheckCmpPrivate(&(l_pak_ctrl.rwfile.passport.pr_info),
					private_p ) == TRUE ){
		    ret_pl_no = i;
		    break;
		}
		private_p++;
	    }
	}
    }
    return ret_pl_no;
}

/*
 ****************************************************************
 *	ȥѥåΥץ졼䡼̾
 ****************************************************************
 */
extern unchar *mCPk_GetPakPlayerName( void ){

    static unchar	dummy_name[PERSON_NAME_NUM] = {
	MOJI_ZI, MOJI_LITTLEYO, MOJI_NI, MOJI_HYPHEN, MOJI_TEN, MOJI_B,
    };
    Private_c		*private_p = NULL;
    mCPk_pkinfo_c	*pak_info_p = mCPk_get_pkinfo( );
    unchar		*ret_name_p = &(dummy_name[0]);
    int			rec;

    /** Ǥ˥ѥåǡɤ߹߽λƤɤ߹Ǥ̾򤫤 */
    if( l_pak_ctrl.status == OFF ){
	/** ץ졼䡼ǡѤΥե륹ơ򥻥å */
	mCPk_SetForestPakState( pak_info_p, mCPk_DATA_PRIVATE_e );
	/** ȥѥåǡɤ߹ */
	rec = mCPk_Load( pak_info_p, &(l_pak_ctrl.rwfile.file[0]));
	if( rec == 1 ){
	    l_pak_ctrl.status = ON;
	    private_p = &(l_pak_ctrl.rwfile.passport.pr_info);
	}
    } else {
	private_p = &(l_pak_ctrl.rwfile.passport.pr_info);
    }
    if(( private_p != NULL ) &&
       ( mPr_NullCheckPersonalID(&(private_p->pID)) == FALSE )){
	ret_name_p = &(private_p->pID.player_name[0]);
    }
#if	defined(U_gen_U)
    else {
	PRINTF(ESC_ERROR"ѥå˥ץ졼䡼ǡϤޤ\n"ESC_NORMAL);
    }
#endif	/** defined(U_gen_U) */

    return ret_name_p;
}

/*
 ****************************************************************
 *	ԡк
 *
 *	å	TRUE
 *	åȼ	FALSE
 *---------------------------------------------------------------
 *	ɬ mCPk_PakOpen( );ԤäƤƤ
 ****************************************************************
 */
extern int mCPk_SetPakCopyProtect(
    mCPk_pkinfo_c	*pak_info_p
    ){

    unshort	protect_code;
    unshort	check_sum;
    int		rec;
    int		ret = FALSE;

    /** ȥѥå˽񤭹 ( λѥåΥǡιʤ ) */
    if( l_pak_ctrl.status == OFF ){
#if	defined(U_gen_U)
	PRINTF(ESC_YELLOW"ȥѥåơ OK\n"ESC_NORMAL);
#endif	/** defined(U_gen_U) end */
	/** ץ졼䡼ǡѤΥե륹ơ򥻥å */
	mCPk_SetForestPakState( pak_info_p, mCPk_DATA_PRIVATE_e );
	/** ȥѥåǡɤ߹ */
	rec = mCPk_Load( pak_info_p, &(l_pak_ctrl.rwfile.file[0]));
	if( rec == 1 ){
#if	defined(U_gen_U)
	    PRINTF(ESC_YELLOW"ȥѥåǡɤ߹OK\n"ESC_NORMAL);
#endif	/** defined(U_gen_U) end */
	    l_pak_ctrl.status = ON;
	}
    }
    if( l_pak_ctrl.status == ON ){
	protect_code = (unshort)( mCPk_PROTECT_MAX_F * rnd( ));
	    
	l_pak_ctrl.protect_code = protect_code;
	l_pak_ctrl.rwfile.passport.copy_protect = protect_code;
	/** åॻå */
	check_sum =
	    mFRm_GetFlatCheckSum((unshort *)(&(l_pak_ctrl.rwfile.file[0])),
				 (int)mCPk_PASSPORT_SIZE,	
				 l_pak_ctrl.rwfile.passport.check_sum );
	l_pak_ctrl.rwfile.passport.check_sum = check_sum;
	
#if	DEBUG
    {
	unshort		flat_check_sum;
	
	flat_check_sum =
	    mFRm_ReturnCheckSum((unshort *)(&(l_pak_ctrl.rwfile.file[0])),
				(int)mCPk_PASSPORT_SIZE );
	PRINTF(ESC_YELLOW
	       "ȥѥåΥå %#010x\n"ESC_NORMAL,
	       flat_check_sum);
	if( flat_check_sum != 0 ){
	    assert(0);
	}
    }
#endif	/** DEBUG end */
	/** ѥå˽񤭹 */
	rec = mCPk_Save( pak_info_p, &(l_pak_ctrl.rwfile.file[0]));
	if( rec == 1 ){
#if	defined(U_gen_U)
	    PRINTF(ESC_GREEN"ѥå񤭹 OK\n"ESC_NORMAL);
#endif	/** defined(U_gen_U) end */
	    ret = TRUE;
	}
    }
    return ret;
}

/*
 ****************************************************************
 *	ԡкɥå
 *
 *	OK	TRUE
 *	NG	FALSE
 *---------------------------------------------------------------
 *	  
 *
 *	δؿǤϥѥåΥץϹԤäƤޤ
 *	ɬȥѥåΰϢνκǽ
 *	ѥåΥץؿ򥳡뤷Ƥ
 ****************************************************************
 */
extern int mCPk_CheckPakCopyProtect(
    mCPk_pkinfo_c	*pak_info_p
    ){

    int		ret = FALSE;
    int		rec;

#if	defined(U_gen_U)
    PRINTF("mCPk_CheckPakCopyProtect \n");
#endif	/** defined(U_gen_U) end */

    /** ɤΥåȤƤ뤫 */
    if( l_pak_ctrl.protect_code != mCPk_PROTECT_ERR_CODE ){
#if	defined(U_gen_U)
	PRINTF("ɤƥɥå\n");
#endif	/** defined(U_gen_U) end */
	/** ץ졼䡼ǡѤΥե륹ơ򥻥å */
	mCPk_SetForestPakState( pak_info_p, mCPk_DATA_PRIVATE_e );
	/** ޤϥѥåǡɤ߹ */
	rec = mCPk_Load( pak_info_p, &(l_pak_ctrl.rwfile.file[0]));
	/** ɤ߹Ƥ饳ɥå */
	if( rec == 1 ){
	    l_pak_ctrl.status = ON;
	    if( l_pak_ctrl.protect_code ==
		l_pak_ctrl.rwfile.passport.copy_protect ){
		ret = TRUE;
	    }
	}
    } else {
#if	defined(U_gen_U)
	PRINTF("ѥåԡɤϥåȤƤޤ\n");
#endif	/** defined(U_gen_U) end */
	ret = TRUE;
    }
    
    return ret;
}

/*
 ****************************************************************
 *	ѥåֵļ	ץ졼䡼ǡ
 *
 *	֤	: ֵ ( cpak_save_permission )
 *---------------------------------------------------------------
 *	  
 *
 *	δؿǤϥѥåΥץϹԤäƤޤ
 *	ɬȥѥåΰϢνκǽ
 *	ѥåΥץؿ򥳡뤷Ƥ
 ****************************************************************
 */
extern int mCPk_GetPermissionSavePakPlayer( void ){

    mCPk_pkinfo_c	*pak_info_p = mCPk_get_pkinfo( );
    int			ret_perm = mCPk_SAVE_PRM_NO_PAK_e;
    int			data_status;

#if	defined(U_gen_U)
    PRINTF("mCPk_GetPermissionSavePakPlayer:\n");
#endif	/** defined(U_gen_U) end */

//    if( pak_info_p->pakFile.error == 0 ){
	/** ץ졼䡼ǡѤΥե륹ơ򥻥å */
	mCPk_SetForestPakState( pak_info_p, mCPk_DATA_PRIVATE_e );
	if( mCPk_CheckPakCopyProtect( pak_info_p ) == TRUE ){
#if	defined(U_gen_U)
	    PRINTF(ESC_GREEN"ѥåΥץƥȤ OK *********************\n"
		   ESC_NORMAL);
#endif	/** defined(U_gen_U) end */
	    if( mCPk_CheckData( &data_status,
				mCPk_DATA_PRIVATE_e,
				pak_info_p ) == TRUE ){
#if	defined(U_gen_U)
		PRINTF(ESC_GREEN
		       "ǡΥå OK OK %d *********************\n"
		       ESC_NORMAL,data_status);
#endif	/** defined(U_gen_U) end */
		ret_perm = mCPk_PakDataStatus2Permission( data_status );
	    }
	} else {	/** ϻȥǡۤʤ */
	    ret_perm = mCPk_SAVE_PRM_DATA_DIFF_e;
	}
//    }
#if	defined(U_gen_U)
    PRINTF("ɤ礫 %d --------------------------------\n",ret_perm);
#endif	/** defined(U_gen_U) end */
    return ret_perm;
}

/*
 ****************************************************************
 *	ǡΥɤȥå
 ****************************************************************
 */
static void mCPk_CheckCheckSumMail(
    unchar		*buf_p,
    int			size,
    mCPk_pkinfo_c	*pak_info_p
    ){

    mCPk_mail_c		*mail_p = (mCPk_mail_c *)buf_p;
    unshort		check_sum;
    int			rec;
    
    rec = mCPk_LoadPakMail2( mail_p, pak_info_p );
    if( rec == 1 ){
	/** å */
	check_sum = mFRm_ReturnCheckSum((unshort *)buf_p, size );
#if	defined(U_gen_U)
	PRINTF("åμ : %#010x\n",check_sum);
#endif	/** defined(U_gen_U) end */
	/** å۾ΤΡȤξõ */
	if( check_sum != 0 ){
	    OSMesgQueue	*Q;
#if	DEBUG
	    int		err;
#endif	/** DEBUG end */

#if	defined(U_gen_U)
	    PRINTF(ESC_RED"å : %#010xʤΤǥΡȺ\n"ESC_NORMAL);
#endif	/** defined(U_gen_U) end */
	    

	    /** ץ졼䡼ǡѤΥե륹ơ򥻥å */
	    mCPk_SetForestPakState( pak_info_p, mCPk_DATA_LETTER_e );
	    
	    Q = padmgr_LockSerialMesgQ();
#if	DEBUG
	    err =
#endif	/** DEBUG end */
		sCPk_DeleteFile(&(pak_info_p->pakFile),
				&(pak_info_p->pakState));
	    padmgr_UnlockSerialMesgQ(Q);
	    
#if	DEBUG
	    if( err != 1 ){
		PRINTF("ΡȺ\n");
	    }
#endif	/** DEBUG end */
	}
    } else if( rec == -1 ){
	mCPk_pkinfo_c	*pak_info_p = mCPk_get_pkinfo( );
#if	DEBUG
	int		err;
#endif	/** DEBUG end */

#if	defined(U_gen_U)
	PRINTF("ΡȤϤΤ˥ɼԤʤΤǥΡȾäޤ\n");
#endif	/** defined(U_gen_U) end */

	/** ץ졼䡼ǡѤΥե륹ơ򥻥å */
	mCPk_SetForestPakState( pak_info_p, mCPk_DATA_LETTER_e );
	    
	/** ꥢåθ */
	l_pak_ctrl.serialMsgQ = padmgr_LockSerialMesgQ( );
#if	DEBUG
	err = 
#endif	/** DEBUG end */
	    sCPk_DeleteFile(&(pak_info_p->pakFile), &(pak_info_p->pakState));

#if	DEBUG
	if( err != 0 ){
	    PRINTF("줿ΡȤκޤ\n");
	}
#endif	/** DEBUG end */
	
	padmgr_UnlockSerialMesgQ(l_pak_ctrl.serialMsgQ);
    }
}
    
/*
 ****************************************************************
 *	ѥåֵ	ǡ
 *
 *	֤	: ֵ ( cpak_save_permission )
 *---------------------------------------------------------------
 *	  
 *
 *	δؿǤϥѥåΥץϹԤäƤޤ
 *	ɬȥѥåΰϢνκǽ
 *	ѥåΥץؿ򥳡뤷Ƥ
 ****************************************************************
 */
extern int mCPk_GetPermissionSavePakMail(
    mCPk_pkinfo_c	*pak_info_p
    ){

    OSPfsState	*pakState;	/** ե륹ơ¤ */
    int		data_status;
    int		ret_perm = mCPk_SAVE_PRM_NO_PAK_e;
    unchar	*buf_p = NULL;

#if	DEBUG
    PRINTF(" mCPk_GetPermissionSavePakMail : \n");
#endif	/** DEBUG end */

    /** ¼ν */
    if( mLd_PlayerManKindCheck( ) == NATIVE_e ){
	/** ѤΥե륹ơ򥻥å */
	mCPk_SetForestPakState( pak_info_p, mCPk_DATA_LETTER_e );
	
	pakState = &(pak_info_p->pakState);
	buf_p = (unchar *)zelda_malloc((unint)(pakState->file_size));
	
#if	DEBUG
	if( buf_p != NULL ){
	    PRINTF(ESC_CYAN" %#010x\n"ESC_NORMAL,
		   pakState->file_size);
	} else {
	    PRINTF(ESC_CYAN" %#010xݼ\n"ESC_NORMAL,
		   pakState->file_size);
	    assert(0);
	}
#endif	/** DEBUG end */

	/** ǡΥɤȥå */
	if( buf_p != NULL ){
	    mCPk_CheckCheckSumMail( buf_p, (int)pakState->file_size,
				    pak_info_p );
	}
	/** ѥåμǡ֥å */
	if( mCPk_CheckData_common( &data_status,
				   mCPk_DATA_LETTER_e,
				   pak_info_p,
				   buf_p ) == TRUE ){
	    /** ǡ֤饻ֵĤѴ */
	    ret_perm = mCPk_PakDataStatus2Permission( data_status );
	}
	if( buf_p != NULL ){
#if	DEBUG
	    PRINTF("ΰβ size : %#010x\n",pakState->file_size);
#endif	/** DEBUG end */
	    zelda_free( buf_p );
	}
    } else {	/**  */
	/** ȥѥåǳϤå */
	if( mImm_CheckStartDataCategory( ) == TRUE ){
	    /** ץ졼䡼ǡѤΥե륹ơ򥻥å */
	    mCPk_SetForestPakState( pak_info_p, mCPk_DATA_PRIVATE_e );
	    if( mCPk_CheckPakCopyProtect( pak_info_p ) == TRUE ){
		if( mCPk_CheckData( &data_status,
				    mCPk_DATA_PRIVATE_e,
				    pak_info_p ) == TRUE ){
		    ret_perm = mCPk_PakDataStatus2Permission( data_status );
		}
	    } else {	/** ϻȥǡۤʤ */
		ret_perm = mCPk_SAVE_PRM_DATA_DIFF_e;
	    }
	}
#if	DEBUG
	else {
	    assert(0);
	}
#endif	/** DEBUG end */
    }
    return ret_perm;
}

/* ѥåץĤ */
extern int mCPk_GetPermissionSavePakMailAndOpen( void ){

    mCPk_pkinfo_c	*pak_info_p = mCPk_get_pkinfo( );
    int			ret_perm = mCPk_SAVE_PRM_NO_PAK_e;

    if( mCPk_PakOpen( pak_info_p, 0 ) == TRUE ){
	ret_perm = mCPk_GetPermissionSavePakMail( pak_info_p );
    }
    return ret_perm;
}

/*
 ****************************************************************
 *	ǡΥ
 *
 *	ｪλ	TRUE	
 *			FALSE
 *	۾ｪλ	-1
 ****************************************************************
 */
typedef int	(* mCPk_ML_SAVE)( mCPk_mail_c *, mCPk_pkinfo_c *, unchar * );

enum	mcpk_mail_save_mode {
    mCPk_MSV_INIT_e,
    mCPk_MSV_MAIN_e,
    
    mCPk_MSV_END_e
};

static int mCPk_SavePakMail_init(
    mCPk_mail_c		*mail_p,	/** ֤ǡ */
    mCPk_pkinfo_c	*pak_info_p,
    unchar		*mode
    ){

    unshort	check_sum;
    int		rec;

#if	defined(U_gen_U)
    PRINTF("楻 \n");
#endif	/** defined(U_gen_U) */
#if	DEBUG
    assert(mail_p);
#endif	/** DEBUG end */
    /** ǡѤΥե륹ơ򥻥å */
    mCPk_SetForestPakState( pak_info_p, mCPk_DATA_LETTER_e );

    /** å */
    check_sum = mFRm_GetFlatCheckSum((unshort *)mail_p,
				     (int)mCPk_MAIL_FILE_SIZE,
				     mail_p->check_sum );
#if	defined(U_gen_U)
    PRINTF(ESC_RED"ret check sum : %#010x %#010x\n"ESC_NORMAL,
	   mFRm_ReturnCheckSum((unshort *)mail_p,
				(int)mCPk_MAIL_FILE_SIZE ),check_sum );
#endif	/** defined(U_gen_U) end */
    mail_p->check_sum = check_sum;
#if	defined(U_gen_U)
    PRINTF(ESC_RED"ret check sum : %#010x %#010x\n"ESC_NORMAL,
	   mFRm_ReturnCheckSum((unshort *)mail_p,
			       (int)mCPk_MAIL_FILE_SIZE ),
	   mail_p->check_sum );
#endif	/** defined(U_gen_U) end */
    
#if	DEBUG
    {
	unshort		flat_check_sum;
	
	flat_check_sum =
	    mFRm_ReturnCheckSum((unshort *)mail_p,
				(int)mCPk_MAIL_FILE_SIZE );
	PRINTF(ESC_YELLOW
	       "ȥѥåΥå %#010x\n"ESC_NORMAL,
	       flat_check_sum);
	if( flat_check_sum != 0 ){
	    assert(0);
	}
    }
#endif	/** DEBUG end */
    
    rec = mCPk_Save( pak_info_p, (unchar *)mail_p );
    if( rec == 1 ){
	/** ͤǤХѥåΥǡ⥻ */
	if( mLd_PlayerManKindCheck( ) != NATIVE_e ){
#if	defined(U_gen_U)
	    PRINTF("ͤμ楻\n");
#endif	/** defined(U_gen_U) end */
	    rec = mCPk_SavePak( ZCommonGet(now_private),
				mNpc_GetInAnimalP( ),
				pak_info_p );
	    if( rec == 1 ){
		(*mode) = mCPk_MSV_MAIN_e;
		return FALSE;
	    } else {
		return -1;
	    }
	} else {
	    /** ιΥץ졼䡼 */
	    (*mode) = mCPk_MSV_MAIN_e;
	    return FALSE;
	}
    } else {
	(*mode) = mCPk_MSV_INIT_e;
	return -1;
    }
}

/*
 ****************************************************************
 *	ǡΥܽ
 *
 *	ｪλ	TRUE	
 *			FALSE
 *	۾ｪλ	-1
 ****************************************************************
 */
static int mCPk_SavePakMail_main(
    mCPk_mail_c		*mail_p,	/** ֤ǡ */
    mCPk_pkinfo_c	*pak_info_p,
    unchar		*mode
    ){

    int		rec;

    rec = mFRm_FlashSaveAllData_bg( );
    if( rec != FALSE ){
	(*mode) = mCPk_MSV_INIT_e;
    }
    (void)mail_p;
    (void)pak_info_p;

    return rec;
}

/*
 ****************************************************************
 *	ǡΥ
 *
 *	ｪλ	TRUE	
 *			FALSE
 *	۾ｪλ	-1
 ****************************************************************
 */
extern int mCPk_SavePakMail2(
    mCPk_mail_c		*mail_p,	/** ֤ǡ */
    mCPk_pkinfo_c	*pak_info_p
    ){

    static mCPk_ML_SAVE	save_proc[mCPk_MSV_END_e] = {
	mCPk_SavePakMail_init,
	mCPk_SavePakMail_main,
    };
    static unchar	mode = mCPk_MSV_INIT_e;
    int			ret;

    if( mode >= mCPk_MSV_END_e ){
	mode = mCPk_MSV_INIT_e;
    }
    ret = (save_proc[mode])( mail_p, pak_info_p, &mode );

#if	defined(U_gen_U)
    PRINTF("楻 ret = %d\n",ret);
#endif	/** defined(U_gen_U) end */

    return ret;
}

/*
 ****************************************************************
 *	ǡΥ
 *
 *	ｪλ		1
 *	ΡȤΥץ	0
 *	ɼ		-1
 ****************************************************************
 */
extern int mCPk_LoadPakMail2(
    mCPk_mail_c		*mail_p,	/** ֤ǡ */
    mCPk_pkinfo_c	*pak_info_p
    ){

    /** ǡѤΥե륹ơ򥻥å */
    mCPk_SetForestPakState( pak_info_p, mCPk_DATA_LETTER_e );
    return mCPk_Load( pak_info_p, (unchar *)mail_p );
}

/*
 ****************************************************************
 *	ȥѥåΥǡõ
 *
 *	ｪλ	TRUE
 *	۾ｪλ	FALSE
 ****************************************************************
 */
extern int mCPk_EraseForestData( void ){

    mCPk_pkinfo_c	*pak_info_p = mCPk_get_pkinfo( );
    mCPk_passport_c	*passport_p = &(l_pak_ctrl.rwfile.passport);
    unshort		check_sum;
    int			ret;

    mCPk_ClearPassport( passport_p );

    /** ե륹ơץ졼䡼ǡѤ˥å */
    mCPk_SetForestPakState( pak_info_p, mCPk_DATA_PRIVATE_e );
    /** å */
    check_sum = mFRm_GetFlatCheckSum((unshort *)(&(l_pak_ctrl.rwfile.file[0])),
				     (int)mCPk_PASSPORT_SIZE,
				     l_pak_ctrl.rwfile.passport.check_sum );
    /** åॻå */
    l_pak_ctrl.rwfile.passport.check_sum = check_sum;

#if	DEBUG
    {
	unshort		flat_check_sum;
	
	flat_check_sum =
	    mFRm_ReturnCheckSum((unshort *)(&(l_pak_ctrl.rwfile.file[0])),
				(int)mCPk_PASSPORT_SIZE );
	PRINTF(ESC_YELLOW
	       "ȥѥåΥå %#010x\n"ESC_NORMAL,
	       flat_check_sum);
	if( flat_check_sum != 0 ){
	    assert(0);
	}
    }
#endif	/** DEBUG end */
    
    /** ѥå˥ꥢ򥻡 */
    ret = mCPk_Save( pak_info_p, &(l_pak_ctrl.rwfile.file[0]));
    
    return ret;
}

/*
 ****************************************************************
 *	ץ졼䡼ǡΤΥå
 *
 *			TRUE
 *			FALSE
 *	ѥå顼	-1	(Ρȥץ󥨥顼)
 *			-2	(ǡɥ顼)
 *
 *	
 *	δؿ˥ѥåץδؿǤ
 ****************************************************************
 */
extern int mCPk_CheckCheckSumPlayer( void ){

    mCPk_pkinfo_c	*pak_info_p = mCPk_get_pkinfo( );
    unshort		check_sum = 0;
    int			rec = 1;
    int			ret = FALSE;

#if	defined(U_gen_U)
    PRINTF(ESC_RED
	   "mCPk_CheckCheckSumPlayer --------------------------------\n"
	   ESC_NORMAL);
#endif	/** defined(U_gen_U) end */

    /** ץ졼䡼ǡѤΥե륹ơ򥻥å */
    mCPk_SetForestPakState( pak_info_p, mCPk_DATA_PRIVATE_e );
    /** ȥѥåǡɤ߹ */
    rec = mCPk_Load( pak_info_p, &(l_pak_ctrl.rwfile.file[0]));
    if( rec == 1 ){
	l_pak_ctrl.status = ON;
	/** å */
	check_sum =
	    mFRm_ReturnCheckSum((unshort *)(&(l_pak_ctrl.rwfile.file[0])),
				(int)mCPk_PASSPORT_SIZE );
#if	defined(U_gen_U)
	PRINTF(ESC_CYAN"å : %#010x\n"ESC_NORMAL,check_sum);
#endif	/** defined(U_gen_U) end */
    } else {
#if 0
	/** ɤ߹ߥեΥꥢ */
	mCPk_ClearPassport( &(l_pak_ctrl.rwfile.passport));
#endif	/** #if 0 end */
	if( rec == -1 ){
	    ret = -2;
	} else {
	    ret = -1;
	}
    }
    /** å OK */
    if(( rec == 1 ) && ( check_sum == 0 )){
	ret = TRUE;
#if	defined(U_gen_U)
	PRINTF(ESC_RED"å OK\n"ESC_NORMAL);
#endif	/** defined(U_gen_U) end */
    } else {
#if	DEBUG
	PRINTF("ѥåΥåपǤ\n");
#endif	/** defined(U_gen_U) end */
	l_pak_ctrl.status = OFF;
	/** åबΤɤ߹ߥեΥꥢ */
	mCPk_ClearPassport( &(l_pak_ctrl.rwfile.passport));
    }
    return ret;
}

/*
 ****************************************************************
 *	೫ϻΥåˤΡȤξõ
 *
 *	
 *	δؿ˥ѥåץδؿǤ
 ****************************************************************
 */
extern void mCPk_CheckCheckSumPlayerErase( void ){

    mCPk_pkinfo_c	*pak_info_p = mCPk_get_pkinfo( );
    int			rec;
#if	DEBUG
    int			err;
#endif	/** DEBUG end */

#if	defined(U_gen_U)
    PRINTF(ESC_RED
	   "mCPk_CheckCheckSumPlayerErase --------------------------------\n"
	   ESC_NORMAL);
#endif	/** defined(U_gen_U) end */

    rec = mCPk_CheckCheckSumPlayer( );
    
    /** å༺ԤƤΡȤκ */
//    if(( rec == FALSE ) || (( rec == -1 ) && ( err == PFS_ERR_BAD_DATA ))){
    if(( rec == FALSE ) || ( rec == -2 )){
	OSMesgQueue	*Q;

#if	defined(U_gen_U)
	PRINTF(ESC_RED"å : %#010xʤΤǥΡȺ\n"ESC_NORMAL);
#endif	/** defined(U_gen_U) end */
	/** ץ졼䡼ǡѤΥե륹ơ򥻥å */
	mCPk_SetForestPakState( pak_info_p, mCPk_DATA_PRIVATE_e );
	
	Q = padmgr_LockSerialMesgQ();
#if	DEBUG
	err =
#endif	/** DEBUG end */
	    sCPk_DeleteFile(&(pak_info_p->pakFile), &(pak_info_p->pakState));
	padmgr_UnlockSerialMesgQ(Q);
#if	DEBUG
	if( err != 1 ){
	    PRINTF("ΡȺ\n");
	}
#endif	/** DEBUG end */
    }
}


/*
 *	ȥѥå¤μ
 */
extern mCPk_pkinfo_c *mCPk_get_pkinfo(void)
{
    return g_paks_info_p;
}

/*
 ****************************************************************
 *	ߥץΥѥå ID狼å
 *
 *	ID 		TRUE
 *	ID ۾		FALSE
 *
 *	δؿ򥳡뤹ɬѥå򥪡ץ󤷤Ƥ
 *	δؿ ID ۾路ߤޤ
 ****************************************************************
 */
extern int mCPk_CheckPakID( void ){

    mCPk_pkinfo_c	*pak_p = mCPk_get_pkinfo( );
    int			ret = TRUE;

    if( pak_p != NULL ){
	if( pak_p->pakFile.error == PFS_ERR_ID_FATAL ){
	    ret = FALSE;
	}
    }
    return ret;
}


/*
 ------------------------------------------------------------------------------
 *			ȥѥåХå
 ------------------------------------------------------------------------------
 */
