/*
 ******************************************************************************
 *  	File 		: m_cpak.h
 *	Programer	: Gentaro Takaki
 *  
 *	$Id: m_cpak.h,v 1.43 2001-02-04 01:20:06+09 gen Exp $
 ******************************************************************************
 */



#ifndef	M_CPAK_H_INCLUDED
#define	M_CPAK_H_INCLUDED

#if	defined(LANGUAGE_C) || defined(_LANGUAGE_C_PLUS_PLUS)

#ifdef	_LANGUAGE_C_PLUS_PLUS
extern "C" {
#endif

#include "m_cpak_h.h"
#include "m_view.h"

#include "m_common_data.h"

/*
 *	ѥå֥ǡ
 */
enum	pak_save_data_kind {
    mCPk_DATA_PRIVATE_e,	/** ץ졼䡼ǡ */
    mCPk_DATA_LETTER_e,		/** ǡ */
    mCPk_DATA_END_e
};

/*
 *	ȥѥåΥǡ
 */
enum	cpak_data_status {
    mCPk_DATA_EX_e,		/** ưʪοΥǡ¸ߤ */
    mCPk_DATA_NO_e,		/** ưʪοΥǡ¸ߤʤ() */
    mCPk_DATA_EX_NO_PLAYER_e,	/** ưʪοΥǡ¸ߤ뤬Ǥ */
    mCPk_DATA_LACK_AREA_e,	/** ֥ꥢ­ */
    mCPk_DATA_NOTE_FULL_e,	/** ѥå˥ǡʤΡȤζʤ */
    mCPk_DATA_ERR_e,		/** 顼 */

    mCPk_DATA_STATUS_END_e
};

/*
 *	ȥ顼ѥåֵ
 */
enum	cpak_save_permission {
    mCPk_SAVE_PRM_NO_PAK_e,	/** ȥѥåʤ */
    mCPk_SAVE_PRM_DATA_DIFF_e,	/** ϻȥǡۤʤ */
    mCPk_SAVE_PRM_NO_AREA_e,	/** ѥå˥ǡʤʤ */
    mCPk_SAVE_PRM_NO_OK_e,	/** ֵ ( ѥå˥ǡʤ ) */
    mCPk_SAVE_PRM_EX_OK_e,	/** ֵ ( ѥå˥ǡ ) */
    mCPk_SAVE_PRM_ERR_e,	/** ȥѥå顼 */
    mCPk_SAVE_PRM_NOTE_FULL_e,	/** ѥå˥ǡʤΡȤζʤ */

    mCPk_SAVE_PERMISSION_END_e
};

/** ե */
#define	mCPk_PACK_FOLDER_MAX		(8)
/** ե٥ʸκʸ */
#define	mCPk_PACK_LABEL_STR_MAX		(10)
/** եμ */
#define	mCPk_PACK_FOLDER_MAIL_CAPA	(20)


/*
 *	ǡ֡ѹ¤
 */
typedef struct	pak_save_load_mail_class {
    unshort	check_sum;		/** å */
    unchar	label[mCPk_PACK_FOLDER_MAX][mCPk_PACK_LABEL_STR_MAX];
    Mail_c	mail[mCPk_PACK_FOLDER_MAX][mCPk_PACK_FOLDER_MAIL_CAPA];
} mCPk_mail_c;

/*
 ****************************************************************
 *	ȥѥåΥ顼åϴؿ
 *
 *	in	: ѥåե빽¤ (sCPK_pkf_c *)
 *		  ȥֹ (int)
 *
 *	out	: ʤ
 *
 *	֤	: ｪλ 1
 *		  ۾ｪλ 0
 ****************************************************************
 */
#define	mCPk_ErrMsg( pakf, idx )	mCPk_PrintErrMsg( pakf, idx )

extern void mCPk_PrintErrMsg(
    sCPk_pkf_c *pakf_p,	/** ѥåե빽¤ */
    int idx		/** ȥֹ */
    );

/*
 ****************************************************************
 *	ȥѥåΥץؿ
 *
 *  	in	: ȥֹ (int)
 *
 *	out	: ѥåɥޥ͡㡼¤ (padmgr_t *)
 *
 *	֤	: ｪλ 1
 *		  ۾ｪλ 0
 ****************************************************************
 */
/** ƥ */
extern int mCPk_PakOpen(
    mCPk_pkinfo_c	*paks_p,
    int			idx	/** ȥֹ */
    );
/** ѥåץ */
#define	mCPk_Open(idx)		mCPk_PakOpen( mCPk_get_pkinfo( ), (idx))

/*
 ****************************************************************
 *	ȥѥåΥΡȤκȻѿ򻻽Фؿ
 *
 *	in	: ѥåɥޥ͡㡼¤ (padmgr_t *)
 *		  ȥֹ (int)
 *
 *	out	: ʤ
 *
 *	֤	: ｪλ 1
 *		  ۾ｪλ 0
 ****************************************************************
 */
/** ƥ */
extern int mCPk_NoteNum(
    mCPk_pkinfo_c	*pak_p
    );

/*
 ****************************************************************
 *	ȥѥåΥΡȤΥơؿ
 *
 *	in	: ѥåɥޥ͡㡼¤ (padmgr_t *)
 *		  ȥֹ (int)
 *
 *	out	: ʤ
 *
 *	֤	: ｪλ 1
 *		  ۾ｪλ 0
 ****************************************************************
 */
/** ƥ */
extern int mCPk_AllFileState(
    mCPk_pkinfo_c	*pak_p
    );

/*
 ****************************************************************
 *	ȥѥåΥΡȤζ֥åؿ
 *
 *	in	: ѥåɥޥ͡㡼¤ (padmgr_t *)
 *		  ȥֹ (int)
 *
 *	out	: ʤ
 *
 *	֤	: ｪλ 1
 *		  ۾ｪλ 0
 ****************************************************************
 */
/** ƥ */
extern int mCPk_FreeBlockNum(
    mCPk_pkinfo_c	*pak_p
    );

/*
 ****************************************************************
 *	ȥѥåν
 *
 *	in	: ȥֹ (int)
 *
 *	out	:
 *	   
 *	֤	: 1 ｪλ / 0 ۾ｪλ
 ****************************************************************
 */
extern int mCPk_InitPak(
    int			idx		/** ȥֹ */
    );

/*
 ****************************************************************
 *	ѥåΰ˥ץ졼䡼ǡå
 ****************************************************************
 */
extern void mCPk_SetPrivateSavefile(
    Private_c	*private_p
    );

/*
 ****************************************************************
 *	ѥåΰΥץ졼䡼ǡݥ󥿼
 ****************************************************************
 */
extern Private_c *mCPk_GetSaveFilePrivateP( void );

/*
 ****************************************************************
 *	Фǡѥå˥
 *
 *	ｪλ	TRUE
 *	۾ｪλ	FALSE
 ****************************************************************
 */
extern int mCPk_SavePak(
    Private_c		*private_p,
    Animal_c		*animal_p,
    mCPk_pkinfo_c	*pak_info_p
    );

/*
 ****************************************************************
 *	ץ쥤䡼򥳥ȥѥåɤؿ
 *
 *	in	: ץ졼䡼ǡݥ
 *
 *	out	: ʤ
 *
 *	֤	: 1 ｪλ / 0 ۾ｪλ
 ****************************************************************
 */
extern int mCPk_PakPrivateLoad(
    Private_c		*private_p,
    Animal_c		*animal_p,
    mCPk_pkinfo_c	*pak_info_p
    );

/*
 ****************************************************************
 *	ȥѥåΥץ졼䡼Υץ졼䡼ʥС
 *
 *	֤
 *
 *		ץ졼䡼ʥС
 *		ιο	0  (COMPATRIOT_PLAYER_NUM - 1)
 *		㤦ο	mPr_FOREIGNER_PLAYER_NO
 *
 *		-1
 ****************************************************************
 */
extern int mCPk_GetPakPlayerNo( void );

/*
 ****************************************************************
 *	ȥѥåΥץ졼䡼̾
 ****************************************************************
 */
extern unchar *mCPk_GetPakPlayerName( void );

/*
 ****************************************************************
 *	ԡк
 *
 *	å	TRUE
 *	åȼ	FALSE
 ****************************************************************
 */
extern int mCPk_SetPakCopyProtect(
    mCPk_pkinfo_c	*pak_info_p
    );

/*
 ****************************************************************
 *	ԡкɥå
 *
 *	OK	TRUE
 *	NG	FALSE
 ****************************************************************
 */
extern int mCPk_CheckPakCopyProtect(
    mCPk_pkinfo_c	*pak_info_p
    );

/*
 ****************************************************************
 *	ѥåֵļ	ץ졼䡼ǡ
 *
 *	֤	:	ѥåֵ
 ****************************************************************
 */
extern int mCPk_GetPermissionSavePakPlayer( void );

/*
 ****************************************************************
 *	ѥåֵ	ǡ
 *
 *	֤	: ֵ ( cpak_save_permission )
 *---------------------------------------------------------------
 *	  
 *
 *	δؿǤϥѥåΥץϹԤäƤޤ
 *	ɬȥѥåΰϢνκǽ
 *	ѥåΥץؿ򥳡뤷Ƥ
 ****************************************************************
 */
extern int mCPk_GetPermissionSavePakMail(
    mCPk_pkinfo_c	*pak_info_p
    );
/* ѥåץĤ */
extern int mCPk_GetPermissionSavePakMailAndOpen( void );
/*
 ****************************************************************
 *	ǡΥ
 *
 *	ｪλ	TRUE	
 *			FALSE
 *	۾ｪλ	-1
 ****************************************************************
 */
extern int mCPk_SavePakMail2(
    mCPk_mail_c		*mail_p,	/** ֤ǡ */
    mCPk_pkinfo_c	*pak_info_p
    );
#define	mCPk_SavePakMail( m )	mCPk_SavePakMail2( m, mCPk_get_pkinfo( ))

/*
 ****************************************************************
 *	ǡΥ
 *
 *	ｪλ		1
 *	ΡȤΥץ	0
 *	ɼ		-1
 ****************************************************************
 */
extern int mCPk_LoadPakMail2(
    mCPk_mail_c		*mail_p,	/** ֤ǡ */
    mCPk_pkinfo_c	*pak_info_p
    );

#define	mCPk_LoadPakMail( m )	mCPk_LoadPakMail2( m, mCPk_get_pkinfo( ))

/*
 ****************************************************************
 *	ȥѥåΥǡõ
 *
 *	ｪλ	TRUE
 *	۾ｪλ	FALSE
 ****************************************************************
 */
extern int mCPk_EraseForestData( void );

/*
 ****************************************************************
 *	ץ졼䡼ǡΤΥå
 *
 *			TRUE
 *			FALSE
 *	ѥå顼	-1
 *
 *	
 *	δؿ˥ѥåץδؿǤ
 ****************************************************************
 */
extern int mCPk_CheckCheckSumPlayer( void );

/*
 ****************************************************************
 *	೫ϻΥåˤΡȤξõ
 *
 *	
 *	δؿ˥ѥåץδؿǤ
 ****************************************************************
 */
extern void mCPk_CheckCheckSumPlayerErase( void );


/*
 ****************************************************************
 *	ߥץΥѥå ID狼å
 *
 *	ID 		TRUE
 *	ID ۾		FALSE
 *
 *	δؿ򥳡뤹ɬѥå򥪡ץ󤷤Ƥ
 *	δؿ ID ۾路ߤޤ
 ****************************************************************
 */
extern int mCPk_CheckPakID( void );

/*
 *	ȥѥå¤μ
 */
extern mCPk_pkinfo_c *mCPk_get_pkinfo(void);

#ifdef	_LANGUAGE_C_PLUS_PLUS
}
#endif

#endif
#endif	/* M_CPAK_H_INCLUDED */
