/*
 ******************************************************************************
 *  	File 		: s_cpak.h
 *	Programer	: Gentaro Takaki
 *  
 *	$Id: s_cpak.h,v 3.1 2001-03-13 18:19:23+09 forest Exp $
 ******************************************************************************
 */
#ifndef S_CPAK_H_INCLUDED
#define S_CPAK_H_INCLUDED

#if	defined(LANGUAGE_C) || defined(_LANGUAGE_C_PLUS_PLUS)

#ifdef	_LANGUAGE_C_PLUS_PLUS
extern "C" {
#endif

#include "ultra64.h"
#include "os.h"

/*
 ***************************************
 *	ȥѥåե빽¤
 ***************************************
 */
typedef struct contpak_file_s	sCPk_pkf_c;
struct contpak_file_s {
    OSPfs	pfs;    	/** եϥɥ */
    s32		file_no;	/** Ρֹ */
    s32		error;		/** 顼åֹ */
};



/*
 ****************************************************************
 *	ҥɤȥॳؿ
 *
 *	in	: ҥ (u8 *)
 *		  ॳ (u8 *)
 *
 *	out	: ե륹ơ¤ (OSPfsState *)
 *
 *	֤	: ʤ
 ****************************************************************
 */
extern void sCPk_SetCode(
    OSPfsState *pakstate,	/** ե륹ơ¤ */
    const u8 *co_code,		/** ҥ */
    const u8 *game_code		/** ๽¤ */
    );


/*
 ****************************************************************
 *	ꤷȥ˥ѥåäƤ뤫å
 *	ȥѥåΥեϥɥνԤ
 *
 *	in	: ȥֹ (int)
 *		  
 *	out	: ȥѥåե빽¤ (sCPk_pkf_c *)
 *
 *	֤	: ｪλ 1
 *		  ۾ｪλ 0
 ****************************************************************
 */
extern int sCPk_PakOpen(
    sCPk_pkf_c *pakf,			/** ȥѥåե빽¤ */
    int pakno				/** ȥֹ */
    );

/*
 ****************************************************************
 *	ȥѥåζΰåؿ
 *
 *	in	: ȥѥåե빽¤ (sCPk_pkf_c *)
 *
 *	out	: ʤ
 *
 *	֤	: ΰХȿ (s32)
 *---------------------------------------------------------------
 *   ()
 *	Ѥեϥɥ ( OSPfs¤ ),
 *	sCPk_PakOpenˤä, Ƥɬפޤ.
 ****************************************************************
 */
extern s32 sCPk_PakFreeArea(
    sCPk_pkf_c *pakf	/** ȥѥåե빽¤ */
    );

/*
 ******************************************************************************
 *	ȥѥå񤭹ߴؿ
 *
 *	in	: ȥѥåե빽¤ (sCPk_pkf_c *)
 *		  ѥåΥǡΰν񤭹߰ (int)
 *		  񤭹ߥ  Х (int)
 *		  񤭹ߥХåե (u8 *)
 *		  
 *	out	: 顼å (ѥåե빽¤)
 *
 *	֤	: 1 ｪλ / 0 ۾ｪλ
 * ---------------------------------------------------------------------------
 * () ... ꤷ 32ܿǤʤˤϥ饤Ȥޤ.
 *   		ꤹ륵ϥΡȤΥե륵⾮ʤƤϤ
 *		ޤ. ޤ, ѥå̰ʾλػߤǤ.
 *		Ѥեϥɥ ( OSPfs¤ ), sCPk_PakOpen
 *		ä, Ƥɬפޤ.
 ******************************************************************************
 */
extern int sCPk_Save(
    sCPk_pkf_c *pakf,	/** ȥѥåե빽¤ */
    int offset_byt,	/** 񤭹߰ */
    int size,		/** 񤭹ߥ */
    u8 *data		/** 񤭹ߥХåե */
    );

/*
 ******************************************************************************
 *	ȥѥåɤ߹ߴؿ
 *
 *	in	: ȥѥåե빽¤ (sCPk_pkf_c *)
 *		  ѥåΥǡΰɤ߹߰ (int)
 *		  ɤ߹ߥ  Х (int)
 *		  ɤ߹ߥХåե (u8 *)
 *		  
 *	out	: 顼å (ѥåե빽¤)
 *
 *	֤	: 1 ｪλ / 0 ۾ｪλ
 * ---------------------------------------------------------------------------
 * () ... ꤷ 32ܿǤʤˤϥ饤Ȥޤ.
 *   		ꤹ륵ϥΡȤΥե륵⾮ʤƤϤ
 *		ޤ. ޤ, ѥå̰ʾλػߤǤ.
 *		Ѥեϥɥ ( OSPfs¤ ), sCPk_PakOpen
 *		ä, Ƥɬפޤ.
 ******************************************************************************
 */
extern int sCPk_Load(
    sCPk_pkf_c *pakf,	/** ȥѥåե빽¤ */
    int offset_byt,	/** ɤ߹߳ϰ */
    int size,		/** ɤ߹ߥ */
    u8 *data		/** ɤ߹ߥХåե */
    );


/*
 ******************************************************************************
 *	ΡȤκؿ
 *
 *	in	: ȥѥåե빽¤ (sCPk_pkf_c *)
 *		  ե륹ơ¤ (OSPfsState *)
 *		  Ρȥ (int)
 *		  
 *	out	: 顼å (ѥåե빽¤)
 *
 *	֤	: 1 ｪλ / 0 ۾ｪλ
 * ---------------------------------------------------------------------------
 * () ...	Ѥեϥɥ ( OSPfs¤ ), sCPk_PakOpen
 *		ä, Ƥɬפޤ.
 *		ե륹ơ¤ (OSPfsState), äƳͤ
 *		åȤƤɬפޤ.
 *		ꤹΡȥ, 256ܿǤʤƤϤޤ.
 *		 256ܿǤʤϥ饤Ȥޤ. ޤ, ѥå
 *		˻ꤷ礭ΰ褬ʤ, ۾ｪλ
 *		ޤ. Ǥ˥ѥå 16ΥΡȤ¸ߤ
 *		ޤ.
 ******************************************************************************
 */
extern int sCPk_MakeFile(
    sCPk_pkf_c *pakf,		/** ȥѥåե빽¤ */
    OSPfsState *pak_state,	/** ե륹ơ¤ */
    int size			/** ΡȤΥ */
    );

/*
 ******************************************************************************
 *	ΡȤΥץؿ
 *
 *	in	: ȥѥåե빽¤ (sCPk_pkf_c *)
 *		  ե륹ơ¤ (OSPfsState *)
 *		  
 *	out	: 顼å (ѥåե빽¤)
 *
 *	֤	: 1 ｪλ / 0 ۾ｪλ
 * ---------------------------------------------------------------------------
 * () ...	Ѥեϥɥ ( OSPfs¤ ), sCPk_PakOpen
 *		ä, Ƥɬפޤ.
 *		ե륹ơ¤ (OSPfsState), äƳͤ
 *		åȤƤɬפޤ.
 ******************************************************************************
 */
extern int sCPk_FileOpen(
    sCPk_pkf_c *pakf,		/** ȥѥåե빽¤ */
    OSPfsState *pak_state	/** ե륹ơ¤ */
    );

/*
 ******************************************************************************
 *	ΡȤξõؿ
 *
 *	in	: ȥѥåե빽¤ (sCPk_pkf_c *)
 *		  ե륹ơ¤ (OSPfsState *)
 *		  
 *	out	: 顼å (ѥåե빽¤)
 *
 *	֤	: 1 ｪλ / 0 ۾ｪλ
 * ---------------------------------------------------------------------------
 * () ...	Ѥեϥɥ ( OSPfs¤ ), sCPk_PakOpen
 *		ä, Ƥɬפޤ.
 *		ե륹ơ¤ (OSPfsState), äƳͤ
 *		åȤƤɬפޤ.
 ******************************************************************************
 */
extern int sCPk_DeleteFile(
    sCPk_pkf_c *pakf,		/** ȥѥåե빽¤ */
    OSPfsState *pak_state	/** ե륹ơ¤ */
    );
    
/*
 ******************************************************************************
 *	ΡȤξõؿ
 *
 *	in	: ȥѥåե빽¤ (sCPk_pkf_c *)
 *
 *	out	: 顼å (ѥåե빽¤)
 *		  ե륹ơ¤ (OSPfsState *)
 *
 *	֤	: ե륵 (u32) / 0 ۾ｪλ
 *  ---------------------------------------------------------------------------
 * () ...	Ѥեϥɥ ( OSPfs¤ ), sCPk_PakOpen
 *		ä, Ƥɬפޤ.
 *		OSPfs¤ file_noǻꤷΡȤ
 *		ե륹ơ¤Τޤ.
 ******************************************************************************
 */
extern u32 sCPk_FileState(
    sCPk_pkf_c *pakf,		/** ȥѥåե빽¤ */
    OSPfsState *pak_state	/** ե륹ơ¤ */
    );

/*
 ******************************************************************************
 *	ѥåκΡȿȻѥΡȿμؿ
 *
 *	in	: ȥѥåե빽¤ (sCPk_pkf_c *)
 *	  
 *	out	: Ρȿ (s32)
 *		  ѥΡȿ (s32)
 *
 *	֤	: 1 ｪλ / 0 ۾ｪλ
 * ---------------------------------------------------------------------------
 * () ...	Ѥեϥɥ ( OSPfs¤ ), sCPk_PakOpen
 *		ä, Ƥɬפޤ.
 ******************************************************************************
 */
extern int sCPk_FileNum(
    sCPk_pkf_c *pakf,	/** ȥѥåե빽¤ */
    s32 *max_files,	/** Ρȿ */
    s32 *files_used	/** ѥΡȿ */
    );

/*
 ******************************************************************************
 *	ȥѥåΥե륷ƥνؿ
 *
 *	in	: ȥѥåե빽¤ (sCPk_pkf_c *)
 *	  
 *	out	: 顼å (sCPk_pkf_c)
 *
 *	֤	: 1 ｪλ / 0 ۾ｪλ
 * ---------------------------------------------------------------------------
 * () ...	Ѥեϥɥ ( OSPfs¤ ), sCPk_PakOpen
 *		ä, Ƥɬפޤ.
 ******************************************************************************
 */
extern int sCPk_RepairID(
    sCPk_pkf_c *pakf	/** ȥѥåե빽¤ */
    );

/*
 ****************************************************************
 *	̥åɤǽ񤭹߳
 ****************************************************************
 */
extern void sCPk_Save_bg(
    sCPk_pkf_c *const	pakf_p,
    int const		offset_byt,
    int const		size,
    u8 *const		data_p
    );

/*
 ****************************************************************
 *	񤭹߽λå
 *
 *	λ		1
 *			0
 *	ѥåʤ	-1
 ****************************************************************
 */
extern s32 sCPk_PakWrite_isFinished( void );
    
/*
 ****************************************************************
 *	̥åɸ
 ****************************************************************
 */
extern s32 sCPk_Pak_sync( void );

/*
 ******************************************
 *	FGǽ񤭹 ( ϡλ )
 ******************************************
 */
extern s32 sCPk_Save_fg(
    sCPk_pkf_c *const	pakf_p,
    int const		offset_byt,
    int const		size,
    u8 *const		data_p
    );
/*
 ****************************************************************
 *	ѥåХåɥơ
 ****************************************************************
 */
extern s32 mCPk_GetPakCommandStatus( void );


#ifdef _LANGUAGE_C_PLUS_PLUS
} /* extern "C" */
#endif

#endif
#endif
