/*
  *****************************************************************************
  
  	File :		s_flashrom.c
  	Programer :	Gentaro Takaki
  
	$Id: s_flashrom.c,v 3.1 2001-03-13 18:19:23+09 forest Exp $
	
  *****************************************************************************
*/

#include <os.h>
#include "m_basic.h"
#include "s_flashrom.h"



static OSMesgQueue	l_dmaMesgQ;	/** dmaλå塼 */
static OSMesg		l_dmaMesgBuf;
static OSIoMesg		l_dmaIOMesgBuf;	/** dmaåꥯȥ֥å */
static s32		l_flashrom_is_available = 0;	/** !0 flashromͭ */


/** եåॳޥɹ¤ν */
static void clear_cmd( void );


/*
  *****************************************************************************
   FlashRomνؿ
  *****************************************************************************
 */
extern int sFRm_FlashRomInit( void ){

    int		ret = TRUE;

    /** FlashRomΤ Piϥɥν*/
    osFlashInit( );
    clear_cmd( );
    
    osCreateMesgQueue( &l_dmaMesgQ, &l_dmaMesgBuf, 1 );

    {
	u32 flash_type;
	u32 flash_maker;
	/* ѤƤեåΥСɽ */
	osFlashReadId(&flash_type, &flash_maker);
	switch(flash_maker) {
	    case FLASH_VERSION_MX_PROTO_A: 
		PRINTF0(ESC_GREEN "եå PROTO A\n" ESC_NORMAL);
                break;
	    case FLASH_VERSION_MX_A:
		PRINTF0(ESC_GREEN "եå TYPE A\n" ESC_NORMAL);
                break;
	    case FLASH_VERSION_MX_C:
		PRINTF0(ESC_GREEN "եå TYPE C\n" ESC_NORMAL);
                break;
	    case FLASH_VERSION_MX_B_AND_D:
		PRINTF0(ESC_GREEN "եå TYPE B&D\n" ESC_NORMAL);
		break;
	    case FLASH_VERSION_MEI:
		PRINTF0(ESC_GREEN "եå TYPE Żһȡޥ˥\n" ESC_NORMAL);
		break;
	    default:
		PRINTF1(ESC_WARNING "ʥեåޤϥեåʤ(%08x)\n" ESC_NORMAL, flash_maker);
		ret = FALSE;
		break;
	}
    }
    if( ret == TRUE ){
	l_flashrom_is_available = 1;
    }
    return ret;
}

/*
  *****************************************************************************
   եåबͭɤ
  *****************************************************************************
 */
extern s32 sFRm_FlashisAvailable( void ){

    return l_flashrom_is_available;
}

/*
  *****************************************************************************
   1M FLASHROMλꤷޤ 16KХȥХΰξõؿ
  *****************************************************************************
 */
extern s32 sFRm_FlashArrayErase( u32 sector_num ){

    s32		err;

#if	defined(U_gen_U)
    PRINTF(ESC_ERROR"ERASE sector num = %d\n"ESC_NORMAL,sector_num);
#endif

    err = osFlashSectorErase( sector_num );

    return err;
    
}


/*
  *****************************************************************************
   FLASHROMΰΥǡõؿ
  *****************************************************************************
 */
extern s32 sFRm_FlashAllErase( void ){

    s32		err;

#if	defined(U_gen_U)
    PRINTF(ESC_ERROR"Flash Rom ALL ERASE\n"ESC_NORMAL);
#endif

    err = osFlashAllErase( );

    return err;
    
}

/*
  *****************************************************************************
   1M FLASHROMλꤷؤ 128ХȤΥǡν񤭹ߴؿ
  *****************************************************************************
 */
extern s32 sFRm_FlashWriteSector( u32 *buf, u32 sector_num ){

    s32		err = -1;
    s32		ret;

    osWritebackDCache( buf, 128 );
    /** RDRAM FlashRomν񤭹ߥХåեؤΥǡž */
    ret = osFlashWriteBuffer( &l_dmaIOMesgBuf, OS_MESG_PRI_NORMAL,
			      buf, &l_dmaMesgQ );
    (void)osRecvMesg( &l_dmaMesgQ, NULL, OS_MESG_BLOCK);
    if( ret == -1 ){
#if	DEBUG
	PRINTF(ESC_ERROR"ERR DMA!!\n"ESC_NORMAL);
#endif
    } else if( ret == 0 ){
	/** 񤭹ߥХåե FlashRomγƥؤΥǡž */
	err = osFlashWriteArray( sector_num );
    }
    
    return err;
    
}

/*
  *****************************************************************************
   1M FLASHROMλꤷޤ 16KХȤΰؤΥǡν񤭹ߴؿ
  *****************************************************************************
 */
extern s32 sFRm_FlashWriteArray( u32 *buf, u32 sector_num, u32 page_n ){

    s32		err;
    u32		i;
    int		rtn_count;

    /** ֹ꤬ 128ܿǤʤ 1֤ */
    if( sector_num & 0x0000007f ){
#if	defined(U_gen_U) && 1
	PRINTF(ESC_ERROR"ERR - sector num 128ܿ.\n"ESC_NORMAL);
#endif
	return	1;
    }

    osWritebackDCache( buf, (s32)( page_n * sFRm_PAGE_BYTE ));

    err = -1;
    rtn_count = 3;
    while(( err == -1 ) && ( rtn_count )){
    
	/** ꥻޤ 16KХȥХΰΥǡõ */
	err = osFlashSectorErase( sector_num );
	if( err == -1 ){
#if	defined(U_gen_U) && 1
	    PRINTF(ESC_ERROR"ERR - Erase!!\n"ESC_NORMAL);
#endif
	    return err;
	}
	/** 16KХʬγƥؤν񤭹 */
	for( i = 0; i < page_n; i++ ){
	    err = osFlashWriteBuffer( &l_dmaIOMesgBuf, OS_MESG_PRI_NORMAL,
				      &buf[i * 32], &l_dmaMesgQ );
	    osRecvMesg( &l_dmaMesgQ, NULL, OS_MESG_BLOCK );
	    /** 񤭹߼ */
	    if( err == -1 ){
#if	defined(U_gen_U)
		PRINTF(ESC_RED"sector num %d 񤭹߼\n"ESC_NORMAL,
		       sector_num + i );
		PRINTF(ESC_RED"Ϥᤫ񤭹ľ\n"ESC_NORMAL);
#endif
		break;
	    }
	    /** 񤭹ߥХåե FlashRomγƥڡؤΥǡž */
	    err = osFlashWriteArray( sector_num + i );
	    /** 񤭹߼ */
	    if( err == -1 ){
#if	defined(U_gen_U)
		PRINTF(ESC_RED"sector num %d 񤭹߼\n"ESC_NORMAL,
		       sector_num + i );
		PRINTF(ESC_RED"Ϥᤫ񤭹ľ\n"ESC_NORMAL);
#endif
		break;
	    }
	}
	rtn_count--;
    }
#if	defined(U_gen_U)
    if( err != -1 ){
	PRINTF("񤭹 sector num : %d\n",sector_num);
    } else {
	PRINTF(ESC_ERROR"񤭹߼ sector num : %d\n"ESC_NORMAL,sector_num);
    }
#endif
	
    return err;
}

/*
  *****************************************************************************
   1M FLASHROMλꤷΥǡɤ߹ߴؿ
  *****************************************************************************
 */
extern s32 sFRm_FlashReadSector( u32 *buf, u32 sector_num ){

    s32		err;

    osInvalDCache( buf, 128);
    /** ꥻΥǡɤ߹ */
    err = osFlashReadArray( &l_dmaIOMesgBuf, OS_MESG_PRI_NORMAL, sector_num,
			    buf, 1, &l_dmaMesgQ );

    (void)osRecvMesg( &l_dmaMesgQ, NULL, OS_MESG_BLOCK);
    
    return err;
    
}


/*
  *****************************************************************************
   1M FLASHROMλꤷ 16KХʬΥǡɤ߹ؿ
  *****************************************************************************
 */
extern s32 sFRm_FlashReadArray( u32 *buf, u32 sector_num, u32 page_n ){


    s32		err;

    OSIoMesg l_dmaIOMesgBuf;		/* dmaåꥯȥ֥å */

    osInvalDCache( buf, (s32)(sFRm_PAGE_BYTE * page_n));

    /* ڡΥǡɤ߹ */
    err = osFlashReadArray( &l_dmaIOMesgBuf, OS_MESG_PRI_NORMAL, sector_num,
			    buf, page_n, &l_dmaMesgQ );
    osRecvMesg(&l_dmaMesgQ, NULL, OS_MESG_BLOCK);

    return err;
}




/*
 ------------------------------------------------------------------------------
 *	եåХåɽ
 ------------------------------------------------------------------------------
 */
#include "stackcheck.h"		/* stackcheck */
#include "ThreadID.h"		/* THREAD_ID_SYS_VOICE2 */
#include "ThreadPriority.h"	/* PRIORITY_SYS_VOICE2 */

/** եåॹåѥå */
#define sFRm_FLASHROM_STACKSIZE (1024)/* 512B */

static u64      sFRm_flashromStack[sFRm_FLASHROM_STACKSIZE / sizeof(u64)];
StackCheckDecl(sFRm_flashrom);
OSThread	sFRm_flashrom_thread; /* åɹ¤ */

typedef enum flash_thread_command {
    FLASH_CMD_NOP,
    FLASH_CMD_WRITE,
    FLASH_CMD_READ,
    FLASH_CMD_MAX
} flash_cmd_e;

typedef struct {
    flash_cmd_e	cmd;
    s32		status;
    u32		*buf;
    u32		sector_num;	/** ϥֹ */
    u32		page_n;		/** ڡ */
    OSMesgQueue statusQ;
    OSMesg	statusBuf;
    void	*stackP;
} sFRm_cmd_c;

static sFRm_cmd_c	l_flash_cmd;


/*
 ****************************************************************
 *	եåॳޥɹ¤ν
 ****************************************************************
 */
static void clear_cmd( void ){
    
    l_flash_cmd.cmd = FLASH_CMD_NOP;
}

/*
 *******************************
 *	եåᥤؿ
 *******************************
 */
static void sFRm_flashrom_MainProc( sFRm_cmd_c *cmd_p ){

#if	DEBUG
    PRINTF("sFRm_flashromåɼ¹Գ\n");
#endif
    switch (cmd_p->cmd) {
    case FLASH_CMD_WRITE:
#if	defined(U_gen_U)
	PRINTF(ESC_CYAN"write sector : %d\n"ESC_NORMAL,
	       cmd_p->sector_num);
#endif
	cmd_p->status = sFRm_FlashWriteArray( cmd_p->buf,
					      cmd_p->sector_num,
					      cmd_p->page_n );
	osSendMesg( &cmd_p->statusQ, (OSMesg)cmd_p->status, OS_MESG_BLOCK );
#if	DEBUG
        PRINTF0("sFRm_flashrom WRITEλ\n");
#endif	/** DEBUG end */
	break;
    case FLASH_CMD_READ:
	cmd_p->status = sFRm_FlashReadArray( cmd_p->buf,
					     cmd_p->sector_num,
					     cmd_p->page_n );
	osSendMesg( &cmd_p->statusQ, (OSMesg)cmd_p->status, OS_MESG_BLOCK );
#if	DEBUG
        PRINTF0("sFRm_flashrom READλ\n");
#endif	/** DEBUG end */
	break;
    default:
	(void)0;
    }
}

/*
 *******************************
 *	̥åɤǽ񤭹߳
 *******************************
 */
extern void sFRm_FlashWriteArray_bg(
    u32		*const buf,
    u32		const sector_num,
    u32		const page_n
    ){
    
    sFRm_cmd_c *cmd_p = &l_flash_cmd;

    cmd_p->cmd = FLASH_CMD_WRITE;
    cmd_p->buf = buf;
    cmd_p->sector_num = sector_num;
    cmd_p->page_n = page_n;
    
    osCreateMesgQueue( &cmd_p->statusQ, &cmd_p->statusBuf, 1 );
    
    StackCheckInit(sFRm_flashrom);
    osCreateThread(
	&sFRm_flashrom_thread,
	THREAD_ID_SYS_FLASHROM,
	(void (*)(void *))sFRm_flashrom_MainProc,
	(void *)cmd_p,
	(void *)(sFRm_flashromStack + sFRm_FLASHROM_STACKSIZE / sizeof(u64)),
	PRIORITY_SYS_FLASHROM
	);
    osStartThread(&sFRm_flashrom_thread);
}

/*
 *******************************
 *	񤭹߽λɤ
 *******************************
 */
extern s32 sFRm_FlashWriteArray_isFinished( void ){
    
    sFRm_cmd_c *cmd_p = &l_flash_cmd;

    if( sFRm_FlashisAvailable( ) != 1 ){
	return -1;
    }
    
    return (s32)MQ_IS_FULL(&cmd_p->statusQ);
}

/*
 ***********************************
 *	̥åɤǽ񤭹߽λ
 ***********************************
 */
extern s32 sFRm_FlashWriteArray_sync( void ){
    
    sFRm_cmd_c *cmd_p = &l_flash_cmd;

#if	defined(U_gen_U)
    PRINTF(ESC_YELLOW"sFRm_FlashWriteArray_sync \n"ESC_NORMAL);
#endif	/** defined(U_gen_U) end */
    osRecvMesg(&cmd_p->statusQ, NULL, OS_MESG_BLOCK);

#if	defined(U_gen_U)
    PRINTF(ESC_YELLOW"osRecvMesg λ \n"ESC_NORMAL);
#endif	/** defined(U_gen_U) end */
    osDestroyThread(&sFRm_flashrom_thread);
#if	defined(U_gen_U)
    PRINTF(ESC_YELLOW"osDestroyThread λ \n"ESC_NORMAL);
#endif	/** defined(U_gen_U) end */
    StackCheckCheckStack(sFRm_flashrom);
#if	defined(U_gen_U)
    PRINTF(ESC_YELLOW"StackCheckCheckStack λ \n"ESC_NORMAL);
#endif	/** defined(U_gen_U) end */
    StackCheckCleanup(sFRm_flashrom);
#if	defined(U_gen_U)
    PRINTF(ESC_YELLOW"StackCheckCleanup λ \n"ESC_NORMAL);
#endif	/** defined(U_gen_U) end */

    return cmd_p->status;
}

/*
 ******************************************
 *	̥åɤǽ񤭹 ( ϡλ )
 ******************************************
 */
extern s32 sFRm_FlashWriteArray_fg(
    u32	*const buf,
    u32	const sector_num,
    u32	const page_n
    ){
    
    sFRm_FlashWriteArray_bg(buf, sector_num, page_n);
    return sFRm_FlashWriteArray_sync( );
}

/*
 ****************************************************************
 *	եåॹơ
 ****************************************************************
 */
extern s32 sFRm_GetFlashStatus( void ){
    
    return l_flash_cmd.status;
}
