
#ifndef __FILESYS_H__
#define __FILESYS_H__

/*
////////////////////////////////////////////////////////////////////////
// Intelligent Systems Co.,Ltd.
//
// IS-VIEWER64 for DD
// 
// Host File System
//
*/

#ifdef __cplusplus
extern "C" {
#endif

/*
////////////////////////////////////////////////////////////////////////
*/

#define FOPEN_MAX     64
#define DIROPEN_MAX   16
#define FILENAME_MAX  0x100

#ifndef u32
#define size_t u32
#endif

typedef struct {
  u32  m_hFile;
} FILE;


typedef struct {
  u32  m_hDir;
} DIR;


typedef struct {
  u8   m_name[FILENAME_MAX];   /* filename        */
  u8   m_timeBCD[8];           /* time[_YYMDHMS]  */
  u32  m_size;                 /* filesize        */
  u16  m_attrib;               /* file attribute  */
}DIRDATA;

/* for m_attrib */
#define FILE_ATRB_NORMAL 0x01   /* normal file */
#define FILE_ATRB_DIR    0x02   /* sub dir     */

/* for fseek */
#define SEEK_SET   0
#define SEEK_CUR   1
#define SEEK_END   2

/* ե륷ƥν */
void   FileInit(void);

/* ե */
FILE	*fopen(u8* pFile, u8* pMode);
size_t	fread(void* pBuf, size_t count, size_t size, FILE* pFile);
size_t	fwrite(u8* pBuf, size_t count, size_t size, FILE *pFile);
int     fseek(FILE *, u32 offset, int whence);
int	fclose(FILE *pFile);
int     ftell(FILE *pFile);
int     feof(FILE* pFile);

/* ǥ쥯ȥ */
DIR*    findfirstfile(u8* pPath, DIRDATA* pData);
int     findnext(DIR* pDir, DIRDATA* pData);
int     findclose(DIR* pDir);

/* եؿ */
int     rename(u8* pOldPath, u8* pNewPath);
int     remove(u8* pPath);
int     mkdir(u8* pPath);
int     rmdir(u8* pPath);
int     chdir(u8* pPath);
int     getcwd(u8* pPath);

#ifdef __cplusplus
}
#endif

/*
////////////////////////////////////////////////////////////////////////
*/

#endif   // __FILESYS_H__

