// FileCopyProgress.cpp : implementation file
//

#include "stdafx.h"
#include "resource.h"
#include "nc.h"
#include "FileCopyProgress.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif
extern void _CopyFileProcess(void* pParam);
/////////////////////////////////////////////////////////////////////////////
// CFileCopyProgress dialog
#define MINIBUFSIZE (512*1024)
#define MAXBUFSIZE (2*1024*1024)
#define MUSICMAXSIZE (1024*1024*12)

CFileCopyProgress::CFileCopyProgress(CWnd* pParent /*=NULL*/)
: CDialog(CFileCopyProgress::IDD, pParent)
{
	//{{AFX_DATA_INIT(CFileCopyProgress)
	// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
}
BOOL CFileCopyProgress::PreTranslateMessage(MSG* pMsg) 
{

	if(pMsg->wParam==VK_ESCAPE)//
	{
		return TRUE;
	}
	if(pMsg->wParam==VK_RETURN)//
	{
		return TRUE;
	}
	
	return CDialog::PreTranslateMessage(pMsg);
}

void CFileCopyProgress::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_BUT_CANCEL, m_butstop);
	DDX_Control(pDX, IDC_PIC, m_Picture);
	//DDX_Control(pDX, IDC_STATIC, m_Picture);
	//{{AFX_DATA_MAP(CFileCopyProgress)
	// NOTE: the ClassWizard will add DDX and DDV calls here
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CFileCopyProgress, CDialog)

//{{AFX_MSG_MAP(CFileCopyProgress)
	ON_WM_ERASEBKGND()
	ON_WM_ACTIVATE()
	ON_BN_CLICKED(IDC_BUT_CANCEL, OnButCancel)
	ON_WM_CLOSE()
	ON_WM_ACTIVATEAPP()
	ON_WM_PAINT()
	ON_WM_ASKCBFORMATNAME()
	ON_WM_CANCELMODE()
	ON_WM_LBUTTONDOWN()
	ON_WM_CAPTURECHANGED()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CFileCopyProgress message handlers

void _CopyFileProcess(void* pParam)
{
	BYTE* buf=NULL;
	int bufsize;
	WORD wparam=0;
	ISFSError err;
	DWORD dwRead= -1;
	int finishedsize=0,finishpercent=0;
	FILECOPYPARAM * pmyParam=(FILECOPYPARAM*)pParam;
	
	
	if(pmyParam->fsize<=MINIBUFSIZE)
		bufsize=pmyParam->fsize;
	else if( pmyParam->fsize<=MUSICMAXSIZE)
		bufsize=MINIBUFSIZE;
	else 
		bufsize=MAXBUFSIZE;
	
	buf=(BYTE*)malloc(bufsize);
    if(buf==NULL)
    {
		::SendMessage(pmyParam->hwndDlg,WM_CLOSE,wparam,0L);
		free(pmyParam);
		::_endthread();
    }
//	int   rst;
	if(pmyParam->ncflg==PC2NC)
	{
	//pc2nc
		while( dwRead=pmyParam->pcFd->Read(buf, bufsize),dwRead >0 ) 
		{
			err=ISFS_Write(pmyParam->ncFd,buf, dwRead);
			if( err<0 )
			{
				ATLTRACE(_T("Error:_CopyFile() write file fail! err=%d \r\n"),err);
				wparam=IDCANCEL;
				return ;
			}
		
			if(*(pmyParam->pCopyCancel)==TRUE)
			{
				wparam=IDCANCEL;
				break;
			}
		}
	}
	if (pmyParam->ncflg == NC2PC)//nc2pc
	{
		int restdata=pmyParam->fsize;
		while( ISFS_Read(pmyParam->ncFd,(u8*)buf,bufsize),restdata >0 ) 
		{

			//err=ISFS_Write(ncf,buf, dwRead);
			 pmyParam->pcFd->Write(buf,bufsize);
			
			if(restdata > bufsize)
				restdata=restdata-bufsize;
			else
			{
				bufsize=restdata;
				restdata=-1;
			}
			finishedsize=pmyParam->fsize -restdata;
			//finishpercent=100*finishedsize/pmyParam->fsize;
			//SendDlgItemMessage(pmyParam->hwndDlg,IDC_PROGRESS_COPY, PBM_SETPOS, finishpercent, 0L);
			//::wsprintf(szTitle, "Ѿ%d%%",finishpercent);
			//SetDlgItemText(pmyParam->hwndDlg,IDC_STATIC_PERCENT, szTitle);
			if(*(pmyParam->pCopyCancel)==TRUE)
			{
				wparam=IDCANCEL;
				pmyParam->pcFd->Close();
				break;
			}
		}
		//pmyParam->pcFd->Close();
	}
	
	ISFS_Close(pmyParam->ncFd);
	free(buf);
	//Ϣļƽ棬ʾƽ
	::SendMessage(pmyParam->hwndDlg,WM_CLOSE,wparam,0L);
	free(pmyParam);
	::_endthread();	
}


BOOL CFileCopyProgress::OnInitDialog() 
{
	CDialog::OnInitDialog();
	//init interface
	//m_butstop.MoveWindow(207,57,257,74);
	m_butstop.LoadBitmaps(IDB_DELDLG_NO_N,IDB_DELDLG_NO_H,IDB_DELDLG_NO_N,IDB_DELDLG_NO_H,IDB_DELDLG_NO_D);
	m_butstop.SetTextAlignment(CBitButton::AlignBelow);
	if (m_Picture.Load(MAKEINTRESOURCE(IDR_GIF_PROC),_T("GIF")))
		m_Picture.Draw();
	//
	// TODO: Add extra initialization here
	//	ATLASSERT(m_pstrFileName);   
	ATLASSERT(m_pstrType);   
	//CResString<512> sFormat(IDS_REPLACE);
	TCHAR szTitle[512];
//	int rst;
	// ::wsprintf(szTitle, "%s",m_pstrFileName);
	//SetDlgItemText(IDC_STATIC_FILENAME, szTitle);
	::MessageBeep(MB_ICONQUESTION); // Beep the user! Ala ::MessageBox() alert...
		//Բ
	RECT r;
	GetClientRect(&r);
	CRgn rgn;
	rgn.CreateRoundRectRgn( 0, 0,r.right , r.bottom, 10,10	 ); 
	SetWindowRgn(rgn,TRUE);
	//end 
	//ļ߳.
	FILECOPYPARAM *pmyParam;
	pmyParam=(FILECOPYPARAM*)malloc(sizeof(FILECOPYPARAM));
	pmyParam->ncFd=ncFd;
	pmyParam->pcFd=pPcFd;
	pmyParam->fsize=fsize;
	pmyParam->ncflg=NCFlag;
	pmyParam->hwndDlg=m_hWnd;
	//pmyParam->hwndProcess=::GetDlgItem(m_hWnd, IDC_PROGRESS_COPY);
	pmyParam->pCopyCancel=&fCopyCanceled;
	
	//rst=SendDlgItemMessage(IDC_PROGRESS_COPY,PBM_SETPOS,0,0);
	::wsprintf(szTitle, "  ");
	// SetDlgItemText(IDC_STATIC_PERCENT, szTitle);
	
	fCopyCanceled=FALSE;
    ::_beginthread(_CopyFileProcess,0,(void*)pmyParam);
	
    return 0;

//	return TRUE;  // return TRUE unless you set the focus to a control
	// EXCEPTION: OCX Property Pages should return FALSE
}
LRESULT CFileCopyProgress::OnButCancel() 
{
	fCopyCanceled=TRUE;
	
	return 0;
}


BOOL CFileCopyProgress::OnEraseBkgnd(CDC* pDC) 
{
	CDC MemDC;
	CBitmap Bitmap,*pOldBitmap;
	BITMAP bm;
	
	if (NCFlag != NC2PC)//nc2pc
	{
		Bitmap.LoadBitmap(IDB_CPDLG_BK);//need to change
	}
	else
	{
		Bitmap.LoadBitmap(IDB_DATA_READ);//need to change
	
	}
	SetWindowPos(&CWnd::wndTop   ,0,0,278,93,SWP_DRAWFRAME);
	CenterWindow();
	Bitmap.GetObject(sizeof(BITMAP),&bm);
	MemDC.CreateCompatibleDC(pDC);
	pOldBitmap=(CBitmap*)(MemDC.SelectObject(&Bitmap));
	//m_butstop.SetWindowPos(&CWnd::wndTop ,152,58,50,18,SWP_DRAWFRAME);
	CRect rcClient;
	GetClientRect(rcClient);

	pDC->BitBlt(0,0,rcClient.Width(),rcClient.Height(),&MemDC,0,0,SRCCOPY);
	MemDC.SelectObject(pOldBitmap);
	MemDC.DeleteDC();
	
    return TRUE;
	//return CDialog::OnEraseBkgnd(pDC);
}

void CFileCopyProgress::OnActivate(UINT nState, CWnd* pWndOther, BOOL bMinimized) 
{
	CDialog::OnActivate(nState, pWndOther, bMinimized);
// TODO: Add your message handler code here
	
}


void CFileCopyProgress::OnClose() 
{
	if(fCopyCanceled==TRUE)
		CDialog::EndDialog(2);
	else
		CDialog::EndDialog(1);
}

void CFileCopyProgress::OnActivateApp(BOOL bActive, HTASK hTask) 
{
	CDialog::OnActivateApp(bActive, hTask);
}

void CFileCopyProgress::OnPaint() 
{
//	CPaintDC dc(this); // device context for painting
	
	// TODO: Add your message handler code here
	
	// Do not call CDialog::OnPaint() for painting messages
		if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		//dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

void CFileCopyProgress::OnAskCbFormatName(UINT nMaxCount, LPTSTR lpszString) 
{
	// TODO: Add your message handler code here and/or call default
	
	CDialog::OnAskCbFormatName(nMaxCount, lpszString);
}

void CFileCopyProgress::OnLButtonDown(UINT nFlags, CPoint point) 
{
	// TODO: Add your message handler code here and/or call default
	
	CDialog::OnLButtonDown(nFlags, point);
	PostMessage(WM_NCLBUTTONDOWN, HTCAPTION, MAKELPARAM(point.x,point.y));
}

void CFileCopyProgress::OnCaptureChanged(CWnd *pWnd) 
{
	// TODO: Add your message handler code here
	
	CDialog::OnCaptureChanged(pWnd);
}
