#include "stdafx.h"
#include "MCIMP3.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

MCIMP3::MCIMP3()
{
	m_wID                 = NULL;
	m_dwLength            = 0;
}

MCIMP3::~MCIMP3()
{
	MCIClose();
}

DWORD MCIMP3::MCIOpen(const CString &strPath)
{
	MCI_OPEN_PARMS mciOP;
	DWORD dwReturn;

	ATLASSERT(m_wID == NULL);

	mciOP.lpstrDeviceType=NULL;
	mciOP.lpstrElementName=strPath;
	dwReturn=mciSendCommand(NULL, MCI_OPEN, MCI_OPEN_ELEMENT | MCI_WAIT | MCI_OPEN_SHAREABLE,
		(DWORD)(LPVOID)&mciOP);
	if (dwReturn==0)
	{	m_wID=mciOP.wDeviceID;
		if (this->MCIGetLength(&m_dwLength)!=0)
			m_dwLength=0;
	}
	else
		m_wID=NULL;
	return dwReturn;

}

DWORD MCIMP3::MCIClose()
{
	MCI_GENERIC_PARMS mciGP;
	DWORD dwReturn;

	dwReturn = mciSendCommand(m_wID, MCI_CLOSE, MCI_NOTIFY|MCI_WAIT,
		(DWORD)(LPVOID)&mciGP);
	m_wID = NULL;
	return dwReturn;
}

DWORD MCIMP3::MCIPlay()
{
	MCI_PLAY_PARMS mciPP;

	return mciSendCommand(m_wID, MCI_PLAY, MCI_NOTIFY,
		(DWORD)(LPVOID)&mciPP);
}

DWORD MCIMP3::MCIPause()
{
	MCI_GENERIC_PARMS mciGP;

	return mciSendCommand(m_wID, MCI_PAUSE, MCI_NOTIFY|MCI_WAIT,
		(DWORD)(LPVOID)&mciGP);
}

DWORD MCIMP3::MCIResume()
{
	MCI_GENERIC_PARMS mciGP;

	return mciSendCommand(m_wID, MCI_RESUME, MCI_NOTIFY|MCI_WAIT,
		(DWORD)(LPVOID)&mciGP);
}


DWORD MCIMP3::MCIStop()
{
	MCI_GENERIC_PARMS mciGP;

	return mciSendCommand(m_wID, MCI_STOP, MCI_NOTIFY|MCI_WAIT,
		(DWORD)(LPVOID)&mciGP);
}


DWORD MCIMP3::MCISeekTo(DWORD dwTo)
{
	DWORD dwReturn;
	
	if (dwTo>0 && dwTo<m_dwLength)
	{	MCI_SEEK_PARMS mciSP;
		mciSP.dwTo=dwTo*1000;
		dwReturn = mciSendCommand(m_wID, MCI_SEEK, MCI_WAIT|MCI_NOTIFY|MCI_TO,
			(DWORD)(LPVOID)&mciSP);
	}else if (dwTo>=m_dwLength)
		dwReturn = MCISeekToEnd();
	else
		dwReturn = MCISeekToStart();
	return dwReturn;
}


DWORD MCIMP3::MCISeekToStart()
{
	MCI_SEEK_PARMS mciSP;
	return mciSendCommand(m_wID, MCI_SEEK, MCI_WAIT|MCI_NOTIFY|MCI_SEEK_TO_START,
		(DWORD)(LPVOID)&mciSP);
}

DWORD MCIMP3::MCISeekToEnd()
{
	MCI_SEEK_PARMS mciSP;
	return mciSendCommand(m_wID, MCI_SEEK, MCI_WAIT|MCI_NOTIFY|MCI_SEEK_TO_END,
		(DWORD)(LPVOID)&mciSP);
}


DWORD MCIMP3::MCIGetLength(DWORD *dwLength)
{
	MCI_STATUS_PARMS mciSP;

	mciSP.dwItem=MCI_STATUS_LENGTH;
	DWORD dwReturn=mciSendCommand(m_wID, MCI_STATUS, MCI_STATUS_ITEM,
		(DWORD)(LPVOID)&mciSP);
	if (dwReturn==0)
		*dwLength=mciSP.dwReturn/1000;
	return dwReturn;
}

DWORD MCIMP3::MCIGetPos(DWORD *dwPos)
{
	MCI_STATUS_PARMS mciSP;

	mciSP.dwItem=MCI_STATUS_POSITION;
	DWORD dwReturn=mciSendCommand(m_wID, MCI_STATUS, MCI_STATUS_ITEM,
		(DWORD)(LPVOID)&mciSP);
	if (dwReturn==0)
		*dwPos=mciSP.dwReturn/1000;
	return dwReturn;
}

DWORD MCIMP3::MCISetMute(BOOL bMute)
{
	MCI_SET_PARMS mciSP;
	mciSP.dwAudio=MCI_SET_AUDIO_ALL;
	DWORD dwFlags;
	if (bMute)
		dwFlags=MCI_WAIT|MCI_SET_AUDIO|MCI_SET_OFF;
	else
		dwFlags=MCI_WAIT|MCI_SET_AUDIO|MCI_SET_ON;
	return mciSendCommand(m_wID, MCI_SET, dwFlags,
		(DWORD)(LPVOID)&mciSP);
}

BOOL MCIMP3::MCIIsPlaying()
{
	MCI_STATUS_PARMS mciSP;

	mciSP.dwItem=MCI_STATUS_MODE;
	DWORD dwReturn=mciSendCommand(m_wID, MCI_STATUS, MCI_STATUS_ITEM,
		(DWORD)(LPVOID)&mciSP);
	if (dwReturn==0)
		if (mciSP.dwReturn==MCI_MODE_PLAY)
			return true;
	return false;
}

BOOL MCIMP3::MCIIsOpened()
{
	MCI_STATUS_PARMS mciSP;

	mciSP.dwItem=MCI_STATUS_MODE;
	DWORD dwReturn=mciSendCommand(m_wID, MCI_STATUS, MCI_STATUS_ITEM,
		(DWORD)(LPVOID)&mciSP);
	if (dwReturn==(DWORD)0)
		if (mciSP.dwReturn==MCI_MODE_OPEN ||
			mciSP.dwReturn==MCI_MODE_PLAY ||
			mciSP.dwReturn==MCI_MODE_PAUSE ||
			mciSP.dwReturn==MCI_MODE_STOP ||
			mciSP.dwReturn==MCI_MODE_SEEK
			)
			return true;
	return false;
}


