#ifndef __NCFOLDER_H_
#define __NCFOLDER_H_

#pragma once
#include "StdAfx.h"
#include <atlbase.h>
#include "utils.h"
#include "include\fs.h"
#include "ncmedia.h"
#include "img2gba\convert.h"
#include "2mp3\sox.h"
#include "include\types.h"
#define DISPLAYNAMELEN 32
#define  MP3DISPLAYNAMEPOS (-125)
#define  TAGPOS (-128)
#define  ID3V1TAGSIZE 128

#define MAXNAMELEN 30 

#define RENAME_TYPE  1
#define COPY_TYPE  2



class CNcFolder
{
public:
	CNcFolder(void);

	HRESULT OpenDevice();
	HRESULT CloseDevice();
	HRESULT AddFile(LPCTSTR pstrSource, int datatype);
	HRESULT DelFile(LPCTSTR pstrFileName,int datatype);
	HRESULT GetNCFile(LPCTSTR pstrFileName,int datatype);
	HRESULT GetObjectList(int datatype,TCHAR OnjList[USB_BUF_SIZE]);
	HRESULT GetFreeDiskSpace();
	HRESULT disp2real(LPCTSTR pDisplayName,LPCTSTR pRealName, int datatype);
	HRESULT real2disp(LPCTSTR pRealName,LPCTSTR pDisplayName, int datatype);
	HRESULT GetDisplayNameOf(IOSFd fd, ncfileinfo *finfo,int datatype);
	int ConvertSourceFile(LPCTSTR pstrSource,TCHAR pstrConverted[MAX_PATH],int datatype);
	HRESULT CheckDul(LPCTSTR pDisplayName,int datatype);
public:
	~CNcFolder(void);
private:
	BOOL _CheckForReadOnly(LPCTSTR vol, LPDWORD pdwFileOpFlags) const;
	BOOL _FindUniqueFileName(LPCTSTR vol, LPTSTR pstrName) const;
	BOOL _FindUniqueRealFileName(LPCTSTR vol, LPTSTR pstrName) const;
	//data member
public:
	TCHAR m_devName[MAX_PATH];
};

#endif