// SkinHeaderCtrl.cpp : implementation file
//

#include "stdafx.h"
#include "resource.h"
#include "SkinHeaderCtrl.h"
#include "memdc.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CSkinHeaderCtrl

CSkinHeaderCtrl::CSkinHeaderCtrl()
{
}

CSkinHeaderCtrl::~CSkinHeaderCtrl()
{
}


BEGIN_MESSAGE_MAP(CSkinHeaderCtrl, CHeaderCtrl)
	//{{AFX_MSG_MAP(CSkinHeaderCtrl)
	ON_WM_PAINT()
	ON_WM_ERASEBKGND()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CSkinHeaderCtrl message handlers

void CSkinHeaderCtrl::DrawItem(LPDRAWITEMSTRUCT lpDrawItemStruct)
{

}

void CSkinHeaderCtrl::OnPaint() 
{
	CPaintDC dc(this); // device context for painting
	
	CRect rect, rectItem, clientRect;
	GetClientRect(&rect);
	GetClientRect(&clientRect);
	CMemDC memDC(&dc, rect);
	CDC bitmapDC;
	bitmapDC.CreateCompatibleDC(&dc);
	
	//memDC.FillSolidRect(&rect, RGB(76,85,118));
	CString m_Header_ch,m_Header_split,strtmp;
	::GetPrivateProfileString("HEADER","CH","default.fil",m_Header_ch.GetBuffer(MAX_PATH),MAX_PATH, SkinFile);
	strtmp.Format("%s%s\0",SkinPath,m_Header_ch);m_Header_ch=strtmp;
	m_HeaderSkin_ch.m_hObject = (HBITMAP)::LoadImage(NULL,m_Header_ch,IMAGE_BITMAP,0,0,LR_LOADFROMFILE);   
	if (m_HeaderSkin_ch.m_hObject==NULL)
	{
		TRACE0("Failed to Load m_Header bitmap of CButton\n");
		return ;	
	}
	::GetPrivateProfileString("HEADER","SPLIT","default.fil",m_Header_split.GetBuffer(MAX_PATH),MAX_PATH, SkinFile);
	strtmp.Format("%s%s\0",SkinPath,m_Header_split);m_Header_split=strtmp;
	m_HeaderSkin_split.m_hObject = (HBITMAP)::LoadImage(NULL,m_Header_split,IMAGE_BITMAP,0,0,LR_LOADFROMFILE);   
	if (m_HeaderSkin_split.m_hObject==NULL)
	{
		TRACE0("Failed to Load m_Header_split bitmap of CButton\n");
		return ;	
	}
	//CBitmap bitmapSpan;
	//bitmapSpan.LoadBitmap(IDB_COLUMNHEADER_SPAN);
	CBitmap* pOldBitmapSpan = bitmapDC.SelectObject(&m_HeaderSkin_ch);
	
	for(int v=0; v<rect.Width(); v++)
	{
		//memDC.BitBlt((rect.left+2)+(v*1), 0, 1, 20, &bitmapDC,0,0,SRCCOPY);
		memDC.StretchBlt((rect.left+2)+(v*1), 0, 1, 25, &bitmapDC,0,0,1,19,SRCCOPY);
	}

	bitmapDC.SelectObject(pOldBitmapSpan);
	//m_HeaderSkin.DeleteObject();
	
	int nItems = GetItemCount();

	//CBitmap bitmap;
	//CBitmap bitmap2;
	//CBitmap bitmap3;
	
	//bitmap.LoadBitmap(IDB_COLUMNHEADER_E);//1x19
	//bitmap2.LoadBitmap(IDB_COLUMNHEADER_SPAN);
	//bitmap3.LoadBitmap(IDB_COLUMNHEADER_E);

	for(int i = 0; i <nItems; i++)
	{
		
		TCHAR buf1[256];
		HD_ITEM hditem1;
		
		hditem1.mask = HDI_TEXT | HDI_FORMAT | HDI_ORDER;
		hditem1.pszText = buf1;
		hditem1.cchTextMax = 255;
		GetItem( i, &hditem1 );
		
		GetItemRect(i, &rect);
		
		CBitmap* pOldBitmap = NULL;
		
		//make sure we draw the start piece
		//on the first item so it has a left border

		//For the following items we will just use the
		//right border of the previous items as the left
		//border
		if(hditem1.iOrder==0)
		{
			pOldBitmap = bitmapDC.SelectObject(&m_HeaderSkin_split);
			//memDC.BitBlt(rect.left,rect.top,1,20,&bitmapDC,0,0,SRCCOPY);
			memDC.StretchBlt(rect.left,rect.top,1,20,&bitmapDC,0,0,1,19,SRCCOPY);
		}
		else
		{
			memDC.BitBlt(rect.left-1,rect.top,1,20,&bitmapDC,0,0,SRCCOPY);
			pOldBitmap = bitmapDC.SelectObject(&m_HeaderSkin_split);
			//memDC.BitBlt(rect.left+1,rect.top,1,20,&bitmapDC,0,0,SRCCOPY);
			memDC.StretchBlt(rect.left+1,rect.top,1,20,&bitmapDC,0,0,1,19,SRCCOPY);
		}

		bitmapDC.SelectObject(pOldBitmap);
		
		//span the bitmap for the width of the column header item
		int nWidth = rect.Width() - 2;
		
		CBitmap* pOldBitmap2 = bitmapDC.SelectObject(&m_HeaderSkin_ch);
		for(int v=0; v<nWidth; v++)
		{
			//memDC.BitBlt((rect.left+2)+(v*1), 0, 1, 20, &bitmapDC,0,0,SRCCOPY);
			memDC.StretchBlt((rect.left+2)+(v*1), 0, 1, 20, &bitmapDC,0,0,1,19,SRCCOPY);
		}

		bitmapDC.SelectObject(pOldBitmap2);
		
		
		//draw the end piece of the column header
		CBitmap* pOldBitmap3 = bitmapDC.SelectObject(&m_HeaderSkin_split);
		//memDC.BitBlt((rect.right-2), 0, 1, 30, &bitmapDC,0,0,SRCCOPY);
		memDC.StretchBlt(rect.right, 0, 1, 20, &bitmapDC,0,0,1,19,SRCCOPY);
		bitmapDC.SelectObject(pOldBitmap3);
		
		//Get all the info for the current
		//item so we can draw the text to it
		//in the desired font and style
		DRAWITEMSTRUCT	DrawItemStruct;
		GetItemRect(i, &rectItem);
		
		
		DrawItemStruct.CtlType		= 100;
		DrawItemStruct.hDC			= dc.GetSafeHdc();
		DrawItemStruct.itemAction	= ODA_DRAWENTIRE; 
		DrawItemStruct.hwndItem 	= GetSafeHwnd(); 
		DrawItemStruct.rcItem	= rectItem;
		DrawItemStruct.itemID	= i;
		DrawItem(&DrawItemStruct);
		
		UINT uFormat = DT_SINGLELINE | DT_NOPREFIX | DT_TOP |DT_CENTER | DT_END_ELLIPSIS ;
		
		
		CFont font;
		LOGFONT lf;
		memset(&lf, 0, sizeof(LOGFONT));
		lf.lfHeight = 12;
		strcpy(lf.lfFaceName, "");
		font.CreateFontIndirect(&lf);
		CFont* def_font = memDC.SelectObject(&font);
	
		memDC.SetBkMode(TRANSPARENT);
		rectItem.DeflateRect(2,2,2,2);
		
		TCHAR buf[256];
		HD_ITEM hditem;
		
		hditem.mask = HDI_TEXT | HDI_FORMAT | HDI_ORDER;
		hditem.pszText = buf;
		hditem.cchTextMax = 255;
		GetItem( DrawItemStruct.itemID, &hditem );

		memDC.DrawText(buf, &rectItem, uFormat);
		memDC.SelectObject(def_font);
		font.DeleteObject();
	}		
}

BOOL CSkinHeaderCtrl::OnEraseBkgnd(CDC* pDC) 
{
	return false;	
}
