#include "stdafx.h"
#include "resource.h"
#include "SliderCtrl.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

//
CBitmapSliderCtrl::CBitmapSliderCtrl()
{
	//load skin 
	LoadSliderSkin((char *)(LPCTSTR)SkinFile);

	DWORD vl;
	m_VControl.Create(this,MIXERLINE_COMPONENTTYPE_DST_SPEAKERS,-1,MIXERCONTROL_CONTROLTYPE_VOLUME);
	m_VControl.GetValue(&vl,&vl); 
}

CBitmapSliderCtrl::~CBitmapSliderCtrl()
{
	m_VControl.Close();
	
}


BEGIN_MESSAGE_MAP(CBitmapSliderCtrl, CSliderCtrl)

	ON_NOTIFY_REFLECT(NM_CUSTOMDRAW, OnCustomDraw)
//	ON_WM_LBUTTONDOWN()
	ON_WM_LBUTTONUP()
	ON_WM_ERASEBKGND()
END_MESSAGE_MAP()
void CBitmapSliderCtrl::LoadSliderSkin(char *m_SkinFile)
{
	m_Thumb.DeleteObject();
	m_Chanel.DeleteObject();
	CString m_ThumbName,m_Chanelname,tmpname;
	char m_SkinPath[MAX_PATH];
	_snprintf(m_SkinPath, MAX_PATH, "%s\0", m_SkinFile);
	char *tmp = strrchr(m_SkinPath, '\\');
	if(tmp != NULL)
		*(tmp + 1) = 0;
	//SkinPath.Format("%s",m_SkinPath);
	::GetPrivateProfileString("SLIDER","THUMB","default.fil",m_ThumbName.GetBuffer(MAX_PATH),MAX_PATH, m_SkinFile);   
	tmpname.Format("%s%s\0",m_SkinPath,m_ThumbName);
	m_ThumbName = tmpname;
	//tmpname.Format("%s%s\0",,)
	m_Thumb.m_hObject = (HBITMAP)::LoadImage(NULL,m_ThumbName,IMAGE_BITMAP,0,0,LR_LOADFROMFILE);   
	if (m_Thumb.m_hObject==NULL)
	{
		TRACE0("Failed to Load m_Thumb bitmap of slider\n");
		
	}
	tmpname.Empty();
	::GetPrivateProfileString("SLIDER","CHANNEL","default.fil",m_Chanelname.GetBuffer(MAX_PATH),MAX_PATH, m_SkinFile);   
	tmpname.Format("%s%s\0",m_SkinPath,m_Chanelname);
	m_Chanelname = tmpname;
	//tmpname.Format("%s%s\0",,)
	m_Chanel.m_hObject = (HBITMAP)::LoadImage(NULL,m_Chanelname,IMAGE_BITMAP,0,0,LR_LOADFROMFILE);   
	if (m_Chanel.m_hObject==NULL)
	{
		TRACE0("Failed to Load m_Chanelname bitmap of slider\n");
		
	}
	//::SendMessage(GetDlgItem(IDC_VOLUME)->m_hWnd,NM_CUSTOMDRAW,   0,   0);
}
void CBitmapSliderCtrl::OnCustomDraw(NMHDR* pNMHDR, LRESULT* pResult) 
{
	LPNMCUSTOMDRAW lpcd = (LPNMCUSTOMDRAW)pNMHDR;
	//Invalidate();
	if (lpcd->dwDrawStage == CDDS_PREPAINT)
	{
		
		*pResult = CDRF_NOTIFYITEMDRAW;         
		return;
	}
	
	 if (lpcd->dwDrawStage == CDDS_ITEMPREPAINT)
	{	
		CDC *pDC = CDC::FromHandle(lpcd->hdc);
		CRect rect(lpcd->rc);
		int nSavedDC = pDC->SaveDC();
		
		if (lpcd->dwItemSpec == TBCD_TICS)
		{
			*pResult = CDRF_DODEFAULT;
			return;
		}	// if drawing tics
		else if (lpcd->dwItemSpec ==  TBCD_THUMB)
		{
			
			if (lpcd->uItemState & CDIS_SELECTED)
			{
			}
			if (rect.Height() > rect.Width())
			{
				//	CRect rcThumb;
				//GetThumbRect(rcThumb);
				//DrawBitmapChannel(pDC, rect, rcThumb.Height() > rcThumb.Width());
				DrawHorizontalBitmapThumb(pDC, rect);
				/*
				RECT r;
				GetClientRect(&r);
				CRgn rgn;
				rgn.CreateRoundRectRgn( 0, 0,r.right , r.bottom, 20,20 ); ;
				SetWindowRgn(rgn,TRUE);*/
				
				
			}
			
			if (lpcd->uItemState & CDIS_SELECTED)
			{
			}
		}	// if drawing thumb
		else if (lpcd->dwItemSpec == TBCD_CHANNEL)
		{
			if (!IsWindowEnabled())
			{
				//	m_crChannel = ::GetSysColor(COLOR_3DFACE);
			}
			
			CRect rcThumb;
			GetThumbRect(rcThumb);
			DrawBitmapChannel(pDC, rect, rcThumb.Height() > rcThumb.Width());
		}	// if drawing channel
		
		pDC->RestoreDC(nSavedDC);
		
		*pResult = CDRF_SKIPDEFAULT;
		return;
	}
	
	*pResult = 0;
}	

void CBitmapSliderCtrl::DrawHorizontalBitmapThumb(CDC *pDC, const CRect &rect)
{
	CDC memDC;
	CRect rc(rect);
	
	//CBitmap pp;
	//pp.LoadBitmap(IDB_VOLUME_T);
	CBitmap* pBitmap;
	pBitmap=&m_Thumb;
	CBitmap* pOld=NULL;
	memDC.CreateCompatibleDC(pDC);
	BITMAP	bmpInfo;
	int Width;
	int Height;
	int xSrc=0;
	int ySrc=0;
	int xDesired;
	int yDesired;
	
	ASSERT(pBitmap->m_hObject!=NULL);
	pBitmap->GetBitmap(&bmpInfo);
	
	pOld=memDC.SelectObject((CBitmap*) pBitmap);
	if (pOld==NULL) return; //Destructors will clean up
	
	Width=(bmpInfo.bmWidth-rc.Width())/2;
	Height=(bmpInfo.bmHeight-rc.Height())/2;
	
		if (Width>0) //If the bitmap Width is larger then rc
		{
			xDesired=rc.left;
			xSrc=abs(Width);
		}
		else xDesired=rc.left+ abs(Width);

		if (Height>0) //If the bitmap Height is larger then rc
		{
			yDesired=rc.top;
			ySrc=abs(Height);
		}
		else yDesired=rc.top+abs(Height);
	
	pDC->BitBlt(xDesired,yDesired+2,rc.Width(),rc.Height(),&memDC,xSrc,ySrc,SRCCOPY);
	memDC.SelectObject(pOld);

}
void CBitmapSliderCtrl::DrawBitmapChannel(CDC *pDC, const CRect &rect, BOOL bHorz)
{
	CDC memDC;
	CRect rc(rect);
	
	//GetClientRect(&rc);
	//CBitmap pp;
	//pp.LoadBitmap(IDB_CHN);
	CBitmap* pBitmap;
	pBitmap=&m_Chanel;
	CBitmap* pOld=NULL;
	memDC.CreateCompatibleDC(pDC);
	BITMAP	bmpInfo;
	int Width;
	int Height;
	int xSrc=0;
	int ySrc=0;
	int xDesired;
	int yDesired;
	
	ASSERT(pBitmap->m_hObject!=NULL);
	pBitmap->GetBitmap(&bmpInfo);
	
	pOld=memDC.SelectObject((CBitmap*) pBitmap);
	if (pOld==NULL) return; //Destructors will clean up
	CRect cct;
	GetClientRect(&cct);
	Width=(bmpInfo.bmWidth-rc.Width())/2;
	Height=(bmpInfo.bmHeight-rc.Height())/2;
	
		if (Width>0) //If the bitmap Width is larger then rc
		{
			xDesired=rc.left;
			xSrc=abs(Width);
		}
		else xDesired=rc.left+ abs(Width);
		if (Height>0) //If the bitmap Height is larger then rc
		{
			yDesired=rc.top;
			ySrc=abs(Height);
		}
		else yDesired=rc.top+abs(Height);
	
//	pDC->BitBlt(xDesired,yDesired,rc.Width(),rc.Height(),&memDC,xSrc,ySrc,SRCCOPY);
	pDC->StretchBlt(0,0,cct.Width(),30,&memDC,0,0,\
		80,30,SRCCOPY);
	memDC.SelectObject(pOld);
}
//CBitmapSliderCtrl::OnMouseMove(UINT nFlags, CPoint point)
BOOL CBitmapSliderCtrl::OnEraseBkgnd(CDC* pDC)
{
	//MessageBox("slider OnEraseBkgnd","slider",MB_OK);
	return FALSE;
}

//CSliderCtrl::OnMouseMove(UINT nFlags, CPoint point)
void CBitmapSliderCtrl::OnLButtonUp(UINT nFlags, CPoint point) 
{
	CSliderCtrl::OnLButtonUp(nFlags,point);
}
void CBitmapSliderCtrl::OnLButtonDown(UINT nFlags, CPoint point) 
{

	::PostMessage((HWND)GetDlgItem(IDC_MUTE),WM_NCLBUTTONUP,0,NULL);
	
	
}