#include "stdafx.h"
#include "bitbutton.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

#define RGB_BUTTON_BLACK    (GetSysColor(COLOR_WINDOWFRAME))
#define RGB_BUTTON_WHITE    RGB(239,235,239)//(GetSysColor(COLOR_BTNHIGHLIGHT))
#define RGB_BUTTON_LIGHT    (GetSysColor(COLOR_BTNFACE))
#define RGB_BUTTON_DARK     RGB(239,235,239)//(GetSysColor(COLOR_BTNSHADOW))

#define BORDER_CLEAR		0x0000L
#define BORDER_PUSHED		0x0001L
#define BORDER_NONPUSHED	0x0002L

CBitButton::CBitButton()
{
	m_bMouseCaptured=FALSE;
	m_bLButtonDown=FALSE;
	m_bHasFocus=FALSE;
	m_bDisabled=FALSE;
	m_bDown=FALSE;
	
	m_TextAlign=AlignLeft;
	m_nBorder=BORDER_CLEAR;
	m_bRaised=FALSE;
	m_muteflag=TRUE;
	m_bHasChanged=FALSE;
	m_musicplaying=FALSE;
	statflag=0;
	DWORD vl;
	m_MuteControl.Create(this,MIXERLINE_COMPONENTTYPE_DST_SPEAKERS,-1,MIXERCONTROL_CONTROLTYPE_VOLUME);
	m_MuteControl.GetValue(&vl,&vl); 
}

CBitButton::~CBitButton()
{

	if( m_bitmap.m_hObject != NULL )
	m_bitmap.DeleteObject();
	if( m_bitmapFocus.m_hObject != NULL )
	m_bitmapFocus.DeleteObject();
	if( m_bitmapDisabled.m_hObject != NULL )
	m_bitmapDisabled.DeleteObject();
	if( m_bitmapRaised.m_hObject != NULL )
	m_bitmapRaised.DeleteObject();
	if( m_bitmapOther.m_hObject != NULL )
	m_bitmapOther.DeleteObject();
	if( m_bitmapDown.m_hObject != NULL )
	m_bitmapDown.DeleteObject();
	if( m_bitmapDown2.m_hObject != NULL )
	m_bitmapDown2.DeleteObject();
	if( m_bitmapFocus2.m_hObject != NULL )
	m_bitmapFocus2.DeleteObject();

}


BEGIN_MESSAGE_MAP(CBitButton, CButton)
	//{{AFX_MSG_MAP(CTrackLookButton)
	ON_WM_MOUSEMOVE()
	ON_WM_KILLFOCUS()
	ON_WM_SETFOCUS()
	ON_WM_LBUTTONDOWN()
	ON_WM_LBUTTONUP()
	ON_WM_CREATE()
	ON_WM_ENABLE()
	ON_WM_ERASEBKGND()
	//}}AFX_MSG_MAPs
END_MESSAGE_MAP()

BOOL CBitButton::OnEraseBkgnd(CDC* pDC) 
{	
/*
CRect rect;

CBrush brush;

brush.CreateSolidBrush(GetDocument()->GetViewBkColor());

pDC->GetClipBox(rect);

pDC->FillRect(rect,&brush);
*/
return TRUE;



}

void CBitButton::OnMouseMove(UINT nFlags, CPoint point) 
{
	
	CButton::OnMouseMove(nFlags,point);
	if (!m_bMouseCaptured || GetCapture()!=this || m_nBorder==BORDER_CLEAR)
	{
		SetCapture();
		m_bMouseCaptured=TRUE;
		OnMouseEnter(nFlags,point);
	} else
	{
		CRect rc;
		this->GetClientRect(&rc);
		if (!rc.PtInRect(point))
		{
			OnMouseLeave(nFlags,point);
			m_bMouseCaptured=FALSE;
			ReleaseCapture();
		}
	}
}

void CBitButton::OnKillFocus(CWnd* pNewWnd) 
{
	m_nBorder=BORDER_CLEAR;
	m_bHasFocus=FALSE;
	m_bRaised=FALSE;
	CButton::OnKillFocus(pNewWnd);
	Invalidate(FALSE);
	UpdateWindow();
}

void CBitButton::OnSetFocus(CWnd* pOldWnd) 
{
	m_nBorder=m_bLButtonDown?BORDER_PUSHED:BORDER_NONPUSHED;
	m_bHasFocus=TRUE;
	m_bRaised=TRUE;
	CButton::OnSetFocus(pOldWnd);
	Invalidate(FALSE);
	UpdateWindow();
}

void CBitButton::DrawItem(LPDRAWITEMSTRUCT lpDrawItemStruct) 
{
	int	 iSaveDC;
	CDC* pDC;
	CBrush brush(RGB_BUTTON_LIGHT);
	CRect rc;
	CString	strTitle;
	UINT	nFormat; //For DrawText
	UINT	nFlags;	//For DrawBitmap
	CBitmap*	pBitmap=NULL;
	
	pDC=CDC::FromHandle(lpDrawItemStruct->hDC);
	VERIFY(pDC);
	rc.CopyRect(&lpDrawItemStruct->rcItem);
	GetWindowText(strTitle);
	nFormat=DT_SINGLELINE;
	iSaveDC=pDC->SaveDC();
	
	switch (m_TextAlign)
	{
	case AlignAbove:
		nFormat|=DT_CENTER|DT_TOP;
		break;	
	case AlignBelow: 
		nFormat|=DT_CENTER|DT_BOTTOM;
		break;
	case AlignLeft:
	case AlignRight: 
		nFormat|=DT_LEFT|DT_VCENTER;
		break;
	default: 
		ASSERT(FALSE); // should not be called;
	}
	
	pDC->SetBkMode(TRANSPARENT);
	
	if (m_bHasFocus)
	{
		pDC->SetTextColor(RGB(0,0,255));
		pBitmap=&m_bitmapFocus;	
		if (pBitmap->m_hObject==NULL) 
			pBitmap=&m_bitmap; //Simulate some bitmap;
	}
	else
	{
		pDC->SetTextColor(RGB_BUTTON_BLACK);
		pBitmap=&m_bitmap;
	}
	
	if (m_bRaised)
	{
		pBitmap=&m_bitmapFocus;
		if (pBitmap->m_hObject==NULL) 
			pBitmap=&m_bitmap; //Simulate some bitmap;
	} 
	if (m_bLButtonDown)
	{
		pBitmap=&m_bitmapDown;
		if (pBitmap->m_hObject==NULL) 
			pBitmap=&m_bitmap; 
	} 
	if (m_bDisabled=(::GetWindowLong(m_hWnd,GWL_STYLE) & WS_DISABLED))
	{
		pBitmap=&m_bitmapDisabled;
	}
	//else if (m_bLButtonDown) 
	//	rc.OffsetRect(1,1);
	
	if (m_bHasChanged)//changed
	{
		pBitmap=&m_bitmapOther;
		if (pBitmap->m_hObject==NULL) 
			pBitmap=&m_bitmap;
	}
	//------------>
	if (m_musicplaying)
	{
		if (m_bHasFocus)
		{
			pDC->SetTextColor(RGB(0,0,255));
			pBitmap=&m_bitmapFocus2;	
			if (pBitmap->m_hObject==NULL) 
			{
				pBitmap=&m_bitmapOther; //Simulate some bitmap;
			}
		}
		else
		{
			pDC->SetTextColor(RGB_BUTTON_BLACK);
			pBitmap=&m_bitmapOther;
		}
		
		if (m_bRaised)
		{
			pBitmap=&m_bitmapFocus2;
			if (pBitmap->m_hObject==NULL) 
				pBitmap=&m_bitmapOther; //Simulate some bitmap;
		} 
		if (m_bLButtonDown)
		{
			pBitmap=&m_bitmapDown2;
			if (pBitmap->m_hObject==NULL) 
				pBitmap=&m_bitmapOther; 
		} 
		/*if (m_bDisabled=(::GetWindowLong(m_hWnd,GWL_STYLE) & WS_DISABLED))
		{
			pBitmap=&m_bitmapDisabled;
		}*/
	}
	//<-----------
	CRect rcText(rc);
	
	if (pBitmap->m_hObject)
	{
		CRect rcBitmap(rc);
		BITMAP	bmpInfo;			
		CSize	size;
		
		switch (m_TextAlign)
		{
		case AlignLeft:
			{
				size=pDC->GetTextExtent(strTitle);
				rcBitmap.OffsetRect(size.cx+5,0);
				nFlags=DB_VCENTER;
				break;
			}
			
		case AlignAbove:
			{
				size=pDC->GetTextExtent(strTitle);
				rcBitmap.OffsetRect(0,size.cy+5);
				nFlags=DB_HCENTER;
				break;
			}
			
		case AlignRight:
			{
				pBitmap->GetBitmap(&bmpInfo);	
				rcText.OffsetRect(bmpInfo.bmWidth+5,0);
				nFlags=DB_VCENTER;
				break;
			}
			
		case AlignBelow:
			{
				pBitmap->GetBitmap(&bmpInfo);	
				rcText.OffsetRect(bmpInfo.bmWidth+5,0);
				//nFlags=DB_HCENTER;
				nFlags=DB_VCENTER;
				break;
			}
		default: ASSERT(FALSE);break;
		}
		
		DrawBitmap(pDC,rcBitmap,nFlags,pBitmap);
	}
	/*
	if (m_bDisabled)
	{
		rcText.OffsetRect(1,1);
		pDC->SetTextColor(RGB_BUTTON_WHITE);
		pDC->DrawText(strTitle,rcText,nFormat);
		rcText.OffsetRect(-1,-1);
		pDC->SetTextColor(RGB_BUTTON_DARK);
		pDC->DrawText(strTitle,rcText,nFormat);
	} else
		pDC->DrawText(strTitle,rcText,nFormat);
	*/
	
	pDC->RestoreDC(iSaveDC);
}

void	CBitButton::OnMouseEnter(UINT nFlags,CPoint point)
{
	m_bLButtonDown=(nFlags & MK_LBUTTON);
	m_nBorder=m_bLButtonDown?BORDER_PUSHED:BORDER_NONPUSHED;
	
	m_bRaised=TRUE;
	Invalidate(FALSE);
	UpdateWindow();
}

void CBitButton::OnMouseLeave(UINT nFlags,CPoint point)	
{
	m_nBorder=BORDER_CLEAR;
	m_bLButtonDown=FALSE;
	m_bRaised=FALSE;
	PostMessage(WM_KILLFOCUS);//kill focus
	
	Invalidate(FALSE);
	UpdateWindow();
}

void CBitButton::Draw3DBorder(CDC* pDC,CRect rc,UINT nOptions)
{
	switch (nOptions)
	{
	case BORDER_CLEAR:
		pDC->Draw3dRect(rc,RGB_BUTTON_LIGHT,RGB_BUTTON_LIGHT);
		break;
	case BORDER_PUSHED:
		pDC->Draw3dRect(rc,RGB_BUTTON_DARK,RGB_BUTTON_WHITE);
		break;
	case BORDER_NONPUSHED:
		pDC->Draw3dRect(rc,RGB_BUTTON_WHITE,RGB_BUTTON_DARK);
		break;
	default:			break;
	}
}

void CBitButton::OnLButtonDown(UINT nFlags, CPoint point) 
{
	m_bLButtonDown=TRUE;
	m_bRaised=FALSE;
	if (GetFocus()!=this)
	{
		this->SetFocus();
		return;
	}
	m_nBorder=BORDER_PUSHED;
	
	CButton::OnLButtonDown(nFlags,point);
	Invalidate(FALSE);
	UpdateWindow();
}


void CBitButton::OnLButtonUp(UINT nFlags, CPoint point) 
{
	m_bLButtonDown=FALSE;
	m_bRaised=TRUE;
	
	if(this->GetDlgCtrlID()==1015)//mute button
	{
		if(!m_bHasChanged)
		{
			m_bHasChanged=TRUE;
			m_MuteControl.GetValue(&m_lVol,&m_rVol);
			m_MuteControl.SetValue(0,0);
		}
		else
		{
			m_bHasChanged=FALSE;
			m_MuteControl.SetValue(m_lVol,m_rVol);
		}
	}
	if(this->GetDlgCtrlID()==1001)//max and restore button
	{
		if(!m_bHasChanged)
		{
			m_bHasChanged=TRUE;
		}
		else
		{
			m_bHasChanged=FALSE;
		}
	}
	//button high light,show position
	if(this->GetDlgCtrlID()>=1004 && this->GetDlgCtrlID()<=1006)
	{
			m_bHasChanged=TRUE;
	}

	if(this->GetDlgCtrlID()==1002)//play and stop button
	{
		if(!m_bHasChanged)
		{
			m_bHasChanged=TRUE;
		}
		else
		{
			m_bHasChanged=FALSE;
		}

	}
	if (GetFocus()!=this)
	{
		
		this->SetFocus();
		
	} else
	{
		m_nBorder=BORDER_NONPUSHED;
		Invalidate(FALSE);
		UpdateWindow();
	}
	
	GetParent()->SendMessage(WM_COMMAND,
		MAKEWPARAM(GetDlgCtrlID(),BN_CLICKED),
		(LPARAM) m_hWnd);
	
}

void CBitButton::OnLButtonDblClk(UINT nFlags, CPoint point) 
{
	m_bLButtonDown=TRUE;
	if (GetFocus()!=this)
	{
		this->SetFocus();
		return;
	}
	m_nBorder=BORDER_PUSHED;
	
	Invalidate(FALSE);
	UpdateWindow();
	CButton::OnLButtonDblClk(nFlags,point);	
	m_nBorder=BORDER_CLEAR;
}

int CBitButton::OnCreate(LPCREATESTRUCT lpCreateStruct) 
{
	if (CButton::OnCreate(lpCreateStruct) == -1)
		return -1;
	
	m_bDisabled=(lpCreateStruct->style & WS_DISABLED);
	return 0;
}

void CBitButton::OnEnable(BOOL bEnable) 
{
	m_bDisabled=!bEnable;
	CButton::OnEnable(bEnable);
}

BOOL CBitButton::LoadBitmaps(UINT nBitmap, UINT nBitmapFocus, UINT nBitmapDisabled,
							 UINT nBitmapOther,UINT nBitmapDown,UINT nBitmapFocus2,
							 UINT nBitmapDown2)
{
	return LoadBitmaps(MAKEINTRESOURCE(nBitmap),
		MAKEINTRESOURCE(nBitmapFocus),
		MAKEINTRESOURCE(nBitmapDisabled),
		MAKEINTRESOURCE(nBitmapOther),
		MAKEINTRESOURCE(nBitmapDown),
		MAKEINTRESOURCE(nBitmapFocus2),
		MAKEINTRESOURCE(nBitmapDown2));
}

CBitButton::TextAlign CBitButton::GetTextAlignment() const
{
	return m_TextAlign;
}

void CBitButton::SetTextAlignment(TextAlign nTextAlign)
{
	m_TextAlign=nTextAlign;
}

void CBitButton::DrawBitmap(CDC * pDC, CRect rc,UINT nFlags,CBitmap * pBitmap)
{
	CDC memDC;
	CBitmap* pOld=NULL;
	memDC.CreateCompatibleDC(pDC);
	BITMAP	bmpInfo;
	int Width;
	int Height;
	int xSrc=0;
	int ySrc=0;
	int xDesired;
	int yDesired;
	
	ASSERT(pBitmap->m_hObject!=NULL);
	pBitmap->GetBitmap(&bmpInfo);
	
	pOld=memDC.SelectObject((CBitmap*) pBitmap);
	if (pOld==NULL) return; //Destructors will clean up
	

	Width=(bmpInfo.bmWidth-rc.Width())/2;
	Height=(bmpInfo.bmHeight-rc.Height())/2;
	//ñɫλͼɾõǰɫΪ
	//memDC.FillSolidRect(0,0,Width,Height,RGB(255,255,255));
	//---------------->
	CDC dcMem;
	BITMAP bm;

	//VERIFY(m_bmp.GetObject(sizeof(bm),(LPVOID)&bm));
	dcMem.CreateCompatibleDC(pDC);
	CBitmap *pOldBMP =( CBitmap *)dcMem.SelectObject(pBitmap);
	memDC.BitBlt( Width,Height,	bmpInfo.bmWidth,bmpInfo.bmHeight,&dcMem,0,0,SRCCOPY);
	dcMem.SelectObject(pOld);

	//<--------------
	if ((nFlags & DB_HCENTER))
	{
		if (Width>0) //If the bitmap Width is larger then rc
		{
			xDesired=rc.left;
			xSrc=abs(Width);
		}
		else xDesired=rc.left+ abs(Width);
	}
	else xDesired=rc.left;
	
	if ((nFlags & DB_VCENTER))
	{
		if (Height>0) //If the bitmap Height is larger then rc
		{
			yDesired=rc.top;
			ySrc=abs(Height);
		}
		else yDesired=rc.top+abs(Height);
	} else
		yDesired=rc.top;
	
	//pDC->BitBlt(xDesired,yDesired,rc.Width(),rc.Height(),&dcMem,xSrc,ySrc,SRCCOPY);
	pDC->BitBlt(0,0,rc.Width(),rc.Height(),&memDC,0,0,SRCCOPY);
	
	memDC.SelectObject(pOld);	
	pOld->DeleteObject();
	//memDC.DeleteObject(pOld);	
	memDC.DeleteDC();
}
BOOL CBitButton::LoadBitmaps(CString szBitmap,CString szBitmapFocus,\
		CString szBitmapDisabled,CString szBitmapOther,\
		CString szBitmapDown,CString szBitmapFocus2,\
		CString szBitmapDown2)
{
	//Delete old ones
	m_bitmap.DeleteObject();
	m_bitmapFocus.DeleteObject();
	m_bitmapDisabled.DeleteObject();
	m_bitmapRaised.DeleteObject();
	m_bitmapOther.DeleteObject();
	m_bitmapDown.DeleteObject();
	m_bitmapDown2.DeleteObject();
	m_bitmapFocus2.DeleteObject();

	/*const   char*   lpszName   =   "c:\\test.bmp";   
    HBITMAP   hBitmap = (HBITMAP)::LoadImage(NULL,lpszName,IMAGE_BITMAP,0,0,LR_LOADFROMFILE);   
    CBitmap   bmp;   
    bmp.Attach(hBitmap);*/ 
	
	m_bitmap.m_hObject = (HBITMAP)::LoadImage(NULL,szBitmap,IMAGE_BITMAP,0,0,LR_LOADFROMFILE);   
	if (m_bitmap.m_hObject==NULL)
	{
		TRACE0("Failed to Load First bitmap of CButton\n");
		return FALSE;	
	}
	
	BOOL bAllLoaded=TRUE;
	if (!szBitmapFocus.IsEmpty() )
	{
		m_bitmapFocus.m_hObject = (HBITMAP)::LoadImage(NULL,szBitmapFocus,IMAGE_BITMAP,0,0,LR_LOADFROMFILE);   
		if (m_bitmapFocus.m_hObject==NULL)
		{
			TRACE0("Failed to Load focus bitmap of CButton\n");
			return bAllLoaded=FALSE;
		}
	}
	
	if (!szBitmapDisabled.IsEmpty())
	{
		m_bitmapDisabled.m_hObject = (HBITMAP)::LoadImage(NULL,szBitmapDisabled,IMAGE_BITMAP,0,0,LR_LOADFROMFILE);   
		if (m_bitmapDisabled.m_hObject==NULL)
		//if (!m_bitmapDisabled.LoadBitmap(lpszBitmapDisabled))
		{
			TRACE0("Failed to Load disabled bitmap of CButton\n");
			return bAllLoaded=FALSE;
		}
	}

	if (!szBitmapOther.IsEmpty())
	{
		m_bitmapOther.m_hObject = (HBITMAP)::LoadImage(NULL,szBitmapOther,IMAGE_BITMAP,0,0,LR_LOADFROMFILE);   
		if (m_bitmapOther.m_hObject==NULL)
		//if (!m_bitmapOther.LoadBitmap(lpszBitmapOther))
		{
			TRACE0("Failed to Load other bitmap of CButton\n");
			return bAllLoaded=FALSE;
		}
	}
	//pic when button is down
	if (!szBitmapDown.IsEmpty())
	{
		m_bitmapDown.m_hObject = (HBITMAP)::LoadImage(NULL,szBitmapDown,IMAGE_BITMAP,0,0,LR_LOADFROMFILE);   
		if (m_bitmapDown.m_hObject==NULL)
		//if (!m_bitmapDown.LoadBitmap(lpszBitmapDown))
		{
			TRACE0("Failed to Load down bitmap of CButton\n");
			return bAllLoaded=FALSE;
		}
	}
	if (!szBitmapFocus2.IsEmpty())
	{
		m_bitmapFocus2.m_hObject = (HBITMAP)::LoadImage(NULL,szBitmapFocus2,IMAGE_BITMAP,0,0,LR_LOADFROMFILE);   
		if (m_bitmapFocus2.m_hObject==NULL)
		//if (!m_bitmapFocus2.LoadBitmap(lpszBitmapFocus2))
		{
			TRACE0("Failed to Load First bitmap of CButton\n");
			return bAllLoaded=FALSE;
		}
	}
	if (!szBitmapDown2.IsEmpty())
	{
		m_bitmapDown2.m_hObject = (HBITMAP)::LoadImage(NULL,szBitmapDown2,IMAGE_BITMAP,0,0,LR_LOADFROMFILE);   
		if(m_bitmapDown2.m_hObject==NULL)
		//if (!m_bitmapDown2.LoadBitmap(lpszBitmapDown2))
		{
			TRACE0("Failed to Load down2 bitmap of CButton\n");
			return bAllLoaded=FALSE;
		}
	}

return bAllLoaded;
}
BOOL CBitButton::LoadBitmaps(LPCSTR lpszBitmap, LPCSTR lpszBitmapFocus,  
							 LPCSTR lpszBitmapDisabled ,LPCSTR lpszBitmapOther,
							 LPCSTR lpszBitmapDown,LPCSTR lpszBitmapFocus2,
		LPCSTR lpszBitmapDown2)
{
	//Delete old ones
	m_bitmap.DeleteObject();
	m_bitmapFocus.DeleteObject();
	m_bitmapDisabled.DeleteObject();
	m_bitmapRaised.DeleteObject();
	m_bitmapOther.DeleteObject();
	m_bitmapDown.DeleteObject();
	m_bitmapDown2.DeleteObject();
	m_bitmapFocus2.DeleteObject();
	
	if (!m_bitmap.LoadBitmap(lpszBitmap))
	{
		TRACE0("Failed to Load First bitmap of CButton\n");
		return FALSE;	
	}
	
	BOOL bAllLoaded=TRUE;
	if (lpszBitmapFocus!=NULL)
	{
		if (!m_bitmapFocus.LoadBitmap(lpszBitmapFocus))
		{
			TRACE0("Failed to Load First bitmap of CButton\n");
			return bAllLoaded=FALSE;
		}
	}
	
	if (lpszBitmapDisabled!=NULL)
	{
		if (!m_bitmapDisabled.LoadBitmap(lpszBitmapDisabled))
		{
			TRACE0("Failed to Load bitmap of CButton\n");
			return bAllLoaded=FALSE;
		}
	}

	if (lpszBitmapOther!=NULL)
	{
		if (!m_bitmapOther.LoadBitmap(lpszBitmapOther))
		{
			TRACE0("Failed to Load bitmap of CButton\n");
			return bAllLoaded=FALSE;
		}
	}
	//pic when button is down
	if (lpszBitmapDown!=NULL)
	{
		if (!m_bitmapDown.LoadBitmap(lpszBitmapDown))
		{
			TRACE0("Failed to Load bitmap of CButton\n");
			return bAllLoaded=FALSE;
		}
	}
	if (lpszBitmapFocus2!=NULL)
	{
		if (!m_bitmapFocus2.LoadBitmap(lpszBitmapFocus2))
		{
			TRACE0("Failed to Load First bitmap of CButton\n");
			return bAllLoaded=FALSE;
		}
	}
	if (lpszBitmapDown2!=NULL)
	{
		if (!m_bitmapDown2.LoadBitmap(lpszBitmapDown2))
		{
			TRACE0("Failed to Load bitmap of CButton\n");
			return bAllLoaded=FALSE;
		}
	}

	return bAllLoaded;
}
