
#if !defined(AFX_NITMAPWINDOW_H)
#define AFX_NITMAPWINDOW_H

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000
#include <afxcmn.h>
#include <atlbase.h>
#include <atlwin.h>
#include "stdafx.h"
#define MINX 606
#define MINY 767
#define TOPLEFT 1
#define TOPMIDDLE 2
#define TOPRIGHT 3
#define MIDDLELEFT 4
#define CLIENT 5
#define MIDDLERIGHT 6
#define BOTTONLEFT 7
#define BOTTONMIDDLE 8
#define BOTTONRIGHT 9
#define MGM	0
#define BTBK	10

class CBitmapWindow  : public CWindowImpl<CBitmapWindow>
{
public:
	CBitmap m_TitleSkin;
	CBitmap m_BottomLeftSkin;
	typedef enum HandlerTypeEnum
	{
		ClientPaint = WM_PAINT,
		BackGroundPaint = WM_ERASEBKGND
	} HandlerTypeEnum;

	CBitmapWindow()
	{
		m_nMessageHandler = ClientPaint;
	};
	
	virtual ~CBitmapWindow()
	{
	};

	BEGIN_MSG_MAP(CBitmapWindow)
		MESSAGE_HANDLER(WM_PAINT, OnPaint)
		MESSAGE_HANDLER(WM_ERASEBKGND, OnEraseBkGnd)
	END_MSG_MAP()
	virtual BOOL Load( INT iSourceID ,int position)
	{
		CString filename=MAKEINTRESOURCE(iSourceID);
		return Load(filename ,position);
	}
	virtual BOOL Load( LPCTSTR szFileName ,int position)
	//virtual BOOL Load( int resid,int position)
	{
		BOOL bResult = FALSE;
		//LPCTSTR szFileName;
		Close();	
		//szFileName = MAKEINTRESOURCE(resid);
		if ( szFileName )
		{
			OFSTRUCT of;
			HANDLE hFile = NULL;
			if ( (hFile = (HANDLE)OpenFile( szFileName, &of, OF_READ | OF_SHARE_COMPAT)) != (HANDLE)HFILE_ERROR )
			{
				DWORD dwHighWord = NULL, dwSizeLow = GetFileSize( hFile, &dwHighWord );
				DWORD dwFileSize = dwSizeLow;
				HRESULT hResult = NULL;	
				if ( HGLOBAL hGlobal = GlobalAlloc(GMEM_MOVEABLE, dwFileSize) )
					if ( void* pvData = GlobalLock( hGlobal ) )
					{
						DWORD dwReadBytes = NULL;
						BOOL bRead = ReadFile( hFile, pvData, dwFileSize, &dwReadBytes, NULL );
						GlobalUnlock( hGlobal );
						if ( bRead )
						{
							CComPtr<IStream> spStream;
							_ASSERTE( dwFileSize == dwReadBytes );
							if ( SUCCEEDED( CreateStreamOnHGlobal( hGlobal, TRUE, &spStream) ) )
								if ( SUCCEEDED( hResult = OleLoadPicture( spStream, 0, FALSE, IID_IPicture, (void**)&m_spPicture ) ) )
								{
									bResult = TRUE;
									//m_topleft =m_spPicture;
									switch( position ) 
									 {
									 case TOPLEFT:
										 m_topleft =m_spPicture;
										 break;
									 case TOPMIDDLE:
										 m_topmidd =m_spPicture;
										 break;
									 case TOPRIGHT:
										 m_topright=m_spPicture;
										 break;
									 case MIDDLELEFT:
										 m_middleleft=m_spPicture;
										 break;
									 case  MIDDLERIGHT:
										 m_middleright=m_spPicture;
										 break;
									 case BOTTONLEFT:
										 //m_BottomLeftSkin =m_spPicture;
										 break;
									 case BOTTONMIDDLE:
										 m_bottommidd =m_spPicture;
										 break;
									 case BOTTONRIGHT:
										 m_bottomright =m_spPicture;
										 break;
									 case MGM:
										 m_mgm =m_spPicture;
										 break;
									 case BTBK:
										m_btbk =m_spPicture;
										break;
									 }
								}
						}
					}
				CloseHandle( hFile );
			}
		}
		Invalidate(FALSE);
		return bResult;
	}

	HandlerTypeEnum m_nMessageHandler;


	
	inline virtual BOOL IsHandlerMessage( UINT uMsg )
	{
		return m_nMessageHandler == (HandlerTypeEnum)uMsg ;
	}
	
	void PutPicture( IPicture* pPicture, HDC hDC, RECT rPicture )
	{
		OLE_XSIZE_HIMETRIC nWidth = NULL; 
		OLE_YSIZE_HIMETRIC nHeight = NULL;
		pPicture->get_Width( &nWidth ); 
		pPicture->get_Height( &nHeight );
		pPicture->Render( hDC, rPicture.left ,rPicture.top, rPicture.right - rPicture.left,\
			rPicture.bottom - rPicture.top, 0, nHeight, nWidth, -nHeight, NULL );
	};
	void LoadTitleAndBtLeft(CString m_title,CString m_btleft)
	{
		m_TitleSkin.m_hObject = (HBITMAP)::LoadImage(NULL,m_title,IMAGE_BITMAP,0,0,LR_LOADFROMFILE);   
		if (m_TitleSkin.m_hObject==NULL)
		{
			TRACE0("Failed to Load m_TitleSkin bitmap of CButton\n");
			return ;	
		}
		m_BottomLeftSkin.m_hObject = (HBITMAP)::LoadImage(NULL,m_btleft,IMAGE_BITMAP,0,0,LR_LOADFROMFILE);   
		if (m_BottomLeftSkin.m_hObject==NULL)
		{
			TRACE0("Failed to Load m_BottomLeftSkin bitmap of CButton\n");
			return ;	
		}
	}
	void DrawMiddleTitle(HDC hDC)
	{
		CDC *pDC=CDC::FromHandle(hDC);
		CDC memDC;
		CString m_title,strtmp;
		::GetPrivateProfileString("DIALOG","TITLE","default.fil",m_title.GetBuffer(MAX_PATH),MAX_PATH, SkinFile);
		strtmp.Format("%s%s\0",SkinPath,m_title);m_title=strtmp;
		m_TitleSkin.m_hObject = (HBITMAP)::LoadImage(NULL,m_title,IMAGE_BITMAP,0,0,LR_LOADFROMFILE);   
		if (m_TitleSkin.m_hObject==NULL)
		{
			TRACE0("Failed to Load m_TitleSkin bitmap of CButton\n");
			return ;	
		}
		//CBitmap pp;
		
		//pp.LoadBitmap(IDB_TITLE);
		CBitmap* pBitmap;
		pBitmap=&m_TitleSkin;
		CBitmap* pOld=NULL;
		memDC.CreateCompatibleDC(pDC);
		BITMAP	bmpInfo;
		
		ASSERT(pBitmap->m_hObject!=NULL);
		pBitmap->GetBitmap(&bmpInfo);
		
		pOld=memDC.SelectObject((CBitmap*) pBitmap);
		if (pOld==NULL) return; //Destructors will clean up

		pDC->StretchBlt(271,0,233,44,&memDC,0,0,233,44,SRCCOPY);//part1
		
		memDC.SelectObject(pOld);
		//pp.DeleteObject();
		pOld->DeleteObject();
		pBitmap->DeleteObject();
	};
	void DrawBottomLeft(RECT rc,HDC hDC)
	{
		CDC *pDC=CDC::FromHandle(hDC);
		CDC memDC;
		//CRect rc;
		
		//GetClientRect(&rc);
		//CBitmap pp;
		//pp.LoadBitmap(IDB_BK_BOTTOMLEFT);
		CString m_btleft,strtmp;
		::GetPrivateProfileString("DIALOG","BOTTOMLEFT","default.fil",m_btleft.GetBuffer(MAX_PATH),MAX_PATH, SkinFile);
		strtmp.Format("%s%s\0",SkinPath,m_btleft);m_btleft=strtmp;
		m_BottomLeftSkin.m_hObject = (HBITMAP)::LoadImage(NULL,m_btleft,IMAGE_BITMAP,0,0,LR_LOADFROMFILE);   
		if (m_BottomLeftSkin.m_hObject==NULL)
		{
			TRACE0("Failed to Load m_BottomLeftSkin bitmap of CButton\n");
			return ;	
		}
		CBitmap* pBitmap;
		pBitmap=&m_BottomLeftSkin;
		CBitmap* pOld=NULL;
		 memDC.CreateCompatibleDC(pDC);
		BITMAP	bmpInfo;
		int Width;
		int Height;
		int xSrc=0;
		int ySrc=0;
		//int xDesired;
		//int yDesired;
		
		//ASSERT(pBitmap->m_hObject!=NULL);
		pBitmap->GetBitmap(&bmpInfo);
		
		pOld=memDC.SelectObject((CBitmap*) pBitmap);
		if (pOld==NULL) return; //Destructors will clean up
		//CRect cct;
		//GetClientRect(&cct);
		Width=rc.right-rc.left;
		Height=rc.bottom-rc.top;
		
		//	pDC->BitBlt(xDesired,yDesired,rc.Width(),rc.Height(),&memDC,xSrc,ySrc,SRCCOPY);
		//pDC->StretchBlt(rc.left,rc.top,Width,Height,&memDC,0,0,534,98,SRCCOPY);
		//draw part
		pDC->StretchBlt(rc.left,rc.top,27,Height,&memDC,0,0,27,98,SRCCOPY);//part1
		pDC->StretchBlt(rc.left+27,rc.top,118,22,&memDC,27,0,118,22,SRCCOPY);//part1
		pDC->StretchBlt(rc.left+27,rc.top+73,118,25,&memDC,27,73,118,25,SRCCOPY);//part1
		//
		pDC->StretchBlt(145,rc.top,3,Height,&memDC,145,0,3,98,SRCCOPY);//part1
		pDC->StretchBlt(148,rc.top,25,37,&memDC,148,0,25,37,SRCCOPY);//part1
		pDC->StretchBlt(148,rc.top+62,25,36,&memDC,148,62,25,36,SRCCOPY);//part1
		pDC->StretchBlt(173,rc.top,2,Height,&memDC,173,0,2,98,SRCCOPY);//part1
		//
		pDC->StretchBlt(rc.left+175,rc.top,80,32,&memDC,175,0,80,32,SRCCOPY);//part2
		pDC->StretchBlt(rc.left+175,rc.top+62,80,36,&memDC,175,62,80,36,SRCCOPY);//part3

		pDC->StretchBlt(rc.left+254,rc.top,27,Height,&memDC,255,0,27,98,SRCCOPY);//part4
		pDC->StretchBlt(rc.left+280,rc.top,223,69,&memDC,280,0,223,69,SRCCOPY);//part5
		pDC->StretchBlt(rc.left+280,rc.top+85,223,13,&memDC,280,85,223,13,SRCCOPY);//part6
		pDC->StretchBlt(rc.left+503,rc.top,31,98,&memDC,503,0,31,98,SRCCOPY);//part7

		memDC.SelectObject(pOld);
		//pp.DeleteObject();//release
		pBitmap->DeleteObject();
		pOld->DeleteObject();
	};
	LRESULT OnEraseBkGnd(UINT uMsg, WPARAM wParam, LPARAM lParam, BOOL& bHandled)
	{
	
		if ( IsHandlerMessage( uMsg ) )
		{
			if ( m_spPicture )
			{
				BeginPaint( NULL );
					RECT r ; 
					GetClientRect(&r);
				/*
				CRect wr;
				CWnd *pWnd = CWnd::FromHandle(m_hWnd);
				pWnd->GetWindowRect(wr);
				*/
					CRect rvol ;
					SetRect(&rvol,175,r.bottom-66,80,30);
					//----------------
					RECT r1,r2,r3,r4,r6,r7,r8,r9,r10;
					HDC hDC = GetDC();

					//HDC hDC = GetWindowDC();
					HWND hWndChild = GetWindow( GW_OWNER );
					while ( ::IsWindow( hWndChild ) )
					{
						if ( ::IsWindowVisible( hWndChild ) )
						{
							RECT rChild; ::GetWindowRect( hWndChild, &rChild );
							ScreenToClient( &rChild );
							ExcludeClipRect( hDC, rChild.left, rChild.top, rChild.right, rChild.bottom );
						}
						hWndChild = ::GetWindow( hWndChild, GW_HWNDNEXT );
					}
					r1.top = 0;
					r1.bottom=44;
					r1.left=0;
					r1.right=17;
					PutPicture( m_topleft, hDC, r1 );
					//draw title
					DrawMiddleTitle( hDC);
					r2.top = 0;
					r2.bottom=44;
					r2.left=r1.right;
					r2.right=271;
					PutPicture( m_topmidd, hDC, r2 );
					r2.top = 0;
					r2.bottom=44;
					r2.left=504;
					r2.right=r.right-102;
					PutPicture( m_topmidd, hDC, r2 );

					r3.top = 0;
					r3.bottom=44;
					r3.left=r.right-102;
					r3.right=r.right;
					PutPicture( m_topright, hDC, r3 );

					r4.top = 44;
					r4.bottom=r.bottom-98;
					r4.left=0;
					r4.right=17;
					PutPicture( m_middleleft, hDC, r4 );

					r6.top = 44;
					r6.bottom=r.bottom-98;
					r6.left=r.right-20;
					r6.right=r.right;
					PutPicture( m_middleright, hDC, r6 );
					//--------
					
					r7.top = r.bottom-98;
					r7.bottom=r.bottom;
					r7.left=0;
					r7.right=534;
					//CopyRect(&r7,&rvol); 
					//IntersectRect(&r11, &rvol, &r7) ;
					//PutPicture( m_bottomleft, hDC, r11 );
					
					DrawBottomLeft(r7,hDC);
					//..................
					r8.top = r7.top;
					r8.bottom=r7.bottom;
					r8.left=r7.right;
					r8.right=r.right-183;
					PutPicture( m_bottommidd, hDC, r8 );
					
					r9.top = r7.top;
					r9.bottom=r7.bottom;
					r9.left=r8.right;
					r9.right=r.right;
					PutPicture( m_bottomright, hDC, r9 );

					r10.top = r1.bottom;
					r10.bottom=r1.bottom+19;
					r10.left=r4.right;
					r10.right=r4.right+233;
					PutPicture( m_mgm, hDC, r10 );
					
				
				/*
					r11.top = 303;
					r11.bottom=r.bottom-98;
					r11.left=17;
					r11.right=249;
					PutPicture( m_btbk, hDC, r11 );
				*/	
					ReleaseDC( hDC );
				EndPaint( NULL );
				return TRUE;
	
			}
			//SendMessage(GetDlgItem(IDC_VOLUME),WM_ERASEBKGND,0);
		}
		bHandled = FALSE;
		return FALSE;
	};

	LRESULT OnPaint(UINT uMsg, WPARAM wParam, LPARAM lParam, BOOL& bHandled)
	{
		if ( IsHandlerMessage( uMsg ) )
		{
			if ( m_spPicture )
			{
				BeginPaint( NULL );
				RECT r ; GetClientRect( &r );
				HDC hDC = GetDC();
				PutPicture( m_spPicture, hDC, r );
				ReleaseDC( hDC );
				EndPaint( NULL );
			}
		}
		bHandled = FALSE;
		return NULL;
	};

	void Close()
	{
		m_spPicture = NULL;
	}
protected:
	CComPtr<IPicture> m_spPicture;
	CComPtr<IPicture> m_topleft;
	CComPtr<IPicture> m_topmidd;
	CComPtr<IPicture> m_topright;
	CComPtr<IPicture> m_middleleft;
	CComPtr<IPicture> m_middmidd;
	CComPtr<IPicture> m_middleright;
	CComPtr<IPicture> m_bottomleft;
	CComPtr<IPicture> m_bottommidd;
	CComPtr<IPicture> m_bottomright;
	CComPtr<IPicture> m_mgm;
	CComPtr<IPicture> m_btbk;


};

#endif 
