#ifndef __FILECOPY_H_
#define __FILECOPY_H_

#pragma once

#include "include\fs.h"
#include <process.h>    /* _beginthread, _endthread */

typedef struct _FileCopyParam_
{
   CFile * pcFd;
   BOOL * pCopyCancel;
   IOSFd ncFd;
   HWND hwndDlg;
   HWND hwndProcess;
   
} FILECOPYPARAM;


//#define BUFFERSIZE (1024*1024)


extern void _CopyFileProcess(void* pParam);

class CFileCopyProcessDlg :
   public CDialogImpl<CFileCopyProcessDlg>
{
public:
   enum {IDD = IDD_DIALOG_COPYFILE};

BEGIN_MSG_MAP(CFileCopyProcessDlg)
   MESSAGE_HANDLER(WM_INITDIALOG, OnInitDialog)
   COMMAND_ID_HANDLER(IDCANCEL, OnButtonClick)
  // COMMAND_HANDLER(IDOK, BN_CLICKED, OnBnClickedOk)
  MESSAGE_HANDLER(WM_CLOSE, OnClose)
END_MSG_MAP()

   LRESULT OnInitDialog(UINT /*uMsg*/, WPARAM /*wParam*/, LPARAM /*lParam*/, BOOL& /*bHandled*/)
   {
      ATLASSERT(m_pstrFileName);   
      ATLASSERT(m_pstrType);   
      //CResString<512> sFormat(IDS_REPLACE);
      TCHAR szTitle[512];
	int rst;
    //  ::wsprintf(szTitle, "%s",m_pstrFileName);
     // SetDlgItemText(IDC_STATIC_FILENAME, szTitle);
      ::MessageBeep(MB_ICONQUESTION); // Beep the user! Ala ::MessageBox() alert...

      //ļ߳.
      FILECOPYPARAM *pmyParam;
      pmyParam=(FILECOPYPARAM*)malloc(sizeof(FILECOPYPARAM));
      pmyParam->ncFd=ncFd;
      pmyParam->pcFd=pPcFd;
      pmyParam->hwndDlg=m_hWnd;
      pmyParam->hwndProcess=::GetDlgItem(m_hWnd, IDC_PROGRESS_COPY);
      pmyParam->pCopyCancel=&fCopyCanceled;

	 rst=SendDlgItemMessage(IDC_PROGRESS_COPY,PBM_SETPOS,0,0);
        ::wsprintf(szTitle, "  ");
      //SetDlgItemText(IDC_STATIC_PERCENT, szTitle);

	fCopyCanceled=FALSE;
      ::_beginthread(_CopyFileProcess,0,(void*)pmyParam);
      return 0;
   }

   LRESULT OnButtonClick(WORD /*wNotifyCode*/, WORD wID, HWND /*hWndCtl*/, BOOL& /*bHandled*/)
   {
      //ý־Ϊ, ̼߳⵽ֹ߳.
      fCopyCanceled=TRUE;
      //EndDialog(wID);
      return 0;
   }

public:
   LPCTSTR m_pstrFileName;
   LPCTSTR m_pstrType;
   CFile *pPcFd;
   IOSFd ncFd;
   BOOL fCopyCanceled;
 //  LRESULT OnBnClickedOk(WORD /*wNotifyCode*/, WORD /*wID*/, HWND /*hWndCtl*/, BOOL& /*bHandled*/);
   LRESULT OnClose(UINT /*uMsg*/, WPARAM /*wParam*/, LPARAM /*lParam*/, BOOL& /*bHandled*/);
};
#endif