/*
 *               Copyright (C) 2005, BroadOn Communications Corp.
 *
 *  These coded instructions, statements, and computer programs contain
 *  unpublished  proprietary information of BroadOn Communications Corp.,
 *  and  are protected by Federal copyright law. They may not be disclosed
 *  to  third  parties or copied or duplicated in any form, in whole or in
 *  part, without the prior written consent of BroadOn Communications Corp.
 *
 */

#ifndef __ES_H__
#define __ES_H__

#include <estypes.h>

/*
 * This structure is used for importing the boot2 content
 */
typedef struct {
    u32 hdrSize;        /* Size of ESWadHeader, may increase in the future */
    u32 contentOffset;  /* Offset to the real content */
    u32 certSize;
    u32 ticketSize;
    u32 tmdSize;
    u32 metaSize;
    u32 metaCid;
} ESWadHeader;

#define ES_CMD_IMP_SERVER_TICKET                1
#define ES_CMD_IMP_SERVER_TITLE_INIT            2
#define ES_CMD_IMP_CONTENT_BEGIN                3
#define ES_CMD_IMP_CONTENT_DATA                 4
#define ES_CMD_IMP_CONTENT_END                  5
#define ES_CMD_IMP_TITLE_DONE                   6
#define ES_CMD_GET_DEVICE_ID                    7 
#define ES_CMD_LAUNCH_TITLE                     8
#define ES_CMD_OPEN_CONTENT_FILE                9
#define ES_CMD_READ_CONTENT_FILE                10
#define ES_CMD_CLOSE_CONTENT_FILE               11
#define ES_CMD_LIST_OWNED_TITLES_CNT            12
#define ES_CMD_LIST_OWNED_TITLES                13
#define ES_CMD_LIST_TITLES_ON_CARD_CNT          14
#define ES_CMD_LIST_TITLES_ON_CARD              15
#define ES_CMD_LIST_TITLE_CONTENTS_CNT          16
#define ES_CMD_LIST_TITLE_CONTENTS              17
#define ES_CMD_GET_TICKET_VIEW_CNT              18 
#define ES_CMD_GET_TICKET_VIEWS                 19
#define ES_CMD_GET_TMD_VIEW_SIZE                20
#define ES_CMD_GET_TMD_VIEW                     21
#define ES_CMD_GET_CONSUMPTION                  22
#define ES_CMD_DELETE_TITLE                     23
#define ES_CMD_DELETE_TICKET                    24
#define ES_CMD_DI_GET_TMD_VIEW_SIZE             25
#define ES_CMD_DI_GET_TMD_VIEW                  26
#define ES_CMD_DI_GET_TICKET_VIEW               27
#define ES_CMD_DI_VERIFY                        28
#define ES_CMD_GET_META_FILE_NAME               29
#define ES_CMD_GET_DATA_DIR                     30 

ESError ES_InitLib(void);
ESError ES_CloseLib(void);
ESError ES_ImportTicket(const void* ticket, 
        const void* certList, u32 certSizeInBytes, 
        const void* crlList, u32 crlSizeInBytes, 
        ESTransferType source);
ESError ES_ImportTitleInit(const void* tmd, u32 tmdSize, 
        const void* certList, u32 certSizeInBytes, 
        const void* crlList, u32 crlSizeInBytes, 
        ESTransferType source);
s32     ES_ImportContentBegin(ESTitleId titleId, ESContentId cid);
ESError ES_ImportContentData(s32 fd, const void* inBuf, u32 inBufSize);
ESError ES_ImportContentEnd(s32 fd);
ESError ES_ImportTitleDone();

ESError ES_LaunchTitle(ESTitleId titleId, ESId deviceId, ESTicketId ticketId);
s32     ES_OpenContentFile(u16 contentIdx);
ESError ES_ReadContentFile(s32 fd, void* buf, u32 size);
ESError ES_CloseContentFile(s32 fd);

ESError ES_GetDeviceId(ESId* devId);
ESError ES_ListOwnedTitles(ESTitleId* titleIds, u32* numTitles);
ESError ES_ListTitlesOnCard(ESTitleId* titleIds, u32* numTitles);
ESError ES_ListTitleContentsOnCard(ESTitleId titleId, ESContentId* cids, 
        u32* numContents);
ESError ES_GetTicketViews(ESTitleId titleId,  ESTicketView* ticketViewList, 
        u32* ticketViewCnt);
ESError ES_GetTmdView(ESTitleId titleId, ESTmdView* tmdView, u32* size);
ESError ES_GetConsumption(ESTicketId ticketId, ESCc* ccList, u32* numCcs);
ESError ES_DeleteTitle(ESTitleId titleId);
ESError ES_DeleteTicket(ESTitleId titleId, ESId deviceId, ESTicketId ticketId); 
ESError ES_GetMetaFileName(ESTitleId titleId, char* metaFileName);
ESError ES_GetDataDir(char* dataDir);

#if defined(NEXT_GEN) || defined(BROADWAY_REV)
#include <iosctypes.h>
ESError ES_DiGetTicketView(const void* ticket, ESTicketView* ticketView);
ESError ES_DiGetTmdView(const void* tmd, u32 tmdSize, ESTmdView* tmdView, 
        u32* tmdViewSize);
ESError ES_DiVerify(const void *certList, u32 certSizeInBytes, 
        const void* crlList, u32 crlListInBytes, 
        const void* ticket, const void* tmd, u32 tmdSize, 
        IOSCSecretKeyHandle* hTitleKey, IOSCHash* hashes);

ESError ES_ImportDataBegin(const void* certList, u32 certSizeInBytes, 
        const void* crlList, u32 crlSizeInBytes);
ESError ES_ImportDataData(const void* inBuf, void* outBuf, u32 size);
ESError ES_ImportDataEnd(const void* sig);

ESError ES_GetExportCertSize(u32* size);
ESError ES_ExportCerts(void* certList);
ESError ES_GetExportCrlSize(u32* size);
ESError ES_ExportCrls(void* crlList);

ESError ES_ExportTitleInit(ESTitleId titleId, ESId deviceId, 
        ESTicketId ticketId, const void* certList, u32 certSizeInBytes, 
        const void* crlList, u32 crlSizeInBytes, ESTransferType dest, 
        void* ticket, void* tmd);
s32     ES_ExportContentBegin(ESTitleId titleId, ESContentId cid);
ESError ES_ExportContentData(s32 fd, void* outBuf, u32 size);
ESError ES_ExportContentEnd(s32 fd);
ESError ES_ExportTitleDone();

ESError ES_ExportDataBegin(const void* certList, u32 certSizeInBytes, 
        const void* crlList, u32 crlSizeInBytes);
ESError ES_ExportDataData(const void* inBuf, void* outBuf, u32 size);
ESError ES_ExportDataEnd(void* sig);
#endif

#if defined(NET_CARD)
#define ntohs(x) ((((x)&0xff)<<8) | (((x)&0xff00)>>8))
#define ntohl(x) ( (((x)&0xff)<<24) | (((x)&0xff00)<<8) | (((x)&0xff0000)>>8) | (((x)&0xff000000)>>24) ) 
#define htonll(x) ((u64)( ((u64)((htonl((u32)(x)))) << 32) | (htonl((u32)(((u64)(x))>>32))) ))
#define ntohll(x) ((u64)( ((u64)((ntohl((u32)(x)))) << 32) | (ntohl((u32)(((u64)(x))>>32))) ))
#endif

#if defined(NEXT_GEN) || defined(BROADWAY_REV) 
#define ntohs(x) (x)
#define ntohl(x) (x)
#define htonll(x) (x)
#define ntohll(x) (x)
#endif

#endif /*__ES_H__*/
