/*
 *               Copyright (C) 2005, BroadOn Communications Corp.
 *
 *  These coded instructions, statements, and computer programs contain
 *  unpublished  proprietary information of BroadOn Communications Corp.,
 *  and  are protected by Federal copyright law. They may not be disclosed
 *  to  third  parties or copied or duplicated in any form, in whole or in
 *  part, without the prior written consent of BroadOn Communications Corp.
 *
 */
#ifndef __IOS_H__
#define __IOS_H__

typedef s32 IOSFd;
typedef struct {
    u8 *base;
    u32 length;
} IOSIoVector;

IOSFd IOS_Open(const char *pathname, u32 flags);
s32 IOS_Close(IOSFd fd);
s32 IOS_Read(IOSFd fd, void *buf, u32 count);
s32 IOS_Write(IOSFd fd, void *buf, u32 count);
s32 IOS_Seek(IOSFd fd, s32 offset, u32 whence);
s32 IOS_Ioctl(IOSFd fd, s32 cmd, void *input, u32 input_bytes,
		   void *output, u32 output_bytes);
s32 IOS_Ioctlv(IOSFd fd, s32 cmd, u32 readCount, u32 writeCount,
		    IOSIoVector * vector);

#endif /* __IOS_H__ */
