/*
 *               Copyright (C) 2005, BroadOn Communications Corp.
 *
 *  These coded instructions, statements, and computer programs contain
 *  unpublished  proprietary information of BroadOn Communications Corp.,
 *  and  are protected by Federal copyright law. They may not be disclosed
 *  to  third  parties or copied or duplicated in any form, in whole or in
 *  part, without the prior written consent of BroadOn Communications Corp.
 *
 */
#ifndef __IOSC_H__
#define __IOSC_H__

#include <iosctypes.h>

#if !defined(ASSEMBLER)

IOSError IOSC_CreateObject(u32 * handle, IOSCObjectType type,
			   IOSCObjectSubType subtype);
IOSError IOSC_DeleteObject(u32 handle);
IOSError IOSC_ImportSecretKey(IOSCSecretKeyHandle importedHandle,
			      IOSCSecretKeyHandle verifyHandle,
			      IOSCSecretKeyHandle decryptHandle,
			      IOSCSecretKeySecurity flag, u8 * signbuffer,
			      u8 * ivData, u8 * keybuffer);
IOSError IOSC_ExportSecretKey(IOSCSecretKeyHandle exportedHandle,
			      IOSCSecretKeyHandle signHandle,
			      IOSCSecretKeyHandle encryptHandle,
			      IOSCSecretKeySecurity flag, u8 * signbuffer,
			      u8 * ivData, u8 * keybuffer);
IOSError IOSC_ImportPublicKey(u8 * publicKeyData, u8 * exponent,
			      IOSCPublicKeyHandle publicKeyHandle);
IOSError IOSC_ExportPublicKey(u8 * publicKeyData, u8 * exponent,
			      IOSCPublicKeyHandle publicKeyHandle);
IOSError IOSC_GenerateKey(IOSCKeyHandle handle);
IOSError IOSC_ComputeSharedKey(IOSCSecretKeyHandle privateHandle,
			       IOSCPublicKeyHandle publicHandle,
			       IOSCSecretKeyHandle sharedHandle);
IOSError IOSC_SetData(IOSCDataHandle dataHandle, u32 value);
IOSError IOSC_GetData(IOSCDataHandle dataHandle, u32 * value);
IOSError IOSC_GetKeySize(u32 * keySize, IOSCKeyHandle handle);
IOSError IOSC_GetSignatureSize(u32 * signSize, IOSCKeyHandle handle);
IOSError IOSC_GenerateRand(u32 * randvalues, u32 numwords);
IOSError IOSC_GenerateHashAsync(u8 * context, u8 * inputData, u32 inputSize,
				u32 chainingFlag, u8 * hashData,
				IOSMessageQueueId mq,
				IOSResourceRequest * reply);
IOSError IOSC_GenerateHash(u8 * context, u8 * inputData, u32 inputSize,
			   u32 chainingFlag, u8 * hashData);
IOSError IOSC_EncryptAsync(IOSCSecretKeyHandle encryptHandle, u8 * ivData,
			   u8 * inputData, u32 inputSize, u8 * outputData,
			   IOSMessageQueueId mq, IOSResourceRequest * reply);
IOSError IOSC_Encrypt(IOSCSecretKeyHandle encryptHandle, u8 * ivData,
		      u8 * inputData, u32 inputSize, u8 * outputData);
IOSError IOSC_DecryptAsync(IOSCSecretKeyHandle decryptHandle, u8 * ivData,
			   u8 * inputData, u32 inputSize, u8 * outputData,
			   IOSMessageQueueId mq, IOSResourceRequest * reply);
IOSError IOSC_Decrypt(IOSCSecretKeyHandle decryptHandle, u8 * ivData,
		      u8 * inputData, u32 inputSize, u8 * outputData);
IOSError IOSC_GeneratePublicKeySign(u8 * inputData, u32 inputSize,
				    IOSCSecretKeyHandle signerHandle,
				    u8 * signData);
IOSError IOSC_VerifyPublicKeySign(u8 * inputData, u32 inputSize,
				  IOSCPublicKeyHandle publicHandle,
				  u8 * signData);
IOSError IOSC_GenerateBlockMAC(u8 * context, u8 * inputData, u32 inputSize,
			       u8 * customData, u32 customDataSize,
			       IOSCSecretKeyHandle signerHandle,
			       u32 chainingFlag, u8 * signData);
IOSError IOSC_GenerateBlockMACAsync(u8 * context, u8 * inputData,
				    u32 inputSize, u8 * customData,
				    u32 customDataSize,
				    IOSCSecretKeyHandle signerHandle,
				    u32 chainingFlag, u8 * signData,
				    IOSMessageQueueId mq,
				    IOSResourceRequest * reply);
IOSError IOSC_VerifyBlockMAC(u8 * context, u8 * inputData, u32 inputSize,
			     u8 * customData, u32 customDataSize,
			     IOSCSecretKeyHandle signerHandle,
			     u32 chainingFlag, u8 * signData);
IOSError IOSC_VerifyBlockMACAsync(u8 * context, u8 * inputData, u32 inputSize,
				  u8 * customData, u32 customDataSize,
				  IOSCSecretKeyHandle signerHandle,
				  u32 chainingFlag, u8 * signData,
				  IOSMessageQueueId mq,
				  IOSResourceRequest * reply);
IOSError IOSC_ImportCertificate(u8 * certData,
				IOSCPublicKeyHandle signerHandle,
				IOSCPublicKeyHandle publicKeyHandle);
IOSError IOSC_GenerateCertificate(IOSCSecretKeyHandle privateHandle,
				  IOSCCertName certname,
				  IOSCEccSignedCert * certificate);
IOSError IOSC_GetDeviceCertificate(IOSCEccSignedCert * certificate);

#endif

#endif /* __IOSC_H__ */
