/*
 *               Copyright (C) 2005, BroadOn Communications Corp.
 *
 *  These coded instructions, statements, and computer programs contain
 *  unpublished  proprietary information of BroadOn Communications Corp.,
 *  and  are protected by Federal copyright law. They may not be disclosed
 *  to  third  parties or copied or duplicated in any form, in whole or in
 *  part, without the prior written consent of BroadOn Communications Corp.
 *
 */
#ifndef __ADDR_MAP_H__
#define __ADDR_MAP_H__

/* Well-known addresses in NetC */

/* The following assumes the DA space is 192 KB.  This could be changed. */
/* secure kernel */
#define KERNEL_SP_START		0x00000000
#define KERNEL_SP_END		0x00015000

/* File system */
#define FS_SP_START		0x00015000
#define FS_SP_END		0x0001d000

/* eTicket manager */
#define ET_SP_START		0x0001d000
#define ET_SP_END		0x00028000

/* Legacy State Saving area */
#define LEGACY_DA_STATE_START	0x00028000
#define LEGACY_DA_STATE_END	0x00030000

/* Boot1 */
#define BOOT1_SP_START	        0x00028000
#define BOOT1_SP_END	        0x00030000

/* SDRAM layout */

/* Boot2 load area */
#define BOOT2_LOAD_START        0x08f00000
#define BOOT2_LOAD_END          0x09000000

/* NC application */
#define APP_SP_START		0x09000000
#define APP_SP_END		0x09b88000

/* Media player */
#define MDFILE_SP_START		0x09b88000
#define MDFILE_SP_END		0x09ba0000

/* Viewer */
#define VIEWER_SP_START		0x09ba0000
#define VIEWER_SP_END		0x09da0000

/* Shared Data */
#define SHARED_SP_START		0x09da0000
#define SHARED_SP_END		0x09ea0000
#define SHARED_SP_SIZE		0x100000

/* Media player */
#define MEDIA_SP_START		0x09ea0000
#define MEDIA_SP_END		0x09ee0000

/* Devmon */
#define DEVMON_SP_START		0x09ee0000
#define DEVMON_SP_END		0x09f00000

/* Virtual Network */
#define VN_SP_START		0x09f00000
#define VN_SP_END		0x09fa0000

/* USB driver */
#define USB_SP_START		0x09fa0000
#define USB_SP_END		0x09fb0000

/* BSS segment for FS driver */
#define FS_BSS_SP_START		0x09fb0000
#define FS_BSS_SP_END		0x09fd0000

/* Audio driver */
#define AUD_SP_START		0x09fd0000
#define AUD_SP_END		0x09fe0000

/* Legacy State Saving area */
#define LEGACY_SDRAM_STATE_START	0x09fe0000
#define LEGACY_SDRAM_STATE_END	0x09fffff0

/* IPC window */
#define IPC_SP_START		0x09fffff0

#endif /* __ADDR_MAP_H__ */
