/*
 *               Copyright (C) 2006, BroadOn Communications Corp.
 *
 *  These coded instructions, statements, and computer programs contain
 *  unpublished  proprietary information of BroadOn Communications Corp.,
 *  and  are protected by Federal copyright law. They may not be disclosed
 *  to  third  parties or copied or duplicated in any form, in whole or in
 *  part, without the prior written consent of BroadOn Communications Corp.
 *
 */

#ifndef __NC_AUD_H_
#define __NC_AUD_H_

#define AUD_DEV                    "/dev/audio"

/* ioctl commands for AUD driver */

/* parameters for ioctl commands */
#define AUD_GET_VOLUME                   0
#define AUD_SET_VOLUME                   1
#define AUD_GET_SIDETONE                 2
#define AUD_SET_SIDETONE                 3
#define AUD_GET_CONFIG                   4
#define AUD_SET_CONFIG                   5
#define AUD_GET_HEADSET                  6
#define AUD_SET_EXT_CODEC                7 /* temporary, for internal use only */

/* audio configurations for AUD_SET_CONFIG and AUD_GET_CONFIG ioctl commands.
 * format is ADCx_DACy, where x and y are the analog-to-digital (i.e., micro-
 * phone input) sampling rate and the digital-to-analog (i.e., headphone output)
 * sampling rate, respectively.  Sampling rates are specified in units of KHz,
 * and the character 'P' is used to represent a decimal point.
 */
#define AUD_CONFIG_UNDEF                 255
#define AUD_CONFIG_ADC_48_DAC_48           0
#define AUD_CONFIG_ADC_48_DAC_8            1
#define AUD_CONFIG_ADC_8_DAC_48            2
#define AUD_CONFIG_ADC_8_DAC_8             3
#define AUD_CONFIG_ADC_32_DAC_32           4
#define AUD_CONFIG_ADC_44P1_DAC_44P1       5
#define AUD_CONFIG_ADC_44P1_DAC_8P018      6
#define AUD_CONFIG_ADC_8P018_DAC_44P1      7
#define AUD_CONFIG_ADC_8P018_DAC_8P018     8

#define AUD_VOLUME_MIN                     0x30
#define AUD_VOLUME_MAX                     0x7F
#define AUD_VOLUME_DEFAULT                 0x79
#define AUD_VOLUME_MUTE                    0x00


#endif
