/*
 *               Copyright (C) 2005, BroadOn Communications Corp.
 *
 *  These coded instructions, statements, and computer programs contain
 *  unpublished  proprietary information of BroadOn Communications Corp.,
 *  and  are protected by Federal copyright law. They may not be disclosed
 *  to  third  parties or copied or duplicated in any form, in whole or in
 *  part, without the prior written consent of BroadOn Communications Corp.
 *
 */
#ifndef __ELF_H__
#define __ELF_H__

/* Adopted from Elf version 1.2 and ARM ELF.
   Only those types used by the NetC are defined here. */


/* Aux. vector */
typedef struct
{
    u32 a_type;
    union {
	s32 a_val;
	void* a_ptr;
	void (*a_fcn)(void);
    } a_un;
} Elf32_auxv_t;

#define AT_ENTRY 9			/* describe an entry point */
#define AT_UID  11			/* specify the process id */

/* The ELF file header.  This appears at the start of every ELF file.  */

#define ELFMAG              "\177ELF"

#define EI_NIDENT           (16)
#define EI_CLASS            4       /* File class byte index */
#define EI_DATA             5       /* Data encoding byte index */
#define EI_VERSION          6       /* File version byte index */
#define EI_OSABI            7       /* OS ABI identification */
#define EI_ABIVERSION       8       /* ABI version */

#define ELFCLASS32          1       /* 32-bit objects */
#define ELFDATA2LSB         1       /* 2's complement, little endian */
#define ELFOSABI_ARM        97      /* ARM */
#define ELFABIVERSION_BCC   1

#define EV_CURRENT          1       /* Current version */
#define ET_EXEC             2       /* Executable file */
#define EM_ARM              40      /* ARM */
#define EF_ARM_RELEXEC      0x01
#define EF_ARM_PIC          0x20

typedef struct
{
    unsigned char	e_ident[EI_NIDENT];	/* Magic number and other info */
    u16	e_type;			/* Object file type */
    u16	e_machine;		/* Architecture */
    u32	e_version;		/* Object file version */
    u32	e_entry;		/* Entry point virtual address */
    u32	e_phoff;		/* Program header table file offset */
    u32	e_shoff;		/* Section header table file offset */
    u32	e_flags;		/* Processor-specific flags */
    u16	e_ehsize;		/* ELF header size in bytes */
    u16	e_phentsize;		/* Program header table entry size */
    u16	e_phnum;		/* Program header table entry count */
    u16	e_shentsize;		/* Section header table entry size */
    u16	e_shnum;		/* Section header table entry count */
    u16	e_shstrndx;		/* Section header string table index */
} Elf32_Ehdr;


/* Program headers */
typedef struct
{
    u32 p_type;				/* segment type */
    u32 p_offset;			/* file offset */
    u32 p_vaddr;			/* virtual address */
    u32 p_paddr;			/* physical address */
    u32 p_filesz;			/* file size of segment */
    u32 p_memsz;			/* memory size of segment */
    u32 p_flags;			/* segment attributes */
    u32 p_align;			/* segment alignment */
} Elf32_Phdr;

/* program header types */
#define PT_LOAD 1			/* loadable segment */
#define PT_NOTE 4			/* Aux. info. program header */
#define PT_PHDR	6			/* in-memory program header table */

/* program flags */
#define PF_X            (1 << 0)        /* Segment is executable */
#define PF_W            (1 << 1)        /* Segment is writable */
#define PF_R            (1 << 2)        /* Segment is readable */
#define PF_MASKOS       0x0ff00000      /* OS-specific */
#define PF_MEM_MASK(x)	((x & PF_MASKOS) >> 20)

/* Note section types */
#define NT_AUXV 6			/* Aux. vector note section */


#endif /* __ELF_H__ */
