/*
 *               Copyright (C) 2005, BroadOn Communications Corp.
 *
 *  These coded instructions, statements, and computer programs contain
 *  unpublished  proprietary information of BroadOn Communications Corp.,
 *  and  are protected by Federal copyright law. They may not be disclosed
 *  to  third  parties or copied or duplicated in any form, in whole or in
 *  part, without the prior written consent of BroadOn Communications Corp.
 *
 */
#ifndef __IOS_H__
#define __IOS_H__

#include <sc/iostypes.h>

#if !defined(ASSEMBLER)

IOSThreadId IOS_CreateThread(IOSEntryProc entry, void *arg, void *stack,
			     u32 stackSize, u32 priority, u32 attributes);
IOSError IOS_JoinThread(IOSThreadId id, void **val);
IOSError IOS_DestroyThread(IOSThreadId id, void *val);
IOSThreadId IOS_GetThreadId(void);
IOSProcessId IOS_GetProcessId(void);
IOSError IOS_StartThread(IOSThreadId id);
IOSError IOS_StopThread(IOSThreadId id);
void IOS_YieldThread(void);
u32 IOS_GetThreadPriority(IOSThreadId id);
IOSError IOS_SetThreadPriority(IOSThreadId id, u32 priority);
IOSMessageQueueId IOS_CreateMessageQueue(IOSMessage * msgarray, u32 count);
IOSError IOS_DestroyMessageQueue(IOSMessageQueueId id);
IOSError IOS_SendMessage(IOSMessageQueueId mq, IOSMessage msg, u32 flag);
IOSError IOS_JamMessage(IOSMessageQueueId mq, IOSMessage msg, u32 flag);
IOSError IOS_ReceiveMessage(IOSMessageQueueId mq, IOSMessage * msg, u32 flag);
IOSError IOS_HandleEvent(IOSEvent event, IOSMessageQueueId mq,
			 IOSMessage mesg);
IOSError IOS_UnhandleEvent(IOSEvent event);
IOSTimerId IOS_CreateTimer(IOSTime value, IOSTime interval,
			   IOSMessageQueueId mq, IOSMessage mesg);
IOSError IOS_RestartTimer(IOSTimerId id, IOSTime value, IOSTime interval);
IOSError IOS_StopTimer(IOSTimerId id);
IOSError IOS_DestroyTimer(IOSTimerId id);
IOSHeapId IOS_CreateHeap(void *ptr, u32 size);
IOSError IOS_DestroyHeap(IOSHeapId id);
void *IOS_Alloc(IOSHeapId id, u32 size);
void *IOS_AllocAligned(IOSHeapId id, u32 size, u32 alignment);
IOSError IOS_Free(IOSHeapId id, void *ptr);
IOSError IOS_RegisterResourceManager(char *path, IOSMessageQueueId mq);
IOSFd IOS_Open(const char *pathname, u32 flags);
IOSError IOS_OpenAsync(const char *pathname, u32 flags, IOSMessageQueueId mq,
		       IOSResourceRequest * reply);
IOSError IOS_Close(IOSFd fd);
IOSError IOS_CloseAsync(IOSFd fd, IOSMessageQueueId mq,
			IOSResourceRequest * reply);
s32 IOS_Read(IOSFd fd, void *buf, u32 count);
IOSError IOS_ReadAsync(IOSFd fd, void *buf, u32 count, IOSMessageQueueId mq,
		       IOSResourceRequest * reply);
s32 IOS_Write(IOSFd fd, void *buf, u32 count);
IOSError IOS_WriteAsync(IOSFd fd, void *buf, u32 count, IOSMessageQueueId mq,
			IOSResourceRequest * reply);
s32 IOS_Seek(IOSFd fd, s32 offset, u32 whence);
IOSError IOS_SeekAsync(IOSFd fd, s32 offset, u32 whence, IOSMessageQueueId mq,
		       IOSResourceRequest * reply);
IOSError IOS_Ioctl(IOSFd fd, s32 cmd, void *input, u32 input_bytes,
		   void *output, u32 output_bytes);
IOSError IOS_IoctlAsync(IOSFd fd, s32 cmd, void *input, u32 input_bytes,
			void *output, u32 output_bytes, IOSMessageQueueId mq,
			IOSResourceRequest * reply);
IOSError IOS_Ioctlv(IOSFd fd, s32 cmd, u32 readCount, u32 writeCount,
		    IOSIoVector * vector);
IOSError IOS_IoctlvAsync(IOSFd fd, s32 cmd, u32 readCount, u32 writeCount,
			 IOSIoVector * vector, IOSMessageQueueId mq,
			 IOSResourceRequest * reply);
IOSError IOS_ResourceReply(IOSResourceRequest * reply, IOSError status);
IOSError IOS_SetUid(IOSProcessId id, IOSUid uid);
IOSUid IOS_GetUid(void);
IOSError IOS_SetGid(IOSProcessId id, IOSGid gid);
IOSGid IOS_GetGid(void);
IOSError IOS_LaunchElf(const char *path);
u32 IOS_GetUsbPower(void);
IOSError IOS_SetPower(u32 device, u32 on);
void *IOS_SetLegacyMode(u32 state, u32 rtc, IOSMessageQueueId mq);
IOSError IOS_SetDate(IOSDate * date);
IOSError IOS_GetDate(IOSDate * date);
IOSError IOS_SendMailbox(u32 msg);
IOSError IOS_GetUsage(u32 flags, char *buf, u32 len);
u32 IOS_NvramReadData(u32 addr, u32 n);
u32 IOS_NvramWriteData(u32 addr, u32 data, u32 n);

#endif

#endif /* __IOS_H__ */
