/*
 *              Copyright (C) 2005, BroadOn Communications Corp.
 *
 * These coded instructions, statements, and computer programs contain
 * unpublished  proprietary information of BroadOn Communications Corp.,
 * and  are protected by Federal copyright law. They may not be disclosed
 * to  third  parties or copied or duplicated in any form, in whole or in
 * part, without the prior written consent of BroadOn Communications Corp.
 *
 */

#ifndef __MEDIAFS_H__
#define __MEDIAFS_H__

#define NC_MEDIA_REQ_MAGIC      0x4E634673             /* NcFs */
#define NC_MEDIA_REPLY_MAGIC    0x7346634E             /* reverse order */

#define NC_MEDIA_CMD_SYNC       0x10000                /* Sync command */
#define NC_MEDIA_CMD_VERSION    0x10001
#define NC_MEDIA_CMD_OPEN       0x10002
#define NC_MEDIA_CMD_SEEK       0x10003
#define NC_MEDIA_CMD_READ       0x10004
#define NC_MEDIA_CMD_WRITE      0x10005
#define NC_MEDIA_CMD_CLOSE      0x10006

#define NC_MEDIA_READ_READY     0xffff

/* * * * * * * * * * * * * * * * * * * * * * * * * * * *
    Media File server request data structure
 * * * * * * * * * * * * * * * * * * * * * * * * * * * */
typedef struct {
    unsigned int magic;     /* request magic number */                       
    int          cmd;       /* ISFS command */ 
    int          paramLen;  /* parameter length */
    int          dataLen;   /* data length */
} USBMediaFsRequest;

/* * * * * * * * * * * * * * * * * * * * * * * * * * * *
    Media File server cmd reply data structure
 * * * * * * * * * * * * * * * * * * * * * * * * * * * */
typedef struct {
    unsigned int magic;     /* request magic number */
    int          cmd;       /* ISFS command used to verify */ 
    int          retCode;   /* return code */
    int          dataLen;   /* data length */
} USBMediaFsReply;

/* * * * * * * * * * * * * * * * * * * * * * * * * * * *
    Media Fs ReadDir parameter
 * * * * * * * * * * * * * * * * * * * * * * * * * * * */
typedef struct {
    int num;
    int addr;           
    u8  path[ISFS_PATH_MAXLEN];
} MediaFsReadDirParam;

/* * * * * * * * * * * * * * * * * * * * * * * * * * * *
    Media Fs General parameter
 * * * * * * * * * * * * * * * * * * * * * * * * * * * */
typedef struct {
    int arg;                        /* argument */
    u8  path[ISFS_PATH_MAXLEN];     /* File path */
} MediaFsParam;

typedef struct {
    IOSFd  fd;
    int param0;
    int param1;
    int param2;
} MediaFsOpsParam;

#endif /* __MEDIAFS_H__ */
